/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactElementType
extends ComplexPackagingElementType<ArtifactPackagingElement> {
    public static final ArtifactElementType ARTIFACT_ELEMENT_TYPE = new ArtifactElementType();

    ArtifactElementType() {
        super("artifact", JavaCompilerBundle.messagePointer((String)"element.type.name.artifact", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return AllIcons.Nodes.Artifact;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            ArtifactElementType.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            ArtifactElementType.$$$reportNull$$$0(1);
        }
        return !ArtifactElementType.getAvailableArtifacts(context, artifact, false).isEmpty();
    }

    @NotNull
    public List<? extends ArtifactPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            ArtifactElementType.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            ArtifactElementType.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            ArtifactElementType.$$$reportNull$$$0(4);
        }
        Project project = context.getProject();
        List artifacts = context.chooseArtifacts(ArtifactElementType.getAvailableArtifacts(context, artifact, false), JavaCompilerBundle.message((String)"dialog.title.choose.artifacts", (Object[])new Object[0]));
        ArrayList<ArtifactPackagingElement> elements = new ArrayList<ArtifactPackagingElement>();
        for (Artifact selected : artifacts) {
            elements.add(new ArtifactPackagingElement(project, ArtifactPointerManager.getInstance((Project)project).createPointer(selected, context.getArtifactModel())));
        }
        ArrayList<ArtifactPackagingElement> arrayList = elements;
        if (arrayList == null) {
            ArtifactElementType.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static List<? extends Artifact> getAvailableArtifacts(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, boolean notIncludedOnly) {
        if (context == null) {
            ArtifactElementType.$$$reportNull$$$0(6);
        }
        if (artifact == null) {
            ArtifactElementType.$$$reportNull$$$0(7);
        }
        HashSet result = ContainerUtil.newHashSet((Object[])context.getArtifactModel().getArtifacts());
        if (notIncludedOnly) {
            ArtifactUtil.processPackagingElements(artifact, ARTIFACT_ELEMENT_TYPE, artifactPackagingElement -> {
                result.remove(artifactPackagingElement.findArtifact((PackagingElementResolvingContext)context));
                return true;
            }, (PackagingElementResolvingContext)context, true);
        }
        result.remove(artifact);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Artifact another = (Artifact)iterator.next();
            boolean notContainThis = ArtifactUtil.processPackagingElements(another, ARTIFACT_ELEMENT_TYPE, element -> !artifact.getName().equals(element.getArtifactName()), (PackagingElementResolvingContext)context, true);
            if (notContainThis) continue;
            iterator.remove();
        }
        ArrayList list = new ArrayList(result);
        list.sort(ArtifactManager.ARTIFACT_COMPARATOR);
        ArrayList arrayList = list;
        if (arrayList == null) {
            ArtifactElementType.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public ArtifactPackagingElement createEmpty(@NotNull Project project) {
        if (project == null) {
            ArtifactElementType.$$$reportNull$$$0(9);
        }
        return new ArtifactPackagingElement(project);
    }

    public String getShowContentActionText() {
        return JavaCompilerBundle.message((String)"show.content.of.included.artifacts", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/ArtifactElementType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/ArtifactElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAndCreate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndCreate";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableArtifacts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEmpty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8 -> new IllegalStateException(string);
        };
    }
}

