/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.java.workspace.entities.DirectoryPackagingElementEntity;
import com.intellij.java.workspace.entities.PackagingElementEntity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingExternalMapping;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.DirectoryElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Unit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DirectoryPackagingElement
extends CompositeElementWithManifest<DirectoryPackagingElement> {
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";
    private String myDirectoryName;

    public DirectoryPackagingElement() {
        super(PackagingElementFactoryImpl.DIRECTORY_ELEMENT_TYPE);
    }

    public DirectoryPackagingElement(String directoryName) {
        super(PackagingElementFactoryImpl.DIRECTORY_ELEMENT_TYPE);
        this.myDirectoryName = directoryName;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            DirectoryPackagingElement.$$$reportNull$$$0(0);
        }
        return new DirectoryElementPresentation(this);
    }

    public DirectoryPackagingElement getState() {
        return this;
    }

    @NonNls
    public String toString() {
        return "dir:" + this.getMyDirectoryName();
    }

    @Attribute(value="name")
    @NlsSafe
    public String getDirectoryName() {
        return this.getMyDirectoryName();
    }

    public void setDirectoryName(String directoryName) {
        this.changeName(directoryName);
    }

    public void rename(@NotNull String newName) {
        if (newName == null) {
            DirectoryPackagingElement.$$$reportNull$$$0(1);
        }
        this.changeName(newName);
    }

    private void changeName(@NotNull String newName) {
        if (newName == null) {
            DirectoryPackagingElement.$$$reportNull$$$0(2);
        }
        this.update(() -> {
            this.myDirectoryName = newName;
        }, (builder, entity) -> builder.modifyEntity(DirectoryPackagingElementEntity.Builder.class, (WorkspaceEntity)entity, ent -> {
            ent.setDirectoryName(newName);
            return Unit.INSTANCE;
        }));
    }

    public String getName() {
        return this.getMyDirectoryName();
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            DirectoryPackagingElement.$$$reportNull$$$0(3);
        }
        return element instanceof DirectoryPackagingElement && ((DirectoryPackagingElement)element).getDirectoryName().equals(this.getMyDirectoryName());
    }

    public PackagingElementEntity.Builder<? extends PackagingElementEntity> getOrAddEntityBuilder(@NotNull MutableEntityStorage diff, @NotNull EntitySource source, @NotNull Project project) {
        PackagingElementEntity existingEntity;
        if (diff == null) {
            DirectoryPackagingElement.$$$reportNull$$$0(4);
        }
        if (source == null) {
            DirectoryPackagingElement.$$$reportNull$$$0(5);
        }
        if (project == null) {
            DirectoryPackagingElement.$$$reportNull$$$0(6);
        }
        if ((existingEntity = (PackagingElementEntity)this.getExistingEntity(diff)) != null) {
            return this.getBuilder(diff, existingEntity);
        }
        List children = ContainerUtil.map((Collection)this.getChildren(), o -> o.getOrAddEntityBuilder(diff, source, project));
        Objects.requireNonNull(this.myDirectoryName, "directoryName is not specified");
        DirectoryPackagingElementEntity entity = (DirectoryPackagingElementEntity)diff.addEntity((WorkspaceEntity.Builder)DirectoryPackagingElementEntity.create((String)this.myDirectoryName, (EntitySource)source, entityBuilder -> {
            entityBuilder.setChildren(children);
            return Unit.INSTANCE;
        }));
        diff.getMutableExternalMapping(PackagingExternalMapping.key).addMapping((WorkspaceEntity)entity, (Object)this);
        return this.getBuilder(diff, (PackagingElementEntity)entity);
    }

    public void loadState(@NotNull DirectoryPackagingElement state) {
        if (state == null) {
            DirectoryPackagingElement.$$$reportNull$$$0(7);
        }
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    private String getMyDirectoryName() {
        if (this.myStorage == null) {
            return this.myDirectoryName;
        }
        DirectoryPackagingElementEntity entity = (DirectoryPackagingElementEntity)this.getThisEntity();
        String directoryName = entity.getDirectoryName();
        if (!Objects.equals(directoryName, this.myDirectoryName)) {
            this.myDirectoryName = directoryName;
        }
        return directoryName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diff";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/elements/DirectoryPackagingElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "changeName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualTo";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrAddEntityBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

