/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.java.workspace.entities.ExtractedDirectoryPackagingElementEntity;
import com.intellij.java.workspace.entities.PackagingElementEntity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingExternalMapping;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.ExtractedDirectoryPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Objects;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractedDirectoryPackagingElement
extends FileOrDirectoryCopyPackagingElement<ExtractedDirectoryPackagingElement> {
    private String myPathInJar;

    public ExtractedDirectoryPackagingElement() {
        super(PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE);
    }

    public ExtractedDirectoryPackagingElement(String jarPath, String pathInJar) {
        super(PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE, jarPath);
        this.myPathInJar = pathInJar;
        if (!StringUtil.startsWithChar((CharSequence)this.myPathInJar, (char)'/')) {
            this.myPathInJar = "/" + this.myPathInJar;
        }
        if (!StringUtil.endsWithChar((CharSequence)this.myPathInJar, (char)'/')) {
            this.myPathInJar = this.myPathInJar + "/";
        }
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(0);
        }
        return new ExtractedDirectoryPresentation(this);
    }

    public String toString() {
        return "extracted:" + this.getMyFilePath() + "!" + this.getMyPathInJar();
    }

    @Override
    public VirtualFile findFile() {
        VirtualFile jarFile = super.findFile();
        if (jarFile == null) {
            return null;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
        if ("/".equals(this.getMyPathInJar())) {
            return jarRoot;
        }
        return jarRoot != null ? jarRoot.findFileByRelativePath(this.getMyPathInJar()) : null;
    }

    @Override
    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(1);
        }
        return element instanceof ExtractedDirectoryPackagingElement && super.isEqualTo(element) && Objects.equals(this.getMyPathInJar(), ((ExtractedDirectoryPackagingElement)element).getPathInJar());
    }

    public ExtractedDirectoryPackagingElement getState() {
        return this;
    }

    public void loadState(@NotNull ExtractedDirectoryPackagingElement state) {
        if (state == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(2);
        }
        this.myFilePath = state.getFilePath();
        this.myPathInJar = state.getPathInJar();
    }

    @Attribute(value="path-in-jar")
    public String getPathInJar() {
        return this.getMyPathInJar();
    }

    public void setPathInJar(String pathInJar) {
        String myPathInJarBefore = this.getMyPathInJar();
        this.update(() -> {
            this.myPathInJar = pathInJar;
        }, (builder, entity) -> {
            if (myPathInJarBefore.equals(pathInJar)) {
                return;
            }
            builder.modifyEntity(ExtractedDirectoryPackagingElementEntity.Builder.class, (WorkspaceEntity)entity, ent -> {
                ent.setPathInArchive(pathInJar);
                return Unit.INSTANCE;
            });
        });
    }

    public PackagingElementEntity.Builder<? extends PackagingElementEntity> getOrAddEntityBuilder(@NotNull MutableEntityStorage diff, @NotNull EntitySource source, @NotNull Project project) {
        PackagingElementEntity existingEntity;
        if (diff == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(3);
        }
        if (source == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(5);
        }
        if ((existingEntity = (PackagingElementEntity)this.getExistingEntity(diff)) != null) {
            return this.getBuilder(diff, existingEntity);
        }
        VirtualFileUrlManager fileUrlManager = WorkspaceModel.getInstance((Project)project).getVirtualFileUrlManager();
        Objects.requireNonNull(this.myFilePath, "filePath is not specified");
        Objects.requireNonNull(this.myPathInJar, "pathInJar is not specified");
        VirtualFileUrl fileUrl = fileUrlManager.getOrCreateFromUrl(VfsUtilCore.pathToUrl((String)this.myFilePath));
        ExtractedDirectoryPackagingElementEntity addedEntity = (ExtractedDirectoryPackagingElementEntity)diff.addEntity((WorkspaceEntity.Builder)ExtractedDirectoryPackagingElementEntity.create((VirtualFileUrl)fileUrl, (String)this.myPathInJar, (EntitySource)source));
        diff.getMutableExternalMapping(PackagingExternalMapping.key).addMapping((WorkspaceEntity)addedEntity, (Object)this);
        return this.getBuilder(diff, (PackagingElementEntity)addedEntity);
    }

    @Nullable
    private String getMyPathInJar() {
        if (this.myStorage == null) {
            return this.myPathInJar;
        }
        ExtractedDirectoryPackagingElementEntity entity = (ExtractedDirectoryPackagingElementEntity)this.getThisEntity();
        String path = entity.getPathInArchive();
        if (!Objects.equals(this.myPathInJar, path)) {
            this.myPathInJar = path;
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diff";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/elements/ExtractedDirectoryPackagingElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualTo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrAddEntityBuilder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

