/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.java.workspace.entities.FileCopyPackagingElementEntity;
import com.intellij.java.workspace.entities.PackagingElementEntity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingExternalMapping;
import com.intellij.packaging.elements.RenameablePackagingElement;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.FileCopyPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.File;
import java.util.Objects;
import kotlin.Unit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileCopyPackagingElement
extends FileOrDirectoryCopyPackagingElement<FileCopyPackagingElement>
implements RenameablePackagingElement {
    @NonNls
    public static final String OUTPUT_FILE_NAME_ATTRIBUTE = "output-file-name";
    private String myRenamedOutputFileName;

    public FileCopyPackagingElement() {
        super(PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE);
    }

    public FileCopyPackagingElement(String filePath) {
        this();
        this.myFilePath = filePath;
    }

    public FileCopyPackagingElement(String filePath, String outputFileName) {
        this(filePath);
        this.myRenamedOutputFileName = outputFileName;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(0);
        }
        return new FileCopyPresentation(this.getMyFilePath(), this.getOutputFileName());
    }

    public String getOutputFileName() {
        return this.getMyRenamedOutputFileName() != null ? this.getMyRenamedOutputFileName() : PathUtil.getFileName((String)this.getMyFilePath());
    }

    @NonNls
    public String toString() {
        return "file:" + this.getMyFilePath() + (String)(this.getMyRenamedOutputFileName() != null ? ",rename to:" + this.getMyRenamedOutputFileName() : "");
    }

    public boolean isDirectory() {
        return new File(FileUtil.toSystemDependentName((String)this.getMyFilePath())).isDirectory();
    }

    @Override
    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(1);
        }
        return element instanceof FileCopyPackagingElement && super.isEqualTo(element) && Objects.equals(this.getMyRenamedOutputFileName(), ((FileCopyPackagingElement)element).getRenamedOutputFileName());
    }

    public FileCopyPackagingElement getState() {
        return this;
    }

    public void loadState(@NotNull FileCopyPackagingElement state) {
        if (state == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(2);
        }
        this.setFilePath(state.getFilePath());
        this.setRenamedOutputFileName(state.getRenamedOutputFileName());
    }

    @Attribute(value="output-file-name")
    @Nullable
    public String getRenamedOutputFileName() {
        return this.getMyRenamedOutputFileName();
    }

    public void setRenamedOutputFileName(String renamedOutputFileName) {
        String renamedBefore = this.getMyRenamedOutputFileName();
        this.update(() -> {
            this.myRenamedOutputFileName = renamedOutputFileName;
        }, (builder, entity) -> {
            if (Objects.equals(renamedBefore, renamedOutputFileName)) {
                return;
            }
            builder.modifyEntity(FileCopyPackagingElementEntity.Builder.class, (WorkspaceEntity)entity, ent -> {
                ent.setRenamedOutputFileName(renamedOutputFileName);
                return Unit.INSTANCE;
            });
        });
    }

    public String getName() {
        return this.getOutputFileName();
    }

    public boolean canBeRenamed() {
        return !this.isDirectory();
    }

    public void rename(@NotNull String newName) {
        if (newName == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(3);
        }
        String updatedName = newName.equals(PathUtil.getFileName((String)this.getMyFilePath())) ? null : newName;
        this.update(() -> {
            this.myRenamedOutputFileName = updatedName;
        }, (builder, entity) -> builder.modifyEntity(FileCopyPackagingElementEntity.Builder.class, (WorkspaceEntity)entity, ent -> {
            ent.setRenamedOutputFileName(updatedName);
            return Unit.INSTANCE;
        }));
    }

    @Nullable
    public VirtualFile getLibraryRoot() {
        String url = VfsUtil.getUrlForLibraryRoot((File)new File(FileUtil.toSystemDependentName((String)this.getFilePath())));
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    public PackagingElementEntity.Builder<? extends PackagingElementEntity> getOrAddEntityBuilder(@NotNull MutableEntityStorage diff, @NotNull EntitySource source, @NotNull Project project) {
        PackagingElementEntity existingEntity;
        if (diff == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(4);
        }
        if (source == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(5);
        }
        if (project == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(6);
        }
        if ((existingEntity = (PackagingElementEntity)this.getExistingEntity(diff)) != null) {
            return this.getBuilder(diff, existingEntity);
        }
        String renamedOutputFileName = this.myRenamedOutputFileName;
        String filePath = this.myFilePath;
        Objects.requireNonNull(filePath, "filePath is not specified");
        VirtualFileUrlManager fileUrlManager = WorkspaceModel.getInstance((Project)project).getVirtualFileUrlManager();
        VirtualFileUrl fileUrl = fileUrlManager.getOrCreateFromUrl(VfsUtilCore.pathToUrl((String)filePath));
        FileCopyPackagingElementEntity addedEntity = renamedOutputFileName != null ? (FileCopyPackagingElementEntity)diff.addEntity((WorkspaceEntity.Builder)FileCopyPackagingElementEntity.create((VirtualFileUrl)fileUrl, (EntitySource)source, entityBuilder -> {
            entityBuilder.setRenamedOutputFileName(renamedOutputFileName);
            return Unit.INSTANCE;
        })) : (FileCopyPackagingElementEntity)diff.addEntity((WorkspaceEntity.Builder)FileCopyPackagingElementEntity.create((VirtualFileUrl)fileUrl, (EntitySource)source));
        diff.getMutableExternalMapping(PackagingExternalMapping.key).addMapping((WorkspaceEntity)addedEntity, (Object)this);
        return this.getBuilder(diff, (PackagingElementEntity)addedEntity);
    }

    @Nullable
    private String getMyRenamedOutputFileName() {
        if (this.myStorage == null) {
            return this.myRenamedOutputFileName;
        }
        FileCopyPackagingElementEntity entity = (FileCopyPackagingElementEntity)this.getThisEntity();
        String path = entity.getRenamedOutputFileName();
        if (!Objects.equals(this.myRenamedOutputFileName, path)) {
            this.myRenamedOutputFileName = path;
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diff";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/elements/FileCopyPackagingElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualTo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrAddEntityBuilder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

