/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.free;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.jsx.JSXImplementation;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class ReactImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final String COMPONENT_NAME = "Component";
    private static final String LIFECYCLE_INTERFACE_WITH_MARK = "^ComponentLifecycle";
    private static final String CHILD_CONTEXT_INTERFACE_WITH_MARK = "^ChildContextProvider";
    private static final String COMPONENT_STATIC_NAME = "^ComponentClass";

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            ReactImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (!DialectDetector.isJSX((PsiElement)element)) {
            return false;
        }
        if (element instanceof JSVariable && "React".equals(((JSVariable)element).getName())) {
            return true;
        }
        if (element instanceof JSField) {
            String name = ((JSField)element).getName();
            return "defaultProps".equals(name) || "propTypes".equals(name) || "contextTypes".equals(name) || "childContextTypes".equals(name) || "displayName".equals(name);
        }
        if (!(element instanceof JSFunction) && !(element instanceof JSProperty)) {
            return false;
        }
        JSNamedElement namedElement = (JSNamedElement)element;
        String name = namedElement.getName();
        if (name == null) {
            return false;
        }
        if (this.checkForClass(namedElement, name, CHILD_CONTEXT_INTERFACE_WITH_MARK)) {
            return true;
        }
        if (this.checkForClass(namedElement, name, LIFECYCLE_INTERFACE_WITH_MARK)) {
            return true;
        }
        if (this.checkForClass(namedElement, name, COMPONENT_NAME)) {
            return true;
        }
        return this.checkForClass(namedElement, name, COMPONENT_STATIC_NAME);
    }

    public boolean checkForClass(@NotNull JSNamedElement namedElement, @NotNull String name, @NotNull String className) {
        if (namedElement == null) {
            ReactImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ReactImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        if (className == null) {
            ReactImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        Collection elements = StubIndex.getElements((StubIndexKey)JSClassIndex.KEY, (Object)className, (Project)namedElement.getProject(), (GlobalSearchScope)JSXImplementation.createLibraryScope((PsiElement)namedElement), JSElement.class);
        HashSet<JSClass> jsClasses = new HashSet<JSClass>();
        for (JSElement element : elements) {
            if (!(element instanceof JSClass)) continue;
            jsClasses.add((JSClass)element);
            ContainerUtil.addAll(jsClasses, (Object[])((JSClass)element).getSupers());
        }
        for (JSClass jsClass : jsClasses) {
            if ("Object".equals(jsClass.getName()) || jsClass.findFunctionByName(name) == null && jsClass.findFieldByName(name) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            ReactImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            ReactImplicitUsageProvider.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        objectArray2[1] = "com/intellij/react/free/ReactImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

