/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.commit;

import com.intellij.dvcs.commit.AmendCommitServiceKt;
import com.intellij.dvcs.commit.LoadDetailsTaskInfo;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.impl.shared.commit.EditedCommitDetails;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/dvcs/commit/AmendCommitService;", "Lcom/intellij/vcs/commit/AmendCommitAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "vcsLog", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "getVcsLog", "()Lcom/intellij/vcs/log/impl/VcsProjectLog;", "vcsLogObjectsFactory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "getVcsLogObjectsFactory", "()Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "getAmendCommitDetails", "Lorg/jetbrains/concurrency/CancellablePromise;", "Lcom/intellij/platform/vcs/impl/shared/commit/EditedCommitDetails;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCommitDetails", "Lorg/jetbrains/concurrency/AsyncPromise;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "hash", "Lcom/intellij/vcs/log/Hash;", "intellij.platform.vcs.dvcs.impl"})
@SourceDebugExtension(value={"SMAP\nAmendCommitService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmendCommitService.kt\ncom/intellij/dvcs/commit/AmendCommitService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,83:1\n30#2,2:84\n*S KotlinDebug\n*F\n+ 1 AmendCommitService.kt\ncom/intellij/dvcs/commit/AmendCommitService\n*L\n37#1:84,2\n*E\n"})
public abstract class AmendCommitService
implements AmendCommitAware {
    @NotNull
    private final Project project;

    public AmendCommitService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    private final VcsProjectLog getVcsLog() {
        return VcsProjectLog.Companion.getInstance(this.project);
    }

    private final VcsLogObjectsFactory getVcsLogObjectsFactory() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<VcsLogObjectsFactory> serviceClass$iv = VcsLogObjectsFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (VcsLogObjectsFactory)object;
    }

    @NotNull
    public CancellablePromise<EditedCommitDetails> getAmendCommitDetails(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Repository repository = VcsRepositoryManager.Companion.getInstance(this.project).getRepositoryForRootQuick(root);
        if (repository == null) {
            Object[] objectArray = new Object[]{root};
            String string = DvcsBundle.message((String)"error.message.amend.no.repository.for.root", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return AmendCommitServiceKt.access$rejected(string);
        }
        Repository repository2 = repository;
        VcsLogData vcsLogData = this.getVcsLog().getDataManager();
        if (vcsLogData == null) {
            String string = DvcsBundle.message((String)"error.message.amend.no.vcs.log.available", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return AmendCommitServiceKt.access$rejected(string);
        }
        VcsLogData logData = vcsLogData;
        String string = repository2.getCurrentRevision();
        if (string == null) {
            Object[] objectArray = new Object[]{root};
            String string2 = DvcsBundle.message((String)"error.message.amend.repository.is.empty.for.root", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return AmendCommitServiceKt.access$rejected(string2);
        }
        String lastCommitId = string;
        Hash hash = this.getVcsLogObjectsFactory().createHash(lastCommitId);
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"createHash(...)");
        return (CancellablePromise)this.getCommitDetails(logData, root, hash);
    }

    private final AsyncPromise<EditedCommitDetails> getCommitDetails(VcsLogData logData, VirtualFile root, Hash hash) {
        AsyncPromise promise = new AsyncPromise();
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(this.project, (TaskInfo)new LoadDetailsTaskInfo(), PerformInBackgroundOption.ALWAYS_BACKGROUND);
        promise.onError(arg_0 -> AmendCommitService.getCommitDetails$lambda$1(arg_0 -> AmendCommitService.getCommitDetails$lambda$0(indicator, arg_0), arg_0));
        logData.getCommitDetailsGetter().loadCommitsData(CollectionsKt.listOf((Object)logData.getCommitIndex(hash, root)), arg_0 -> AmendCommitService.getCommitDetails$lambda$3(arg_0 -> AmendCommitService.getCommitDetails$lambda$2(promise, hash, logData, root, arg_0), arg_0), arg_0 -> AmendCommitService.getCommitDetails$lambda$5(arg_0 -> AmendCommitService.getCommitDetails$lambda$4(promise, arg_0), arg_0), (ProgressIndicator)indicator);
        return promise;
    }

    private static final Unit getCommitDetails$lambda$0(BackgroundableProcessIndicator $indicator, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Promises.errorIfNotMessage((Logger)AmendCommitServiceKt.access$getLOG$p(), (Throwable)it);
        if ($indicator.isRunning()) {
            $indicator.cancel();
        }
        return Unit.INSTANCE;
    }

    private static final void getCommitDetails$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit getCommitDetails$lambda$2(AsyncPromise $promise, Hash $hash, VcsLogData $logData, VirtualFile $root, List commits) {
        Intrinsics.checkNotNull((Object)commits);
        AmendCommitServiceKt.access$setCommit($promise, $hash, (VcsFullCommitDetails)CollectionsKt.firstOrNull((List)commits), (VcsUser)$logData.getCurrentUser().get($root));
        return Unit.INSTANCE;
    }

    private static final void getCommitDetails$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit getCommitDetails$lambda$4(AsyncPromise $promise, Throwable error) {
        Intrinsics.checkNotNull((Object)error);
        $promise.setError(error);
        return Unit.INSTANCE;
    }

    private static final void getCommitDetails$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

