/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.PlatformUtils;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.Closeable;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"writeApplicationInfoJson", "", "out", "Ljava/io/OutputStream;", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "isLocalOrigin", "", "writeAboutJson", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nAboutHttpService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AboutHttpService.kt\norg/jetbrains/ide/AboutHttpServiceKt\n+ 2 jackson.kt\ncom/intellij/util/io/jackson/JacksonUtil\n*L\n1#1,119:1\n11#2,6:120\n21#2,5:126\n11#2,8:131\n26#2,2:139\n17#2,2:141\n*S KotlinDebug\n*F\n+ 1 AboutHttpService.kt\norg/jetbrains/ide/AboutHttpServiceKt\n*L\n79#1:120,6\n88#1:126,5\n90#1:131,8\n88#1:139,2\n79#1:141,2\n*E\n"})
public final class AboutHttpServiceKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void writeApplicationInfoJson(@NotNull OutputStream out, @Nullable QueryStringDecoder urlDecoder, boolean isLocalOrigin) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Closeable closeable = (Closeable)new JsonFactory().createGenerator(out).useDefaultPrettyPrinter();
        Throwable throwable = null;
        try {
            JsonGenerator writer = (JsonGenerator)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)writer);
            JsonGenerator $this$obj_u24default$iv = writer;
            Object fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj_u24default$iv.writeStartObject();
            boolean bl2 = false;
            AboutHttpServiceKt.writeAboutJson(writer);
            if (!isLocalOrigin) {
                return;
            }
            if (urlDecoder != null && RestService.Companion.getBooleanParameter$default(RestService.Companion, "registeredFileTypes", urlDecoder, false, 4, null)) {
                void $this$array$iv;
                JsonGenerator jsonGenerator = writer;
                String fieldName$iv2 = "registeredFileTypes";
                boolean $i$f$array = false;
                String it$iv = fieldName$iv2;
                boolean bl3 = false;
                $this$array$iv.writeFieldName(it$iv);
                $this$array$iv.writeStartArray();
                boolean bl4 = false;
                FileType[] fileTypeArray = FileTypeRegistry.getInstance().getRegisteredFileTypes();
                Intrinsics.checkNotNullExpressionValue((Object)fileTypeArray, (String)"getRegisteredFileTypes(...)");
                for (FileType fileType : fileTypeArray) {
                    JsonGenerator $this$obj_u24default$iv2 = writer;
                    Object fieldName$iv3 = null;
                    boolean $i$f$obj2 = false;
                    $this$obj_u24default$iv2.writeStartObject();
                    boolean bl5 = false;
                    writer.writeStringField("name", fileType.getName());
                    writer.writeStringField("description", fileType.getDescription());
                    writer.writeBooleanField("isBinary", fileType.isBinary());
                    $this$obj_u24default$iv2.writeEndObject();
                }
                $this$array$iv.writeEndArray();
            }
            $this$obj_u24default$iv.writeEndObject();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void writeAboutJson(@NotNull JsonGenerator writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        String appName = ApplicationInfo.getInstance().getFullApplicationName();
        if (!PlatformUtils.isIdeaUltimate()) {
            String productName = ApplicationNamesInfo.getInstance().getProductName();
            String string = appName;
            Intrinsics.checkNotNull((Object)string);
            String string2 = productName + " (" + productName + ")";
            Intrinsics.checkNotNull((Object)productName);
            appName = StringsKt.removePrefix((String)StringsKt.replace$default((String)string, (String)string2, (String)productName, (boolean)false, (int)4, null), (CharSequence)"JetBrains ");
        }
        writer.writeStringField("name", appName);
        writer.writeStringField("productName", ApplicationNamesInfo.getInstance().getProductName());
        writer.writeStringField("edition", ApplicationNamesInfo.getInstance().getEditionName());
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        BuildNumber build = buildNumber;
        writer.writeNumberField("baselineVersion", build.getBaselineVersion());
        if (!build.isSnapshot()) {
            writer.writeStringField("buildNumber", build.asStringWithoutProductCode());
        }
    }
}

