/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.h2.mvstore.MVMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.OneToManyPathMapping;
import org.jetbrains.jps.incremental.storage.PathTypeAwareRelativizer;
import org.jetbrains.jps.incremental.storage.RelativePathType;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataTypeKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001BC\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0016J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0013R\"\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalOneToManyPathMapping;", "Lorg/jetbrains/jps/incremental/storage/OneToManyPathMapping;", "map", "Lorg/h2/mvstore/MVMap;", "", "", "", "relativizer", "Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;", "valueOffset", "", "keyKind", "Lorg/jetbrains/jps/incremental/storage/RelativePathType;", "valueKind", "<init>", "(Lorg/h2/mvstore/MVMap;Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;ILorg/jetbrains/jps/incremental/storage/RelativePathType;Lorg/jetbrains/jps/incremental/storage/RelativePathType;)V", "getKey", "path", "file", "Ljava/nio/file/Path;", "getOutputs", "", "doGetValuesByRawKey", "key", "setOutputs", "", "outPaths", "remove", "intellij.platform.jps.build"})
@ApiStatus.Internal
public class ExperimentalOneToManyPathMapping
implements OneToManyPathMapping {
    @JvmField
    @NotNull
    public final MVMap<long[], String[]> map;
    @JvmField
    @NotNull
    public final PathTypeAwareRelativizer relativizer;
    private final int valueOffset;
    @NotNull
    private final RelativePathType keyKind;
    @NotNull
    private final RelativePathType valueKind;

    public ExperimentalOneToManyPathMapping(@NotNull MVMap<long[], String[]> map, @NotNull PathTypeAwareRelativizer relativizer, int valueOffset, @NotNull RelativePathType keyKind, @NotNull RelativePathType valueKind) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)relativizer, (String)"relativizer");
        Intrinsics.checkNotNullParameter((Object)((Object)keyKind), (String)"keyKind");
        Intrinsics.checkNotNullParameter((Object)((Object)valueKind), (String)"valueKind");
        this.map = map;
        this.relativizer = relativizer;
        this.valueOffset = valueOffset;
        this.keyKind = keyKind;
        this.valueKind = valueKind;
    }

    public /* synthetic */ ExperimentalOneToManyPathMapping(MVMap mVMap, PathTypeAwareRelativizer pathTypeAwareRelativizer, int n, RelativePathType relativePathType, RelativePathType relativePathType2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this((MVMap<long[], String[]>)mVMap, pathTypeAwareRelativizer, n, relativePathType, relativePathType2);
    }

    @NotNull
    public final long[] getKey(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return LongPairKeyDataTypeKt.stringTo128BitHash(this.relativizer.toRelative(path, this.keyKind));
    }

    @NotNull
    public final long[] getKey(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return LongPairKeyDataTypeKt.stringTo128BitHash(this.relativizer.toRelative(file, this.keyKind));
    }

    @Nullable
    public final List<String> getOutputs(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.doGetValuesByRawKey(this.getKey(path));
    }

    @Nullable
    public final List<Path> getOutputs(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        long[] key = this.getKey(file);
        String[] stringArray = (String[])this.map.get((Object)key);
        if (stringArray == null) {
            return null;
        }
        String[] list = stringArray;
        int n = 0;
        int n2 = list.length - this.valueOffset;
        Object[] objectArray = new Path[n2];
        while (n < n2) {
            int n3 = n++;
            objectArray[n3] = this.relativizer.toAbsoluteFile(list[n3 + this.valueOffset], this.valueKind);
        }
        return ArraysKt.asList((Object[])objectArray);
    }

    private final List<String> doGetValuesByRawKey(long[] key) {
        String[] stringArray = (String[])this.map.get((Object)key);
        if (stringArray == null) {
            return null;
        }
        String[] list = stringArray;
        int n = 0;
        int n2 = list.length - this.valueOffset;
        Object[] objectArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            objectArray[n3] = this.relativizer.toAbsolute(list[n3 + this.valueOffset], this.valueKind);
        }
        return ArraysKt.asList((Object[])objectArray);
    }

    @Override
    public void setOutputs(@NotNull Path path, @NotNull List<? extends Path> outPaths) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(outPaths, (String)"outPaths");
        if (outPaths.isEmpty()) {
            stringArray = null;
        } else {
            int n = 0;
            int n2 = outPaths.size();
            String[] stringArray2 = new String[n2];
            while (n < n2) {
                int n3 = n++;
                stringArray2[n3] = this.relativizer.toRelative(outPaths.get(n3), this.valueKind);
            }
            stringArray = stringArray2;
        }
        String[] normalizedOutputPaths = stringArray;
        String[] stringArray3 = normalizedOutputPaths == null ? (String[])this.map.remove((Object)this.getKey(path)) : (String[])this.map.put((Object)this.getKey(path), normalizedOutputPaths);
    }

    @Override
    public final void remove(@NotNull Path key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.map.remove((Object)this.getKey(key));
    }
}

