/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.type.DataType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.storage.AddItemDecisionMaker;
import org.jetbrains.jps.incremental.storage.ExperimentalOneToManyPathMapping;
import org.jetbrains.jps.incremental.storage.ExperimentalOutputToTargetMapping;
import org.jetbrains.jps.incremental.storage.ExperimentalOutputToTargetMappingKt;
import org.jetbrains.jps.incremental.storage.PathTypeAwareRelativizer;
import org.jetbrains.jps.incremental.storage.RelativePathType;
import org.jetbrains.jps.incremental.storage.RemoveItemDecisionMaker;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingCursor;
import org.jetbrains.jps.incremental.storage.StorageManager;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataType;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataTypeKt;
import org.jetbrains.jps.incremental.storage.dataTypes.StringListDataType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0004\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B=\b\u0002\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\"H\u0016J\b\u0010$\u001a\u00020\u0012H\u0007R\u0010\u0010\u0007\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalSourceToOutputMapping;", "Lorg/jetbrains/jps/builders/storage/SourceToOutputMapping;", "map", "Lorg/h2/mvstore/MVMap;", "", "", "", "relativizer", "Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;", "outputToTargetMapping", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOutputToTargetMapping;", "targetHashId", "", "<init>", "(Lorg/h2/mvstore/MVMap;Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;Lorg/jetbrains/jps/incremental/storage/ExperimentalOutputToTargetMapping;J)V", "impl", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOneToManyPathMapping;", "remove", "", "sourceFile", "Ljava/nio/file/Path;", "getOutputs", "", "sourcePath", "setOutputs", "outputPaths", "appendOutput", "outputPath", "removeOutput", "outputs", "Lkotlin/sequences/Sequence;", "cursor", "Lorg/jetbrains/jps/incremental/storage/SourceToOutputMappingCursor;", "getSourcesIterator", "", "getSourceFileIterator", "clear", "Companion", "intellij.platform.jps.build"})
@ApiStatus.Internal
public final class ExperimentalSourceToOutputMapping
implements SourceToOutputMapping {
    @NotNull
    public static final Companion Companion;
    @JvmField
    @NotNull
    public final PathTypeAwareRelativizer relativizer;
    @Nullable
    private final ExperimentalOutputToTargetMapping outputToTargetMapping;
    @JvmField
    public final long targetHashId;
    @NotNull
    private final ExperimentalOneToManyPathMapping impl;
    @NotNull
    private static final MVMap.Builder<long[], String[]> mapBuilder;

    private ExperimentalSourceToOutputMapping(MVMap<long[], String[]> map, PathTypeAwareRelativizer relativizer, ExperimentalOutputToTargetMapping outputToTargetMapping, long targetHashId) {
        this.relativizer = relativizer;
        this.outputToTargetMapping = outputToTargetMapping;
        this.targetHashId = targetHashId;
        this.impl = new ExperimentalOneToManyPathMapping(map, this.relativizer, 1, RelativePathType.SOURCE, RelativePathType.OUTPUT);
    }

    @Override
    public void remove(@NotNull Path sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        this.impl.remove(sourceFile);
    }

    @Nullable
    public List<String> getOutputs(@NotNull String sourcePath) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        return this.impl.getOutputs(sourcePath);
    }

    @Nullable
    public List<Path> getOutputs(@NotNull Path sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.impl.getOutputs(sourceFile);
    }

    public void setOutputs(@NotNull Path sourceFile, @NotNull List<? extends Path> outputPaths) {
        block4: {
            String[] normalizeOutputPaths;
            long[] key;
            block3: {
                String[] stringArray;
                Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
                Intrinsics.checkNotNullParameter(outputPaths, (String)"outputPaths");
                String relativeSourcePath = this.relativizer.toRelative(sourceFile, RelativePathType.SOURCE);
                key = LongPairKeyDataTypeKt.stringTo128BitHash(relativeSourcePath);
                if (outputPaths.isEmpty()) {
                    stringArray = null;
                } else {
                    int n = outputPaths.size() + 1;
                    String[] stringArray2 = new String[n];
                    for (int i = 0; i < n; ++i) {
                        int n2 = i;
                        stringArray2[n2] = n2 == 0 ? relativeSourcePath : this.impl.relativizer.toRelative(outputPaths.get(n2 - 1), RelativePathType.OUTPUT);
                    }
                    stringArray = normalizeOutputPaths = stringArray2;
                }
                if (normalizeOutputPaths != null) break block3;
                this.impl.map.remove((Object)key);
                break block4;
            }
            this.impl.map.put((Object)key, normalizeOutputPaths);
            ExperimentalOutputToTargetMapping experimentalOutputToTargetMapping = this.outputToTargetMapping;
            if (experimentalOutputToTargetMapping == null) break block4;
            experimentalOutputToTargetMapping.addMappings(normalizeOutputPaths, this.targetHashId);
        }
    }

    @Override
    public void appendOutput(@NotNull String sourcePath, @NotNull String outputPath) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
            String relativeSourcePath = this.relativizer.toRelative(sourcePath, RelativePathType.SOURCE);
            String relativeOutputPath = this.relativizer.toRelative(outputPath, RelativePathType.OUTPUT);
            this.impl.map.operate((Object)LongPairKeyDataTypeKt.stringTo128BitHash(relativeSourcePath), null, (MVMap.DecisionMaker)new AddItemDecisionMaker(relativeSourcePath, relativeOutputPath));
            ExperimentalOutputToTargetMapping experimentalOutputToTargetMapping = this.outputToTargetMapping;
            if (experimentalOutputToTargetMapping == null) break block0;
            experimentalOutputToTargetMapping.addMapping(relativeOutputPath, this.targetHashId);
        }
    }

    @Override
    public void removeOutput(@NotNull String sourcePath, @NotNull String outputPath) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        this.impl.map.operate((Object)this.impl.getKey(sourcePath), null, (MVMap.DecisionMaker)new RemoveItemDecisionMaker(this.relativizer.toRelative(outputPath, RelativePathType.OUTPUT)));
    }

    @NotNull
    public final Sequence<String> outputs() {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ExperimentalSourceToOutputMapping this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var7_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        cursor = ExperimentalSourceToOutputMapping.access$getImpl$p((ExperimentalSourceToOutputMapping)this.this$0).map.cursor(null);
                        while (cursor.hasNext()) {
                            cursor.next();
                            list = (String[])cursor.getValue();
                            index = 1;
                            var6_7 = list.length;
lbl13:
                            // 2 sources

                            while (index < var6_7) {
                                this.L$0 = $this$sequence;
                                this.L$1 = cursor;
                                this.L$2 = list;
                                this.I$0 = index;
                                this.I$1 = var6_7;
                                this.label = 1;
                                v0 = $this$sequence.yield((Object)list[index], (Continuation)this);
                                if (v0 == var7_3) {
                                    return var7_3;
                                }
                                ** GOTO lbl33
                            }
                        }
                        break;
                    }
                    case 1: {
                        var6_7 = this.I$1;
                        index = this.I$0;
                        list = (String[])this.L$2;
                        cursor = (Cursor)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl33:
                        // 2 sources

                        ++index;
                        ** GOTO lbl13
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super String> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @NotNull
    public SourceToOutputMappingCursor cursor() {
        return new SourceToOutputMappingCursor(this){
            private final Cursor<long[], String[]> cursor;
            final /* synthetic */ ExperimentalSourceToOutputMapping this$0;
            {
                this.this$0 = $receiver;
                this.cursor = ExperimentalSourceToOutputMapping.access$getImpl$p((ExperimentalSourceToOutputMapping)$receiver).map.cursor(null);
            }

            public boolean hasNext() {
                return this.cursor.hasNext();
            }

            public String next() {
                this.cursor.next();
                return this.this$0.relativizer.toAbsolute(((String[])this.cursor.getValue())[0], RelativePathType.SOURCE);
            }

            public String[] getOutputPaths() {
                String[] list = (String[])this.cursor.getValue();
                int n = 0;
                int n2 = list.length - 1;
                String[] stringArray = new String[n2];
                while (n < n2) {
                    int n3 = n++;
                    stringArray[n3] = this.this$0.relativizer.toAbsolute(list[n3 + 1], RelativePathType.OUTPUT);
                }
                return stringArray;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Override
    @NotNull
    public Iterator<String> getSourcesIterator() {
        return this.cursor();
    }

    @Override
    @NotNull
    public Iterator<Path> getSourceFileIterator() {
        return new Iterator<Path>(this){
            private final Cursor<long[], String[]> cursor;
            final /* synthetic */ ExperimentalSourceToOutputMapping this$0;
            {
                this.this$0 = $receiver;
                this.cursor = ExperimentalSourceToOutputMapping.access$getImpl$p((ExperimentalSourceToOutputMapping)$receiver).map.cursor(null);
            }

            public boolean hasNext() {
                return this.cursor.hasNext();
            }

            public Path next() {
                this.cursor.next();
                return this.this$0.relativizer.toAbsoluteFile(((String[])this.cursor.getValue())[0], RelativePathType.SOURCE);
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @TestOnly
    public final void clear() {
        this.impl.map.clear();
    }

    public /* synthetic */ ExperimentalSourceToOutputMapping(MVMap map, PathTypeAwareRelativizer relativizer, ExperimentalOutputToTargetMapping outputToTargetMapping, long targetHashId, DefaultConstructorMarker $constructor_marker) {
        this((MVMap<long[], String[]>)map, relativizer, outputToTargetMapping, targetHashId);
    }

    public static final /* synthetic */ ExperimentalOneToManyPathMapping access$getImpl$p(ExperimentalSourceToOutputMapping $this) {
        return $this.impl;
    }

    static {
        MVMap.Builder builder;
        Companion = new Companion(null);
        MVMap.Builder it = builder = new MVMap.Builder();
        boolean bl = false;
        it.setKeyType((DataType)LongPairKeyDataType.INSTANCE);
        it.setValueType((DataType)StringListDataType.INSTANCE);
        mapBuilder = builder;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalSourceToOutputMapping$Companion;", "", "<init>", "()V", "mapBuilder", "Lorg/h2/mvstore/MVMap$Builder;", "", "", "", "createSourceToOutputMap", "Lorg/jetbrains/jps/incremental/storage/ExperimentalSourceToOutputMapping;", "storageManager", "Lorg/jetbrains/jps/incremental/storage/StorageManager;", "relativizer", "Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;", "targetId", "targetTypeId", "outputToTargetMapping", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOutputToTargetMapping;", "intellij.platform.jps.build"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @ApiStatus.Internal
        @NotNull
        public final ExperimentalSourceToOutputMapping createSourceToOutputMap(@NotNull StorageManager storageManager, @NotNull PathTypeAwareRelativizer relativizer, @NotNull String targetId, @NotNull String targetTypeId, @Nullable ExperimentalOutputToTargetMapping outputToTargetMapping) {
            Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
            Intrinsics.checkNotNullParameter((Object)relativizer, (String)"relativizer");
            Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
            Intrinsics.checkNotNullParameter((Object)targetTypeId, (String)"targetTypeId");
            String mapName = storageManager.getMapName(targetId, targetTypeId, "src-to-out-v1");
            return new ExperimentalSourceToOutputMapping(storageManager.openMap(mapName, mapBuilder), relativizer, outputToTargetMapping, ExperimentalOutputToTargetMappingKt.targetToHash(targetId, targetTypeId), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

