/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.ide.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionsCatalog;
import com.intellij.vcs.github.ultimate.features.i18n.GithubUltimateBundle;
import com.intellij.vcs.github.ultimate.features.ide.inspections.ActionInspectionsUtilKt;
import com.intellij.vcs.github.ultimate.features.ide.inspections.BaseGitHubActionInspection;
import com.intellij.vcs.github.ultimate.features.ide.inspections.UndefinedActionInspection;
import com.intellij.vcs.github.ultimate.features.ide.intentions.ReloadActionIntention;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/github/ultimate/features/ide/inspections/UndefinedActionInspection;", "Lcom/intellij/vcs/github/ultimate/features/ide/inspections/BaseGitHubActionInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.vcs.github.ultimate.features"})
public final class UndefinedActionInspection
extends BaseGitHubActionInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new YamlPsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitKeyValue(YAMLKeyValue keyValue) {
                String scheme;
                Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
                if (!ActionInspectionsUtilKt.getStepFileReferencePattern().accepts((Object)keyValue) && !ActionInspectionsUtilKt.getReusableWorkflowPattern().accepts((Object)keyValue)) {
                    super.visitKeyValue(keyValue);
                    return;
                }
                YAMLValue yAMLValue = keyValue.getValue();
                if (yAMLValue == null) {
                    return;
                }
                YAMLValue actionReference = yAMLValue;
                String string = actionReference.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                Url url = Urls.parseEncoded((String)string);
                String string2 = scheme = url != null ? url.getScheme() : null;
                if (scheme != null) {
                    return;
                }
                String string3 = actionReference.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                if (!StringsKt.contains$default((CharSequence)string3, (char)'/', (boolean)false, (int)2, null)) {
                    return;
                }
                buildVisitor.1 $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(buildVisitor.1.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("UndefinedActionInspection.visitKeyValue(): " + actionReference.getText());
                try {
                    Project project = actionReference.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    ComponentManager $this$service$iv = (ComponentManager)project;
                    boolean $i$f$service = false;
                    Class<GitHubActionsCatalog> serviceClass$iv = GitHubActionsCatalog.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    ((GitHubActionsCatalog)object).resolveActionMetadata(actionReference.getText());
                }
                catch (GithubStatusCodeException exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = actionReference.getText();
                    objectArray[1] = exception.getStatusCode();
                    String string4 = exception.getMessage();
                    if (string4 == null) {
                        string4 = "";
                    }
                    objectArray[2] = string4;
                    String string5 = GithubUltimateBundle.message("inspection.message.unresolved.action.with.issue.reference", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                    String message = string5;
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{IntentionWrapper.wrapToQuickFix((IntentionAction)((IntentionAction)new ReloadActionIntention()), (PsiFile)actionReference.getContainingFile())};
                    this.$holder.registerProblem((PsiElement)actionReference, message, localQuickFixArray);
                }
            }
        };
    }
}

