/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.icons.AllIcons;
import com.intellij.java.JavaPluginDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.EmptyCompileScopeBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import com.intellij.util.concurrency.Semaphore;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompileStepBeforeRun
extends BeforeRunTaskProvider<MakeBeforeRunTask>
implements DumbAware {
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Make");
    private static final Logger LOG = Logger.getInstance(CompileStepBeforeRun.class);
    @NonNls
    private static final String MAKE_PROJECT_ON_RUN_KEY = "makeProjectOnRun";
    private final Project myProject;

    public CompileStepBeforeRun(@NotNull Project project) {
        if (project == null) {
            CompileStepBeforeRun.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
    }

    public String getDescription(MakeBeforeRunTask task) {
        return ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.Actions.Compile;
    }

    public Icon getTaskIcon(MakeBeforeRunTask task) {
        return AllIcons.Actions.Compile;
    }

    @Nullable
    public MakeBeforeRunTask createTask(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            CompileStepBeforeRun.$$$reportNull$$$0(1);
        }
        MakeBeforeRunTask task = null;
        if (CompileStepBeforeRun.shouldCreateTask(configuration)) {
            task = new MakeBeforeRunTask();
            task.setEnabled(CompileStepBeforeRun.isEnabledByDefault(configuration));
        }
        return task;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull MakeBeforeRunTask task) {
        if (context == null) {
            CompileStepBeforeRun.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            CompileStepBeforeRun.$$$reportNull$$$0(3);
        }
        if (env == null) {
            CompileStepBeforeRun.$$$reportNull$$$0(4);
        }
        if (task == null) {
            CompileStepBeforeRun.$$$reportNull$$$0(5);
        }
        return CompileStepBeforeRun.doMake(this.myProject, configuration, env, false);
    }

    private static boolean isEnabledByDefault(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            CompileStepBeforeRun.$$$reportNull$$$0(6);
        }
        if (configuration instanceof RunProfileWithCompileBeforeLaunchOption) {
            return ((RunProfileWithCompileBeforeLaunchOption)configuration).isBuildBeforeLaunchAddedByDefault();
        }
        return false;
    }

    static boolean shouldCreateTask(RunConfiguration configuration) {
        return !(configuration instanceof RemoteConfiguration) && configuration instanceof RunProfileWithCompileBeforeLaunchOption;
    }

    static boolean doMake(Project myProject, RunConfiguration configuration, ExecutionEnvironment env, boolean ignoreErrors) {
        return CompileStepBeforeRun.doMake(myProject, configuration, env, ignoreErrors, Boolean.getBoolean(MAKE_PROJECT_ON_RUN_KEY));
    }

    static boolean doMake(Project myProject, RunConfiguration configuration, ExecutionEnvironment env, boolean ignoreErrors, boolean forceMakeProject) {
        if (!(configuration instanceof RunProfileWithCompileBeforeLaunchOption)) {
            return true;
        }
        RunProfileWithCompileBeforeLaunchOption runConfiguration = (RunProfileWithCompileBeforeLaunchOption)configuration;
        if (runConfiguration.isExcludeCompileBeforeLaunchOption() || configuration instanceof RunConfigurationBase && ((RunConfigurationBase)configuration).excludeCompileBeforeLaunchOption()) {
            return true;
        }
        Ref result = new Ref((Object)Boolean.FALSE);
        try {
            Semaphore done = new Semaphore(1);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (myProject.isDisposed()) {
                    done.up();
                    return;
                }
                ProjectTaskManager projectTaskManager = ProjectTaskManager.getInstance((Project)myProject);
                try {
                    Pair pair = (Pair)ReadAction.nonBlocking(() -> {
                        Object projectTask;
                        if (forceMakeProject) {
                            projectTask = projectTaskManager.createAllModulesBuildTask(true, myProject);
                        } else {
                            Module[] modules = runConfiguration.getModules();
                            if (modules.length > 0) {
                                for (Module module : modules) {
                                    if (module != null) continue;
                                    LOG.error("RunConfiguration should not return null modules. Configuration=" + runConfiguration.getName() + "; class=" + runConfiguration.getClass().getName());
                                }
                                Ref includeTests = new Ref((Object)true);
                                if (configuration instanceof JavaRunConfigurationBase) {
                                    JavaRunConfigurationBase conf = (JavaRunConfigurationBase)configuration;
                                    String runClass = conf.getRunClass();
                                    JavaRunConfigurationModule confModule = (JavaRunConfigurationModule)conf.getConfigurationModule();
                                    if (runClass != null && confModule != null) {
                                        DumbService.getInstance((Project)confModule.getProject()).runWithAlternativeResolveEnabled(() -> {
                                            try {
                                                includeTests.set((Object)((JavaParametersUtil.getClasspathType((RunConfigurationModule)confModule, runClass, false, true) & 4) != 0 ? 1 : 0));
                                            }
                                            catch (CantRunException cantRunException) {
                                                // empty catch block
                                            }
                                        });
                                    }
                                }
                                projectTask = projectTaskManager.createModulesBuildTask(modules, true, true, true, ((Boolean)includeTests.get()).booleanValue());
                            } else {
                                projectTask = runConfiguration.isBuildProjectOnEmptyModuleList() ? projectTaskManager.createAllModulesBuildTask(true, myProject) : new EmptyCompileScopeBuildTaskImpl(true);
                            }
                        }
                        ProjectTaskContext context = new ProjectTaskContext(ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)env), configuration, env.isAutoTriggered());
                        env.copyUserDataTo((UserDataHolderBase)context);
                        return new Pair((Object)context, projectTask);
                    }).expireWith((Disposable)JavaPluginDisposable.getInstance((Project)myProject)).executeSynchronously();
                    ProjectTaskManagerImpl.putBuildOriginator((Project)myProject, CompileStepBeforeRun.class);
                    ApplicationManager.getApplication().invokeAndWait(() -> ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).saveAllDocuments(false));
                    projectTaskManager.run((ProjectTaskContext)pair.first, (ProjectTask)pair.second).onSuccess(taskResult -> {
                        if (!(taskResult.hasErrors() && !ignoreErrors || taskResult.isAborted())) {
                            result.set((Object)Boolean.TRUE);
                        }
                    }).onProcessed(taskResult -> done.up());
                }
                catch (ProcessCanceledException e) {
                    done.up();
                }
            });
            done.waitFor();
        }
        catch (Throwable e) {
            return false;
        }
        return (Boolean)result.get();
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(CompileContext context) {
        return CompileStepBeforeRun.getRunConfiguration(context.getCompileScope());
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(CompileScope compileScope) {
        return (RunConfiguration)compileScope.getUserData(CompilerManager.RUN_CONFIGURATION_KEY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/options/CompileStepBeforeRun";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledByDefault";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MakeBeforeRunTask
    extends BeforeRunTask<MakeBeforeRunTask> {
        public MakeBeforeRunTask() {
            super(ID);
            this.setEnabled(true);
        }
    }
}

