/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.scratch.JavaScratchCompilationSupport;
import com.intellij.execution.scratch.JavaScratchConfigurable;
import com.intellij.execution.scratch.JavaScratchConfigurationOptions;
import com.intellij.execution.scratch.JavaScratchPositionManager;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaScratchConfiguration
extends ApplicationConfiguration {
    JavaScratchConfiguration(String name, @NotNull Project project, @NotNull ConfigurationFactory factory) {
        if (project == null) {
            JavaScratchConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            JavaScratchConfiguration.$$$reportNull$$$0(1);
        }
        super(name, project, factory);
    }

    public boolean isBuildProjectOnEmptyModuleList() {
        return false;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE(this);
        String className = this.getMainClassName();
        if (className == null || className.isEmpty()) {
            throw new RuntimeConfigurationError(ExecutionBundle.message((String)"no.main.class.specified.error.text", (Object[])new Object[0]));
        }
        if (this.getScratchFileUrl() == null) {
            throw new RuntimeConfigurationError(JavaCompilerBundle.message((String)"error.no.scratch.file.associated.with.configuration", (Object[])new Object[0]));
        }
        if (this.getScratchVirtualFile() == null) {
            throw new RuntimeConfigurationError(JavaCompilerBundle.message((String)"error.associated.scratch.file.not.found", (Object[])new Object[0]));
        }
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)((JavaRunConfigurationModule)this.getConfigurationModule()).getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid(this);
    }

    @Override
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            JavaScratchConfiguration.$$$reportNull$$$0(2);
        }
        if (env == null) {
            JavaScratchConfiguration.$$$reportNull$$$0(3);
        }
        ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration> state = new ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration>(this, env){

            @Override
            protected JavaParameters createJavaParameters() throws ExecutionException {
                ParametersList vmOptions;
                JavaSdkVersion version;
                JavaParameters params = super.createJavaParameters();
                Sdk jdk = params.getJdk();
                if (jdk != null && (version = JavaSdk.getInstance().getVersion(jdk)) != null && version.getMaxLanguageLevel().isPreview() && !(vmOptions = params.getVMParametersList()).hasParameter("--enable-preview")) {
                    vmOptions.add("--enable-preview");
                }
                return params;
            }

            @Override
            protected void setupJavaParameters(@NotNull JavaParameters params) throws ExecutionException {
                if (params == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.setupJavaParameters(params);
                File scrachesOutput = JavaScratchCompilationSupport.getScratchOutputDirectory(JavaScratchConfiguration.this.getProject());
                if (scrachesOutput != null) {
                    params.getClassPath().addFirst(FileUtil.toCanonicalPath((String)scrachesOutput.getAbsolutePath()).replace('/', File.separatorChar));
                }
            }

            @Override
            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                VirtualFile vFile;
                OSProcessHandler handler = super.startProcess();
                if (this.getRunnerSettings() instanceof DebuggingRunnerData && (vFile = ((JavaScratchConfiguration)this.getConfiguration()).getScratchVirtualFile()) != null) {
                    DebuggerManager.getInstance((Project)JavaScratchConfiguration.this.getProject()).addDebugProcessListener((ProcessHandler)handler, new DebugProcessListener(){

                        public void processAttached(@NotNull DebugProcess process) {
                            if (process == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (vFile.isValid()) {
                                process.appendPositionManager((PositionManager)new JavaScratchPositionManager((DebugProcessImpl)process, vFile));
                            }
                            process.removeDebugProcessListener((DebugProcessListener)this);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/scratch/JavaScratchConfiguration$1$1", "processAttached"));
                        }
                    });
                }
                OSProcessHandler oSProcessHandler = handler;
                if (oSProcessHandler == null) {
                    1.$$$reportNull$$$0(1);
                }
                return oSProcessHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "params";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/scratch/JavaScratchConfiguration$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/scratch/JavaScratchConfiguration$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "setupJavaParameters";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), ((JavaRunConfigurationModule)this.getConfigurationModule()).getSearchScope()));
        return state;
    }

    @Override
    @Nullable
    public PsiClass getMainClass() {
        final String mainClassName = this.getMainClassName();
        if (mainClassName == null) {
            throw new IllegalStateException("Main class name is not set");
        }
        VirtualFile scratchVirtualFile = this.getScratchVirtualFile();
        if (scratchVirtualFile == null) {
            throw new IllegalArgumentException("VirtualFile of the scratch file doesn't exist");
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(scratchVirtualFile);
        if (!(psiFile instanceof PsiJavaFile)) {
            throw new IllegalArgumentException("PsiJavaFile expected");
        }
        PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
        final Ref psiClassRef = Ref.create(null);
        psiJavaFile.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(this){

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (mainClassName.equals(aClass.getQualifiedName())) {
                    psiClassRef.set((Object)aClass);
                }
                super.visitClass(aClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/execution/scratch/JavaScratchConfiguration$2", "visitClass"));
            }
        });
        return (PsiClass)psiClassRef.get();
    }

    @Override
    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new JavaScratchConfigurable(this.getProject());
    }

    public void setScratchFileUrl(String url) {
        this.getOptions().setScratchFileUrl(url);
    }

    @Nullable
    public String getScratchFileUrl() {
        return this.getOptions().getScratchFileUrl();
    }

    @Nullable
    public VirtualFile getScratchVirtualFile() {
        String url = this.getScratchFileUrl();
        return url == null ? null : VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Override
    @NotNull
    protected JavaScratchConfigurationOptions getOptions() {
        JavaScratchConfigurationOptions javaScratchConfigurationOptions = (JavaScratchConfigurationOptions)super.getOptions();
        if (javaScratchConfigurationOptions == null) {
            JavaScratchConfiguration.$$$reportNull$$$0(4);
        }
        return javaScratchConfigurationOptions;
    }

    @Override
    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return null;
    }

    @Override
    @Nullable
    public String getDefaultTargetName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/scratch/JavaScratchConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/scratch/JavaScratchConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

