/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.AbstractApplicationConfigurationProducer;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.scratch.JavaScratchConfiguration;
import com.intellij.execution.scratch.JavaScratchConfigurationType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class JavaScratchConfigurationProducer
extends AbstractApplicationConfigurationProducer<JavaScratchConfiguration>
implements DumbAware {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        JavaScratchConfigurationType javaScratchConfigurationType = JavaScratchConfigurationType.getInstance();
        if (javaScratchConfigurationType == null) {
            JavaScratchConfigurationProducer.$$$reportNull$$$0(0);
        }
        return javaScratchConfigurationType;
    }

    @Override
    protected boolean setupConfigurationFromContext(@NotNull JavaScratchConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiFile psiFile;
        VirtualFile vFile;
        Location location;
        if (configuration == null) {
            JavaScratchConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JavaScratchConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            JavaScratchConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((location = context.getLocation()) != null && (vFile = location.getVirtualFile()) != null && ScratchUtil.isScratch((VirtualFile)vFile) && (psiFile = location.getPsiElement().getContainingFile()) != null && psiFile.getLanguage() == JavaLanguage.INSTANCE) {
            configuration.setScratchFileUrl(vFile.getUrl());
            return super.setupConfigurationFromContext(configuration, context, sourceElement);
        }
        return false;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            JavaScratchConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (other == null) {
            JavaScratchConfigurationProducer.$$$reportNull$$$0(5);
        }
        return other.isProducedBy(AbstractApplicationConfigurationProducer.class) && !other.isProducedBy(JavaScratchConfigurationProducer.class);
    }

    @Override
    public boolean isConfigurationFromContext(@NotNull JavaScratchConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiFile containingFile;
        VirtualFile scratchFile;
        PsiElement location;
        PsiClass aClass;
        if (configuration == null) {
            JavaScratchConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JavaScratchConfigurationProducer.$$$reportNull$$$0(7);
        }
        return (aClass = ApplicationConfigurationType.getMainClass(location = context.getPsiLocation())) != null && Objects.equals(aClass.getQualifiedName(), configuration.getMainClassName()) && (scratchFile = configuration.getScratchVirtualFile()) != null && (containingFile = aClass.getContainingFile()) != null && scratchFile.equals(containingFile.getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/scratch/JavaScratchConfigurationProducer";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/scratch/JavaScratchConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

