/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.testframework.AbstractJavaTestConfigurationProducer;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractPatternBasedConfigurationProducer<T extends JavaTestConfigurationBase>
extends AbstractJavaTestConfigurationProducer<T>
implements Cloneable {
    protected AbstractPatternBasedConfigurationProducer() {
    }

    public boolean isConfiguredFromContext(ConfigurationContext context, Set<String> patterns) {
        int patternsSize;
        LinkedHashSet classes = new LinkedHashSet();
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible((DataContext)dataContext)) {
            return false;
        }
        PsiElement[] locationElements = this.collectLocationElements(classes, dataContext);
        if (locationElements == null) {
            this.collectContextElements(dataContext, true, false, classes, (PsiElementProcessor.CollectElements<PsiElement>)new PsiElementProcessor.CollectElements());
        }
        if ((patternsSize = patterns.size()) == classes.size()) {
            String pattern;
            Iterator<String> patternsIterator = patterns.iterator();
            Iterator classesIterator = classes.iterator();
            while (patternsIterator.hasNext() && classesIterator.hasNext()) {
                if (Objects.equals(patternsIterator.next(), classesIterator.next())) continue;
                return false;
            }
            if (patternsSize == 1 && !(pattern = patterns.iterator().next()).contains(",")) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)), PsiMethod.class);
                return method != null && this.isTestMethod(false, method);
            }
            return true;
        }
        return false;
    }

    public PsiElement checkPatterns(ConfigurationContext context, LinkedHashSet<? super String> classes) {
        PsiElement[] result;
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible((DataContext)dataContext)) {
            return null;
        }
        PsiElement[] locationElements = this.collectLocationElements(classes, dataContext);
        PsiElementProcessor.CollectElements processor = new PsiElementProcessor.CollectElements();
        if (locationElements != null) {
            this.collectTestMembers(locationElements, false, true, (PsiElementProcessor.CollectElements<PsiElement>)processor);
            result = processor.toArray();
        } else if (this.collectContextElements(dataContext, true, true, classes, (PsiElementProcessor.CollectElements<PsiElement>)processor)) {
            result = processor.toArray();
        } else {
            return null;
        }
        if (result.length <= 1) {
            return null;
        }
        return result[0];
    }
}

