/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.DefaultJreSelectorKt;
import com.intellij.execution.ui.ModuleClasspathCombo;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.FactoryMap;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000 \u000f2\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00060\u0005H&J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector;", "", "<init>", "()V", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "", "getVersion", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "isValid", "", "getDescriptionString", "Companion", "ProjectSdkSelector", "SdkFromModuleDependencies", "SdkFromSourceRootDependencies", "intellij.java.execution.impl"})
public abstract class DefaultJreSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract Pair<String, String> getNameAndDescription();

    @Nullable
    public String getVersion() {
        return null;
    }

    public void addChangeListener(@NotNull Runnable listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public boolean isValid() {
        return true;
    }

    @Nls
    @NotNull
    public final String getDescriptionString() {
        Pair<String, String> pair = this.getNameAndDescription();
        String name = (String)ExtensionsKt.component1(pair);
        String description = (String)ExtensionsKt.component2(pair);
        String string = name;
        if (string == null) {
            String string2 = JavaBundle.message((String)"no.jre.description", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        return " (" + string + " - " + description + ")";
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector projectSdk(@NotNull Project project) {
        return Companion.projectSdk(project);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromModuleDependencies(@NotNull ModulesComboBox moduleComboBox, boolean productionOnly) {
        return Companion.fromModuleDependencies(moduleComboBox, productionOnly);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromModuleDependencies(@NotNull ModuleDescriptionsComboBox moduleComboBox, boolean productionOnly) {
        return Companion.fromModuleDependencies(moduleComboBox, productionOnly);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromModuleDependencies(@NotNull ModuleClasspathCombo moduleComboBox, boolean productionOnly) {
        return Companion.fromModuleDependencies(moduleComboBox, productionOnly);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModulesComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
        return Companion.fromSourceRootsDependencies(moduleComboBox, classSelector);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModuleDescriptionsComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
        return Companion.fromSourceRootsDependencies(moduleComboBox, classSelector);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModuleClasspathCombo moduleComboBox, @NotNull EditorTextField classSelector) {
        return Companion.fromSourceRootsDependencies(moduleComboBox, classSelector);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0012H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$Companion;", "", "<init>", "()V", "projectSdk", "Lcom/intellij/execution/ui/DefaultJreSelector;", "project", "Lcom/intellij/openapi/project/Project;", "fromModuleDependencies", "moduleComboBox", "Lcom/intellij/application/options/ModulesComboBox;", "productionOnly", "", "Lcom/intellij/application/options/ModuleDescriptionsComboBox;", "Lcom/intellij/execution/ui/ModuleClasspathCombo;", "fromSourceRootsDependencies", "classSelector", "Lcom/intellij/ui/EditorTextFieldWithBrowseButton;", "Lcom/intellij/ui/EditorTextField;", "intellij.java.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector projectSdk(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new ProjectSdkSelector(project);
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromModuleDependencies(@NotNull ModulesComboBox moduleComboBox, boolean productionOnly) {
            Intrinsics.checkNotNullParameter((Object)moduleComboBox, (String)"moduleComboBox");
            return new SdkFromModuleDependencies<ComboBox>((ComboBox)moduleComboBox, fromModuleDependencies.1.INSTANCE, (Function0<Boolean>)((Function0)() -> Companion.fromModuleDependencies$lambda$0(productionOnly)));
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromModuleDependencies(@NotNull ModuleDescriptionsComboBox moduleComboBox, boolean productionOnly) {
            Intrinsics.checkNotNullParameter((Object)moduleComboBox, (String)"moduleComboBox");
            return new SdkFromModuleDependencies<ComboBox>((ComboBox)moduleComboBox, fromModuleDependencies.3.INSTANCE, (Function0<Boolean>)((Function0)() -> Companion.fromModuleDependencies$lambda$1(productionOnly)));
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromModuleDependencies(@NotNull ModuleClasspathCombo moduleComboBox, boolean productionOnly) {
            Intrinsics.checkNotNullParameter((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            return new SdkFromModuleDependencies<ComboBox>(moduleComboBox, fromModuleDependencies.5.INSTANCE, (Function0<Boolean>)((Function0)() -> Companion.fromModuleDependencies$lambda$2(productionOnly)));
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModulesComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
            Intrinsics.checkNotNullParameter((Object)moduleComboBox, (String)"moduleComboBox");
            Intrinsics.checkNotNullParameter((Object)classSelector, (String)"classSelector");
            ComboBox comboBox = (ComboBox)moduleComboBox;
            Function1 function1 = fromSourceRootsDependencies.1.INSTANCE;
            JComponent jComponent = classSelector.getChildComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getChildComponent(...)");
            return new SdkFromSourceRootDependencies<ComboBox>(comboBox, function1, (EditorTextField)jComponent);
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModuleDescriptionsComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
            Intrinsics.checkNotNullParameter((Object)moduleComboBox, (String)"moduleComboBox");
            Intrinsics.checkNotNullParameter((Object)classSelector, (String)"classSelector");
            ComboBox comboBox = (ComboBox)moduleComboBox;
            Function1 function1 = fromSourceRootsDependencies.2.INSTANCE;
            JComponent jComponent = classSelector.getChildComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getChildComponent(...)");
            return new SdkFromSourceRootDependencies<ComboBox>(comboBox, function1, (EditorTextField)jComponent);
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModuleClasspathCombo moduleComboBox, @NotNull EditorTextField classSelector) {
            Intrinsics.checkNotNullParameter((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            Intrinsics.checkNotNullParameter((Object)classSelector, (String)"classSelector");
            return new SdkFromSourceRootDependencies<ComboBox>((ComboBox)moduleComboBox, (Function1)fromSourceRootsDependencies.3.INSTANCE, classSelector);
        }

        private static final boolean fromModuleDependencies$lambda$0(boolean $productionOnly) {
            return $productionOnly;
        }

        private static final boolean fromModuleDependencies$lambda$1(boolean $productionOnly) {
            return $productionOnly;
        }

        private static final boolean fromModuleDependencies$lambda$2(boolean $productionOnly) {
            return $productionOnly;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\n0\tH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$ProjectSdkSelector;", "Lcom/intellij/execution/ui/DefaultJreSelector;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "", "getVersion", "isValid", "", "intellij.java.execution.impl"})
    public static final class ProjectSdkSelector
    extends DefaultJreSelector {
        @NotNull
        private final Project project;

        public ProjectSdkSelector(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Override
        @NotNull
        public Pair<String, String> getNameAndDescription() {
            Pair pair = Pair.create((Object)ProjectRootManager.getInstance((Project)this.project).getProjectSdkName(), (Object)"project SDK");
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
            return pair;
        }

        @Override
        @Nullable
        public String getVersion() {
            Sdk sdk = ProjectRootManager.getInstance((Project)this.project).getProjectSdk();
            return sdk != null ? sdk.getVersionString() : null;
        }

        @Override
        public boolean isValid() {
            return !this.project.isDisposed();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B3\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\nH\u0016R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011RV\u0010\u0012\u001aJ\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00150\u0015 \u0014*#\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00150\u00150\u0017\u00a2\u0006\u0002\b\u00160\u0013\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromModuleDependencies;", "T", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/execution/ui/DefaultJreSelector;", "moduleComboBox", "getSelectedModule", "Lkotlin/Function1;", "Lcom/intellij/openapi/module/Module;", "productionOnly", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/ui/ComboBox;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "Lcom/intellij/openapi/ui/ComboBox;", "getGetSelectedModule", "()Lkotlin/jvm/functions/Function1;", "getProductionOnly", "()Lkotlin/jvm/functions/Function0;", "jdkCache", "", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lorg/jetbrains/annotations/NotNull;", "", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "", "getVersion", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "isValid", "intellij.java.execution.impl"})
    public static class SdkFromModuleDependencies<T extends ComboBox<?>>
    extends DefaultJreSelector {
        @NotNull
        private final T moduleComboBox;
        @NotNull
        private final Function1<T, Module> getSelectedModule;
        @NotNull
        private final Function0<Boolean> productionOnly;
        @NotNull
        private final Map<Module, Sdk> jdkCache;

        public SdkFromModuleDependencies(@NotNull T moduleComboBox, @NotNull Function1<? super T, ? extends Module> getSelectedModule, @NotNull Function0<Boolean> productionOnly) {
            Intrinsics.checkNotNullParameter(moduleComboBox, (String)"moduleComboBox");
            Intrinsics.checkNotNullParameter(getSelectedModule, (String)"getSelectedModule");
            Intrinsics.checkNotNullParameter(productionOnly, (String)"productionOnly");
            this.moduleComboBox = moduleComboBox;
            this.getSelectedModule = getSelectedModule;
            this.productionOnly = productionOnly;
            Map map = FactoryMap.create(arg_0 -> SdkFromModuleDependencies.jdkCache$lambda$1(arg_0 -> SdkFromModuleDependencies.jdkCache$lambda$0(this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"create(...)");
            this.jdkCache = map;
        }

        @NotNull
        public final Function1<T, Module> getGetSelectedModule() {
            return this.getSelectedModule;
        }

        @NotNull
        public final Function0<Boolean> getProductionOnly() {
            return this.productionOnly;
        }

        @Override
        @NotNull
        public Pair<String, String> getNameAndDescription() {
            String string = ExecutionBundle.message((String)"module.not.specified", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String moduleNotSpecified = string;
            Module module = (Module)this.getSelectedModule.invoke(this.moduleComboBox);
            if (module == null) {
                Pair pair = Pair.create(null, (Object)moduleNotSpecified);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                return pair;
            }
            Module module2 = module;
            Sdk jdkToRun = this.jdkCache.get(module2);
            Sdk moduleJdk = ModuleRootManager.getInstance((Module)module2).getSdk();
            if (moduleJdk == null || jdkToRun == null) {
                Pair pair = Pair.create(null, (Object)moduleNotSpecified);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                return pair;
            }
            if (Intrinsics.areEqual((Object)moduleJdk.getHomeDirectory(), (Object)jdkToRun.getHomeDirectory())) {
                Object[] objectArray = new Object[]{module2.getName()};
                Pair pair = Pair.create((Object)moduleJdk.getName(), (Object)ExecutionBundle.message((String)"sdk.of.0.module", (Object[])objectArray));
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                return pair;
            }
            Object[] objectArray = new Object[]{module2.getName(), (Boolean)this.productionOnly.invoke() != false ? 0 : 1};
            Pair pair = Pair.create((Object)jdkToRun.getName(), (Object)ExecutionBundle.message((String)"newest.sdk.from.0.module.1.choice.0.1.test.dependencies", (Object[])objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
            return pair;
        }

        @Override
        @Nullable
        public String getVersion() {
            Module module = (Module)this.getSelectedModule.invoke(this.moduleComboBox);
            if (module == null) {
                return null;
            }
            Module module2 = module;
            Sdk sdk = this.jdkCache.get(module2);
            return sdk != null ? sdk.getVersionString() : null;
        }

        @Override
        public void addChangeListener(@NotNull Runnable listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.moduleComboBox.addActionListener(arg_0 -> SdkFromModuleDependencies.addChangeListener$lambda$0(listener, arg_0));
        }

        @Override
        public boolean isValid() {
            Module module = (Module)this.getSelectedModule.invoke(this.moduleComboBox);
            return module == null ? true : !module.isDisposed();
        }

        private static final Sdk jdkCache$lambda$0(SdkFromModuleDependencies this$0, Module it) {
            return JavaParameters.getJdkToRunModule((Module)it, (boolean)((Boolean)this$0.productionOnly.invoke()));
        }

        private static final Sdk jdkCache$lambda$1(Function1 $tmp0, Object p0) {
            return (Sdk)$tmp0.invoke(p0);
        }

        private static final void addChangeListener$lambda$0(Runnable $listener, ActionEvent it) {
            $listener.run();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B-\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromSourceRootDependencies;", "T", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromModuleDependencies;", "moduleComboBox", "getSelectedModule", "Lkotlin/Function1;", "Lcom/intellij/openapi/module/Module;", "classSelector", "Lcom/intellij/ui/EditorTextField;", "<init>", "(Lcom/intellij/openapi/ui/ComboBox;Lkotlin/jvm/functions/Function1;Lcom/intellij/ui/EditorTextField;)V", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "intellij.java.execution.impl"})
    public static final class SdkFromSourceRootDependencies<T extends ComboBox<?>>
    extends SdkFromModuleDependencies<T> {
        @NotNull
        private final EditorTextField classSelector;

        public SdkFromSourceRootDependencies(final @NotNull T moduleComboBox, final @NotNull Function1<? super T, ? extends Module> getSelectedModule, @NotNull EditorTextField classSelector) {
            Intrinsics.checkNotNullParameter(moduleComboBox, (String)"moduleComboBox");
            Intrinsics.checkNotNullParameter(getSelectedModule, (String)"getSelectedModule");
            Intrinsics.checkNotNullParameter((Object)classSelector, (String)"classSelector");
            super(moduleComboBox, getSelectedModule, (Function0<Boolean>)((Function0)() -> SdkFromSourceRootDependencies._init_$lambda$0(classSelector)));
            this.classSelector = classSelector;
            this.classSelector.addDocumentListener(new DocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    ReadAction.nonBlocking(() -> 2.documentChanged$lambda$0(moduleComboBox, getSelectedModule, this)).expireWhen(() -> 2.documentChanged$lambda$1(this)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> 2.documentChanged$lambda$2(this, arg_0)).submit((Executor)NonUrgentExecutor.getInstance());
                }

                private static final Boolean documentChanged$lambda$0(ComboBox $moduleComboBox, Function1 $getSelectedModule, SdkFromSourceRootDependencies this$0) {
                    return DefaultJreSelectorKt.access$isClassInProductionSources($moduleComboBox, $getSelectedModule, this$0.classSelector);
                }

                private static final boolean documentChanged$lambda$1(SdkFromSourceRootDependencies this$0) {
                    return !this$0.classSelector.isVisible();
                }

                private static final void documentChanged$lambda$2(SdkFromSourceRootDependencies this$0, Boolean it) {
                    this$0.classSelector.putClientProperty((Object)"production.cached", (Object)it);
                    this$0.classSelector.invalidate();
                    this$0.classSelector.repaint();
                }
            });
        }

        @Override
        public void addChangeListener(@NotNull Runnable listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            super.addChangeListener(listener);
            this.classSelector.addDocumentListener(new DocumentListener(listener){
                final /* synthetic */ Runnable $listener;
                {
                    this.$listener = $listener;
                }

                public void documentChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$listener.run();
                }
            });
        }

        private static final boolean _init_$lambda$0(EditorTextField $classSelector) {
            return Intrinsics.areEqual((Object)((Boolean)$classSelector.getClientProperty((Object)"production.cached")), (Object)true);
        }
    }
}

