/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.build.BuildContentManager;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.util.UnknownAlternativeSdkResolver;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.FixWithConsent;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTracker;
import com.intellij.openapi.roots.ui.configuration.SdkLookup;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.roots.ui.configuration.SdkLookupDecision;
import com.intellij.openapi.roots.ui.configuration.SdkLookupDownloadDecision;
import com.intellij.openapi.roots.ui.configuration.SdkLookupParameters;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/util/UnknownAlternativeSdkResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "notifyUserToResolveJreAndFail", "", "jreHome", "", "tryResolveJre", "Lcom/intellij/openapi/projectRoots/Sdk;", "Companion", "intellij.java.execution.impl"})
public final class UnknownAlternativeSdkResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public UnknownAlternativeSdkResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Void notifyUserToResolveJreAndFail(@NotNull String jreHome) throws CantRunException {
        Intrinsics.checkNotNullParameter((Object)jreHome, (String)"jreHome");
        Notification notification = new Notification("JDK resolve problems", ProjectBundle.message((String)"failed.to.resolve.sdk.notification.title", (Object[])new Object[0]), "", NotificationType.INFORMATION);
        String string = ProjectBundle.message((String)"try.to.find.sdk.notification.action", (Object[])new Object[0]);
        notification.addAction(new AnAction(this, jreHome, string){
            final /* synthetic */ UnknownAlternativeSdkResolver this$0;
            final /* synthetic */ String $jreHome;
            {
                this.this$0 = $receiver;
                this.$jreHome = $jreHome;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                try {
                    UnknownAlternativeSdkResolver.access$tryResolveJre(this.this$0, this.$jreHome);
                }
                catch (CantRunException e2) {
                    String string = BuildContentManager.getInstance((Project)UnknownAlternativeSdkResolver.access$getProject$p(this.this$0)).getOrCreateToolWindow().getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    String buildToolWindowId = string;
                    ExecutionUtil.handleExecutionError((Project)UnknownAlternativeSdkResolver.access$getProject$p(this.this$0), (String)buildToolWindowId, (String)ProjectBundle.message((String)"resolve.sdk.task.name", (Object[])new Object[0]), (Throwable)e2);
                }
            }
        });
        notification.notify(this.project);
        throw new CantRunException.CustomProcessedCantRunException();
    }

    private final Sdk tryResolveJre(String jreHome) throws CantRunException {
        Sdk found;
        if (!Registry.Companion.is("jdk.auto.run.configurations")) {
            return null;
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        if (StringsKt.contains$default((CharSequence)jreHome, (CharSequence)"/", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)jreHome, (CharSequence)"\\", (boolean)false, (int)2, null)) {
            return null;
        }
        AtomicReference<Object> theDownload = new AtomicReference<Object>(null);
        AtomicReference<Object> theSdk = new AtomicReference<Object>(null);
        AtomicReference<Object> theFix = new AtomicReference<Object>(null);
        Project project = this.project;
        String string = ProjectBundle.message((String)"progress.title.resolving.sdks", (Object[])new Object[0]);
        new Task.Modal(jreHome, javaSdk, theFix, theSdk, theDownload, project, string){
            final /* synthetic */ String $jreHome;
            final /* synthetic */ JavaSdk $javaSdk;
            final /* synthetic */ AtomicReference<UnknownSdkFixAction> $theFix;
            final /* synthetic */ AtomicReference<Sdk> $theSdk;
            final /* synthetic */ AtomicReference<Sdk> $theDownload;
            {
                this.$jreHome = $jreHome;
                this.$javaSdk = $javaSdk;
                this.$theFix = $theFix;
                this.$theSdk = $theSdk;
                this.$theDownload = $theDownload;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                SdkLookupBuilder sdkLookupBuilder = SdkLookup.Companion.newLookupBuilder().withProgressIndicator(indicator).withProject(this.getProject()).withSdkName(this.$jreHome);
                JavaSdk javaSdk = this.$javaSdk;
                Intrinsics.checkNotNull((Object)javaSdk);
                SdkLookupBuilder lookup = sdkLookupBuilder.withSdkType((SdkType)javaSdk).onDownloadingSdkDetected(arg_0 -> tryResolveJre.1.run$lambda$0(this.$theDownload, arg_0)).onSdkFixResolved(arg_0 -> tryResolveJre.1.run$lambda$1(this.$theFix, arg_0)).onSdkResolved(arg_0 -> tryResolveJre.1.run$lambda$2(this.$theSdk, arg_0));
                SdkLookup sdkLookup = SdkLookup.Companion.getInstance();
                Intrinsics.checkNotNull((Object)lookup, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.ui.configuration.SdkLookupParameters");
                sdkLookup.lookupBlocking((SdkLookupParameters)lookup);
                UnknownSdkFixAction fix = this.$theFix.get();
                if (this.$theSdk.get() == null && fix != null && UnknownSdkTracker.getInstance((Project)this.getProject()).isAutoFixAction(fix)) {
                    this.$theFix.set(null);
                    ActionsKt.invokeAndWaitIfNeeded$default(null, () -> tryResolveJre.1.run$lambda$3(this, fix, indicator, this.$theSdk), (int)1, null);
                }
            }

            private static final SdkLookupDownloadDecision run$lambda$0(AtomicReference $theDownload, Sdk sdk) {
                Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
                $theDownload.set(sdk);
                return SdkLookupDownloadDecision.STOP;
            }

            private static final SdkLookupDecision run$lambda$1(AtomicReference $theFix, UnknownSdkFixAction fix) {
                Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
                $theFix.set(fix);
                return SdkLookupDecision.STOP;
            }

            private static final Unit run$lambda$2(AtomicReference $theSdk, Sdk sdk) {
                $theSdk.set(sdk);
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$3(tryResolveJre.1 this$0, UnknownSdkFixAction $fix, ProgressIndicator $indicator, AtomicReference $theSdk) {
                if (this$0.getProject().isDisposed()) {
                    return Unit.INSTANCE;
                }
                Sdk sdk = UnknownSdkTracker.getInstance((Project)this$0.getProject()).applyAutoFixAndNotify($fix, $indicator);
                Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"applyAutoFixAndNotify(...)");
                Sdk sdk2 = sdk;
                $theSdk.set(sdk2);
                return Unit.INSTANCE;
            }
        }.queue();
        Sdk sdk = found = (Sdk)theSdk.get();
        if (sdk != null) {
            return sdk;
        }
        Sdk downloading = theDownload.get();
        if (downloading != null) {
            Object[] objectArray = new Object[]{jreHome};
            throw new CantRunException(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.downloading.message", (Object[])objectArray));
        }
        UnknownSdkFixAction fix = theFix.get();
        if (fix != null) {
            HtmlBuilder builder = new HtmlBuilder();
            String linkTarget = "this-is-an-action-to-fix-jdk";
            Object object = new Object[]{jreHome};
            builder.append(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.message", (Object[])object));
            builder.append((HtmlChunk)HtmlChunk.br());
            builder.append((HtmlChunk)HtmlChunk.link((String)linkTarget, (String)fix.getActionDetailedText()));
            object = builder.toString();
            throw new HyperlinkListener(fix, this, (String)object){
                final /* synthetic */ UnknownSdkFixAction $fix;
                final /* synthetic */ UnknownAlternativeSdkResolver this$0;
                {
                    this.$fix = $fix;
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                        return;
                    }
                    if (this.$fix instanceof FixWithConsent) {
                        ((FixWithConsent)this.$fix).giveConsent();
                    }
                    this.$fix.applySuggestionAsync(UnknownAlternativeSdkResolver.access$getProject$p(this.this$0));
                }
            };
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final UnknownAlternativeSdkResolver getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Sdk access$tryResolveJre(UnknownAlternativeSdkResolver $this, String jreHome) {
        return $this.tryResolveJre(jreHome);
    }

    public static final /* synthetic */ Project access$getProject$p(UnknownAlternativeSdkResolver $this) {
        return $this.project;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/util/UnknownAlternativeSdkResolver$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/execution/util/UnknownAlternativeSdkResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.java.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nUnknownAlternativeSdkResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnknownAlternativeSdkResolver.kt\ncom/intellij/execution/util/UnknownAlternativeSdkResolver$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,134:1\n30#2,2:135\n*S KotlinDebug\n*F\n+ 1 UnknownAlternativeSdkResolver.kt\ncom/intellij/execution/util/UnknownAlternativeSdkResolver$Companion\n*L\n40#1:135,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UnknownAlternativeSdkResolver getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<UnknownAlternativeSdkResolver> serviceClass$iv = UnknownAlternativeSdkResolver.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UnknownAlternativeSdkResolver)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

