/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationEntry;
import com.intellij.testIntegration.RunConfigurationEntryKt;
import com.intellij.testIntegration.SingleTestEntry;
import com.intellij.testIntegration.TestEntryVisitor;
import java.util.Date;
import java.util.HashSet;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0014J\u0010\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020/H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000bR\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00060"}, d2={"Lcom/intellij/testIntegration/SuiteEntry;", "Lcom/intellij/testIntegration/RecentTestsPopupEntry;", "suiteUrl", "", "runDate", "Ljava/util/Date;", "runConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "<init>", "(Ljava/lang/String;Ljava/util/Date;Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "getSuiteUrl", "()Ljava/lang/String;", "getRunDate", "()Ljava/util/Date;", "getRunConfiguration", "()Lcom/intellij/execution/RunnerAndConfigurationSettings;", "setRunConfiguration", "(Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "tests", "Ljava/util/HashSet;", "Lcom/intellij/testIntegration/SingleTestEntry;", "Lkotlin/collections/HashSet;", "getTests", "()Ljava/util/HashSet;", "suiteName", "getSuiteName", "runConfigurationEntry", "Lcom/intellij/testIntegration/RunConfigurationEntry;", "getRunConfigurationEntry", "()Lcom/intellij/testIntegration/RunConfigurationEntry;", "setRunConfigurationEntry", "(Lcom/intellij/testIntegration/RunConfigurationEntry;)V", "presentation", "getPresentation", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "failed", "", "getFailed", "()Z", "addTest", "", "test", "accept", "visitor", "Lcom/intellij/testIntegration/TestEntryVisitor;", "intellij.java.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationEntry.kt\ncom/intellij/testIntegration/SuiteEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class SuiteEntry
implements RecentTestsPopupEntry {
    @NotNull
    private final String suiteUrl;
    @NotNull
    private final Date runDate;
    @NotNull
    private RunnerAndConfigurationSettings runConfiguration;
    @NotNull
    private final HashSet<SingleTestEntry> tests;
    @NotNull
    private final String suiteName;
    @Nullable
    private RunConfigurationEntry runConfigurationEntry;
    @NotNull
    private final String presentation;
    @NotNull
    private final Icon icon;

    public SuiteEntry(@NotNull String suiteUrl, @NotNull Date runDate, @NotNull RunnerAndConfigurationSettings runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)suiteUrl, (String)"suiteUrl");
        Intrinsics.checkNotNullParameter((Object)runDate, (String)"runDate");
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        this.suiteUrl = suiteUrl;
        this.runDate = runDate;
        this.runConfiguration = runConfiguration;
        this.tests = new HashSet();
        String string = VirtualFileManager.extractPath((String)this.suiteUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractPath(...)");
        this.suiteName = string;
        this.presentation = RunConfigurationEntryKt.access$toClassName(this.suiteUrl, 0);
        Icon icon = AllIcons.RunConfigurations.Junit;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Junit");
        this.icon = icon;
    }

    @NotNull
    public final String getSuiteUrl() {
        return this.suiteUrl;
    }

    @Override
    @NotNull
    public Date getRunDate() {
        return this.runDate;
    }

    @NotNull
    public final RunnerAndConfigurationSettings getRunConfiguration() {
        return this.runConfiguration;
    }

    public final void setRunConfiguration(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        Intrinsics.checkNotNullParameter((Object)runnerAndConfigurationSettings, (String)"<set-?>");
        this.runConfiguration = runnerAndConfigurationSettings;
    }

    @NotNull
    public final HashSet<SingleTestEntry> getTests() {
        return this.tests;
    }

    @NotNull
    public final String getSuiteName() {
        return this.suiteName;
    }

    @Nullable
    public final RunConfigurationEntry getRunConfigurationEntry() {
        return this.runConfigurationEntry;
    }

    public final void setRunConfigurationEntry(@Nullable RunConfigurationEntry runConfigurationEntry) {
        this.runConfigurationEntry = runConfigurationEntry;
    }

    @Override
    @NotNull
    public String getPresentation() {
        return this.presentation;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public boolean getFailed() {
        Object v0;
        block1: {
            Iterable iterable = this.tests;
            for (Object t : iterable) {
                SingleTestEntry it = (SingleTestEntry)t;
                boolean bl = false;
                if (!it.getFailed()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    public final void addTest(@NotNull SingleTestEntry test) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        this.tests.add(test);
        test.setSuite(this);
    }

    @Override
    public void accept(@NotNull TestEntryVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        visitor.visitSuite(this);
    }
}

