/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.jetbrains.gateway.ssh.deploy.trustedHosts.GatewayTrustedHostsConfigProvider;
import com.jetbrains.gateway.ssh.deploy.trustedHosts.GatewayTrustedHostsService;
import com.jetbrains.gateway.ssh.deploy.trustedHosts.GatewayTrustedHostsState;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/gateway/impl/ExternalGatewayConfigMerger;", "", "<init>", "()V", "lastSeenTrustedHosts", "", "", "updateTrustedHostsState", "", "file", "Ljava/nio/file/Path;", "freezeStates", "Companion", "intellij.gateway.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nExternalGatewayConfigMerger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalGatewayConfigMerger.kt\ncom/jetbrains/gateway/impl/ExternalGatewayConfigMerger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,50:1\n1915#2,2:51\n13#3:53\n*S KotlinDebug\n*F\n+ 1 ExternalGatewayConfigMerger.kt\ncom/jetbrains/gateway/impl/ExternalGatewayConfigMerger\n*L\n43#1:51,2\n19#1:53\n*E\n"})
public final class ExternalGatewayConfigMerger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Set<String> lastSeenTrustedHosts;
    @NotNull
    private static final Logger LOG;

    public ExternalGatewayConfigMerger() {
        this.freezeStates();
    }

    public final void updateTrustedHostsState(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        GatewayTrustedHostsService service = GatewayTrustedHostsService.Companion.getInstance();
        List list = JDOMUtil.load((Path)file).getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Element element = (Element)CollectionsKt.firstOrNull((List)list);
        if (element == null) {
            return;
        }
        Element parsedXml = element;
        GatewayTrustedHostsState state = (GatewayTrustedHostsState)((Object)XmlSerializer.deserialize((Element)parsedXml, GatewayTrustedHostsState.class));
        Set<String> set2 = state.getHosts();
        Set<String> set3 = this.lastSeenTrustedHosts;
        if (set3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lastSeenTrustedHosts");
            set3 = null;
        }
        Set addedHosts = SetsKt.minus(set2, (Iterable)set3);
        Iterable $this$forEach$iv = addedHosts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            service.addTrustedHost(p0);
        }
        this.freezeStates();
    }

    public final void freezeStates() {
        this.lastSeenTrustedHosts = CollectionsKt.toSet((Iterable)((GatewayTrustedHostsState)GatewayTrustedHostsConfigProvider.Companion.getServiceInstance().getState()).getHosts());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExternalGatewayConfigMerger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/impl/ExternalGatewayConfigMerger$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

