/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.impl;

import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PathKt;
import com.jetbrains.gateway.impl.GatewayStarter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\b\u0010\t\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getGatewayAppInfo", "", "addDefaultVmOptions", "", "javaParameters", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "options", "getCurrentTimeString", "isGatewayRunning", "", "configPath", "Ljava/nio/file/Path;", "systemPath", "cleanTrustedHostsSettingsIfExists", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nGatewayStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayStarter.kt\ncom/jetbrains/gateway/impl/GatewayStarterKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,363:1\n1#2:364\n13#3:365\n*S KotlinDebug\n*F\n+ 1 GatewayStarter.kt\ncom/jetbrains/gateway/impl/GatewayStarterKt\n*L\n41#1:365\n*E\n"})
public final class GatewayStarterKt {
    @NotNull
    private static final Logger logger;

    private static final String getGatewayAppInfo() {
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance(...)");
        ApplicationInfoEx appInfo = applicationInfoEx;
        URL gatewayAppInfoResource = GatewayStarter.class.getResource("/template.xml");
        if (gatewayAppInfoResource == null) {
            throw new Exception("Can not start gateway: template.xml is not found in plugin com.jetbrains.gateway.");
        }
        URL uRL = gatewayAppInfoResource;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        String gatewayAppInfoTemplate = new String(byArray, charset);
        String string = appInfo.getMajorVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMajorVersion(...)");
        String string2 = StringsKt.replace$default((String)gatewayAppInfoTemplate, (String)"__MAJOR__", (String)string, (boolean)false, (int)4, null);
        String string3 = appInfo.getMinorVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMinorVersion(...)");
        String string4 = StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"__MINOR__", (String)string3, (boolean)false, (int)4, null), (String)"__EAP__", (String)(appInfo.isEAP() ? "true" : "false"), (boolean)false, (int)4, null);
        String string5 = appInfo.getBuild().asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"asStringWithoutProductCode(...)");
        return StringsKt.replace$default((String)string4, (String)"__BUILD__", (String)string5, (boolean)false, (int)4, null);
    }

    private static final void addDefaultVmOptions(SimpleJavaParameters javaParameters, String options) {
        for (String option : StringsKt.lines((CharSequence)options)) {
            if (StringsKt.isBlank((CharSequence)option)) continue;
            javaParameters.getVMParametersList().add(option);
        }
    }

    private static final String getCurrentTimeString() {
        String string = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private static final boolean isGatewayRunning(Path configPath, Path systemPath) {
        Path lockPath;
        block11: {
            block10: {
                Path portPath = systemPath.resolve(".port");
                lockPath = configPath.resolve(".lock");
                Intrinsics.checkNotNull((Object)portPath);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(portPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block10;
                Intrinsics.checkNotNull((Object)lockPath);
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.notExists(lockPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block11;
            }
            Path path = configPath.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            logger.info("Gateway .port or .lock file does not exist in parent directory: <" + ((Object)path).toString() + ">. Process is not running.");
            return false;
        }
        try {
            Object object;
            Integer pid;
            block9: {
                String pidString = PathsKt.readText$default((Path)lockPath, null, (int)1, null);
                pid = StringsKt.toIntOrNull((String)pidString);
                if (pid == null) {
                    logger.info("Read Gateway process PID value that cannot be cast to integer: <" + pid + ">");
                    return false;
                }
                ProcessInfo[] processInfoArray = ProcessListUtil.getProcessList();
                Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
                for (Object object2 : (Object[])processInfoArray) {
                    ProcessInfo process = (ProcessInfo)object2;
                    boolean bl = false;
                    Integer n = pid;
                    if (!(n != null && process.getPid() == n.intValue())) continue;
                    object = object2;
                    break block9;
                }
                object = null;
            }
            ProcessInfo runningProcess = (ProcessInfo)object;
            if (runningProcess != null) {
                logger.info("Found running Gateway process with expected PID: <" + pid + ">");
                return true;
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to read running Gateway process PID from: " + ((Object)lockPath).toString(), t);
        }
        return false;
    }

    private static final void cleanTrustedHostsSettingsIfExists(Path configPath) {
        Path path = configPath.resolve("options");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path.resolve("GatewayTrustedHostsConfigProvider.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path trustedHostsSettingsFile = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(trustedHostsSettingsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathKt.delete$default((Path)trustedHostsSettingsFile, (boolean)false, (int)1, null);
        }
    }

    public static final /* synthetic */ String access$getCurrentTimeString() {
        return GatewayStarterKt.getCurrentTimeString();
    }

    public static final /* synthetic */ void access$cleanTrustedHostsSettingsIfExists(Path configPath) {
        GatewayStarterKt.cleanTrustedHostsSettingsIfExists(configPath);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ boolean access$isGatewayRunning(Path configPath, Path systemPath) {
        return GatewayStarterKt.isGatewayRunning(configPath, systemPath);
    }

    public static final /* synthetic */ String access$getGatewayAppInfo() {
        return GatewayStarterKt.getGatewayAppInfo();
    }

    public static final /* synthetic */ void access$addDefaultVmOptions(SimpleJavaParameters javaParameters, String options) {
        GatewayStarterKt.addDefaultVmOptions(javaParameters, options);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GatewayStarter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GatewayStarterKt.logger = logger;
    }
}

