/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.promo;

import com.intellij.ide.IdeBundle;
import com.intellij.java.promo.Framework;
import com.intellij.java.promo.FrameworkSuggestionProviderKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserServiceKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/intellij/java/promo/FrameworkPluginSuggestion;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "framework", "Lcom/intellij/java/promo/Framework;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/java/promo/Framework;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFramework", "()Lcom/intellij/java/promo/Framework;", "pluginIds", "", "", "getPluginIds", "()Ljava/util/List;", "apply", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "intellij.java.promo"})
public final class FrameworkPluginSuggestion
implements PluginSuggestion {
    @NotNull
    private final Project project;
    @NotNull
    private final Framework framework;
    @NotNull
    private final List<String> pluginIds;

    public FrameworkPluginSuggestion(@NotNull Project project, @NotNull Framework framework) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)framework, (String)"framework");
        this.project = project;
        this.framework = framework;
        this.pluginIds = CollectionsKt.listOf((Object)this.framework.getPluginId());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Framework getFramework() {
        return this.framework;
    }

    @NotNull
    public List<String> getPluginIds() {
        return this.pluginIds;
    }

    @NotNull
    public EditorNotificationPanel apply(@NotNull FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Promo);
        Object[] objectArray = new Object[]{this.framework.getName(), PluginAdvertiserService.Companion.getIdeaUltimate().getName()};
        panel.setText(IdeBundle.message((String)"plugins.advertiser.framework.supported.in.ultimate", (Object[])objectArray));
        PluginAdvertiserServiceKt.createTryUltimateActionLabel$default((EditorNotificationPanel)panel, (SuggestedIde)PluginAdvertiserService.Companion.getIdeaUltimate(), (Project)this.project, (PluginId)PluginId.Companion.getId(this.framework.getPluginId()), null, null, (int)24, null);
        panel.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.ultimate", (Object[])new Object[0]), () -> FrameworkPluginSuggestion.apply$lambda$0(this));
        return panel;
    }

    private static final void apply$lambda$0(FrameworkPluginSuggestion this$0) {
        FUSEventSource.EDITOR.logIgnoreExtension(this$0.project);
        FrameworkSuggestionProviderKt.access$dismissPluginSuggestion(this$0.framework);
        EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
    }
}

