/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.EventTrackingIntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.ide.DataManager;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.DictionaryLayer;
import com.intellij.spellchecker.DictionaryLayersProvider;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.statistics.SpellcheckerActionStatistics;
import com.intellij.spellchecker.statistics.SpellcheckerRateTracker;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import icons.SpellcheckerIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SaveTo
implements SpellCheckerQuickFix,
LowPriorityAction,
DumbAware,
EventTrackingIntentionAction {
    private SpellcheckerRateTracker myTracker;
    @Nullable
    private DictionaryLayer myLayer;
    private String myWord;

    public SaveTo(@NotNull DictionaryLayer layer) {
        if (layer == null) {
            SaveTo.$$$reportNull$$$0(0);
        }
        this.myLayer = null;
        this.myLayer = layer;
    }

    public SaveTo(String word) {
        this.myLayer = null;
        this.myWord = word;
    }

    public SaveTo(String word, @Nullable DictionaryLayer layer, SpellcheckerRateTracker tracker) {
        this.myLayer = null;
        this.myWord = word;
        this.myLayer = layer;
        this.myTracker = tracker;
    }

    @NotNull
    public String getName() {
        String string = SpellCheckerBundle.message("save.0.to.dictionary.fix", this.myWord != null ? SpellCheckerBundle.message("0.in.quotes", this.myWord) : "");
        if (string == null) {
            SaveTo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpellCheckerBundle.message("save.to.dictionary.fix", new Object[0]);
        if (string == null) {
            SaveTo.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            SaveTo.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            SaveTo.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile psiFile = psiElement.getContainingFile();
        TextRange wordRange = descriptor.getTextRangeInElement().shiftRight(psiElement.getTextRange().getStartOffset());
        String wordToSave = this.myWord != null ? this.myWord : ProblemDescriptorUtil.extractHighlightedText((CommonProblemDescriptor)descriptor, (PsiElement)descriptor.getPsiElement());
        SaveTo.applyFix(project, psiFile, wordRange, wordToSave, this.myLayer);
        if (this.myTracker != null) {
            SpellcheckerActionStatistics.saveToPerformed(this.myTracker, this.myLayer);
        }
    }

    public void suggestionShown(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            SaveTo.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            SaveTo.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            SaveTo.$$$reportNull$$$0(7);
        }
        if (this.myTracker != null && this.myTracker.markShown()) {
            SpellcheckerActionStatistics.suggestionShown(this.myTracker);
        }
    }

    public static void applyFix(@NotNull Project project, PsiFile psiFile, TextRange wordRange, String wordToSave, @Nullable DictionaryLayer layer) {
        if (project == null) {
            SaveTo.$$$reportNull$$$0(8);
        }
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            if (layer == null) {
                ArrayList dictList = new ArrayList(ContainerUtil.map(DictionaryLayersProvider.getAllLayers(project), it -> it.getName()));
                JBPopupFactory.getInstance().createPopupChooserBuilder(dictList).setTitle(SpellCheckerBundle.message("select.dictionary.title", new Object[0])).setItemChosenCallback(item -> CommandProcessor.getInstance().executeCommand(project, () -> SaveTo.acceptWord(wordToSave, DictionaryLayersProvider.getLayer(project, item), psiFile, wordRange), SpellCheckerBundle.message("save.0.to.dictionary.action", wordToSave), null)).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
                    label.setText(value);
                    label.setBorder((Border)JBUI.Borders.empty((int)0, (int)15));
                })).createPopup().showInBestPositionFor(context);
            } else {
                SaveTo.acceptWord(wordToSave, layer, psiFile, wordRange);
            }
        });
    }

    private static void acceptWord(String word, @Nullable DictionaryLayer layer, PsiFile file, TextRange wordRange) {
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.SETTINGS);
        Project project = file.getProject();
        SpellCheckerManager.getInstance(project).acceptWordAsCorrect$intellij_spellchecker(word, file.getViewProvider().getVirtualFile(), project, layer);
        SaveTo.removeHighlightersWithExactRange(file.getViewProvider().getDocument(), project, (Segment)wordRange, "SpellCheckingInspection");
    }

    public static void removeHighlightersWithExactRange(@NotNull Document document, @NotNull Project project, @NotNull Segment range, @NotNull String inspectionToolId) {
        if (document == null) {
            SaveTo.$$$reportNull$$$0(9);
        }
        if (project == null) {
            SaveTo.$$$reportNull$$$0(10);
        }
        if (range == null) {
            SaveTo.$$$reportNull$$$0(11);
        }
        if (inspectionToolId == null) {
            SaveTo.$$$reportNull$$$0(12);
        }
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        MarkupModel model = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)false);
        if (model == null) {
            return;
        }
        for (RangeHighlighter highlighter : model.getAllHighlighters()) {
            HighlightInfo highlightInfo;
            if (!TextRange.areSegmentsEqual((Segment)range, (Segment)highlighter) || (highlightInfo = HighlightInfo.fromRangeHighlighter((RangeHighlighter)highlighter)) == null || !inspectionToolId.equals(highlightInfo.getInspectionToolId())) continue;
            model.removeHighlighter(highlighter);
        }
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    public static String getFixName() {
        return SpellCheckerBundle.message("save.to.dictionary.fix", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/SaveTo";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionToolId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/SaveTo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestionShown";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlightersWithExactRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

