/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.maven;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.quarkus.maven.QsMavenMockRunConfiguration;
import com.intellij.quarkus.maven.QsMavenRunConfiguration;
import com.intellij.quarkus.run.QsExternalSystemBridge;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/quarkus/maven/QsMavenBridge;", "Lcom/intellij/quarkus/run/QsExternalSystemBridge;", "<init>", "()V", "getDelegate", "Lcom/intellij/execution/configurations/RunConfiguration;", "module", "Lcom/intellij/openapi/module/Module;", "createDelegateConfiguration", "createMockDelegate", "project", "Lcom/intellij/openapi/project/Project;", "runConfigurationName", "", "intellij.quarkus.maven"})
public final class QsMavenBridge
extends QsExternalSystemBridge {
    @Override
    @Nullable
    public RunConfiguration getDelegate(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)module.getProject()).findProject(module);
        if (mavenProject == null) {
            return null;
        }
        QsMavenRunConfiguration configuration = new QsMavenRunConfiguration(module);
        MavenRunnerParameters mavenRunnerParameters = configuration.getRunnerParameters();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerParameters, (String)"getRunnerParameters(...)");
        MavenRunnerParameters runnerParameters = mavenRunnerParameters;
        runnerParameters.setWorkingDirPath(mavenProject.getDirectory());
        runnerParameters.setPomFileName(mavenProject.getFile().getName());
        runnerParameters.setGoals((List)new SmartList((Object)"quarkus:dev"));
        configuration.setRunnerParameters(runnerParameters);
        return (RunConfiguration)configuration;
    }

    @Override
    @NotNull
    public RunConfiguration createDelegateConfiguration(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return (RunConfiguration)new QsMavenRunConfiguration(module);
    }

    @Override
    @Nullable
    public RunConfiguration createMockDelegate(@NotNull Project project, @NotNull String runConfigurationName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runConfigurationName, (String)"runConfigurationName");
        return Intrinsics.areEqual((Object)"QsMavenRunConfiguration", (Object)runConfigurationName) ? (RunConfiguration)new QsMavenMockRunConfiguration(project) : null;
    }
}

