/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run.application;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.JvmMainMethodRunConfigurationOptions;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.microservices.jvm.gutter.DumbAwareLineMarkerUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.run.application.QsApplicationConfigurationType;
import com.intellij.quarkus.run.application.QsApplicationRunConfiguration;
import com.intellij.quarkus.run.application.QsApplicationRunConfigurationProducerKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\"\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/quarkus/run/application/QsApplicationRunConfigurationProducer;", "Lcom/intellij/execution/junit/JavaRunConfigurationProducerBase;", "Lcom/intellij/quarkus/run/application/QsApplicationRunConfiguration;", "<init>", "()V", "isDumbAware", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "setupConfigurationFromContext", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromContext", "shouldReplace", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "findQuarkusApplication", "Lkotlin/Pair;", "", "psiElement", "mainMethodContainer", "Lorg/jetbrains/uast/UElement;", "isAnnotatedWithQuarkusMain", "uClass", "Lorg/jetbrains/uast/UClass;", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsApplicationRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsApplicationRunConfigurationProducer.kt\ncom/intellij/quarkus/run/application/QsApplicationRunConfigurationProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,89:1\n1#2:90\n296#3,2:91\n212#4:93\n176#4:94\n*S KotlinDebug\n*F\n+ 1 QsApplicationRunConfigurationProducer.kt\ncom/intellij/quarkus/run/application/QsApplicationRunConfigurationProducer\n*L\n62#1:91,2\n75#1:93\n75#1:94\n*E\n"})
public final class QsApplicationRunConfigurationProducer
extends JavaRunConfigurationProducerBase<QsApplicationRunConfiguration> {
    public boolean isDumbAware() {
        return true;
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return ((QsApplicationConfigurationType)ConfigurationTypeUtil.findConfigurationType(QsApplicationConfigurationType.class)).getConfigurationFactories()[0];
    }

    protected boolean setupConfigurationFromContext(@NotNull QsApplicationRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(context.getModule())) {
            return false;
        }
        Pair<String, PsiElement> pair = this.findQuarkusApplication((PsiElement)sourceElement.get());
        if (pair == null) {
            return false;
        }
        Pair<String, PsiElement> pair2 = pair;
        String mainClassName = (String)pair2.component1();
        PsiElement definitionElement = (PsiElement)pair2.component2();
        if (definitionElement != null) {
            sourceElement.set((Object)definitionElement);
        }
        configuration.setMainClassName(mainClassName);
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull QsApplicationRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Module configurationModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        if (!Intrinsics.areEqual((Object)context.getModule(), (Object)configurationModule)) {
            return false;
        }
        Pair<String, PsiElement> pair = this.findQuarkusApplication(context.getPsiLocation());
        if (pair == null) {
            return false;
        }
        String mainClassName = (String)pair.component1();
        PsiClass psiClass = configuration.getMainClass();
        return Intrinsics.areEqual((Object)mainClassName, (Object)(psiClass != null ? psiClass.getQualifiedName() : null));
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ConfigurationFactory factory2 = other.getConfiguration().getFactory();
        return factory2 != null && Intrinsics.areEqual((Object)factory2.getOptionsClass(), JvmMainMethodRunConfigurationOptions.class);
    }

    private final Pair<String, PsiElement> findQuarkusApplication(PsiElement psiElement) {
        UClass uClass;
        UClass it;
        UElement uElement;
        if (psiElement == null) {
            return null;
        }
        UElement container = this.mainMethodContainer(psiElement);
        if (container instanceof UClass) {
            uElement = container;
            it = (UClass)uElement;
            boolean bl = false;
            uClass = (UClass)(PsiMethodUtil.hasMainMethod((PsiClass)it.getJavaPsi()) ? uElement : null);
        } else if (container instanceof UFile) {
            Object v1;
            block9: {
                Iterable $this$firstOrNull$iv = ((UFile)container).getClasses();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    UClass it2 = (UClass)element$iv;
                    boolean bl = false;
                    if (!PsiMethodUtil.hasMainMethod((PsiClass)it2.getJavaPsi())) continue;
                    v1 = element$iv;
                    break block9;
                }
                v1 = null;
            }
            uClass = v1;
        } else {
            uClass = null;
        }
        if (uClass == null) {
            return null;
        }
        UClass mainClass = uClass;
        if (!this.isAnnotatedWithQuarkusMain(mainClass)) {
            return null;
        }
        String string = PsiMethodUtil.getMainClassQualifiedName((PsiClass)mainClass.getJavaPsi());
        if (string == null) {
            return null;
        }
        String mainClassName = string;
        uElement = mainClass.getSourcePsi();
        it = uElement;
        boolean bl = false;
        UElement sourceElement = !PsiMethodUtil.isMainMethodWithProvider((PsiClass)mainClass.getJavaPsi(), (PsiElement)psiElement) ? uElement : null;
        return TuplesKt.to((Object)mainClassName, (Object)sourceElement);
    }

    private final UElement mainMethodContainer(PsiElement psiElement) {
        UElement uElement;
        PsiElement $this$getUastParentOfType_u24default$iv = psiElement;
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        UClass uClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
        if (uClass != null) {
            uElement = (UElement)uClass;
        } else {
            PsiElement $this$toUElementOfType$iv = psiElement;
            boolean $i$f$toUElementOfType = false;
            uElement = UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UFile.class);
        }
        return uElement;
    }

    private final boolean isAnnotatedWithQuarkusMain(UClass uClass) {
        boolean bl;
        try {
            PsiClass psiClass = uClass.getJavaPsi();
            bl = AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass), (String)"io.quarkus.runtime.annotations.QuarkusMain", (int)0);
        }
        catch (IndexNotReadyException e) {
            bl = DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)((UDeclaration)uClass), (Collection)CollectionsKt.listOf((Object)QsApplicationRunConfigurationProducerKt.access$getQUARKUS_MAIN_ANNOTATION_NAME$p()));
        }
        return bl;
    }
}

