/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.java.codeserver.core.JavaPsiAnnotationUtil;
import com.intellij.java.codeserver.highlighting.JavaCompilationErrorBundle;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AnnotationChecker {
    private static final ElementPattern<PsiElement> ANY_ANNOTATION_ALLOWED = PsiJavaPatterns.psiElement().andOr(new ElementPattern[]{PsiJavaPatterns.psiElement().withParent(PsiNameValuePair.class), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiArrayInitializerMemberValue.class, PsiNameValuePair.class}), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiArrayInitializerMemberValue.class, PsiAnnotationMethod.class}), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiAnnotationMethod.class)).afterLeaf(new String[]{"default"}), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiModifierList.class, PsiParameterList.class})});
    @NotNull
    private final JavaErrorVisitor myVisitor;

    AnnotationChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            AnnotationChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    private void checkReferenceTarget(@NotNull PsiAnnotation annotation, @Nullable PsiJavaCodeReferenceElement ref) {
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(1);
        }
        if (ref == null) {
            return;
        }
        PsiElement refTarget = ref.resolve();
        if (refTarget == null) {
            return;
        }
        if (!(refTarget instanceof PsiClass)) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_REF.create(annotation));
            return;
        }
        PsiElement parent = ref.getParent();
        while (parent instanceof PsiJavaCodeReferenceElement) {
            PsiMember member;
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
            PsiElement qualified = referenceElement.resolve();
            if (qualified instanceof PsiMember && (member = (PsiMember)qualified).hasModifierProperty("static")) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_STATIC.create(annotation));
                return;
            }
            if (!(qualified instanceof PsiClass)) break;
            parent = parent.getParent();
        }
    }

    void checkPackageAnnotationContainingFile(@NotNull PsiPackageStatement statement) {
        PsiModifierList annotationList;
        if (statement == null) {
            AnnotationChecker.$$$reportNull$$$0(2);
        }
        if ((annotationList = statement.getAnnotationList()) != null && !"package-info.java".equals(this.myVisitor.file().getName())) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_ON_PACKAGE.create(statement));
        }
    }

    void checkAnnotationDeclaration(PsiElement parent, @NotNull PsiReferenceList list) {
        PsiElement child;
        PsiClass aClass;
        if (list == null) {
            AnnotationChecker.$$$reportNull$$$0(3);
        }
        if (PsiUtil.isAnnotationMethod((PsiElement)parent)) {
            PsiAnnotationMethod method = (PsiAnnotationMethod)parent;
            if (list == method.getThrowsList()) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_MEMBER_THROWS_NOT_ALLOWED.create(list));
            }
        } else if (parent instanceof PsiClass && (aClass = (PsiClass)parent).isAnnotationType() && PsiUtil.isJavaToken((PsiElement)(child = list.getFirstChild()), (IElementType)JavaTokenType.EXTENDS_KEYWORD)) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_EXTENDS.create(list));
        }
    }

    void checkConstantExpression(@NotNull PsiExpression expression) {
        PsiElement parent;
        if (expression == null) {
            AnnotationChecker.$$$reportNull$$$0(4);
        }
        if ((PsiUtil.isAnnotationMethod((PsiElement)(parent = expression.getParent())) || parent instanceof PsiNameValuePair || parent instanceof PsiArrayInitializerMemberValue) && !PsiUtil.isConstantExpression((PsiExpression)expression)) {
            if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference((PsiExpression)expression)) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_ATTRIBUTE_NON_CONSTANT.create(expression));
        }
    }

    void checkValidAnnotationType(@Nullable PsiType type, @NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            AnnotationChecker.$$$reportNull$$$0(5);
        }
        if (type == null || !AnnotationChecker.isValidAnnotationMethodType(type)) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_METHOD_INVALID_TYPE.create(typeElement, type));
        }
    }

    void checkCyclicMemberType(@NotNull PsiTypeElement typeElement, @NotNull PsiClass aClass) {
        HashSet checked;
        PsiType type;
        if (typeElement == null) {
            AnnotationChecker.$$$reportNull$$$0(6);
        }
        if (aClass == null) {
            AnnotationChecker.$$$reportNull$$$0(7);
        }
        if (AnnotationChecker.cyclicDependencies(aClass, type = typeElement.getType(), checked = new HashSet())) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_CYCLIC_TYPE.create(typeElement));
        }
    }

    void checkClashesWithSuperMethods(@NotNull PsiAnnotationMethod psiMethod) {
        PsiIdentifier nameIdentifier;
        if (psiMethod == null) {
            AnnotationChecker.$$$reportNull$$$0(8);
        }
        if ((nameIdentifier = psiMethod.getNameIdentifier()) != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = psiMethod.findDeepestSuperMethods()) {
                String qualifiedName;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || !"java.lang.Object".equals(qualifiedName = containingClass.getQualifiedName()) && !"java.lang.annotation.Annotation".equals(qualifiedName)) continue;
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_MEMBER_CLASH.create((PsiMethod)psiMethod, method));
            }
        }
    }

    void checkAnnotationMethodParameters(@NotNull PsiParameterList list) {
        PsiElement parent;
        if (list == null) {
            AnnotationChecker.$$$reportNull$$$0(9);
        }
        if (PsiUtil.isAnnotationMethod((PsiElement)(parent = list.getParent())) && (!list.isEmpty() || PsiTreeUtil.getChildOfType((PsiElement)list, PsiReceiverParameter.class) != null)) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_MEMBER_MAY_NOT_HAVE_PARAMETERS.create(list));
        }
    }

    private static boolean cyclicDependencies(@NotNull PsiClass aClass, @Nullable PsiType type, @NotNull Set<? super PsiClass> checked) {
        PsiClass resolvedClass;
        if (aClass == null) {
            AnnotationChecker.$$$reportNull$$$0(10);
        }
        if (checked == null) {
            AnnotationChecker.$$$reportNull$$$0(11);
        }
        if ((resolvedClass = PsiUtil.resolveClassInType((PsiType)type)) != null && resolvedClass.isAnnotationType()) {
            PsiMethod[] methods;
            if (aClass == resolvedClass) {
                return true;
            }
            if (!checked.add((PsiClass)resolvedClass)) {
                return false;
            }
            for (PsiMethod method : methods = resolvedClass.getMethods()) {
                if (!AnnotationChecker.cyclicDependencies(aClass, method.getReturnType(), checked)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(value="null->null; !null->!null")
    private static PsiJavaCodeReferenceElement getOutermostReferenceElement(@Nullable PsiJavaCodeReferenceElement ref) {
        PsiElement psiElement;
        if (ref == null) {
            return null;
        }
        while ((psiElement = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement referenceElement;
            ref = referenceElement = (PsiJavaCodeReferenceElement)psiElement;
        }
        return ref;
    }

    void checkAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(12);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkAnnotationApplicability(annotation);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkAnnotationType(annotation);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkMissingAttributes(annotation);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkSafeVarargAnnotation(annotation);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkTargetAnnotationDuplicates(annotation);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkFunctionalInterface(annotation);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkOverrideAnnotation(annotation);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkDuplicateAnnotations(annotation);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkRepeatableAnnotation(annotation);
        }
    }

    private void checkRepeatableAnnotation(@NotNull PsiAnnotation annotation) {
        PsiAnnotationMemberValue containerRef;
        String qualifiedName;
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(13);
        }
        if (!"java.lang.annotation.Repeatable".equals(qualifiedName = annotation.getQualifiedName())) {
            return;
        }
        String description = AnnotationChecker.doCheckRepeatableAnnotation(annotation);
        if (description != null && (containerRef = PsiImplUtil.findAttributeValue((PsiAnnotation)annotation, null)) != null) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_MALFORMED_REPEATABLE_EXPLAINED.create(containerRef, description));
        }
    }

    private void checkDuplicateAnnotations(@NotNull PsiAnnotation annotation) {
        String containedElementFQN;
        PsiAnnotationOwner owner;
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(14);
        }
        if ((owner = annotation.getOwner()) == null) {
            return;
        }
        PsiClass annotationType = annotation.resolveAnnotationType();
        if (annotationType == null) {
            return;
        }
        PsiClass contained = AnnotationChecker.contained(annotationType);
        String string = containedElementFQN = contained == null ? null : contained.getQualifiedName();
        if (containedElementFQN != null && AnnotationChecker.isAnnotationRepeatedTwice(owner, containedElementFQN)) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_CONTAINER_WRONG_PLACE.create(annotation));
            return;
        }
        if (AnnotationChecker.isAnnotationRepeatedTwice(owner, annotationType.getQualifiedName())) {
            PsiAnnotation.TargetType[] targets;
            PsiAnnotation.TargetType applicable;
            if (!this.myVisitor.isApplicable(JavaFeature.REPEATING_ANNOTATIONS)) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_DUPLICATE.create(annotation));
                return;
            }
            PsiAnnotation metaAnno = PsiImplUtil.findAnnotation((PsiAnnotationOwner)annotationType.getModifierList(), (String)"java.lang.annotation.Repeatable");
            if (metaAnno == null) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_DUPLICATE_NON_REPEATABLE.create(annotation));
                return;
            }
            String explanation = AnnotationChecker.doCheckRepeatableAnnotation(metaAnno);
            if (explanation != null) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_DUPLICATE_EXPLAINED.create(annotation, explanation));
                return;
            }
            PsiClass container = AnnotationChecker.getRepeatableContainer(metaAnno);
            if (container != null && (applicable = AnnotationTargetUtil.findAnnotationTarget((PsiClass)container, (PsiAnnotation.TargetType[])(targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)owner)))) == null) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_CONTAINER_NOT_APPLICABLE.create(annotation, container));
            }
        }
    }

    void checkArrayInitializer(@NotNull PsiArrayInitializerMemberValue initializer) {
        if (initializer == null) {
            AnnotationChecker.$$$reportNull$$$0(15);
        }
        PsiMethod method = null;
        PsiElement parent = initializer.getParent();
        if (parent instanceof PsiNameValuePair) {
            PsiReference reference = parent.getReference();
            if (reference != null) {
                method = (PsiMethod)reference.resolve();
            }
        } else if (PsiUtil.isAnnotationMethod((PsiElement)parent)) {
            method = (PsiMethod)parent;
        }
        if (method instanceof PsiAnnotationMethod) {
            PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)method;
            PsiType type = method.getReturnType();
            if (type instanceof PsiArrayType) {
                PsiAnnotationMemberValue[] initializers;
                PsiArrayType arrayType = (PsiArrayType)type;
                type = arrayType.getComponentType();
                for (PsiAnnotationMemberValue initializer1 : initializers = initializer.getInitializers()) {
                    this.checkMemberValueType(initializer1, type, annotationMethod);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NlsContexts.DetailedDescription
    public static String doCheckRepeatableAnnotation(@NotNull PsiAnnotation annotation) {
        void var11_14;
        PsiMethod[] containerTargets;
        RetentionPolicy containerPolicy;
        PsiArrayType expected;
        PsiMethod[] methods;
        PsiClass psiClass;
        PsiAnnotationOwner owner;
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(16);
        }
        if (!((owner = annotation.getOwner()) instanceof PsiModifierList)) {
            return null;
        }
        PsiModifierList list = (PsiModifierList)owner;
        PsiElement target = list.getParent();
        if (!(target instanceof PsiClass) || !(psiClass = (PsiClass)target).isAnnotationType()) {
            return null;
        }
        PsiClass container = AnnotationChecker.getRepeatableContainer(annotation);
        if (container == null) {
            return null;
        }
        PsiMethod[] psiMethodArray = methods = !container.isAnnotationType() ? PsiMethod.EMPTY_ARRAY : container.findMethodsByName("value", false);
        if (methods.length == 0) {
            return JavaCompilationErrorBundle.message("annotation.container.no.value", container.getQualifiedName());
        }
        if (methods.length == 1 && !(expected = new PsiImmediateClassType(psiClass, PsiSubstitutor.EMPTY).createArrayType()).equals(methods[0].getReturnType())) {
            return JavaCompilationErrorBundle.message("annotation.container.bad.type", container.getQualifiedName(), PsiTypesUtil.removeExternalAnnotations((PsiType)expected).getInternalCanonicalText());
        }
        RetentionPolicy targetPolicy = JavaPsiAnnotationUtil.getRetentionPolicy((PsiClass)psiClass);
        if (targetPolicy != null && (containerPolicy = JavaPsiAnnotationUtil.getRetentionPolicy((PsiClass)container)) != null && targetPolicy.compareTo(containerPolicy) > 0) {
            return JavaCompilationErrorBundle.message("annotation.container.low.retention", new Object[]{container.getQualifiedName(), containerPolicy});
        }
        Set repeatableTargets = AnnotationTargetUtil.getAnnotationTargets((PsiClass)psiClass);
        if (repeatableTargets != null && (containerTargets = AnnotationTargetUtil.getAnnotationTargets((PsiClass)container)) != null) {
            for (PsiAnnotation.TargetType targetType : containerTargets) {
                if (repeatableTargets.contains(targetType) || targetType == PsiAnnotation.TargetType.ANNOTATION_TYPE && (repeatableTargets.contains(PsiAnnotation.TargetType.TYPE) || repeatableTargets.contains(PsiAnnotation.TargetType.TYPE_USE)) || (targetType == PsiAnnotation.TargetType.TYPE || targetType == PsiAnnotation.TargetType.TYPE_PARAMETER) && repeatableTargets.contains(PsiAnnotation.TargetType.TYPE_USE)) continue;
                return JavaCompilationErrorBundle.message("annotation.container.wide.target", container.getQualifiedName());
            }
        }
        containerTargets = container.getMethods();
        int n = containerTargets.length;
        boolean bl = false;
        while (var11_14 < n) {
            PsiMethod method = containerTargets[var11_14];
            if (method instanceof PsiAnnotationMethod) {
                PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)method;
                if (!"value".equals(method.getName()) && annotationMethod.getDefaultValue() == null) {
                    return JavaCompilationErrorBundle.message("annotation.container.abstract", container.getQualifiedName(), method.getName());
                }
            }
            ++var11_14;
        }
        @Nullable String missedAnnotationError = AnnotationChecker.getMissedAnnotationError(psiClass, container, Inherited.class.getName());
        if (missedAnnotationError != null) {
            return missedAnnotationError;
        }
        return AnnotationChecker.getMissedAnnotationError(psiClass, container, Documented.class.getName());
    }

    @Nls
    private static String getMissedAnnotationError(PsiClass target, PsiClass container, String annotationFqn) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)target, (String)annotationFqn, (int)0) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)container, (String)annotationFqn, (int)0)) {
            return JavaCompilationErrorBundle.message("annotation.container.missed.annotation", container.getQualifiedName(), StringUtil.getShortName((String)annotationFqn));
        }
        return null;
    }

    @Nullable
    private static PsiClass getRepeatableContainer(@NotNull PsiAnnotation annotation) {
        PsiAnnotationMemberValue containerRef;
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(17);
        }
        if (!((containerRef = PsiImplUtil.findAttributeValue((PsiAnnotation)annotation, null)) instanceof PsiClassObjectAccessExpression)) {
            return null;
        }
        PsiClassObjectAccessExpression expression = (PsiClassObjectAccessExpression)containerRef;
        PsiType containerType = expression.getOperand().getType();
        if (!(containerType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)containerType;
        return classType.resolve();
    }

    private static PsiClass contained(@NotNull PsiClass annotationType) {
        if (annotationType == null) {
            AnnotationChecker.$$$reportNull$$$0(18);
        }
        if (!annotationType.isAnnotationType()) {
            return null;
        }
        PsiMethod[] values = annotationType.findMethodsByName("value", false);
        if (values.length != 1) {
            return null;
        }
        PsiMethod value = values[0];
        PsiType returnType = value.getReturnType();
        if (!(returnType instanceof PsiArrayType)) {
            return null;
        }
        PsiArrayType arrayType = (PsiArrayType)returnType;
        PsiType type = arrayType.getComponentType();
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass contained = classType.resolve();
        if (contained == null || !contained.isAnnotationType()) {
            return null;
        }
        if (PsiImplUtil.findAnnotation((PsiAnnotationOwner)contained.getModifierList(), (String)"java.lang.annotation.Repeatable") == null) {
            return null;
        }
        return contained;
    }

    private void checkFunctionalInterface(@NotNull PsiAnnotation annotation) {
        PsiModifierList list;
        PsiElement parent;
        PsiAnnotationOwner owner;
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(19);
        }
        if (this.myVisitor.isApplicable(JavaFeature.LAMBDA_EXPRESSIONS) && Comparing.strEqual((String)annotation.getQualifiedName(), (String)"java.lang.FunctionalInterface") && (owner = annotation.getOwner()) instanceof PsiModifierList && (parent = (list = (PsiModifierList)owner).getParent()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)parent;
            PsiClassType type = this.myVisitor.factory().createType(psiClass);
            switch (LambdaUtil.checkInterfaceFunctional((PsiClass)psiClass)) {
                case NOT_INTERFACE: {
                    this.myVisitor.report(JavaErrorKinds.LAMBDA_NOT_FUNCTIONAL_INTERFACE.create((PsiElement)annotation, (PsiType)type));
                    break;
                }
                case NO_ABSTRACT_METHOD: {
                    this.myVisitor.report(JavaErrorKinds.LAMBDA_NO_TARGET_METHOD.create((PsiElement)annotation, (PsiType)type));
                    break;
                }
                case MULTIPLE_ABSTRACT_METHODS: {
                    this.myVisitor.report(JavaErrorKinds.LAMBDA_MULTIPLE_TARGET_METHODS.create((PsiElement)annotation, (PsiType)type));
                }
            }
            if (psiClass.hasModifierProperty("sealed")) {
                this.myVisitor.report(JavaErrorKinds.FUNCTIONAL_INTERFACE_SEALED.create(annotation, psiClass));
            }
        }
    }

    private void checkSafeVarargAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(20);
        }
        if (!Comparing.strEqual((String)annotation.getQualifiedName(), (String)"java.lang.SafeVarargs")) {
            return;
        }
        PsiAnnotationOwner owner = annotation.getOwner();
        if (!(owner instanceof PsiModifierList)) {
            return;
        }
        PsiModifierList list = (PsiModifierList)owner;
        PsiElement parent = list.getParent();
        if (parent instanceof PsiRecordComponent) {
            this.myVisitor.report(JavaErrorKinds.SAFE_VARARGS_ON_RECORD_COMPONENT.create(annotation));
        } else if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            if (!method.isVarArgs()) {
                this.myVisitor.report(JavaErrorKinds.SAFE_VARARGS_ON_FIXED_ARITY.create(annotation, method));
            } else if (!GenericsUtil.isSafeVarargsNoOverridingCondition((PsiMethod)method)) {
                this.myVisitor.report(JavaErrorKinds.SAFE_VARARGS_ON_NON_FINAL_METHOD.create(annotation, method));
            }
        }
    }

    private void checkMissingAttributes(@NotNull PsiAnnotation annotation) {
        PsiClass psiClass;
        PsiJavaCodeReferenceElement nameRef;
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(21);
        }
        if ((nameRef = annotation.getNameReferenceElement()) == null) {
            return;
        }
        PsiElement aClass = nameRef.resolve();
        if (aClass instanceof PsiClass && (psiClass = (PsiClass)aClass).isAnnotationType()) {
            PsiNameValuePair[] attributes;
            HashSet<String> names = new HashSet<String>();
            for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
                String name = attribute.getName();
                names.add(Objects.requireNonNullElse(name, "value"));
            }
            PsiMethod[] annotationMethods = psiClass.getMethods();
            ArrayList<String> missed = new ArrayList<String>();
            for (PsiMethod method : annotationMethods) {
                PsiAnnotationMethod annotationMethod;
                if (!PsiUtil.isAnnotationMethod((PsiElement)method) || (annotationMethod = (PsiAnnotationMethod)method).getDefaultValue() != null || names.contains(annotationMethod.getName())) continue;
                missed.add(annotationMethod.getName());
            }
            if (!missed.isEmpty()) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_MISSING_ATTRIBUTE.create(annotation, missed));
            }
        }
    }

    private void checkAnnotationType(@NotNull PsiAnnotation annotation) {
        PsiClass psiClass;
        PsiElement resolved;
        PsiJavaCodeReferenceElement nameReferenceElement;
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(22);
        }
        if (!((nameReferenceElement = annotation.getNameReferenceElement()) == null || (resolved = nameReferenceElement.resolve()) == null || resolved instanceof PsiClass && (psiClass = (PsiClass)resolved).isAnnotationType())) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_TYPE_EXPECTED.create(nameReferenceElement));
        }
    }

    private void checkAnnotationApplicability(@NotNull PsiAnnotation annotation) {
        PsiAnnotation.TargetType applicable;
        PsiTypeElement typeElement;
        PsiElement element;
        PsiElement psiElement;
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(23);
        }
        if (ANY_ANNOTATION_ALLOWED.accepts((Object)annotation)) {
            return;
        }
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return;
        }
        PsiAnnotationOwner owner = annotation.getOwner();
        PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)owner);
        if (owner == null || targets.length == 0) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_HERE.create(annotation));
            return;
        }
        if (!(owner instanceof PsiModifierList)) {
            this.myVisitor.checkFeature((PsiElement)annotation, JavaFeature.TYPE_ANNOTATIONS);
            if (this.myVisitor.hasErrorResults()) {
                return;
            }
        }
        if (!(annotation.getOwner() instanceof PsiArrayType) && (psiElement = annotation.getParent()) instanceof PsiTypeElement && (element = PsiTreeUtil.skipParentsOfType((PsiElement)(typeElement = (PsiTypeElement)psiElement), (Class[])new Class[]{PsiTypeElement.class})) instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)element;
            targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)modifierListOwner.getModifierList());
        }
        if ((applicable = AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])targets)) == PsiAnnotation.TargetType.UNKNOWN) {
            return;
        }
        if (applicable == null) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_NOT_APPLICABLE.create(annotation, Arrays.asList(targets)));
            return;
        }
        if (applicable == PsiAnnotation.TargetType.TYPE_USE) {
            if (PsiTreeUtil.skipParentsOfType((PsiElement)annotation, (Class[])new Class[]{PsiTypeElement.class}) instanceof PsiClassObjectAccessExpression) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_CLASS.create(annotation));
                return;
            }
            if (owner instanceof PsiClassReferenceType) {
                PsiClassReferenceType referenceType = (PsiClassReferenceType)owner;
                this.checkReferenceTarget(annotation, referenceType.getReference());
            } else if (owner instanceof PsiModifierList || owner instanceof PsiTypeElement) {
                PsiTypeElement typeElementOwner;
                PsiTypeElement nextElement;
                Object object = nextElement = owner instanceof PsiTypeElement ? (typeElementOwner = (PsiTypeElement)owner) : PsiTreeUtil.skipSiblingsForward((PsiElement)((PsiModifierList)owner), (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class});
                if (nextElement instanceof PsiTypeElement) {
                    PsiTypeElement typeElement2 = nextElement;
                    PsiType type = typeElement2.getType();
                    if (PsiTypes.voidType().equals((Object)type)) {
                        this.myVisitor.report(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_VOID.create(annotation));
                        return;
                    }
                    if (typeElement2.isInferredType()) {
                        this.myVisitor.report(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_VAR.create(annotation));
                        return;
                    }
                    if (!(type instanceof PsiPrimitiveType) && !(type instanceof PsiArrayType)) {
                        PsiJavaCodeReferenceElement ref = AnnotationChecker.getOutermostReferenceElement(typeElement2.getInnermostComponentReferenceElement());
                        this.checkReferenceTarget(annotation, ref);
                    }
                }
            }
        }
    }

    private void checkTargetAnnotationDuplicates(@NotNull PsiAnnotation annotation) {
        PsiClass psiClass;
        PsiJavaCodeReferenceElement nameRef;
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(24);
        }
        if ((nameRef = annotation.getNameReferenceElement()) == null) {
            return;
        }
        PsiElement resolved = nameRef.resolve();
        if (!(resolved instanceof PsiClass) || !"java.lang.annotation.Target".equals((psiClass = (PsiClass)resolved).getQualifiedName())) {
            return;
        }
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (attributes.length < 1) {
            return;
        }
        PsiAnnotationMemberValue value = attributes[0].getValue();
        if (!(value instanceof PsiArrayInitializerMemberValue)) {
            return;
        }
        PsiArrayInitializerMemberValue initializerMemberValue = (PsiArrayInitializerMemberValue)value;
        PsiAnnotationMemberValue[] arrayInitializers = initializerMemberValue.getInitializers();
        HashSet<PsiElement> targets = new HashSet<PsiElement>();
        for (PsiAnnotationMemberValue initializer : arrayInitializers) {
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            if (!(initializer instanceof PsiReferenceExpression) || (target = (referenceExpression = (PsiReferenceExpression)initializer).resolve()) == null) continue;
            if (targets.contains(target)) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_REPEATED_TARGET.create(referenceExpression));
            }
            targets.add(target);
        }
    }

    private void checkOverrideAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(25);
        }
        if (!"java.lang.Override".equals(annotation.getQualifiedName())) {
            return;
        }
        PsiAnnotationOwner psiAnnotationOwner = annotation.getOwner();
        if (!(psiAnnotationOwner instanceof PsiModifierList)) {
            return;
        }
        PsiModifierList list = (PsiModifierList)psiAnnotationOwner;
        PsiElement psiElement = list.getParent();
        if (!(psiElement instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)psiElement;
        if (method.hasModifierProperty("static")) {
            this.myVisitor.report(JavaErrorKinds.OVERRIDE_ON_STATIC_METHOD.create(annotation, method));
            return;
        }
        MethodSignatureBackedByPsiMethod superMethod = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
        PsiClass psiClass = method.getContainingClass();
        if (psiClass != null) {
            if (superMethod != null && psiClass.isInterface()) {
                PsiClassType[] psiMethod = superMethod.getMethod();
                PsiClass superClass = psiMethod.getContainingClass();
                if (superClass != null && "java.lang.Object".equals(superClass.getQualifiedName()) && psiMethod.hasModifierProperty("protected")) {
                    superMethod = null;
                }
            } else if (superMethod == null) {
                if (this.myVisitor.isIncompleteModel()) {
                    if (!IncompleteModelUtil.isHierarchyResolved((PsiClass)psiClass)) {
                        return;
                    }
                } else {
                    for (PsiClassType type : psiClass.getSuperTypes()) {
                        if (type.resolve() != null) continue;
                        return;
                    }
                }
            }
        }
        if (superMethod == null) {
            if (JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)method) == null) {
                this.myVisitor.report(JavaErrorKinds.OVERRIDE_ON_NON_OVERRIDING_METHOD.create(annotation, method));
            }
            return;
        }
        PsiClass superClass = superMethod.getMethod().getContainingClass();
        if (superClass != null && superClass.isInterface()) {
            this.myVisitor.checkFeature((PsiElement)annotation, JavaFeature.OVERRIDE_INTERFACE);
        }
    }

    void checkNameValuePair(@NotNull PsiNameValuePair pair) {
        PsiAnnotationParameterList list;
        PsiNameValuePair[] attributes;
        PsiElement psiElement;
        if (pair == null) {
            AnnotationChecker.$$$reportNull$$$0(26);
        }
        if (pair.getFirstChild() instanceof PsiErrorElement) {
            return;
        }
        PsiIdentifier identifier = pair.getNameIdentifier();
        if (identifier == null && (psiElement = pair.getParent()) instanceof PsiAnnotationParameterList && (attributes = (list = (PsiAnnotationParameterList)psiElement).getAttributes()).length > 1) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_ATTRIBUTE_NAME_MISSING.create(pair));
            return;
        }
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)pair, PsiAnnotation.class);
        if (annotation == null) {
            return;
        }
        PsiClass annotationClass = annotation.resolveAnnotationType();
        if (annotationClass == null) {
            return;
        }
        PsiReference ref = pair.getReference();
        if (ref == null) {
            return;
        }
        PsiElement target = ref.resolve();
        if (target == null) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_ATTRIBUTE_UNKNOWN_METHOD.create(pair, ref.getCanonicalText()));
            return;
        }
        if (!(target instanceof PsiAnnotationMethod)) {
            throw new IllegalStateException("Unexpected: should resolve to annotation method; got " + String.valueOf(target.getClass()));
        }
        PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)target;
        PsiAnnotationMemberValue value = pair.getValue();
        if (value != null) {
            PsiType expectedType = Objects.requireNonNull(annotationMethod.getReturnType());
            this.checkMemberValueType(value, expectedType, annotationMethod);
        }
        this.checkDuplicateAttribute(pair);
    }

    private void checkDuplicateAttribute(@NotNull PsiNameValuePair pair) {
        PsiNameValuePair[] attributes;
        if (pair == null) {
            AnnotationChecker.$$$reportNull$$$0(27);
        }
        PsiAnnotationParameterList annotation = (PsiAnnotationParameterList)pair.getParent();
        for (PsiNameValuePair attribute : attributes = annotation.getAttributes()) {
            if (attribute == pair) break;
            String name = pair.getName();
            if (!Objects.equals(attribute.getName(), name)) continue;
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_ATTRIBUTE_DUPLICATE.create(pair, name == null ? "value" : name));
            break;
        }
    }

    void checkMemberValueType(@NotNull PsiAnnotationMemberValue value, @NotNull PsiType expectedType, @NotNull PsiAnnotationMethod method) {
        if (value == null) {
            AnnotationChecker.$$$reportNull$$$0(28);
        }
        if (expectedType == null) {
            AnnotationChecker.$$$reportNull$$$0(29);
        }
        if (method == null) {
            AnnotationChecker.$$$reportNull$$$0(30);
        }
        if (expectedType instanceof PsiClassType && expectedType.equalsToText("java.lang.Class") && !(value instanceof PsiClassObjectAccessExpression)) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_ATTRIBUTE_NON_CLASS_LITERAL.create(value));
            return;
        }
        if (method instanceof SyntheticElement) {
            return;
        }
        if (value instanceof PsiAnnotation) {
            PsiClassType classType;
            PsiClass aClass;
            PsiArrayType arrayType;
            PsiType componentType;
            PsiClassType classType2;
            PsiClass aClass2;
            PsiAnnotation annotation = (PsiAnnotation)value;
            PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
            if (nameRef == null) {
                return;
            }
            if (expectedType instanceof PsiClassType && (aClass2 = (classType2 = (PsiClassType)expectedType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass2)) {
                return;
            }
            if (expectedType instanceof PsiArrayType && (componentType = (arrayType = (PsiArrayType)expectedType).getComponentType()) instanceof PsiClassType && (aClass = (classType = (PsiClassType)componentType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass)) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_ATTRIBUTE_INCOMPATIBLE_TYPE.create((PsiAnnotationMemberValue)annotation, JavaErrorKinds.AnnotationValueErrorContext.from((PsiAnnotationMemberValue)annotation, method, expectedType)));
            return;
        }
        if (value instanceof PsiArrayInitializerMemberValue) {
            PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)value;
            if (!(expectedType instanceof PsiArrayType)) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_ATTRIBUTE_ILLEGAL_ARRAY_INITIALIZER.create(arrayValue, JavaErrorKinds.AnnotationValueErrorContext.from((PsiAnnotationMemberValue)arrayValue, method, expectedType)));
                return;
            }
        }
        if (value instanceof PsiExpression) {
            PsiArrayType arrayType;
            PsiReferenceExpression referenceExpression;
            PsiExpression expr = (PsiExpression)value;
            PsiType type = expr.getType();
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
            if (!(psiClass == null || !psiClass.isEnum() || expr instanceof PsiReferenceExpression && (referenceExpression = (PsiReferenceExpression)expr).resolve() instanceof PsiEnumConstant)) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_ATTRIBUTE_NON_ENUM_CONSTANT.create(expr));
                return;
            }
            if (type != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)expectedType, (PsiExpression)expr) || expectedType instanceof PsiArrayType && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)(arrayType = (PsiArrayType)expectedType).getComponentType(), (PsiExpression)expr)) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_ATTRIBUTE_INCOMPATIBLE_TYPE.create((PsiAnnotationMemberValue)expr, JavaErrorKinds.AnnotationValueErrorContext.from((PsiAnnotationMemberValue)expr, method, expectedType)));
        }
    }

    private static boolean isAnnotationRepeatedTwice(@NotNull PsiAnnotationOwner owner, @Nullable String qualifiedName) {
        if (owner == null) {
            AnnotationChecker.$$$reportNull$$$0(31);
        }
        int count = 0;
        for (PsiAnnotation annotation : owner.getAnnotations()) {
            PsiClass psiClass;
            PsiElement resolved;
            PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
            if (nameRef == null || !((resolved = nameRef.resolve()) instanceof PsiClass) || !Objects.equals(qualifiedName, (psiClass = (PsiClass)resolved).getQualifiedName()) || ++count != 2) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidAnnotationMethodType(@NotNull PsiType type) {
        if (type == null) {
            AnnotationChecker.$$$reportNull$$$0(32);
        }
        if (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            if (arrayType.getArrayDimensions() != 1) {
                return false;
            }
            type = arrayType.getComponentType();
        }
        if (type instanceof PsiPrimitiveType) {
            return !PsiTypes.voidType().equals((Object)type) && !PsiTypes.nullType().equals(type);
        }
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            if (classType.getParameters().length > 0) {
                return PsiTypesUtil.classNameEquals((PsiType)classType, (String)"java.lang.Class");
            }
            if (classType.equalsToText("java.lang.Class") || classType.equalsToText("java.lang.String")) {
                return true;
            }
            PsiClass aClass = classType.resolve();
            return aClass != null && (aClass.isAnnotationType() || aClass.isEnum());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checked";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationType";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/AnnotationChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReferenceTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPackageAnnotationContainingFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAnnotationDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConstantExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValidAnnotationType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCyclicMemberType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClashesWithSuperMethods";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAnnotationMethodParameters";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "cyclicDependencies";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRepeatableAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDuplicateAnnotations";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArrayInitializer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheckRepeatableAnnotation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getRepeatableContainer";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "contained";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunctionalInterface";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSafeVarargAnnotation";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMissingAttributes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAnnotationType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAnnotationApplicability";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTargetAnnotationDuplicates";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOverrideAnnotation";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNameValuePair";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDuplicateAttribute";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMemberValueType";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnnotationRepeatedTwice";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidAnnotationMethodType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

