/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.java.codeserver.highlighting.ExpressionChecker;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

final class TypeChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;

    TypeChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            TypeChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    void checkIllegalType(@NotNull PsiTypeElement typeElement) {
        PsiClass aClass;
        PsiElement parent;
        if (typeElement == null) {
            TypeChecker.$$$reportNull$$$0(1);
        }
        if ((parent = typeElement.getParent()) instanceof PsiTypeElement) {
            return;
        }
        if (PsiUtil.isInsideJavadocComment((PsiElement)typeElement)) {
            return;
        }
        PsiType type = typeElement.getType();
        PsiType componentType = type.getDeepComponentType();
        if (componentType instanceof PsiClassType && (aClass = PsiUtil.resolveClassInType((PsiType)componentType)) == null) {
            PsiLocalVariable localVariable;
            PsiExpression initializer;
            if (typeElement.isInferredType() && parent instanceof PsiLocalVariable && (initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)(localVariable = (PsiLocalVariable)parent).getInitializer())) instanceof PsiNewExpression) {
                return;
            }
            if (this.myVisitor.isIncompleteModel()) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.TYPE_UNKNOWN_CLASS.create(typeElement));
        }
    }

    void checkVarTypeApplicability(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            TypeChecker.$$$reportNull$$$0(2);
        }
        if (!typeElement.isInferredType()) {
            return;
        }
        PsiElement parent = typeElement.getParent();
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)parent, PsiVariable.class);
        if (variable instanceof PsiLocalVariable) {
            PsiLocalVariable localVariable = (PsiLocalVariable)variable;
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                if (PsiUtilCore.hasErrorElementChild((PsiElement)variable)) {
                    return;
                }
                this.myVisitor.report(JavaErrorKinds.LVTI_NO_INITIALIZER.create(localVariable));
                return;
            }
            PsiExpression deparen = PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer);
            if (deparen instanceof PsiFunctionalExpression) {
                JavaErrorKind.Simple<PsiLocalVariable> kind = deparen instanceof PsiLambdaExpression ? JavaErrorKinds.LVTI_LAMBDA : JavaErrorKinds.LVTI_METHOD_REFERENCE;
                this.myVisitor.report(kind.create(localVariable));
                return;
            }
            if (ExpressionChecker.isArrayDeclaration(variable)) {
                this.myVisitor.report(JavaErrorKinds.LVTI_ARRAY.create((PsiVariable)localVariable));
                return;
            }
            PsiType lType = variable.getType();
            if (PsiTypes.nullType().equals(lType) && TypeChecker.allChildrenAreNullLiterals(initializer)) {
                this.myVisitor.report(JavaErrorKinds.LVTI_NULL.create(localVariable));
                return;
            }
            if (PsiTypes.voidType().equals((Object)lType)) {
                this.myVisitor.report(JavaErrorKinds.LVTI_VOID.create(localVariable));
            }
        } else if (variable instanceof PsiParameter && variable.getParent() instanceof PsiParameterList && ExpressionChecker.isArrayDeclaration(variable)) {
            this.myVisitor.report(JavaErrorKinds.LVTI_ARRAY.create(variable));
        }
    }

    void checkVariableInitializerType(@NotNull PsiVariable variable) {
        PsiExpression initializer;
        if (variable == null) {
            TypeChecker.$$$reportNull$$$0(3);
        }
        if ((initializer = variable.getInitializer()) == null || initializer instanceof PsiArrayInitializerExpression) {
            return;
        }
        PsiTypeElement typeElement = variable.getTypeElement();
        if (typeElement != null && typeElement.isInferredType()) {
            return;
        }
        PsiType lType = variable.getType();
        PsiType rType = initializer.getType();
        this.myVisitor.myExpressionChecker.checkAssignability(lType, rType, initializer, (PsiElement)initializer);
    }

    void checkVarTypeApplicability(@NotNull PsiVariable variable) {
        if (variable == null) {
            TypeChecker.$$$reportNull$$$0(4);
        }
        if (variable instanceof PsiLocalVariable) {
            PsiDeclarationStatement statement;
            PsiElement parent;
            PsiLocalVariable local = (PsiLocalVariable)variable;
            if (variable.getTypeElement().isInferredType() && (parent = variable.getParent()) instanceof PsiDeclarationStatement && (statement = (PsiDeclarationStatement)parent).getDeclaredElements().length > 1) {
                this.myVisitor.report(JavaErrorKinds.LVTI_COMPOUND.create(local));
            }
        }
    }

    private static boolean allChildrenAreNullLiterals(PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
            return false;
        }
        if (expression instanceof PsiLiteralExpression) {
            PsiLiteralExpression literal = (PsiLiteralExpression)expression;
            if (PsiTypes.nullType().equals(literal.getType())) {
                return true;
            }
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression cast = (PsiTypeCastExpression)expression;
            return TypeChecker.allChildrenAreNullLiterals(cast.getOperand());
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            return TypeChecker.allChildrenAreNullLiterals(conditional.getThenExpression()) && TypeChecker.allChildrenAreNullLiterals(conditional.getElseExpression());
        }
        if (expression instanceof PsiSwitchExpression) {
            PsiStatement[] statements;
            PsiSwitchExpression switchExpression = (PsiSwitchExpression)expression;
            PsiCodeBlock switchBody = switchExpression.getBody();
            if (switchBody == null) {
                return false;
            }
            for (PsiStatement statement : statements = switchBody.getStatements()) {
                if (statement instanceof PsiSwitchLabeledRuleStatement) {
                    PsiExpressionStatement expr;
                    PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)statement;
                    PsiStatement ruleBody = rule.getBody();
                    if (ruleBody instanceof PsiBlockStatement) {
                        PsiBlockStatement blockStatement = (PsiBlockStatement)ruleBody;
                        for (PsiYieldStatement yield : PsiTreeUtil.findChildrenOfType((PsiElement)blockStatement, PsiYieldStatement.class)) {
                            if (yield.findEnclosingExpression() != switchExpression || TypeChecker.allChildrenAreNullLiterals(yield.getExpression())) continue;
                            return false;
                        }
                        continue;
                    }
                    if (!(ruleBody instanceof PsiExpressionStatement) || TypeChecker.allChildrenAreNullLiterals((expr = (PsiExpressionStatement)ruleBody).getExpression())) continue;
                    return false;
                }
                if (statement instanceof PsiYieldStatement) {
                    PsiYieldStatement yield = (PsiYieldStatement)statement;
                    if (TypeChecker.allChildrenAreNullLiterals(yield.getExpression())) continue;
                    return false;
                }
                for (PsiYieldStatement yield : PsiTreeUtil.findChildrenOfType((PsiElement)statement, PsiYieldStatement.class)) {
                    if (yield.findEnclosingExpression() != switchExpression || TypeChecker.allChildrenAreNullLiterals(yield.getExpression())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    void checkArrayType(@NotNull PsiTypeElement type) {
        if (type == null) {
            TypeChecker.$$$reportNull$$$0(5);
        }
        int dimensions = 0;
        for (PsiElement child = type.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.LBRACKET)) continue;
            ++dimensions;
        }
        if (dimensions > 255) {
            this.myVisitor.report(JavaErrorKinds.ARRAY_TOO_MANY_DIMENSIONS.create(type));
        }
    }

    void checkIllegalVoidType(@NotNull PsiKeyword type) {
        if (type == null) {
            TypeChecker.$$$reportNull$$$0(6);
        }
        if (!"void".equals(type.getText())) {
            return;
        }
        PsiElement parent = type.getParent();
        if (parent instanceof PsiErrorElement) {
            return;
        }
        if (parent instanceof PsiTypeElement) {
            PsiClassObjectAccessExpression classAccess;
            PsiMethod method;
            PsiElement typeOwner = parent.getParent();
            if (typeOwner != null && PsiUtilCore.hasErrorElementChild((PsiElement)typeOwner)) {
                return;
            }
            if (typeOwner instanceof PsiMethod ? (method = (PsiMethod)typeOwner).getReturnTypeElement() == parent && PsiTypes.voidType().equals((Object)method.getReturnType()) : (typeOwner instanceof PsiClassObjectAccessExpression ? TypeConversionUtil.isVoidType((PsiType)(classAccess = (PsiClassObjectAccessExpression)typeOwner).getOperand().getType()) : typeOwner instanceof JavaCodeFragment && typeOwner.getUserData(PsiUtil.VALID_VOID_TYPE_IN_CODE_FRAGMENT) != null)) {
                return;
            }
        }
        this.myVisitor.report(JavaErrorKinds.TYPE_VOID_ILLEGAL.create(type));
    }

    void checkMustBeThrowable(@NotNull PsiElement context, PsiType type) {
        if (context == null) {
            TypeChecker.$$$reportNull$$$0(7);
        }
        PsiElementFactory factory = this.myVisitor.factory();
        PsiClassType throwable = factory.createTypeByFQClassName("java.lang.Throwable", context.getResolveScope());
        if (!(type == null || TypeConversionUtil.isAssignable((PsiType)throwable, (PsiType)type) || this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isPotentiallyConvertible((PsiType)throwable, (PsiType)type, (PsiElement)context))) {
            this.myVisitor.reportIncompatibleType((PsiType)throwable, type, context);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/TypeChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIllegalType";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVarTypeApplicability";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVariableInitializerType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArrayType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIllegalVoidType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMustBeThrowable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

