/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting.errors;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.core.JavaPsiBundle;
import com.intellij.java.codeserver.core.JavaPreviewFeatureUtil;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.java.codeserver.core.JavaPsiSwitchUtil;
import com.intellij.java.codeserver.core.JpmsModuleAccessInfo;
import com.intellij.java.codeserver.highlighting.JavaCompilationErrorBundle;
import com.intellij.java.codeserver.highlighting.errors.JavaAmbiguousCallContext;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorFormatUtil;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorHighlightType;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaIncompatibleTypeErrorContext;
import com.intellij.java.codeserver.highlighting.errors.JavaMismatchedCallContext;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiDefaultCaseLabelElement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.AccessModifier;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class JavaErrorKinds {
    public static final JavaErrorKind.Parameterized<PsiElement, @NotNull JavaFeature> UNSUPPORTED_FEATURE = JavaErrorKinds.parameterized(PsiElement.class, JavaFeature.class, "insufficient.language.level").withDescription((element, feature) -> {
        String name = feature.getFeatureName();
        String version = JavaSdkVersion.fromLanguageLevel((LanguageLevel)PsiUtil.getLanguageLevel((PsiElement)element)).getDescription();
        return JavaCompilationErrorBundle.message("insufficient.language.level", name, version);
    }).withRange((element, feature) -> {
        if (feature == JavaFeature.TEXT_BLOCK_ESCAPES && element instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            return PsiLiteralUtil.findSlashS((String)literalExpression.getText());
        }
        return null;
    });
    public static final JavaErrorKind.Parameterized<PsiElement, @NotNull TextRange> ILLEGAL_UNICODE_ESCAPE = JavaErrorKinds.parameterized(PsiElement.class, TextRange.class, "illegal.unicode.escape").withRange((psi, range) -> range);
    public static final JavaErrorKind.Parameterized<PsiElement, @NotNull Character> ILLEGAL_CHARACTER = JavaErrorKinds.parameterized(PsiElement.class, Character.class, "illegal.character").withDescription((e, c) -> {
        boolean printable = StringUtil.isPrintableUnicode((char)c.charValue()) && !Character.isSpaceChar(c.charValue());
        @NlsSafe String hex = String.format("U+%04X", c.charValue());
        return JavaCompilationErrorBundle.message("illegal.character", printable ? c + " (" + hex + ")" : hex);
    });
    public static final JavaErrorKind.Simple<PsiErrorElement> SYNTAX_ERROR = JavaErrorKinds.error(PsiErrorElement.class, "syntax.error").withRange(e -> {
        TextRange range = e.getTextRange();
        if (range.getLength() == 0) {
            PsiFile file = e.getContainingFile();
            int endOffset = range.getEndOffset();
            if (endOffset < file.getTextLength() && file.getFileDocument().getCharsSequence().charAt(endOffset) != '\n') {
                return TextRange.from((int)0, (int)1);
            }
        }
        return null;
    }).withDescription(e -> JavaCompilationErrorBundle.message("syntax.error", e.getErrorDescription()));
    public static final JavaErrorKind.Parameterized<PsiElement, JavaPreviewFeatureUtil.PreviewFeatureUsage> PREVIEW_API_USAGE = JavaErrorKinds.parameterized(PsiElement.class, JavaPreviewFeatureUtil.PreviewFeatureUsage.class, "preview.api.usage").withDescription((e, c) -> JavaCompilationErrorBundle.message("preview.api.usage", c.targetName()));
    public static final JavaErrorKind.Simple<PsiAnnotation> ANNOTATION_NOT_ALLOWED_HERE = JavaErrorKinds.error("annotation.not.allowed.here");
    public static final JavaErrorKind.Simple<PsiAnnotation> ANNOTATION_NOT_ALLOWED_IN_PERMIT_LIST = JavaErrorKinds.error("annotation.not.allowed.in.permit.list");
    public static final JavaErrorKind.Simple<PsiPackageStatement> ANNOTATION_NOT_ALLOWED_ON_PACKAGE = JavaErrorKinds.error(PsiPackageStatement.class, "annotation.not.allowed.on.package").withAnchor(statement -> (PsiElement)Objects.requireNonNull(statement.getAnnotationList()));
    public static final JavaErrorKind.Simple<PsiReferenceList> ANNOTATION_MEMBER_THROWS_NOT_ALLOWED = JavaErrorKinds.error(PsiReferenceList.class, "annotation.member.may.not.have.throws.list").withAnchor(list -> Objects.requireNonNull(list.getFirstChild()));
    public static final JavaErrorKind.Simple<PsiParameterList> ANNOTATION_MEMBER_MAY_NOT_HAVE_PARAMETERS = JavaErrorKinds.error(PsiParameterList.class, "annotation.member.may.not.have.parameters");
    public static final JavaErrorKind.Simple<PsiReferenceList> ANNOTATION_NOT_ALLOWED_EXTENDS = JavaErrorKinds.error(PsiReferenceList.class, "annotation.may.not.have.extends.list").withAnchor(list -> Objects.requireNonNull(list.getFirstChild()));
    public static final JavaErrorKind.Simple<PsiElement> ANNOTATION_LOCAL = JavaErrorKinds.error("annotation.cannot.be.local");
    public static final JavaErrorKind.Simple<PsiAnnotation> ANNOTATION_NOT_ALLOWED_VAR = JavaErrorKinds.error("annotation.not.allowed.var");
    public static final JavaErrorKind.Simple<PsiAnnotation> ANNOTATION_NOT_ALLOWED_VOID = JavaErrorKinds.error("annotation.not.allowed.void");
    public static final JavaErrorKind.Simple<PsiAnnotation> ANNOTATION_NOT_ALLOWED_CLASS = JavaErrorKinds.error("annotation.not.allowed.class");
    public static final JavaErrorKind.Simple<PsiAnnotation> ANNOTATION_NOT_ALLOWED_REF = JavaErrorKinds.error("annotation.not.allowed.ref");
    public static final JavaErrorKind.Simple<PsiAnnotation> ANNOTATION_NOT_ALLOWED_STATIC = JavaErrorKinds.error("annotation.not.allowed.static");
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> ANNOTATION_TYPE_EXPECTED = JavaErrorKinds.error("annotation.type.expected");
    public static final JavaErrorKind.Simple<PsiReferenceExpression> ANNOTATION_REPEATED_TARGET = JavaErrorKinds.error("annotation.repeated.target");
    public static final JavaErrorKind.Simple<PsiNameValuePair> ANNOTATION_ATTRIBUTE_NAME_MISSING = JavaErrorKinds.error("annotation.attribute.name.missing");
    public static final JavaErrorKind.Simple<PsiAnnotationMemberValue> ANNOTATION_ATTRIBUTE_NON_CLASS_LITERAL = JavaErrorKinds.error("annotation.attribute.non.class.literal");
    public static final JavaErrorKind.Simple<PsiExpression> ANNOTATION_ATTRIBUTE_NON_ENUM_CONSTANT = JavaErrorKinds.error("annotation.attribute.non.enum.constant");
    public static final JavaErrorKind.Simple<PsiExpression> ANNOTATION_ATTRIBUTE_NON_CONSTANT = JavaErrorKinds.error("annotation.attribute.non.constant");
    public static final JavaErrorKind.Simple<PsiTypeElement> ANNOTATION_CYCLIC_TYPE = JavaErrorKinds.error("annotation.cyclic.element.type");
    public static final JavaErrorKind.Parameterized<PsiMethod, PsiMethod> ANNOTATION_MEMBER_CLASH = JavaErrorKinds.error(PsiMethod.class, "annotation.member.clash").withAnchor(curMethod -> (PsiElement)Objects.requireNonNull(curMethod.getNameIdentifier())).parameterized().withDescription((curMethod, clashMethod) -> {
        PsiClass containingClass = Objects.requireNonNull(clashMethod.getContainingClass());
        return JavaCompilationErrorBundle.message("annotation.member.clash", JavaErrorFormatUtil.formatMethod(clashMethod), JavaErrorFormatUtil.formatClass(containingClass));
    });
    public static final JavaErrorKind.Parameterized<PsiTypeElement, PsiType> ANNOTATION_METHOD_INVALID_TYPE = JavaErrorKinds.parameterized(PsiTypeElement.class, PsiType.class, "annotation.member.invalid.type").withDescription((element, type) -> JavaCompilationErrorBundle.message("annotation.member.invalid.type", type == null ? null : type.getPresentableText()));
    public static final JavaErrorKind.Parameterized<PsiAnnotationMemberValue, AnnotationValueErrorContext> ANNOTATION_ATTRIBUTE_INCOMPATIBLE_TYPE = JavaErrorKinds.parameterized(PsiAnnotationMemberValue.class, AnnotationValueErrorContext.class, "annotation.attribute.incompatible.type").withDescription((value, context) -> {
        String text;
        if (value instanceof PsiAnnotation) {
            PsiAnnotation annotation = (PsiAnnotation)value;
            text = Objects.requireNonNull(annotation.getNameReferenceElement()).getText();
        } else {
            PsiType type = ((PsiExpression)value).getType();
            text = type == null ? "null" : PsiTypesUtil.removeExternalAnnotations((PsiType)type).getInternalCanonicalText();
        }
        return JavaCompilationErrorBundle.message("annotation.attribute.incompatible.type", context.typeText(), text);
    });
    public static final JavaErrorKind.Parameterized<PsiArrayInitializerMemberValue, AnnotationValueErrorContext> ANNOTATION_ATTRIBUTE_ILLEGAL_ARRAY_INITIALIZER = JavaErrorKinds.parameterized(PsiArrayInitializerMemberValue.class, AnnotationValueErrorContext.class, "annotation.attribute.illegal.array.initializer").withDescription((element, context) -> JavaCompilationErrorBundle.message("annotation.attribute.illegal.array.initializer", context.typeText()));
    public static final JavaErrorKind.Parameterized<PsiNameValuePair, String> ANNOTATION_ATTRIBUTE_DUPLICATE = JavaErrorKinds.parameterized(PsiNameValuePair.class, String.class, "annotation.attribute.duplicate").withDescription((pair, attribute) -> JavaCompilationErrorBundle.message("annotation.attribute.duplicate", attribute));
    public static final JavaErrorKind.Parameterized<PsiNameValuePair, String> ANNOTATION_ATTRIBUTE_UNKNOWN_METHOD = JavaErrorKinds.error(PsiNameValuePair.class, "annotation.attribute.unknown.method").withAnchor(pair -> Objects.requireNonNull(pair.getReference()).getElement()).withHighlightType(pair -> pair.getName() == null ? JavaErrorHighlightType.ERROR : JavaErrorHighlightType.WRONG_REF).parameterized().withDescription((pair, methodName) -> JavaCompilationErrorBundle.message("annotation.attribute.unknown.method", methodName));
    public static final JavaErrorKind.Simple<PsiReferenceList> ANNOTATION_PERMITS = JavaErrorKinds.error(PsiReferenceList.class, "annotation.permits").withAnchor(PsiElement::getFirstChild);
    public static final JavaErrorKind.Parameterized<PsiElement, PsiType> LAMBDA_NOT_FUNCTIONAL_INTERFACE = JavaErrorKinds.parameterized(PsiElement.class, PsiType.class, "lambda.not.a.functional.interface").withDescription((element, type) -> JavaCompilationErrorBundle.message("lambda.not.a.functional.interface", JavaErrorFormatUtil.formatType(type)));
    public static final JavaErrorKind.Parameterized<PsiElement, PsiType> LAMBDA_NO_TARGET_METHOD = JavaErrorKinds.parameterized("lambda.no.target.method.found");
    public static final JavaErrorKind.Parameterized<PsiElement, PsiType> LAMBDA_MULTIPLE_TARGET_METHODS = JavaErrorKinds.parameterized(PsiElement.class, PsiType.class, "lambda.multiple.sam.candidates").withDescription((psi, type) -> {
        PsiType psiType;
        Object[] objectArray = new Object[1];
        if (type instanceof PsiClassType) {
            PsiClassType cls = (PsiClassType)type;
            psiType = cls.rawType();
        } else {
            psiType = type;
        }
        objectArray[0] = psiType.getPresentableText();
        return JavaCompilationErrorBundle.message("lambda.multiple.sam.candidates", objectArray);
    });
    public static final JavaErrorKind.Parameterized<PsiAnnotation, PsiClass> FUNCTIONAL_INTERFACE_SEALED = JavaErrorKinds.parameterized("lambda.sealed.functional.interface");
    public static final JavaErrorKind.Simple<PsiLambdaExpression> LAMBDA_NOT_EXPECTED = JavaErrorKinds.error("lambda.not.expected");
    public static final JavaErrorKind.Simple<PsiParameterList> LAMBDA_PARAMETERS_INCONSISTENT_VAR = JavaErrorKinds.error("lambda.parameters.inconsistent.var");
    public static final JavaErrorKind.Simple<PsiLambdaExpression> LAMBDA_SEALED = JavaErrorKinds.error("lambda.sealed");
    public static final JavaErrorKind.Simple<PsiFunctionalExpression> LAMBDA_TYPE_INFERENCE_FAILURE = JavaErrorKinds.error("lambda.type.inference.failure");
    public static final JavaErrorKind.Simple<PsiFunctionalExpression> LAMBDA_SAM_GENERIC = JavaErrorKinds.error("lambda.sam.generic");
    public static final JavaErrorKind.Parameterized<PsiFunctionalExpression, PsiType> LAMBDA_TARGET_NOT_INTERFACE = JavaErrorKinds.parameterized("lambda.target.not.interface");
    public static final JavaErrorKind.Parameterized<PsiLambdaExpression, MethodCandidateInfo> LAMBDA_INFERENCE_ERROR = JavaErrorKinds.parameterized(PsiLambdaExpression.class, MethodCandidateInfo.class, "lambda.inference.error").withDescription((psi, candidate) -> JavaCompilationErrorBundle.message("lambda.inference.error", candidate.getInferenceErrorMessage()));
    public static final JavaErrorKind.Parameterized<PsiElement, String> LAMBDA_RETURN_TYPE_ERROR = JavaErrorKinds.parameterized(PsiElement.class, String.class, "lambda.return.type.error").withDescription((psi, message) -> JavaCompilationErrorBundle.message("lambda.return.type.error", message));
    public static final JavaErrorKind.Parameterized<PsiLambdaExpression, PsiMethod> LAMBDA_WRONG_NUMBER_OF_PARAMETERS = JavaErrorKinds.parameterized(PsiLambdaExpression.class, PsiMethod.class, "lambda.wrong.number.of.parameters").withAnchor(PsiLambdaExpression::getParameterList).withDescription((lambda, method) -> JavaCompilationErrorBundle.message("lambda.wrong.number.of.parameters", method.getParameterList().getParametersCount(), lambda.getParameterList().getParametersCount()));
    public static final JavaErrorKind.Parameterized<PsiParameter, PsiType> LAMBDA_INCOMPATIBLE_PARAMETER_TYPES = JavaErrorKinds.parameterized(PsiParameter.class, PsiType.class, "lambda.incompatible.parameter.types").withDescription((parameter, expectedType) -> JavaCompilationErrorBundle.message("lambda.incompatible.parameter.types", expectedType.getPresentableText(), parameter.getType().getPresentableText()));
    public static final JavaErrorKind.Simple<PsiMethodReferenceExpression> METHOD_REFERENCE_SEALED = JavaErrorKinds.error("method.reference.sealed");
    public static final JavaErrorKind.Simple<PsiMethodReferenceExpression> METHOD_REFERENCE_NOT_EXPECTED = JavaErrorKinds.error("method.reference.not.expected");
    public static final JavaErrorKind.Simple<PsiMethodReferenceExpression> METHOD_REFERENCE_RAW_CONSTRUCTOR = JavaErrorKinds.error("method.reference.raw.constructor");
    public static final JavaErrorKind.Simple<PsiElement> METHOD_REFERENCE_QUALIFIER_CLASS_UNRESOLVED = JavaErrorKinds.error(PsiElement.class, "method.reference.qualifier.class.unresolved").withDescription(qualifier -> JavaCompilationErrorBundle.message("method.reference.qualifier.class.unresolved", qualifier.getText()));
    public static final JavaErrorKind.Simple<PsiTypeElement> METHOD_REFERENCE_QUALIFIER_WILDCARD = JavaErrorKinds.error("method.reference.qualifier.wildcard");
    public static final JavaErrorKind.Parameterized<PsiMethodReferenceExpression, String> METHOD_REFERENCE_RETURN_TYPE_ERROR = JavaErrorKinds.parameterized(PsiMethodReferenceExpression.class, String.class, "method.reference.return.type.error").withDescription((psi, message) -> JavaCompilationErrorBundle.message("method.reference.return.type.error", message));
    public static final JavaErrorKind.Parameterized<PsiMethodReferenceExpression, MethodCandidateInfo> METHOD_REFERENCE_INFERENCE_ERROR = JavaErrorKinds.parameterized(PsiMethodReferenceExpression.class, MethodCandidateInfo.class, "method.reference.inference.error").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription((ref, candidate) -> JavaCompilationErrorBundle.message("method.reference.inference.error", candidate.getInferenceErrorMessage()));
    public static final JavaErrorKind.Parameterized<PsiMethodReferenceExpression, PsiClass> METHOD_REFERENCE_UNRESOLVED_CONSTRUCTOR = JavaErrorKinds.parameterized(PsiMethodReferenceExpression.class, PsiClass.class, "method.reference.unresolved.constructor").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription((ref, cls) -> JavaCompilationErrorBundle.message("method.reference.unresolved.constructor", cls.getName()));
    public static final JavaErrorKind.Simple<PsiMethodReferenceExpression> METHOD_REFERENCE_UNRESOLVED_METHOD = JavaErrorKinds.error(PsiMethodReferenceExpression.class, "method.reference.unresolved.method").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withHighlightType(JavaErrorHighlightType.WRONG_REF).withDescription(ref -> JavaCompilationErrorBundle.message("method.reference.unresolved.method", ref.getReferenceName()));
    public static final JavaErrorKind.Parameterized<PsiMethodReferenceExpression, PsiMethod> METHOD_REFERENCE_ABSTRACT_METHOD = JavaErrorKinds.parameterized(PsiMethodReferenceExpression.class, PsiMethod.class, "method.reference.abstract.method").withDescription((psi, method) -> JavaCompilationErrorBundle.message("method.reference.abstract.method", method.getName()));
    public static final JavaErrorKind.Parameterized<PsiMethodReferenceExpression, PsiMethod> METHOD_REFERENCE_NON_STATIC_METHOD_IN_STATIC_CONTEXT = JavaErrorKinds.parameterized(PsiMethodReferenceExpression.class, PsiMethod.class, "method.reference.non.static.method.in.static.context");
    public static final JavaErrorKind.Parameterized<PsiMethodReferenceExpression, PsiMethod> METHOD_REFERENCE_STATIC_METHOD_NON_STATIC_QUALIFIER = JavaErrorKinds.parameterized(PsiMethodReferenceExpression.class, PsiMethod.class, "method.reference.static.method.non.static.qualifier");
    public static final JavaErrorKind.Parameterized<PsiMethodReferenceExpression, PsiMethod> METHOD_REFERENCE_STATIC_METHOD_RECEIVER = JavaErrorKinds.parameterized(PsiMethodReferenceExpression.class, PsiMethod.class, "method.reference.static.method.receiver");
    public static final JavaErrorKind.Parameterized<PsiMethodReferenceExpression, PsiClass> METHOD_REFERENCE_ENCLOSING_INSTANCE_NOT_IN_SCOPE = JavaErrorKinds.parameterized(PsiMethodReferenceExpression.class, PsiClass.class, "method.reference.enclosing.instance.not.in.scope").withDescription((psi, cls) -> JavaCompilationErrorBundle.message("method.reference.enclosing.instance.not.in.scope", JavaErrorFormatUtil.formatClass(cls)));
    public static final JavaErrorKind.Simple<PsiReferenceParameterList> METHOD_REFERENCE_PARAMETERIZED_QUALIFIER = JavaErrorKinds.error("method.reference.parameterized.qualifier");
    public static final JavaErrorKind.Parameterized<PsiAnnotation, @NotNull List<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PsiAnnotation.TargetType>> ANNOTATION_NOT_APPLICABLE = JavaErrorKinds.error(PsiAnnotation.class, "annotation.not.applicable").parameterized().withDescription((annotation, types) -> {
        String target = JavaPsiBundle.message((String)("annotation.target." + String.valueOf(types.get(0))), (Object[])new Object[0]);
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        return JavaCompilationErrorBundle.message("annotation.not.applicable", nameRef != null ? nameRef.getText() : annotation.getText(), target);
    });
    public static final JavaErrorKind.Parameterized<PsiAnnotation, @NotNull List<String>> ANNOTATION_MISSING_ATTRIBUTE = JavaErrorKinds.error(PsiAnnotation.class, "annotation.missing.attribute").withAnchor(annotation -> annotation.getNameReferenceElement()).parameterized().withDescription((annotation, attributeNames) -> JavaCompilationErrorBundle.message("annotation.missing.attribute", attributeNames.stream().map(attr -> "'" + attr + "'").collect(Collectors.joining(", "))));
    public static final JavaErrorKind.Simple<PsiAnnotation> ANNOTATION_CONTAINER_WRONG_PLACE = JavaErrorKinds.error(PsiAnnotation.class, "annotation.container.wrong.place").withDescription(annotation -> JavaCompilationErrorBundle.message("annotation.container.wrong.place", Objects.requireNonNull(annotation.resolveAnnotationType()).getQualifiedName()));
    public static final JavaErrorKind.Parameterized<PsiAnnotation, PsiClass> ANNOTATION_CONTAINER_NOT_APPLICABLE = JavaErrorKinds.parameterized(PsiAnnotation.class, PsiClass.class, "annotation.container.not.applicable").withDescription((annotation, containerClass) -> {
        PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)annotation.getOwner());
        String target = JavaPsiBundle.message((String)("annotation.target." + String.valueOf(targets[0])), (Object[])new Object[0]);
        return JavaCompilationErrorBundle.message("annotation.container.not.applicable", containerClass.getName(), target);
    });
    public static final JavaErrorKind.Simple<PsiAnnotation> ANNOTATION_DUPLICATE = JavaErrorKinds.error(PsiAnnotation.class, "annotation.duplicate").withAnchor(annotation -> (PsiElement)Objects.requireNonNull(annotation.getNameReferenceElement()));
    public static final JavaErrorKind.Simple<PsiAnnotation> ANNOTATION_DUPLICATE_NON_REPEATABLE = JavaErrorKinds.error(PsiAnnotation.class, "annotation.duplicate.non.repeatable").withAnchor(annotation -> (PsiElement)Objects.requireNonNull(annotation.getNameReferenceElement())).withDescription(annotation -> JavaCompilationErrorBundle.message("annotation.duplicate.non.repeatable", Objects.requireNonNull(annotation.resolveAnnotationType()).getQualifiedName()));
    public static final JavaErrorKind.Parameterized<PsiAnnotation, String> ANNOTATION_DUPLICATE_EXPLAINED = JavaErrorKinds.error(PsiAnnotation.class, "annotation.duplicate.explained").withAnchor(annotation -> (PsiElement)Objects.requireNonNull(annotation.getNameReferenceElement())).parameterized().withDescription((annotation, message) -> JavaCompilationErrorBundle.message("annotation.duplicate.explained", message));
    public static final JavaErrorKind.Parameterized<PsiAnnotationMemberValue, String> ANNOTATION_MALFORMED_REPEATABLE_EXPLAINED = JavaErrorKinds.parameterized(PsiAnnotationMemberValue.class, String.class, "annotation.malformed.repeatable.explained").withDescription((containerRef, message) -> JavaCompilationErrorBundle.message("annotation.malformed.repeatable.explained", message));
    public static final JavaErrorKind.Simple<PsiAnnotation> SAFE_VARARGS_ON_RECORD_COMPONENT = JavaErrorKinds.error("safe.varargs.on.record.component");
    public static final JavaErrorKind.Parameterized<PsiAnnotation, PsiMethod> SAFE_VARARGS_ON_FIXED_ARITY = JavaErrorKinds.parameterized("safe.varargs.on.fixed.arity");
    public static final JavaErrorKind.Parameterized<PsiAnnotation, PsiMethod> SAFE_VARARGS_ON_NON_FINAL_METHOD = JavaErrorKinds.parameterized("safe.varargs.on.non.final.method");
    public static final JavaErrorKind.Parameterized<PsiAnnotation, PsiMethod> OVERRIDE_ON_STATIC_METHOD = JavaErrorKinds.parameterized("override.on.static.method");
    public static final JavaErrorKind.Parameterized<PsiAnnotation, PsiMethod> OVERRIDE_ON_NON_OVERRIDING_METHOD = JavaErrorKinds.parameterized("override.on.non-overriding.method");
    public static final JavaErrorKind.Simple<PsiReceiverParameter> RECEIVER_WRONG_CONTEXT = JavaErrorKinds.error(PsiReceiverParameter.class, "receiver.wrong.context").withAnchor(PsiReceiverParameter::getIdentifier);
    public static final JavaErrorKind.Simple<PsiReceiverParameter> RECEIVER_STATIC_CONTEXT = JavaErrorKinds.error(PsiReceiverParameter.class, "receiver.static.context").withAnchor(PsiReceiverParameter::getIdentifier);
    public static final JavaErrorKind.Simple<PsiReceiverParameter> RECEIVER_WRONG_POSITION = JavaErrorKinds.error(PsiReceiverParameter.class, "receiver.wrong.position").withAnchor(PsiReceiverParameter::getIdentifier);
    public static final JavaErrorKind.Parameterized<PsiReceiverParameter, PsiType> RECEIVER_TYPE_MISMATCH = JavaErrorKinds.error(PsiReceiverParameter.class, "receiver.type.mismatch").withAnchor(parameter -> (PsiElement)Objects.requireNonNullElse(parameter.getTypeElement(), parameter)).parameterized();
    public static final JavaErrorKind.Parameterized<PsiReceiverParameter, @Nullable String> RECEIVER_NAME_MISMATCH = JavaErrorKinds.error(PsiReceiverParameter.class, "receiver.name.mismatch").withAnchor(PsiReceiverParameter::getIdentifier).parameterized();
    public static final JavaErrorKind.Parameterized<PsiMember, PsiMethod> CLASS_NO_ABSTRACT_METHOD = JavaErrorKinds.error(PsiMember.class, "class.must.implement.method").withRange(member -> {
        TextRange textRange;
        if (member instanceof PsiEnumConstant) {
            PsiEnumConstant enumConstant = (PsiEnumConstant)member;
            textRange = enumConstant.getNameIdentifier().getTextRangeInParent();
        } else if (member instanceof PsiClass) {
            PsiClass aClass = (PsiClass)member;
            textRange = JavaErrorFormatUtil.getClassDeclarationTextRange(aClass);
        } else {
            textRange = null;
        }
        return textRange;
    }).parameterized().withDescription((member, abstractMethod) -> {
        String referenceName;
        String messageKey;
        PsiClass aClass;
        if (member instanceof PsiEnumConstant) {
            PsiEnumConstant enumConstant = (PsiEnumConstant)member;
            v0 = Objects.requireNonNullElse(enumConstant.getInitializingClass(), member.getContainingClass());
        } else {
            v0 = aClass = (PsiClass)member;
        }
        if (member instanceof PsiEnumConstant) {
            PsiEnumConstant enumConstant = (PsiEnumConstant)member;
            messageKey = "class.must.implement.method.enum.constant";
            referenceName = enumConstant.getName();
        } else {
            messageKey = aClass.isEnum() || aClass.isRecord() || aClass instanceof PsiAnonymousClass ? "class.must.implement.method" : "class.must.implement.method.or.abstract";
            referenceName = JavaErrorFormatUtil.formatClass(aClass, false);
        }
        return JavaCompilationErrorBundle.message(messageKey, referenceName, JavaErrorFormatUtil.formatMethod(abstractMethod), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(abstractMethod.getContainingClass()), false));
    });
    public static final JavaErrorKind.Parameterized<PsiClass, OverrideClashContext> CLASS_INHERITS_ABSTRACT_AND_DEFAULT = JavaErrorKinds.parameterized(PsiClass.class, OverrideClashContext.class, "class.inherits.abstract.and.default").withAnchor(PsiClass::getNameIdentifier).withDescription((cls, ctx) -> JavaCompilationErrorBundle.message("class.inherits.abstract.and.default", JavaErrorFormatUtil.formatClass(cls), JavaErrorFormatUtil.formatMethod(ctx.method()), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(ctx.method().getContainingClass())), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(ctx.superMethod().getContainingClass()))));
    public static final JavaErrorKind.Parameterized<PsiClass, OverrideClashContext> CLASS_INHERITS_UNRELATED_DEFAULTS = JavaErrorKinds.parameterized(PsiClass.class, OverrideClashContext.class, "class.inherits.unrelated.defaults").withAnchor(PsiClass::getNameIdentifier).withDescription((cls, ctx) -> JavaCompilationErrorBundle.message("class.inherits.unrelated.defaults", JavaErrorFormatUtil.formatClass(cls), JavaErrorFormatUtil.formatMethod(ctx.method()), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(ctx.method().getContainingClass())), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(ctx.superMethod().getContainingClass()))));
    public static final JavaErrorKind.Simple<PsiClass> CLASS_ALREADY_IMPORTED = JavaErrorKinds.error(PsiClass.class, "class.already.imported").withAnchor(PsiClass::getNameIdentifier).withDescription(cls -> JavaCompilationErrorBundle.message("class.already.imported", JavaErrorFormatUtil.formatClass(cls, false)));
    public static final JavaErrorKind.Parameterized<PsiClass, PsiClass> CLASS_DUPLICATE = JavaErrorKinds.error(PsiClass.class, "class.duplicate").withAnchor(cls -> (PsiElement)Objects.requireNonNullElse(cls.getNameIdentifier(), cls)).withHighlightType(cls -> cls instanceof PsiImplicitClass ? JavaErrorHighlightType.FILE_LEVEL_ERROR : JavaErrorHighlightType.ERROR).withDescription(cls -> JavaCompilationErrorBundle.message("class.duplicate", cls.getName())).parameterized();
    public static final JavaErrorKind.Parameterized<PsiClass, PsiClass> CLASS_DUPLICATE_IN_OTHER_FILE = JavaErrorKinds.error(PsiClass.class, "class.duplicate").withAnchor(cls -> (PsiElement)Objects.requireNonNullElse(cls.getNameIdentifier(), cls)).withHighlightType(cls -> cls instanceof PsiImplicitClass ? JavaErrorHighlightType.FILE_LEVEL_ERROR : JavaErrorHighlightType.ERROR).parameterized().withDescription((cls, dupCls) -> JavaCompilationErrorBundle.message("class.duplicate.in.other.file", FileUtil.toSystemDependentName((String)dupCls.getContainingFile().getVirtualFile().getPath())));
    public static final JavaErrorKind.Simple<PsiClass> CLASS_CLASHES_WITH_PACKAGE = JavaErrorKinds.error(PsiClass.class, "class.clashes.with.package").withAnchor(cls -> (PsiElement)Objects.requireNonNullElse(cls.getNameIdentifier(), cls)).withHighlightType(cls -> cls instanceof PsiImplicitClass ? JavaErrorHighlightType.FILE_LEVEL_ERROR : JavaErrorHighlightType.ERROR).withDescription(cls -> JavaCompilationErrorBundle.message("class.clashes.with.package", cls.getQualifiedName()));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> PACKAGE_CLASHES_WITH_CLASS = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "package.clashes.with.class").withDescription(ref -> JavaCompilationErrorBundle.message("package.clashes.with.class", ref.getText()));
    public static final JavaErrorKind.Simple<PsiClass> CLASS_WRONG_FILE_NAME = JavaErrorKinds.error(PsiClass.class, "class.wrong.filename").withRange(JavaErrorFormatUtil::getClassDeclarationTextRange).withDescription(cls -> JavaCompilationErrorBundle.message("class.wrong.filename", cls.getName()));
    public static final JavaErrorKind.Parameterized<PsiClass, PsiClass> CLASS_CYCLIC_INHERITANCE = JavaErrorKinds.error(PsiClass.class, "class.cyclic.inheritance").withRange(JavaErrorFormatUtil::getClassDeclarationTextRange).parameterized().withDescription((aClass, circularClass) -> JavaCompilationErrorBundle.message("class.cyclic.inheritance", JavaErrorFormatUtil.formatClass(circularClass)));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> CLASS_REFERENCE_LIST_DUPLICATE = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "class.reference.list.duplicate").withDescription((ref, target) -> JavaCompilationErrorBundle.message("class.reference.list.duplicate", JavaErrorFormatUtil.formatClass(target), ref.getParent().getFirstChild().getText()));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> CLASS_REFERENCE_LIST_NAME_EXPECTED = JavaErrorKinds.error("class.reference.list.name.expected");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> CLASS_REFERENCE_LIST_INNER_PRIVATE = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "class.reference.list.inner.private").withDescription((ref, target) -> JavaCompilationErrorBundle.message("class.reference.list.inner.private", JavaErrorFormatUtil.formatClass(target), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(target.getContainingClass()))));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> CLASS_REFERENCE_LIST_NO_ENCLOSING_INSTANCE = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "class.reference.list.no.enclosing.instance").withDescription((ref, target) -> JavaCompilationErrorBundle.message("class.reference.list.no.enclosing.instance", JavaErrorFormatUtil.formatClass(target)));
    public static final JavaErrorKind.Simple<PsiReferenceList> CLASS_CANNOT_EXTEND_MULTIPLE_CLASSES = JavaErrorKinds.error("class.cannot.extend.multiple.classes");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> CLASS_EXTENDS_INTERFACE = JavaErrorKinds.parameterized("class.extends.interface");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> CLASS_EXTENDS_SEALED_LOCAL = JavaErrorKinds.parameterized("class.extends.sealed.local");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, SuperclassSubclassContext> CLASS_EXTENDS_SEALED_NOT_PERMITTED = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, SuperclassSubclassContext.class, "class.extends.sealed.not.permitted").withDescription((ref, cls) -> JavaCompilationErrorBundle.message("class.extends.sealed.not.permitted", JavaErrorFormatUtil.formatClass(cls.subClass())));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, SuperclassSubclassContext> CLASS_EXTENDS_SEALED_ANOTHER_MODULE = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, SuperclassSubclassContext.class, "class.extends.sealed.another.module");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, SuperclassSubclassContext> CLASS_EXTENDS_SEALED_ANOTHER_PACKAGE = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, SuperclassSubclassContext.class, "class.extends.sealed.another.package").withDescription((ref, cls) -> StringUtil.capitalize((String)JavaCompilationErrorBundle.message("class.extends.sealed.another.package", JavaElementKind.fromElement((PsiElement)cls.subClass()).subject(), JavaErrorFormatUtil.formatClass(cls.subClass()), JavaElementKind.fromElement((PsiElement)cls.superClass()).subject(), JavaErrorFormatUtil.formatClass(cls.superClass()))));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> CLASS_EXTENDS_PROHIBITED_CLASS = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "class.extends.prohibited.class").withDescription((ref, cls) -> JavaCompilationErrorBundle.message("class.extends.prohibited.class", cls.getQualifiedName()));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> CLASS_INHERITS_TYPE_PARAMETER = JavaErrorKinds.parameterized("class.inherits.type.parameter");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> CLASS_EXTENDS_FINAL = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "class.extends.final").withDescription((ref, cls) -> {
        int choice = cls.isEnum() ? 2 : (cls.isRecord() ? 3 : (cls.isValueClass() ? 4 : 1));
        return JavaCompilationErrorBundle.message("class.extends.final", JavaErrorFormatUtil.formatClass(cls), choice);
    });
    public static final JavaErrorKind.Simple<PsiAnonymousClass> CLASS_ANONYMOUS_EXTENDS_SEALED = JavaErrorKinds.error(PsiAnonymousClass.class, "class.anonymous.extends.sealed").withAnchor(PsiAnonymousClass::getBaseClassReference);
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> CLASS_IMPLEMENTS_CLASS = JavaErrorKinds.parameterized("class.implements.class");
    public static final JavaErrorKind.Simple<PsiClass> CLASS_SEALED_NO_INHERITORS = JavaErrorKinds.error(PsiClass.class, "class.sealed.no.inheritors").withAnchor(PsiClass::getNameIdentifier);
    public static final JavaErrorKind.Simple<PsiClass> CLASS_SEALED_INCOMPLETE_PERMITS = JavaErrorKinds.error(PsiClass.class, "class.sealed.incomplete.permits").withAnchor(PsiClass::getNameIdentifier);
    public static final JavaErrorKind.Simple<PsiClass> CLASS_SEALED_INHERITOR_EXPECTED_MODIFIERS_CAN_BE_FINAL = JavaErrorKinds.error(PsiClass.class, "class.sealed.inheritor.expected.modifiers.can.be.final").withAnchor(PsiClass::getNameIdentifier);
    public static final JavaErrorKind.Simple<PsiClass> CLASS_SEALED_INHERITOR_EXPECTED_MODIFIERS = JavaErrorKinds.error(PsiClass.class, "class.sealed.inheritor.expected.modifiers").withAnchor(PsiClass::getNameIdentifier);
    public static final JavaErrorKind.Simple<PsiClass> CLASS_SEALED_PERMITS_ON_NON_SEALED = JavaErrorKinds.error(PsiClass.class, "class.sealed.permits.on.non.sealed").withAnchor(cls -> Objects.requireNonNull(cls.getPermitsList()).getFirstChild()).withDescription(cls -> JavaCompilationErrorBundle.message("class.sealed.permits.on.non.sealed", cls.getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, ClassStaticReferenceErrorContext> CLASS_NOT_ENCLOSING = JavaErrorKinds.parameterized(PsiElement.class, ClassStaticReferenceErrorContext.class, "class.not.enclosing").withDescription((psi, ctx) -> JavaCompilationErrorBundle.message("class.not.enclosing", JavaErrorFormatUtil.formatClass(ctx.outerClass())));
    public static final JavaErrorKind.Parameterized<PsiElement, ClassStaticReferenceErrorContext> CLASS_CANNOT_BE_REFERENCED_FROM_STATIC_CONTEXT = JavaErrorKinds.parameterized(PsiElement.class, ClassStaticReferenceErrorContext.class, "class.cannot.be.referenced.from.static.context").withDescription((psi, ctx) -> JavaCompilationErrorBundle.message("class.cannot.be.referenced.from.static.context", JavaErrorFormatUtil.formatClass(ctx.outerClass()) + "." + (psi instanceof PsiSuperExpression ? "super" : "this")));
    public static final JavaErrorKind.Parameterized<PsiClass, InheritTypeClashContext> CLASS_INHERITANCE_DIFFERENT_TYPE_ARGUMENTS = JavaErrorKinds.parameterized(PsiClass.class, InheritTypeClashContext.class, "class.inheritance.different.type.arguments").withRange((cls, ctx) -> JavaErrorFormatUtil.getClassDeclarationTextRange(cls)).withDescription((cls, ctx) -> JavaCompilationErrorBundle.message("class.inheritance.different.type.arguments", JavaErrorFormatUtil.formatClass(ctx.superClass()), JavaErrorFormatUtil.formatType(ctx.type1()), JavaErrorFormatUtil.formatType(ctx.type2())));
    public static final JavaErrorKind.Parameterized<PsiClass, InheritTypeClashContext> CLASS_INHERITANCE_RAW_AND_GENERIC = JavaErrorKinds.parameterized(PsiClass.class, InheritTypeClashContext.class, "class.inheritance.raw.and.generic").withRange((cls, ctx) -> JavaErrorFormatUtil.getClassDeclarationTextRange(cls)).withDescription((cls, ctx) -> JavaCompilationErrorBundle.message("class.inheritance.raw.and.generic", JavaErrorFormatUtil.formatClass(ctx.superClass()), JavaErrorFormatUtil.formatType(ctx.type1() != null ? ctx.type1() : ctx.type2())));
    public static final JavaErrorKind.Parameterized<PsiClass, OverrideClashContext> CLASS_INHERITANCE_METHOD_CLASH = JavaErrorKinds.parameterized(PsiClass.class, OverrideClashContext.class, "class.inheritance.method.clash").withAnchor(PsiClass::getNameIdentifier).withDescription((cls, ctx) -> JavaCompilationErrorBundle.message("class.inheritance.method.clash", JavaErrorFormatUtil.formatMethod(ctx.superMethod()), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(ctx.superMethod().getContainingClass())), JavaErrorFormatUtil.formatMethod(ctx.method()), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(ctx.method().getContainingClass()))));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> CLASS_GENERIC_EXTENDS_EXCEPTION = JavaErrorKinds.error("class.generic.extends.exception");
    public static final JavaErrorKind.Parameterized<PsiElement, PsiClass> CLASS_NOT_ACCESSIBLE = JavaErrorKinds.parameterized(PsiElement.class, PsiClass.class, "class.not.accessible").withRange((psi, cls) -> {
        TextRange textRange;
        if (psi instanceof PsiMember) {
            PsiMember member = (PsiMember)psi;
            textRange = JavaErrorFormatUtil.getMemberDeclarationTextRange(member);
        } else {
            textRange = null;
        }
        return textRange;
    }).withDescription((psi, cls) -> JavaCompilationErrorBundle.message("class.not.accessible", JavaErrorFormatUtil.formatClass(cls)));
    public static final JavaErrorKind.Simple<PsiCodeBlock> CLASS_INITIALIZER_MUST_COMPLETE_NORMALLY = JavaErrorKinds.error("class.initializer.must.complete.normally");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> CLASS_PERMITTED_MUST_HAVE_MODIFIER = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "class.permitted.must.have.modifier");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, SuperclassSubclassContext> CLASS_PERMITTED_NOT_DIRECT_SUBCLASS = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, SuperclassSubclassContext.class, "class.permitted.not.direct.subclass").withDescription((ref, ctx) -> JavaCompilationErrorBundle.message("class.permitted.not.direct.subclass", ctx.subClass().getName(), ctx.subClass().isInterface() == ctx.superClass().isInterface() ? 1 : 2, ctx.superClass().getName()));
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiClass> CLASS_OR_PACKAGE_EXPECTED = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiClass.class, "class.or.package.expected").withAnchor(ref -> ref.getQualifierExpression());
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> VALUE_CLASS_EXTENDS_NON_ABSTRACT = JavaErrorKinds.error("value.class.extends.non.abstract");
    public static final JavaErrorKind.Simple<PsiExpression> INSTANTIATION_ENUM = JavaErrorKinds.error("instantiation.enum");
    public static final JavaErrorKind.Parameterized<PsiExpression, PsiClass> INSTANTIATION_ABSTRACT = JavaErrorKinds.parameterized(PsiExpression.class, PsiClass.class, "instantiation.abstract").withDescription((expr, aClass) -> JavaCompilationErrorBundle.message("instantiation.abstract", aClass.getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, PsiClass> INSTANTIATION_LOCAL_CLASS_WRONG_STATIC_CONTEXT = JavaErrorKinds.parameterized(PsiElement.class, PsiClass.class, "instantiation.local.class.wrong.static.context").withDescription((psi, ctx) -> JavaCompilationErrorBundle.message("instantiation.local.class.wrong.static.context", ctx.getName()));
    public static final JavaErrorKind.Simple<PsiClass> RECORD_NO_HEADER = JavaErrorKinds.error(PsiClass.class, "record.no.header").withAnchor(PsiClass::getNameIdentifier);
    public static final JavaErrorKind.Simple<PsiRecordHeader> RECORD_HEADER_REGULAR_CLASS = JavaErrorKinds.error("record.header.regular.class");
    public static final JavaErrorKind.Simple<PsiClassInitializer> RECORD_INSTANCE_INITIALIZER = JavaErrorKinds.error("record.instance.initializer");
    public static final JavaErrorKind.Simple<PsiField> RECORD_INSTANCE_FIELD = JavaErrorKinds.error("record.instance.field");
    public static final JavaErrorKind.Simple<PsiReferenceList> RECORD_EXTENDS = JavaErrorKinds.error(PsiReferenceList.class, "record.extends").withAnchor(PsiElement::getFirstChild);
    public static final JavaErrorKind.Simple<PsiReferenceList> RECORD_PERMITS = JavaErrorKinds.error(PsiReferenceList.class, "record.permits").withAnchor(PsiElement::getFirstChild);
    public static final JavaErrorKind.Simple<PsiRecordComponent> RECORD_COMPONENT_VARARG_NOT_LAST = JavaErrorKinds.error("record.component.vararg.not.last");
    public static final JavaErrorKind.Parameterized<PsiRecordComponent, @NotNull TextRange> RECORD_COMPONENT_CSTYLE_DECLARATION = JavaErrorKinds.parameterized(PsiRecordComponent.class, TextRange.class, "record.component.cstyle.declaration").withRange((component, range) -> range);
    public static final JavaErrorKind.Simple<PsiRecordComponent> RECORD_COMPONENT_RESTRICTED_NAME = JavaErrorKinds.error(PsiRecordComponent.class, "record.component.restricted.name").withAnchor(PsiVariable::getNameIdentifier).withDescription(component -> JavaCompilationErrorBundle.message("record.component.restricted.name", component.getName()));
    public static final JavaErrorKind.Simple<PsiRecordComponent> RECORD_COMPONENT_NOT_INITIALIZED = JavaErrorKinds.error(PsiRecordComponent.class, "record.component.not.initialized").withAnchor(PsiVariable::getNameIdentifier).withDescription(component -> JavaCompilationErrorBundle.message("record.component.not.initialized", component.getName()));
    public static final JavaErrorKind.Simple<PsiTypeParameterList> RECORD_SPECIAL_METHOD_TYPE_PARAMETERS = JavaErrorKinds.error(PsiTypeParameterList.class, "record.special.method.type.parameters").withDescription(tpl -> JavaCompilationErrorBundle.message("record.special.method.type.parameters", JavaErrorFormatUtil.getRecordMethodKind((PsiMethod)tpl.getParent())));
    public static final JavaErrorKind.Simple<PsiReferenceList> RECORD_SPECIAL_METHOD_THROWS = JavaErrorKinds.error(PsiReferenceList.class, "record.special.method.throws").withAnchor(PsiElement::getFirstChild).withDescription(throwsList -> JavaCompilationErrorBundle.message("record.special.method.throws", JavaErrorFormatUtil.getRecordMethodKind((PsiMethod)throwsList.getParent())));
    public static final JavaErrorKind.Parameterized<PsiMethod, AccessModifier> RECORD_CONSTRUCTOR_STRONGER_ACCESS = JavaErrorKinds.parameterized(PsiMethod.class, AccessModifier.class, "record.constructor.stronger.access").withAnchor(PsiMethod::getNameIdentifier).withDescription((method, classModifier) -> JavaCompilationErrorBundle.message("record.constructor.stronger.access", JavaErrorFormatUtil.getRecordMethodKind(method), classModifier));
    public static final JavaErrorKind.Parameterized<PsiMethod, JavaIncompatibleTypeErrorContext> RECORD_ACCESSOR_WRONG_RETURN_TYPE = JavaErrorKinds.parameterized(PsiMethod.class, JavaIncompatibleTypeErrorContext.class, "record.accessor.wrong.return.type").withAnchor(PsiMethod::getReturnTypeElement).withDescription((method, ctx) -> JavaCompilationErrorBundle.message("record.accessor.wrong.return.type", ctx.lType().getPresentableText(), Objects.requireNonNull(ctx.rType()).getPresentableText()));
    public static final JavaErrorKind.Simple<PsiMethod> RECORD_ACCESSOR_NON_PUBLIC = JavaErrorKinds.error(PsiMethod.class, "record.accessor.non.public").withAnchor(PsiMethod::getNameIdentifier);
    public static final JavaErrorKind.Simple<PsiMethod> RECORD_NO_CONSTRUCTOR_CALL_IN_NON_CANONICAL = JavaErrorKinds.error(PsiMethod.class, "record.no.constructor.call.in.non.canonical").withAnchor(PsiMethod::getNameIdentifier);
    public static final JavaErrorKind.Parameterized<PsiParameter, PsiRecordComponent> RECORD_CANONICAL_CONSTRUCTOR_WRONG_PARAMETER_TYPE = JavaErrorKinds.parameterized(PsiParameter.class, PsiRecordComponent.class, "record.canonical.constructor.wrong.parameter.type").withAnchor(PsiParameter::getTypeElement).withDescription((parameter, component) -> JavaCompilationErrorBundle.message("record.canonical.constructor.wrong.parameter.type", component.getName(), component.getType().getPresentableText(), parameter.getType().getPresentableText()));
    public static final JavaErrorKind.Parameterized<PsiParameter, PsiRecordComponent> RECORD_CANONICAL_CONSTRUCTOR_WRONG_PARAMETER_NAME = JavaErrorKinds.parameterized(PsiParameter.class, PsiRecordComponent.class, "record.canonical.constructor.wrong.parameter.name").withAnchor(PsiVariable::getNameIdentifier).withDescription((parameter, component) -> JavaCompilationErrorBundle.message("record.canonical.constructor.wrong.parameter.name", component.getName(), parameter.getName()));
    public static final JavaErrorKind.Simple<PsiParameter> VARARG_NOT_LAST_PARAMETER = JavaErrorKinds.error("vararg.not.last.parameter");
    public static final JavaErrorKind.Parameterized<PsiParameter, @NotNull TextRange> VARARG_CSTYLE_DECLARATION = JavaErrorKinds.parameterized(PsiParameter.class, TextRange.class, "vararg.cstyle.array.declaration").withRange((component, range) -> range);
    public static final JavaErrorKind.Simple<PsiReferenceList> ENUM_EXTENDS = JavaErrorKinds.error(PsiReferenceList.class, "enum.extends").withAnchor(PsiElement::getFirstChild);
    public static final JavaErrorKind.Simple<PsiReferenceList> ENUM_PERMITS = JavaErrorKinds.error(PsiReferenceList.class, "enum.permits").withAnchor(PsiElement::getFirstChild);
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiField> ENUM_CONSTANT_ILLEGAL_ACCESS_IN_CONSTRUCTOR = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiField.class, "enum.constant.illegal.access.in.constructor").withDescription((expr, field) -> {
        int fieldType = field instanceof PsiEnumConstant ? 2 : 1;
        PsiMember initializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expr);
        int initializerType = initializer instanceof PsiMethod ? 1 : (initializer instanceof PsiField ? 2 : 3);
        return JavaCompilationErrorBundle.message("enum.constant.illegal.access.in.constructor", fieldType, initializerType);
    });
    public static final JavaErrorKind.Simple<PsiKeyword> ENUM_CONSTANT_MODIFIER = JavaErrorKinds.error(PsiKeyword.class, "enum.constant.modifier");
    public static final JavaErrorKind.Simple<PsiClassInitializer> INTERFACE_CLASS_INITIALIZER = JavaErrorKinds.error("interface.class.initializer");
    public static final JavaErrorKind.Simple<PsiMethod> INTERFACE_CONSTRUCTOR = JavaErrorKinds.error("interface.constructor");
    public static final JavaErrorKind.Simple<PsiReferenceList> INTERFACE_IMPLEMENTS = JavaErrorKinds.error(PsiReferenceList.class, "interface.implements").withAnchor(PsiElement::getFirstChild);
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> INTERFACE_EXTENDS_CLASS = JavaErrorKinds.parameterized("interface.extends.class");
    public static final JavaErrorKind.Parameterized<PsiJavaFile, PsiImplicitClass> CLASS_IMPLICIT_NO_MAIN_METHOD = JavaErrorKinds.error(PsiJavaFile.class, "class.implicit.no.main.method").withHighlightType(JavaErrorHighlightType.FILE_LEVEL_ERROR).parameterized();
    public static final JavaErrorKind.Parameterized<PsiJavaFile, PsiImplicitClass> CLASS_IMPLICIT_INVALID_FILE_NAME = JavaErrorKinds.error(PsiJavaFile.class, "class.implicit.invalid.file.name").withHighlightType(JavaErrorHighlightType.FILE_LEVEL_ERROR).parameterized();
    public static final JavaErrorKind.Simple<PsiClassInitializer> CLASS_IMPLICIT_INITIALIZER = JavaErrorKinds.error("class.implicit.initializer");
    public static final JavaErrorKind.Simple<PsiPackageStatement> CLASS_IMPLICIT_PACKAGE = JavaErrorKinds.error("class.implicit.package.statement");
    public static final JavaErrorKind.Simple<PsiIdentifier> IDENTIFIER_RESTRICTED = JavaErrorKinds.error(PsiIdentifier.class, "identifier.restricted").withDescription(psi -> JavaCompilationErrorBundle.message("identifier.restricted", psi.getText()));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiTypeParameter> TYPE_PARAMETER_EXTENDS_INTERFACE_EXPECTED = JavaErrorKinds.parameterized("type.parameter.extends.interface.expected");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiTypeParameter> TYPE_PARAMETER_CANNOT_BE_FOLLOWED_BY_OTHER_BOUNDS = JavaErrorKinds.parameterized("type.parameter.cannot.be.followed.by.other.bounds");
    public static final JavaErrorKind.Simple<PsiTypeParameterList> TYPE_PARAMETER_ON_ENUM = JavaErrorKinds.error("type.parameter.on.enum");
    public static final JavaErrorKind.Simple<PsiTypeParameterList> TYPE_PARAMETER_ON_ANNOTATION = JavaErrorKinds.error("type.parameter.on.annotation");
    public static final JavaErrorKind.Simple<PsiTypeParameterList> TYPE_PARAMETER_ON_ANNOTATION_MEMBER = JavaErrorKinds.error("type.parameter.on.annotation.member");
    public static final JavaErrorKind.Simple<PsiTypeParameter> TYPE_PARAMETER_DUPLICATE = JavaErrorKinds.error(PsiTypeParameter.class, "type.parameter.on.annotation.member").withDescription(typeParameter -> JavaCompilationErrorBundle.message("type.parameter.duplicate", typeParameter.getName()));
    public static final JavaErrorKind.Parameterized<PsiMethodCallExpression, IncompatibleIntersectionContext> TYPE_PARAMETER_INCOMPATIBLE_UPPER_BOUNDS = JavaErrorKinds.parameterized(PsiMethodCallExpression.class, IncompatibleIntersectionContext.class, "type.parameter.incompatible.upper.bounds").withRange((call, ctx) -> JavaErrorFormatUtil.getRange((PsiElement)call)).withDescription((call, ctx) -> JavaCompilationErrorBundle.message("type.parameter.incompatible.upper.bounds", ctx.parameter().getName(), ctx.message()));
    public static final JavaErrorKind.Parameterized<PsiMethodCallExpression, TypeParameterBoundMismatchContext> TYPE_PARAMETER_INFERRED_TYPE_NOT_WITHIN_EXTEND_BOUND = JavaErrorKinds.parameterized(PsiMethodCallExpression.class, TypeParameterBoundMismatchContext.class, "type.parameter.inferred.type.not.within.extend.bound").withDescription((call, ctx) -> JavaCompilationErrorBundle.message("type.parameter.inferred.type.not.within.extend.bound", JavaErrorFormatUtil.formatClass((PsiClass)ctx.parameter()), JavaErrorFormatUtil.formatType(ctx.bound()), JavaErrorFormatUtil.formatType(ctx.actualType())));
    public static final JavaErrorKind.Parameterized<PsiMethodCallExpression, TypeParameterBoundMismatchContext> TYPE_PARAMETER_INFERRED_TYPE_NOT_WITHIN_IMPLEMENT_BOUND = JavaErrorKinds.parameterized(PsiMethodCallExpression.class, TypeParameterBoundMismatchContext.class, "type.parameter.inferred.type.not.within.implement.bound").withDescription((call, ctx) -> JavaCompilationErrorBundle.message("type.parameter.inferred.type.not.within.implement.bound", JavaErrorFormatUtil.formatClass((PsiClass)ctx.parameter()), JavaErrorFormatUtil.formatType(ctx.bound()), JavaErrorFormatUtil.formatType(ctx.actualType())));
    public static final JavaErrorKind.Parameterized<PsiTypeElement, TypeParameterBoundMismatchContext> TYPE_PARAMETER_TYPE_NOT_WITHIN_EXTEND_BOUND = JavaErrorKinds.parameterized(PsiTypeElement.class, TypeParameterBoundMismatchContext.class, "type.parameter.type.not.within.extend.bound").withDescription((call, ctx) -> JavaCompilationErrorBundle.message("type.parameter.type.not.within.extend.bound", JavaErrorFormatUtil.formatClassOrType(ctx.actualType()), JavaErrorFormatUtil.formatType(ctx.bound())));
    public static final JavaErrorKind.Parameterized<PsiTypeElement, TypeParameterBoundMismatchContext> TYPE_PARAMETER_TYPE_NOT_WITHIN_IMPLEMENT_BOUND = JavaErrorKinds.parameterized(PsiTypeElement.class, TypeParameterBoundMismatchContext.class, "type.parameter.type.not.within.implement.bound").withDescription((call, ctx) -> JavaCompilationErrorBundle.message("type.parameter.type.not.within.implement.bound", JavaErrorFormatUtil.formatClassOrType(ctx.actualType()), JavaErrorFormatUtil.formatType(ctx.bound())));
    public static final JavaErrorKind.Parameterized<PsiReferenceParameterList, PsiClass> TYPE_PARAMETER_ABSENT_CLASS = JavaErrorKinds.parameterized(PsiReferenceParameterList.class, PsiClass.class, "type.parameter.absent.class").withDescription((list, cls) -> JavaCompilationErrorBundle.message("type.parameter.absent.class", JavaErrorFormatUtil.formatClass(cls)));
    public static final JavaErrorKind.Parameterized<PsiReferenceParameterList, PsiMethod> TYPE_PARAMETER_ABSENT_METHOD = JavaErrorKinds.parameterized(PsiReferenceParameterList.class, PsiMethod.class, "type.parameter.absent.method").withDescription((list, method) -> JavaCompilationErrorBundle.message("type.parameter.absent.method", JavaErrorFormatUtil.formatMethod(method)));
    public static final JavaErrorKind.Parameterized<PsiReferenceParameterList, PsiTypeParameterListOwner> TYPE_PARAMETER_COUNT_MISMATCH = JavaErrorKinds.parameterized(PsiReferenceParameterList.class, PsiTypeParameterListOwner.class, "type.parameter.count.mismatch").withNavigationShift(1).withDescription((list, owner) -> JavaCompilationErrorBundle.message("type.parameter.count.mismatch", list.getTypeArgumentCount(), owner.getTypeParameters().length));
    public static final JavaErrorKind.Simple<PsiTypeElement> TYPE_PARAMETER_ACTUAL_INFERRED_MISMATCH = JavaErrorKinds.error("type.parameter.actual.inferred.mismatch");
    public static final JavaErrorKind.Parameterized<PsiMethod, DuplicateMethodsContext> METHOD_DUPLICATE = JavaErrorKinds.parameterized(PsiMethod.class, DuplicateMethodsContext.class, "method.duplicate").withRange((method, duplicates) -> JavaErrorFormatUtil.getMethodDeclarationTextRange(method)).withDescription((method, duplicates) -> JavaCompilationErrorBundle.message("method.duplicate", JavaErrorFormatUtil.formatMethod(method), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(method.getContainingClass()))));
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_NO_PARAMETER_LIST = JavaErrorKinds.error(PsiMethod.class, "method.no.parameter.list").withAnchor(PsiMethod::getNameIdentifier);
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> METHOD_THROWS_CLASS_NAME_EXPECTED = JavaErrorKinds.error("method.throws.class.name.expected");
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_INTERFACE_BODY = JavaErrorKinds.error(PsiMethod.class, "method.interface.body").withRange(JavaErrorFormatUtil::getMethodDeclarationTextRange);
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_ABSTRACT_BODY = JavaErrorKinds.error(PsiMethod.class, "method.abstract.body").withRange(JavaErrorFormatUtil::getMethodDeclarationTextRange);
    public static final JavaErrorKind.Parameterized<PsiKeyword, PsiMethod> METHOD_ABSTRACT_IN_NON_ABSTRACT_CLASS = JavaErrorKinds.parameterized(PsiKeyword.class, PsiMethod.class, "method.abstract.in.non.abstract.class");
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_NATIVE_BODY = JavaErrorKinds.error(PsiMethod.class, "method.native.body").withRange(JavaErrorFormatUtil::getMethodDeclarationTextRange);
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_STATIC_IN_INTERFACE_SHOULD_HAVE_BODY = JavaErrorKinds.error(PsiMethod.class, "method.static.in.interface.should.have.body").withRange(JavaErrorFormatUtil::getMethodDeclarationTextRange);
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_PRIVATE_IN_INTERFACE_SHOULD_HAVE_BODY = JavaErrorKinds.error(PsiMethod.class, "method.private.in.interface.should.have.body").withRange(JavaErrorFormatUtil::getMethodDeclarationTextRange);
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_DEFAULT_SHOULD_HAVE_BODY = JavaErrorKinds.error(PsiMethod.class, "method.default.should.have.body").withRange(JavaErrorFormatUtil::getMethodDeclarationTextRange);
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_DEFAULT_IN_CLASS = JavaErrorKinds.error(PsiMethod.class, "method.default.in.class").withRange(JavaErrorFormatUtil::getMethodDeclarationTextRange);
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_DEFAULT_OVERRIDES_OBJECT_MEMBER = JavaErrorKinds.error(PsiMethod.class, "method.default.overrides.object.member").withAnchor(PsiMethod::getNameIdentifier).withDescription(method -> JavaCompilationErrorBundle.message("method.default.overrides.object.member", method.getName()));
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_SHOULD_HAVE_BODY = JavaErrorKinds.error(PsiMethod.class, "method.should.have.body").withRange(JavaErrorFormatUtil::getMethodDeclarationTextRange);
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_SHOULD_HAVE_BODY_OR_ABSTRACT = JavaErrorKinds.error(PsiMethod.class, "method.should.have.body.or.abstract").withRange(JavaErrorFormatUtil::getMethodDeclarationTextRange);
    public static final JavaErrorKind.Parameterized<PsiMember, @NotNull OverrideClashContext> METHOD_STATIC_OVERRIDES_INSTANCE = JavaErrorKinds.parameterized(PsiMember.class, OverrideClashContext.class, "method.static.overrides.instance").withRange((member, ctx) -> JavaErrorFormatUtil.getMemberDeclarationTextRange(member)).withDescription((method, ctx) -> JavaCompilationErrorBundle.message("method.static.overrides.instance", JavaErrorFormatUtil.formatMethod(ctx.method()), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(ctx.method().getContainingClass())), JavaErrorFormatUtil.formatMethod(ctx.superMethod()), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(ctx.superMethod().getContainingClass()))));
    public static final JavaErrorKind.Parameterized<PsiMember, @NotNull OverrideClashContext> METHOD_INSTANCE_OVERRIDES_STATIC = JavaErrorKinds.parameterized(PsiMember.class, OverrideClashContext.class, "method.instance.overrides.static").withRange((method, ctx) -> JavaErrorFormatUtil.getMemberDeclarationTextRange(method)).withDescription((method, ctx) -> JavaCompilationErrorBundle.message("method.instance.overrides.static", JavaErrorFormatUtil.formatMethod(ctx.method()), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(ctx.method().getContainingClass())), JavaErrorFormatUtil.formatMethod(ctx.superMethod()), JavaErrorFormatUtil.formatClass(Objects.requireNonNull(ctx.superMethod().getContainingClass()))));
    public static final JavaErrorKind.Parameterized<PsiMethod, PsiMethod> METHOD_OVERRIDES_FINAL = JavaErrorKinds.parameterized(PsiMethod.class, PsiMethod.class, "method.overrides.final").withRange((method, superMethod) -> JavaErrorFormatUtil.getMethodDeclarationTextRange(method)).withDescription((method, superMethod) -> {
        PsiClass superClass = superMethod.getContainingClass();
        return JavaCompilationErrorBundle.message("method.overrides.final", JavaErrorFormatUtil.formatMethod(method), JavaErrorFormatUtil.formatMethod(superMethod), superClass != null ? JavaErrorFormatUtil.formatClass(superClass) : "<unknown>");
    });
    public static final JavaErrorKind.Parameterized<PsiMember, @NotNull OverrideClashContext> METHOD_INHERITANCE_WEAKER_PRIVILEGES = JavaErrorKinds.parameterized(PsiMember.class, OverrideClashContext.class, "method.inheritance.weaker.privileges").withRange((psi, ctx) -> {
        if (psi instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)psi;
            PsiModifierList modifierList = method.getModifierList();
            PsiElement keyword = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)PsiUtil.getAccessModifier((int)PsiUtil.getAccessLevel((PsiModifierList)modifierList)));
            if (keyword != null) {
                return keyword.getTextRange().shiftLeft(method.getTextRange().getStartOffset());
            }
            PsiIdentifier identifier = method.getNameIdentifier();
            if (identifier != null) {
                return identifier.getTextRangeInParent();
            }
        }
        return JavaErrorFormatUtil.getMemberDeclarationTextRange(psi);
    }).withDescription((psi, ctx) -> JavaCompilationErrorBundle.message("method.inheritance.weaker.privileges", ctx.clashMessage(), VisibilityUtil.toPresentableText((String)PsiUtil.getAccessModifier((int)PsiUtil.getAccessLevel((PsiModifierList)ctx.method().getModifierList()))), VisibilityUtil.toPresentableText((String)PsiUtil.getAccessModifier((int)PsiUtil.getAccessLevel((PsiModifierList)ctx.superMethod().getModifierList())))));
    public static final JavaErrorKind.Parameterized<PsiMember, OverrideClashContext> METHOD_GENERIC_CLASH = JavaErrorKinds.parameterized(PsiMember.class, OverrideClashContext.class, "method.generic.same.erasure").withRange((member, ctx) -> JavaErrorFormatUtil.getMemberDeclarationTextRange(member)).withDescription((member, ctx) -> {
        @NonNls String key = ctx.sameClass() ? "method.generic.same.erasure" : (ctx.method().hasModifierProperty("static") ? "method.generic.same.erasure.hide" : "method.generic.same.erasure.override");
        return JavaCompilationErrorBundle.message(key, ctx.clashMessage());
    });
    public static final JavaErrorKind.Parameterized<PsiClass, @NotNull OverrideClashContext> METHOD_INHERITANCE_CLASH_UNRELATED_RETURN_TYPES = JavaErrorKinds.parameterized(PsiClass.class, OverrideClashContext.class, "method.inheritance.clash.unrelated.return.types").withRange((cls, ctx) -> JavaErrorFormatUtil.getClassDeclarationTextRange(cls)).withDescription((cls, ctx) -> JavaCompilationErrorBundle.message("method.inheritance.clash.unrelated.return.types", JavaErrorFormatUtil.formatClashMethodMessage(ctx.superMethod(), ctx.method())));
    public static final JavaErrorKind.Parameterized<PsiMember, @NotNull IncompatibleOverrideReturnTypeContext> METHOD_INHERITANCE_CLASH_INCOMPATIBLE_RETURN_TYPES = JavaErrorKinds.parameterized(PsiMember.class, IncompatibleOverrideReturnTypeContext.class, "method.inheritance.clash.incompatible.return.types").withRange((psi, ctx) -> {
        PsiRecordComponent component;
        PsiTypeElement typeElement;
        PsiMethod method;
        PsiTypeElement returnTypeElement;
        if (psi instanceof PsiMethod && (returnTypeElement = (method = (PsiMethod)psi).getReturnTypeElement()) != null) {
            return returnTypeElement.getTextRangeInParent();
        }
        if (psi instanceof PsiRecordComponent && (typeElement = (component = (PsiRecordComponent)psi).getTypeElement()) != null) {
            return typeElement.getTextRangeInParent();
        }
        return JavaErrorFormatUtil.getMemberDeclarationTextRange(psi);
    }).withDescription((cls, ctx) -> JavaCompilationErrorBundle.message("method.inheritance.clash.incompatible.return.types", JavaErrorFormatUtil.formatClashMethodMessage(ctx.method(), ctx.superMethod())));
    public static final JavaErrorKind.Parameterized<PsiMember, @NotNull IncompatibleOverrideExceptionContext> METHOD_INHERITANCE_CLASH_DOES_NOT_THROW = JavaErrorKinds.parameterized(PsiMember.class, IncompatibleOverrideExceptionContext.class, "method.inheritance.clash.does.not.throw").withRange((psi, ctx) -> ctx.exceptionReference() != null ? ctx.exceptionReference().getTextRange().shiftLeft(psi.getTextRange().getStartOffset()) : JavaErrorFormatUtil.getMemberDeclarationTextRange(psi)).withDescription((cls, ctx) -> JavaCompilationErrorBundle.message("method.inheritance.clash.does.not.throw", JavaErrorFormatUtil.formatClashMethodMessage(ctx.method(), ctx.superMethod()), JavaErrorFormatUtil.formatType((PsiType)ctx.exceptionType())));
    public static final JavaErrorKind.Parameterized<PsiMethod, @NotNull String> METHOD_MISSING_RETURN_TYPE = JavaErrorKinds.parameterized(PsiMethod.class, String.class, "method.missing.return.type").withAnchor(method -> (PsiElement)Objects.requireNonNullElse(method.getNameIdentifier(), method));
    public static final JavaErrorKind.Simple<PsiMethod> METHOD_MISSING_RETURN_TYPE_NOT_CONSTRUCTOR = JavaErrorKinds.error(PsiMethod.class, "method.missing.return.type.not.constructor").withAnchor(method -> (PsiElement)Objects.requireNonNullElse(method.getNameIdentifier(), method));
    public static final JavaErrorKind.Parameterized<PsiMember, AmbiguousImplicitConstructorCallContext> CONSTRUCTOR_AMBIGUOUS_IMPLICIT_CALL = JavaErrorKinds.parameterized(PsiMember.class, AmbiguousImplicitConstructorCallContext.class, "constructor.ambiguous.implicit.call").withDescription((member, ctx) -> ctx.description()).withRange((member, ctx) -> JavaErrorFormatUtil.getMemberDeclarationTextRange(member));
    public static final JavaErrorKind.Parameterized<PsiMember, PsiClass> CONSTRUCTOR_NO_DEFAULT = JavaErrorKinds.parameterized(PsiMember.class, PsiClass.class, "constructor.no.default").withDescription((member, cls) -> JavaCompilationErrorBundle.message("constructor.no.default", JavaErrorFormatUtil.formatClass(Objects.requireNonNull(cls)))).withRange((member, ctx) -> JavaErrorFormatUtil.getMemberDeclarationTextRange(member));
    public static final JavaErrorKind.Simple<PsiMethod> CONSTRUCTOR_IN_IMPLICIT_CLASS = JavaErrorKinds.error(PsiMethod.class, "constructor.in.implicit.class").withRange(JavaErrorFormatUtil::getMemberDeclarationTextRange);
    public static final JavaErrorKind.Parameterized<PsiElement, Collection<PsiClassType>> EXCEPTION_UNHANDLED = JavaErrorKinds.error(PsiElement.class, "exception.unhandled").withRange(JavaErrorFormatUtil::getRange).withHighlightType(JavaErrorHighlightType.UNHANDLED_EXCEPTION).parameterized().withDescription((psi, unhandled) -> JavaCompilationErrorBundle.message("exception.unhandled", JavaErrorFormatUtil.formatTypes(unhandled), unhandled.size()));
    public static final JavaErrorKind.Parameterized<PsiResourceListElement, Collection<PsiClassType>> EXCEPTION_UNHANDLED_CLOSE = JavaErrorKinds.error(PsiResourceListElement.class, "exception.unhandled").withHighlightType(JavaErrorHighlightType.UNHANDLED_EXCEPTION).parameterized().withDescription((psi, unhandled) -> JavaCompilationErrorBundle.message("exception.unhandled.close", JavaErrorFormatUtil.formatTypes(unhandled), unhandled.size()));
    public static final JavaErrorKind.Parameterized<PsiTypeElement, SuperclassSubclassContext> EXCEPTION_MUST_BE_DISJOINT = JavaErrorKinds.parameterized(PsiTypeElement.class, SuperclassSubclassContext.class, "exception.must.be.disjoint").withDescription((te, ctx) -> JavaCompilationErrorBundle.message("exception.must.be.disjoint", PsiFormatUtil.formatClass((PsiClass)ctx.subClass(), (int)2049), PsiFormatUtil.formatClass((PsiClass)ctx.superClass(), (int)2049)));
    public static final JavaErrorKind.Parameterized<PsiTypeElement, PsiCatchSection> EXCEPTION_ALREADY_CAUGHT = JavaErrorKinds.parameterized(PsiTypeElement.class, PsiCatchSection.class, "exception.already.caught").withDescription((te, upperCatch) -> JavaCompilationErrorBundle.message("exception.already.caught", PsiFormatUtil.formatClass((PsiClass)Objects.requireNonNull(PsiUtil.resolveClassInClassTypeOnly((PsiType)te.getType())), (int)2049)));
    public static final JavaErrorKind.Parameterized<PsiParameter, PsiClassType> EXCEPTION_NEVER_THROWN_TRY = JavaErrorKinds.parameterized(PsiParameter.class, PsiClassType.class, "exception.never.thrown.try").withDescription((parameter, type) -> JavaCompilationErrorBundle.message("exception.never.thrown.try", JavaErrorFormatUtil.formatType((PsiType)type)));
    public static final JavaErrorKind.Parameterized<PsiTypeElement, PsiClassType> EXCEPTION_NEVER_THROWN_TRY_MULTI = JavaErrorKinds.parameterized(PsiTypeElement.class, PsiClassType.class, "exception.never.thrown.try.multi").withDescription((parameter, type) -> JavaCompilationErrorBundle.message("exception.never.thrown.try.multi", JavaErrorFormatUtil.formatType((PsiType)type)));
    public static final JavaErrorKind.Parameterized<PsiElement, JavaIncompatibleTypeErrorContext> TYPE_INCOMPATIBLE = JavaErrorKinds.parameterized(PsiElement.class, JavaIncompatibleTypeErrorContext.class, "type.incompatible").withAbsoluteRange((psi, context) -> {
        TextRange textRange;
        PsiElement patt0$temp = psi.getParent();
        if (patt0$temp instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)patt0$temp;
            textRange = assignment.getTextRange();
        } else {
            textRange = JavaErrorFormatUtil.getRange(psi).shiftRight(psi.getTextRange().getStartOffset());
        }
        return textRange;
    }).withDescription((psi, context) -> context.createDescription()).withTooltip((psi, context) -> context.createTooltip());
    public static final JavaErrorKind.Simple<PsiKeyword> TYPE_VOID_ILLEGAL = JavaErrorKinds.error("type.void.illegal");
    public static final JavaErrorKind.Simple<PsiExpression> TYPE_VOID_NOT_ALLOWED = JavaErrorKinds.error("type.void.not.allowed");
    public static final JavaErrorKind.Parameterized<PsiElement, PsiClass> TYPE_INACCESSIBLE = JavaErrorKinds.parameterized(PsiElement.class, PsiClass.class, "type.inaccessible").withDescription((psi, cls) -> JavaCompilationErrorBundle.message("type.inaccessible", JavaErrorFormatUtil.formatClass(cls)));
    public static final JavaErrorKind.Simple<PsiTypeElement> TYPE_UNKNOWN_CLASS = JavaErrorKinds.error(PsiTypeElement.class, "type.unknown.class").withDescription(type -> JavaCompilationErrorBundle.message("type.unknown.class", type.getType().getDeepComponentType().getCanonicalText()));
    public static final JavaErrorKind.Simple<PsiTypeElement> TYPE_ARGUMENT_PRIMITIVE = JavaErrorKinds.error(PsiTypeElement.class, "type.argument.primitive");
    public static final JavaErrorKind.Simple<PsiReferenceParameterList> TYPE_ARGUMENT_NOT_ALLOWED = JavaErrorKinds.error("type.argument.not.allowed");
    public static final JavaErrorKind.Simple<PsiReferenceParameterList> TYPE_ARGUMENT_ON_RAW_TYPE = JavaErrorKinds.error("type.argument.on.raw.type");
    public static final JavaErrorKind.Simple<PsiReferenceParameterList> TYPE_ARGUMENT_ON_RAW_METHOD = JavaErrorKinds.error("type.argument.on.raw.method");
    public static final JavaErrorKind.Simple<PsiReferenceParameterList> TYPE_ARGUMENT_IN_PERMITS_LIST = JavaErrorKinds.error("type.argument.in.permits.list");
    public static final JavaErrorKind.Simple<PsiTypeElement> TYPE_WILDCARD_NOT_EXPECTED = JavaErrorKinds.error(PsiTypeElement.class, "type.wildcard.not.expected");
    public static final JavaErrorKind.Simple<PsiTypeElement> TYPE_WILDCARD_MAY_BE_USED_ONLY_AS_REFERENCE_PARAMETERS = JavaErrorKinds.error(PsiTypeElement.class, "type.wildcard.may.be.used.only.as.reference.parameters");
    public static final JavaErrorKind.Simple<PsiTypeElement> TYPE_WILDCARD_CANNOT_BE_INSTANTIATED = JavaErrorKinds.error(PsiTypeElement.class, "type.wildcard.cannot.be.instantiated").withDescription(type -> JavaCompilationErrorBundle.message("type.wildcard.cannot.be.instantiated", JavaErrorFormatUtil.formatType(type.getType())));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> TYPE_RESTRICTED_IDENTIFIER = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "type.restricted.identifier").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription(ref -> JavaCompilationErrorBundle.message("type.restricted.identifier", ref.getReferenceName()));
    public static final JavaErrorKind.Simple<PsiExpression> FOREACH_NOT_APPLICABLE = JavaErrorKinds.error(PsiExpression.class, "foreach.not.applicable").withDescription(expression -> JavaCompilationErrorBundle.message("foreach.not.applicable", JavaErrorFormatUtil.formatType(expression.getType())));
    public static final JavaErrorKind.Simple<PsiLocalVariable> LVTI_NO_INITIALIZER = JavaErrorKinds.error(PsiLocalVariable.class, "lvti.no.initializer").withAnchor(var -> var.getTypeElement());
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiLocalVariable> LVTI_SELF_REFERENCED = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiLocalVariable.class, "lvti.self.referenced").withDescription((ref, var) -> JavaCompilationErrorBundle.message("lvti.self.referenced", var.getName()));
    public static final JavaErrorKind.Simple<PsiLocalVariable> LVTI_COMPOUND = JavaErrorKinds.error(PsiLocalVariable.class, "lvti.compound");
    public static final JavaErrorKind.Simple<PsiLocalVariable> LVTI_VOID = JavaErrorKinds.error(PsiLocalVariable.class, "lvti.void").withAnchor(var -> var.getTypeElement());
    public static final JavaErrorKind.Simple<PsiLocalVariable> LVTI_NULL = JavaErrorKinds.error(PsiLocalVariable.class, "lvti.null").withAnchor(var -> var.getTypeElement());
    public static final JavaErrorKind.Simple<PsiLocalVariable> LVTI_LAMBDA = JavaErrorKinds.error(PsiLocalVariable.class, "lvti.lambda").withAnchor(var -> var.getTypeElement());
    public static final JavaErrorKind.Simple<PsiLocalVariable> LVTI_METHOD_REFERENCE = JavaErrorKinds.error(PsiLocalVariable.class, "lvti.method.reference").withAnchor(var -> var.getTypeElement());
    public static final JavaErrorKind.Simple<PsiVariable> LVTI_ARRAY = JavaErrorKinds.error(PsiVariable.class, "lvti.array").withAnchor(var -> var.getTypeElement());
    public static final JavaErrorKind.Simple<PsiLabeledStatement> LABEL_WITHOUT_STATEMENT = JavaErrorKinds.error(PsiLabeledStatement.class, "label.without.statement").withAnchor(label -> label.getLabelIdentifier());
    public static final JavaErrorKind.Simple<PsiLabeledStatement> LABEL_DUPLICATE = JavaErrorKinds.error(PsiLabeledStatement.class, "label.duplicate").withAnchor(label -> label.getLabelIdentifier()).withDescription(statement -> JavaCompilationErrorBundle.message("label.duplicate", statement.getLabelIdentifier().getText()));
    public static final JavaErrorKind.Simple<PsiIdentifier> LABEL_UNRESOLVED = JavaErrorKinds.error(PsiIdentifier.class, "label.unresolved").withDescription(label -> JavaCompilationErrorBundle.message("label.unresolved", label.getText()));
    public static final JavaErrorKind.Parameterized<PsiContinueStatement, PsiIdentifier> LABEL_MUST_BE_LOOP = JavaErrorKinds.parameterized(PsiContinueStatement.class, PsiIdentifier.class, "label.must.be.loop").withDescription((statement, label) -> JavaCompilationErrorBundle.message("label.must.be.loop", label.getText()));
    public static final JavaErrorKind.Simple<PsiBreakStatement> BREAK_OUTSIDE_SWITCH_OR_LOOP = JavaErrorKinds.error("break.outside.switch.or.loop");
    public static final JavaErrorKind.Simple<PsiBreakStatement> BREAK_OUT_OF_SWITCH_EXPRESSION = JavaErrorKinds.error("break.out.of.switch.expression");
    public static final JavaErrorKind.Simple<PsiContinueStatement> CONTINUE_OUTSIDE_LOOP = JavaErrorKinds.error("continue.outside.loop");
    public static final JavaErrorKind.Simple<PsiContinueStatement> CONTINUE_OUT_OF_SWITCH_EXPRESSION = JavaErrorKinds.error("continue.out.of.switch.expression");
    public static final JavaErrorKind.Simple<PsiYieldStatement> YIELD_UNEXPECTED = JavaErrorKinds.error("yield.unexpected");
    public static final JavaErrorKind.Simple<PsiExpression> YIELD_VOID = JavaErrorKinds.error("yield.void");
    public static final JavaErrorKind.Simple<PsiTypeElement> CATCH_TYPE_PARAMETER = JavaErrorKinds.error("catch.type.parameter");
    public static final JavaErrorKind.Parameterized<PsiExpression, PsiType> ARRAY_ILLEGAL_INITIALIZER = JavaErrorKinds.parameterized(PsiExpression.class, PsiType.class, "array.illegal.initializer").withDescription((expr, type) -> JavaCompilationErrorBundle.message("array.illegal.initializer", JavaErrorFormatUtil.formatType(type)));
    public static final JavaErrorKind.Simple<PsiArrayInitializerExpression> ARRAY_INITIALIZER_NOT_ALLOWED = JavaErrorKinds.error("array.initializer.not.allowed");
    public static final JavaErrorKind.Parameterized<PsiExpression, PsiType> ARRAY_TYPE_EXPECTED = JavaErrorKinds.parameterized(PsiExpression.class, PsiType.class, "array.type.expected").withDescription((expr, type) -> JavaCompilationErrorBundle.message("array.type.expected", JavaErrorFormatUtil.formatType(type)));
    public static final JavaErrorKind.Simple<PsiElement> ARRAY_GENERIC = JavaErrorKinds.error("array.generic");
    public static final JavaErrorKind.Simple<PsiReferenceParameterList> ARRAY_EMPTY_DIAMOND = JavaErrorKinds.error("array.empty.diamond");
    public static final JavaErrorKind.Simple<PsiReferenceParameterList> ARRAY_TYPE_ARGUMENTS = JavaErrorKinds.error("array.type.arguments");
    public static final JavaErrorKind.Simple<PsiTypeElement> ARRAY_TOO_MANY_DIMENSIONS = JavaErrorKinds.error("array.too.many.dimensions");
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiClass> PATTERN_TYPE_PATTERN_EXPECTED = JavaErrorKinds.parameterized("pattern.type.pattern.expected");
    public static final JavaErrorKind.Simple<PsiPatternVariable> PATTERN_DECONSTRUCTION_VARIABLE = JavaErrorKinds.error("pattern.deconstruction.variable");
    public static final JavaErrorKind.Simple<PsiAnnotation> PATTERN_DECONSTRUCTION_ANNOTATION = JavaErrorKinds.error("pattern.deconstruction.annotation");
    public static final JavaErrorKind.Parameterized<PsiPattern, PatternTypeContext> PATTERN_UNSAFE_CAST = JavaErrorKinds.parameterized(PsiPattern.class, PatternTypeContext.class, "pattern.unsafe.cast").withDescription((psi, ctx) -> JavaCompilationErrorBundle.message("pattern.unsafe.cast", ctx.contextType().getPresentableText(), ctx.patternType().getPresentableText()));
    public static final JavaErrorKind.Parameterized<PsiDeconstructionPattern, PatternTypeContext> PATTERN_NOT_EXHAUSTIVE = JavaErrorKinds.parameterized(PsiDeconstructionPattern.class, PatternTypeContext.class, "pattern.not.exhaustive").withDescription((psi, ctx) -> JavaCompilationErrorBundle.message("pattern.not.exhaustive", JavaErrorFormatUtil.formatType(ctx.patternType()), JavaErrorFormatUtil.formatType(ctx.contextType())));
    public static final JavaErrorKind.Simple<PsiTypeElement> PATTERN_DECONSTRUCTION_REQUIRES_RECORD = JavaErrorKinds.error(PsiTypeElement.class, "pattern.deconstruction.requires.record").withDescription(type -> JavaCompilationErrorBundle.message("pattern.deconstruction.requires.record", JavaErrorFormatUtil.formatType(type.getType())));
    public static final JavaErrorKind.Parameterized<PsiTypeElement, @Nls String> PATTERN_CANNOT_INFER_TYPE = JavaErrorKinds.parameterized(PsiTypeElement.class, String.class, "pattern.cannot.infer.type").withDescription((te, inferenceError) -> JavaCompilationErrorBundle.message("pattern.cannot.infer.type", inferenceError));
    public static final JavaErrorKind.Parameterized<PsiDeconstructionList, DeconstructionCountMismatchContext> PATTERN_DECONSTRUCTION_COUNT_MISMATCH = JavaErrorKinds.parameterized(PsiDeconstructionList.class, DeconstructionCountMismatchContext.class, "pattern.deconstruction.count.mismatch").withRange((list, ctx) -> {
        if (ctx.recordComponents().length < ctx.patternComponents().length && !ctx.hasMismatch()) {
            PsiPattern[] deconstructionComponents = list.getDeconstructionComponents();
            int endOffset = list.getTextLength();
            int startOffset = deconstructionComponents[ctx.recordComponents().length].getStartOffsetInParent();
            return TextRange.create((int)startOffset, (int)endOffset);
        }
        return null;
    }).withNavigationShift((list, ctx) -> ctx.recordComponents().length < ctx.patternComponents().length && !ctx.hasMismatch() ? 0 : 1).withDescription((list, ctx) -> JavaCompilationErrorBundle.message("pattern.deconstruction.count.mismatch", ctx.recordComponents().length, ctx.patternComponents().length));
    public static final JavaErrorKind.Parameterized<PsiTypeTestPattern, JavaIncompatibleTypeErrorContext> PATTERN_INSTANCEOF_SUPERTYPE = JavaErrorKinds.parameterized(PsiTypeTestPattern.class, JavaIncompatibleTypeErrorContext.class, "pattern.instanceof.supertype").withAnchor(PsiTypeTestPattern::getCheckType).withDescription((expr, context) -> JavaCompilationErrorBundle.message("pattern.instanceof.supertype", context.lType().getPresentableText(), Objects.requireNonNull(context.rType()).getPresentableText()));
    public static final JavaErrorKind.Parameterized<PsiTypeTestPattern, PsiType> PATTERN_INSTANCEOF_EQUALS = JavaErrorKinds.parameterized(PsiTypeTestPattern.class, PsiType.class, "pattern.instanceof.equals").withAnchor(PsiTypeTestPattern::getCheckType).withDescription((expr, context) -> JavaCompilationErrorBundle.message("pattern.instanceof.equals", context.getPresentableText()));
    public static final JavaErrorKind.Simple<PsiPattern> PATTERN_EXPECTED_CLASS_OR_ARRAY_TYPE = JavaErrorKinds.error(PsiPattern.class, "pattern.expected.class.or.array.type");
    public static final JavaErrorKind.Simple<PsiTypeElement> INSTANCEOF_TYPE_PARAMETER = JavaErrorKinds.error("instanceof.type.parameter");
    public static final JavaErrorKind.Simple<PsiTypeElement> INSTANCEOF_ILLEGAL_GENERIC_TYPE = JavaErrorKinds.error("instanceof.illegal.generic.type");
    public static final JavaErrorKind.Parameterized<PsiTypeElement, JavaIncompatibleTypeErrorContext> INSTANCEOF_UNSAFE_CAST = JavaErrorKinds.parameterized(PsiTypeElement.class, JavaIncompatibleTypeErrorContext.class, "instanceof.unsafe.cast").withDescription((expr, context) -> JavaCompilationErrorBundle.message("instanceof.unsafe.cast", context.lType().getPresentableText(), Objects.requireNonNull(context.rType()).getPresentableText()));
    public static final JavaErrorKind.Parameterized<PsiElement, JavaIncompatibleTypeErrorContext> CAST_INCONVERTIBLE = JavaErrorKinds.parameterized(PsiElement.class, JavaIncompatibleTypeErrorContext.class, "cast.inconvertible").withDescription((psi, ctx) -> JavaCompilationErrorBundle.message("cast.inconvertible", JavaErrorFormatUtil.formatType(ctx.lType()), JavaErrorFormatUtil.formatType(ctx.rType())));
    public static final JavaErrorKind.Simple<PsiTypeElement> CAST_INTERSECTION_NOT_INTERFACE = JavaErrorKinds.error("cast.intersection.not.interface");
    public static final JavaErrorKind.Simple<PsiTypeElement> CAST_INTERSECTION_UNEXPECTED_TYPE = JavaErrorKinds.error("cast.intersection.unexpected.type");
    public static final JavaErrorKind.Simple<PsiTypeElement> CAST_INTERSECTION_REPEATED_INTERFACE = JavaErrorKinds.error("cast.intersection.repeated.interface");
    public static final JavaErrorKind.Parameterized<PsiTypeCastExpression, InheritTypeClashContext> CAST_INTERSECTION_INHERITANCE_CLASH = JavaErrorKinds.parameterized(PsiTypeCastExpression.class, InheritTypeClashContext.class, "cast.intersection.inheritance.clash").withDescription((cast, ctx) -> JavaCompilationErrorBundle.message("cast.intersection.inheritance.clash", JavaErrorFormatUtil.formatClass(ctx.superClass()), Objects.requireNonNull(ctx.type1()).getPresentableText(), Objects.requireNonNull(ctx.type2()).getPresentableText()));
    public static final JavaErrorKind.Simple<PsiExpression> RESOURCE_DECLARATION_OR_VARIABLE_EXPECTED = JavaErrorKinds.error("resource.declaration.or.variable.expected");
    public static final JavaErrorKind.Simple<PsiSwitchLabeledRuleStatement> SWITCH_RULE_SHOULD_PRODUCE_RESULT = JavaErrorKinds.error(PsiSwitchLabeledRuleStatement.class, "switch.rule.should.produce.result").withAnchor(rule -> (PsiElement)Objects.requireNonNullElse((PsiElement)ObjectUtils.tryCast((Object)rule.getFirstChild(), PsiKeyword.class), rule));
    public static final JavaErrorKind.Simple<PsiSwitchExpression> SWITCH_EXPRESSION_NO_RESULT = JavaErrorKinds.error(PsiSwitchExpression.class, "switch.expression.no.result").withAnchor(switchExpression -> (PsiElement)Objects.requireNonNullElse((PsiElement)ObjectUtils.tryCast((Object)switchExpression.getFirstChild(), PsiKeyword.class), switchExpression));
    public static final JavaErrorKind.Simple<PsiSwitchExpression> SWITCH_EXPRESSION_SHOULD_PRODUCE_RESULT = JavaErrorKinds.error(PsiSwitchExpression.class, "switch.expression.should.produce.result").withAnchor(switchExpression -> (PsiElement)Objects.requireNonNullElse((PsiElement)ObjectUtils.tryCast((Object)switchExpression.getFirstChild(), PsiKeyword.class), switchExpression));
    public static final JavaErrorKind.Simple<PsiSwitchExpression> SWITCH_EXPRESSION_CANNOT_BE_VOID = JavaErrorKinds.error(PsiSwitchExpression.class, "switch.expression.cannot.be.void").withAnchor(switchExpression -> (PsiElement)Objects.requireNonNullElse((PsiElement)ObjectUtils.tryCast((Object)switchExpression.getFirstChild(), PsiKeyword.class), switchExpression));
    public static final JavaErrorKind.Parameterized<PsiExpression, JavaIncompatibleTypeErrorContext> SWITCH_EXPRESSION_INCOMPATIBLE_TYPE = JavaErrorKinds.parameterized(PsiExpression.class, JavaIncompatibleTypeErrorContext.class, "switch.expression.incompatible.type").withDescription((expr, context) -> JavaCompilationErrorBundle.message("switch.expression.incompatible.type", JavaErrorFormatUtil.formatType(context.rType()), JavaErrorFormatUtil.formatType(context.lType())));
    public static final JavaErrorKind.Simple<PsiElement> SWITCH_LABEL_EXPECTED = JavaErrorKinds.error(PsiElement.class, "switch.label.expected");
    public static final JavaErrorKind.Simple<PsiStatement> SWITCH_DIFFERENT_CASE_KINDS = JavaErrorKinds.error(PsiStatement.class, "switch.different.case.kinds").withRange(statement -> {
        PsiSwitchLabeledRuleStatement rule;
        PsiCaseLabelElementList list;
        if (statement instanceof PsiSwitchLabeledRuleStatement && (list = (rule = (PsiSwitchLabeledRuleStatement)statement).getCaseLabelElementList()) != null) {
            return TextRange.create((int)0, (int)list.getTextRangeInParent().getEndOffset());
        }
        return null;
    });
    public static final JavaErrorKind.Parameterized<PsiExpression, JavaPsiSwitchUtil.SelectorKind> SWITCH_SELECTOR_TYPE_INVALID = JavaErrorKinds.parameterized(PsiExpression.class, JavaPsiSwitchUtil.SelectorKind.class, "switch.selector.type.invalid").withDescription((expr, kind) -> kind.getFeature() == null ? JavaCompilationErrorBundle.message("switch.selector.type.invalid", JavaErrorFormatUtil.formatType(expr.getType())) : JavaCompilationErrorBundle.message("switch.selector.type.invalid.level", JavaErrorFormatUtil.formatType(expr.getType()), PsiUtil.getLanguageLevel((PsiElement)expr).getShortText()));
    public static final JavaErrorKind.Parameterized<PsiCaseLabelElement, PsiType> SWITCH_NULL_TYPE_INCOMPATIBLE = JavaErrorKinds.parameterized(PsiCaseLabelElement.class, PsiType.class, "switch.null.type.incompatible").withDescription((label, selectorType) -> JavaCompilationErrorBundle.message("switch.null.type.incompatible", JavaErrorFormatUtil.formatType(selectorType)));
    public static final JavaErrorKind.Simple<PsiReferenceExpression> SWITCH_LABEL_QUALIFIED_ENUM = JavaErrorKinds.error(PsiReferenceExpression.class, "switch.label.qualified.enum");
    public static final JavaErrorKind.Simple<PsiExpression> SWITCH_LABEL_CONSTANT_EXPECTED = JavaErrorKinds.error(PsiExpression.class, "switch.label.constant.expected");
    public static final JavaErrorKind.Simple<PsiCaseLabelElement> SWITCH_LABEL_UNEXPECTED = JavaErrorKinds.error("switch.label.unexpected");
    public static final JavaErrorKind.Parameterized<PsiDefaultCaseLabelElement, PsiCaseLabelElementList> SWITCH_DEFAULT_LABEL_CONTAINS_CASE = JavaErrorKinds.parameterized("switch.default.label.contains.case");
    public static final JavaErrorKind.Parameterized<PsiExpression, PsiType> SWITCH_LABEL_PATTERN_EXPECTED = JavaErrorKinds.parameterized(PsiExpression.class, PsiType.class, "switch.label.pattern.expected").withDescription((expr, type) -> JavaCompilationErrorBundle.message("switch.label.pattern.expected", JavaErrorFormatUtil.formatType(type)));
    public static final JavaErrorKind.Parameterized<PsiElement, Object> SWITCH_LABEL_DUPLICATE = JavaErrorKinds.parameterized(PsiElement.class, Object.class, "switch.label.duplicate").withDescription((label, value) -> {
        if (value instanceof JavaPsiSwitchUtil.SwitchSpecialValue) {
            JavaPsiSwitchUtil.SwitchSpecialValue specialValue = (JavaPsiSwitchUtil.SwitchSpecialValue)value;
            return switch (specialValue) {
                default -> throw new MatchException(null, null);
                case JavaPsiSwitchUtil.SwitchSpecialValue.UNCONDITIONAL_PATTERN -> JavaCompilationErrorBundle.message("switch.label.duplicate.unconditional.pattern", new Object[0]);
                case JavaPsiSwitchUtil.SwitchSpecialValue.DEFAULT_VALUE -> JavaCompilationErrorBundle.message("switch.label.duplicate.default", new Object[0]);
                case JavaPsiSwitchUtil.SwitchSpecialValue.NULL_VALUE -> JavaCompilationErrorBundle.message("switch.label.duplicate", "null");
            };
        }
        if (value instanceof PsiEnumConstant) {
            PsiEnumConstant constant = (PsiEnumConstant)value;
            return JavaCompilationErrorBundle.message("switch.label.duplicate", constant.getName());
        }
        if (label instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)label;
            return JavaCompilationErrorBundle.message("switch.label.duplicate", literalExpression.getValue());
        }
        return JavaCompilationErrorBundle.message("switch.label.duplicate", value);
    });
    public static final JavaErrorKind.Simple<PsiCaseLabelElement> SWITCH_FALLTHROUGH_TO_PATTERN = JavaErrorKinds.error("switch.fallthrough.to.pattern");
    public static final JavaErrorKind.Simple<PsiCaseLabelElement> SWITCH_MULTIPLE_LABELS_WITH_PATTERN_VARIABLES = JavaErrorKinds.error("switch.multiple.labels.with.pattern.variables");
    public static final JavaErrorKind.Parameterized<PsiDefaultCaseLabelElement, PsiCaseLabelElementList> SWITCH_DEFAULT_NULL_ORDER = JavaErrorKinds.parameterized("switch.default.null.order");
    public static final JavaErrorKind.Simple<PsiDefaultCaseLabelElement> SWITCH_DEFAULT_LABEL_NOT_ALLOWED = JavaErrorKinds.error("switch.default.label.not.allowed");
    public static final JavaErrorKind.Simple<PsiExpression> SWITCH_NULL_LABEL_NOT_ALLOWED = JavaErrorKinds.error("switch.null.label.not.allowed");
    public static final JavaErrorKind.Simple<PsiCaseLabelElement> SWITCH_LABEL_COMBINATION_CONSTANTS_AND_PATTERNS = JavaErrorKinds.error("switch.label.combination.constants.and.patterns");
    public static final JavaErrorKind.Simple<PsiCaseLabelElement> SWITCH_LABEL_COMBINATION_CONSTANTS_AND_PATTERNS_UNNAMED = JavaErrorKinds.error("switch.label.combination.constants.and.patterns.unnamed");
    public static final JavaErrorKind.Simple<PsiCaseLabelElement> SWITCH_LABEL_MULTIPLE_PATTERNS = JavaErrorKinds.error("switch.label.multiple.patterns");
    public static final JavaErrorKind.Simple<PsiCaseLabelElement> SWITCH_LABEL_MULTIPLE_PATTERNS_UNNAMED = JavaErrorKinds.error("switch.label.multiple.patterns.unnamed");
    public static final JavaErrorKind.Parameterized<PsiCaseLabelElement, PsiElement> SWITCH_DOMINANCE_VIOLATION = JavaErrorKinds.parameterized(PsiCaseLabelElement.class, PsiElement.class, "switch.dominance.violation").withDescription((overWhom, who) -> JavaCompilationErrorBundle.message("switch.dominance.violation", who.getText()));
    public static final JavaErrorKind.Simple<PsiElement> SWITCH_UNCONDITIONAL_PATTERN_AND_DEFAULT = JavaErrorKinds.error("switch.unconditional.pattern.and.default");
    public static final JavaErrorKind.Simple<PsiElement> SWITCH_DEFAULT_AND_BOOLEAN = JavaErrorKinds.error("switch.default.and.boolean");
    public static final JavaErrorKind.Simple<PsiCaseLabelElement> SWITCH_UNCONDITIONAL_PATTERN_AND_BOOLEAN = JavaErrorKinds.error("switch.unconditional.pattern.and.boolean");
    public static final JavaErrorKind.Simple<PsiSwitchBlock> SWITCH_EMPTY = JavaErrorKinds.error(PsiSwitchBlock.class, "switch.empty").withAnchor(block -> Objects.requireNonNullElse(block.getExpression(), block.getFirstChild())).withDescription(block -> JavaCompilationErrorBundle.message("switch.empty", JavaElementKind.fromElement((PsiElement)block).subject()));
    public static final JavaErrorKind.Simple<PsiSwitchBlock> SWITCH_INCOMPLETE = JavaErrorKinds.error(PsiSwitchBlock.class, "switch.incomplete").withAnchor(block -> Objects.requireNonNullElse(block.getExpression(), block.getFirstChild())).withDescription(psi -> JavaCompilationErrorBundle.message("switch.incomplete", JavaElementKind.fromElement((PsiElement)psi).subject()));
    public static final JavaErrorKind.Simple<PsiReferenceExpression> EXPRESSION_EXPECTED = JavaErrorKinds.error("expression.expected");
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiSuperExpression> EXPRESSION_SUPER_UNQUALIFIED_DEFAULT_METHOD = JavaErrorKinds.parameterized("expression.super.unqualified.default.method");
    public static final JavaErrorKind.Simple<PsiSuperExpression> EXPRESSION_SUPER_DOT_EXPECTED = JavaErrorKinds.error(PsiSuperExpression.class, "expression.super.dot.expected").withRange(expr -> TextRange.from((int)expr.getTextLength(), (int)1));
    public static final JavaErrorKind.Parameterized<PsiSuperExpression, PsiClass> EXPRESSION_SUPER_NOT_ENCLOSING_CLASS = JavaErrorKinds.parameterized(PsiSuperExpression.class, PsiClass.class, "expression.super.not.enclosing.class").withDescription((expr, cls) -> JavaCompilationErrorBundle.message("expression.super.not.enclosing.class", JavaErrorFormatUtil.formatClass(cls)));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, SuperclassSubclassContext> EXPRESSION_SUPER_BAD_QUALIFIER_REDUNDANT_EXTENDED = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, SuperclassSubclassContext.class, "expression.super.bad.qualifier.redundant.extended").withDescription((expr, ctx) -> JavaCompilationErrorBundle.message("expression.super.bad.qualifier.redundant.extended", JavaErrorFormatUtil.formatClass(ctx.subClass()), JavaErrorFormatUtil.formatClass(ctx.superClass())));
    public static final JavaErrorKind.Parameterized<PsiSuperExpression, PsiClass> EXPRESSION_SUPER_BAD_QUALIFIER_METHOD_OVERRIDDEN = JavaErrorKinds.parameterized(PsiSuperExpression.class, PsiClass.class, "expression.super.bad.qualifier.method.overridden").withAnchor(PsiSuperExpression::getQualifier).withDescription((expr, superClass) -> JavaCompilationErrorBundle.message("expression.super.bad.qualifier.method.overridden", ((PsiReferenceExpression)expr.getParent()).getReferenceName(), JavaErrorFormatUtil.formatClass(superClass)));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> EXPRESSION_SUPER_NO_ENCLOSING_INSTANCE = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "expression.super.no.enclosing.instance").withDescription((expr, cls) -> JavaCompilationErrorBundle.message("expression.super.no.enclosing.instance", JavaErrorFormatUtil.formatClass(cls)));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> EXPRESSION_QUALIFIED_CLASS_EXPECTED = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "expression.qualified.class.expected");
    public static final JavaErrorKind.Simple<PsiTypeElement> EXPRESSION_CLASS_TYPE_PARAMETER = JavaErrorKinds.error("expression.class.type.parameter");
    public static final JavaErrorKind.Simple<PsiTypeElement> EXPRESSION_CLASS_PARAMETERIZED_TYPE = JavaErrorKinds.error("expression.class.parameterized.type");
    public static final JavaErrorKind.Parameterized<PsiExpression, PsiVariable> ASSIGNMENT_DECLARED_OUTSIDE_GUARD = JavaErrorKinds.parameterized(PsiExpression.class, PsiVariable.class, "assignment.declared.outside.guard").withDescription((expr, variable) -> JavaCompilationErrorBundle.message("assignment.declared.outside.guard", variable.getName()));
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> ASSIGNMENT_TO_FINAL_VARIABLE = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiVariable.class, "assignment.to.final.variable").withDescription((expr, variable) -> JavaCompilationErrorBundle.message("assignment.to.final.variable", variable.getName()));
    public static final JavaErrorKind.Simple<PsiExpression> LVALUE_VARIABLE_EXPECTED = JavaErrorKinds.error("lvalue.variable.expected");
    public static final JavaErrorKind.Parameterized<PsiJavaToken, JavaIncompatibleTypeErrorContext> BINARY_OPERATOR_NOT_APPLICABLE = JavaErrorKinds.parameterized(PsiJavaToken.class, JavaIncompatibleTypeErrorContext.class, "binary.operator.not.applicable").withAnchor(token -> TypeConversionUtil.convertEQtoOperation((IElementType)token.getTokenType()) == null ? token.getParent() : token).withDescription((token, context) -> {
        String text = token.getText();
        if (TypeConversionUtil.convertEQtoOperation((IElementType)token.getTokenType()) != null) {
            text = text.replace("=", "");
        }
        return JavaCompilationErrorBundle.message("binary.operator.not.applicable", text, JavaErrorFormatUtil.formatType(context.lType()), JavaErrorFormatUtil.formatType(context.rType()));
    });
    public static final JavaErrorKind.Parameterized<PsiUnaryExpression, PsiType> UNARY_OPERATOR_NOT_APPLICABLE = JavaErrorKinds.parameterized(PsiUnaryExpression.class, PsiType.class, "unary.operator.not.applicable").withDescription((unary, type) -> JavaCompilationErrorBundle.message("unary.operator.not.applicable", unary.getOperationSign().getText(), JavaErrorFormatUtil.formatType(type)));
    public static final JavaErrorKind.Simple<PsiReferenceParameterList> NEW_EXPRESSION_DIAMOND_NOT_APPLICABLE = JavaErrorKinds.error("new.expression.diamond.not.applicable");
    public static final JavaErrorKind.Simple<PsiNewExpression> NEW_EXPRESSION_QUALIFIED_MALFORMED = JavaErrorKinds.error("new.expression.qualified.malformed");
    public static final JavaErrorKind.Parameterized<PsiNewExpression, PsiClass> NEW_EXPRESSION_QUALIFIED_STATIC_CLASS = JavaErrorKinds.parameterized("new.expression.qualified.static.class");
    public static final JavaErrorKind.Parameterized<PsiNewExpression, PsiClass> NEW_EXPRESSION_QUALIFIED_ANONYMOUS_IMPLEMENTS_INTERFACE = JavaErrorKinds.parameterized("new.expression.qualified.anonymous.implements.interface");
    public static final JavaErrorKind.Simple<PsiElement> NEW_EXPRESSION_QUALIFIED_QUALIFIED_CLASS_REFERENCE = JavaErrorKinds.error("new.expression.qualified.qualified.class.reference");
    public static final JavaErrorKind.Simple<PsiReferenceParameterList> NEW_EXPRESSION_DIAMOND_NOT_ALLOWED = JavaErrorKinds.error("new.expression.diamond.not.allowed");
    public static final JavaErrorKind.Simple<PsiReferenceParameterList> NEW_EXPRESSION_DIAMOND_ANONYMOUS_INNER_NON_PRIVATE = JavaErrorKinds.error("new.expression.diamond.anonymous.inner.non.private");
    public static final JavaErrorKind.Simple<PsiReferenceParameterList> NEW_EXPRESSION_ANONYMOUS_IMPLEMENTS_INTERFACE_WITH_TYPE_ARGUMENTS = JavaErrorKinds.error("new.expression.anonymous.implements.interface.with.type.arguments");
    public static final JavaErrorKind.Parameterized<PsiReferenceParameterList, PsiDiamondType.DiamondInferenceResult> NEW_EXPRESSION_DIAMOND_INFERENCE_FAILURE = JavaErrorKinds.parameterized(PsiReferenceParameterList.class, PsiDiamondType.DiamondInferenceResult.class, "new.expression.diamond.inference.failure").withDescription((list, inferenceResult) -> JavaCompilationErrorBundle.message("new.expression.diamond.inference.failure", inferenceResult.getErrorMessage()));
    public static final JavaErrorKind.Parameterized<PsiConstructorCall, UnresolvedConstructorContext> NEW_EXPRESSION_UNRESOLVED_CONSTRUCTOR = JavaErrorKinds.parameterized(PsiConstructorCall.class, UnresolvedConstructorContext.class, "new.expression.unresolved.constructor").withAnchor(PsiCall::getArgumentList).withNavigationShift(1).withDescription((call, ctx) -> JavaCompilationErrorBundle.message("new.expression.unresolved.constructor", ctx.psiClass().getName() + JavaErrorFormatUtil.formatArgumentTypes(call.getArgumentList(), true)));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiTypeParameter> NEW_EXPRESSION_TYPE_PARAMETER = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiTypeParameter.class, "new.expression.type.parameter").withDescription((ref, typeParameter) -> JavaCompilationErrorBundle.message("new.expression.type.parameter", JavaErrorFormatUtil.formatClass((PsiClass)typeParameter)));
    public static final JavaErrorKind.Parameterized<PsiElement, String> REFERENCE_MEMBER_BEFORE_CONSTRUCTOR = JavaErrorKinds.parameterized(PsiElement.class, String.class, "reference.member.before.constructor").withRange((psi, refName) -> JavaErrorFormatUtil.getRange(psi)).withDescription((psi, refName) -> JavaCompilationErrorBundle.message("reference.member.before.constructor", refName));
    public static final JavaErrorKind.Parameterized<PsiReferenceParameterList, PsiClass> REFERENCE_TYPE_ARGUMENT_STATIC_CLASS = JavaErrorKinds.parameterized(PsiReferenceParameterList.class, PsiClass.class, "reference.type.argument.static.class").withDescription((list, cls) -> JavaCompilationErrorBundle.message("reference.type.argument.static.class", JavaErrorFormatUtil.formatClass(cls)));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> REFERENCE_TYPE_NEEDS_TYPE_ARGUMENTS = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "reference.type.needs.type.arguments").withDescription(ref -> JavaCompilationErrorBundle.message("reference.type.needs.type.arguments", Objects.requireNonNull(ref.getReferenceNameElement()).getText()));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> REFERENCE_LOCAL_CLASS_OTHER_SWITCH_BRANCH = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "reference.local.class.other.switch.branch").withHighlightType(JavaErrorHighlightType.WRONG_REF).withDescription((ref, cls) -> JavaCompilationErrorBundle.message("reference.local.class.other.switch.branch", JavaErrorFormatUtil.formatClass(cls)));
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiField> REFERENCE_FIELD_FORWARD = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiField.class, "reference.field.forward").withDescription((ref, field) -> JavaCompilationErrorBundle.message("reference.field.forward", field.getName()));
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiField> REFERENCE_FIELD_SELF = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiField.class, "reference.field.self").withDescription((ref, field) -> JavaCompilationErrorBundle.message("reference.field.self", field.getName()));
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiField> REFERENCE_ENUM_FORWARD = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiField.class, "reference.enum.forward").withDescription((ref, field) -> JavaCompilationErrorBundle.message("reference.enum.forward", field.getName()));
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiField> REFERENCE_ENUM_SELF = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiField.class, "reference.enum.self").withDescription((ref, field) -> JavaCompilationErrorBundle.message("reference.enum.self", field.getName()));
    public static final JavaErrorKind.Simple<PsiExpression> REFERENCE_QUALIFIER_NOT_EXPRESSION = JavaErrorKinds.error(PsiExpression.class, "reference.qualifier.not.expression").withHighlightType(JavaErrorHighlightType.WRONG_REF);
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiPrimitiveType> REFERENCE_QUALIFIER_PRIMITIVE = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiPrimitiveType.class, "reference.qualifier.primitive").withHighlightType(JavaErrorHighlightType.WRONG_REF).withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription((ref, type) -> JavaCompilationErrorBundle.message("reference.qualifier.primitive", type.getPresentableText()));
    public static final JavaErrorKind.Simple<PsiElement> REFERENCE_PENDING = JavaErrorKinds.error(PsiElement.class, "incomplete.project.state.pending.reference").withHighlightType(JavaErrorHighlightType.PENDING_REF);
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> REFERENCE_UNRESOLVED = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "reference.unresolved").withHighlightType(JavaErrorHighlightType.WRONG_REF).withDescription(ref -> JavaCompilationErrorBundle.message("reference.unresolved", ref.getReferenceName())).withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> REFERENCE_IMPLICIT_CLASS = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "reference.implicit.class").withHighlightType(JavaErrorHighlightType.WRONG_REF).withDescription(ref -> JavaCompilationErrorBundle.message("reference.implicit.class", ref.getReferenceName())).withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> REFERENCE_CLASS_IN_DEFAULT_PACKAGE = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "reference.class.in.default.package").withHighlightType(JavaErrorHighlightType.WRONG_REF).withDescription((ref, cls) -> JavaCompilationErrorBundle.message("reference.class.in.default.package", cls.getName())).withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, List<JavaResolveResult>> REFERENCE_AMBIGUOUS = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "reference.ambiguous").withHighlightType(JavaErrorHighlightType.WRONG_REF).withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).parameterized().withDescription((ref, results) -> {
        String element2;
        String element1 = JavaErrorFormatUtil.format(Objects.requireNonNull(((JavaResolveResult)results.get(0)).getElement()));
        boolean comparison = element1.compareTo(element2 = JavaErrorFormatUtil.format(Objects.requireNonNull(((JavaResolveResult)results.get(1)).getElement()))) < 0;
        return JavaCompilationErrorBundle.message("reference.ambiguous", ref.getReferenceName(), comparison ? element1 : element2, comparison ? element2 : element1);
    });
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiElement> REFERENCE_NON_STATIC_FROM_STATIC_CONTEXT = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiElement.class, "reference.non.static.from.static.context").withHighlightType(JavaErrorHighlightType.WRONG_REF).withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription((ref, refElement) -> {
        String type = JavaElementKind.fromElement((PsiElement)refElement).lessDescriptive().subject();
        String name = HighlightMessageUtil.getSymbolName((PsiElement)refElement, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return JavaCompilationErrorBundle.message("reference.non.static.from.static.context", type, name);
    });
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiTypeParameter> REFERENCE_OUTER_TYPE_PARAMETER_FROM_STATIC_CONTEXT = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiTypeParameter.class, "reference.outer.type.parameter.from.static.context").withHighlightType(JavaErrorHighlightType.WRONG_REF).withDescription((ref, refElement) -> JavaCompilationErrorBundle.message("reference.outer.type.parameter.from.static.context", refElement.getName()));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> REFERENCE_SELECT_FROM_TYPE_PARAMETER = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "reference.select.from.type.parameter");
    public static final JavaErrorKind.Parameterized<PsiElement, String> REFERENCE_PACKAGE_NOT_FOUND = JavaErrorKinds.parameterized(PsiElement.class, String.class, "reference.package.not.found").withDescription((psi, packageName) -> JavaCompilationErrorBundle.message("reference.package.not.found", packageName));
    public static final JavaErrorKind.Simple<PsiSwitchLabelStatementBase> STATEMENT_CASE_OUTSIDE_SWITCH = JavaErrorKinds.error("statement.case.outside.switch");
    public static final JavaErrorKind.Simple<PsiStatement> STATEMENT_INVALID = JavaErrorKinds.error("statement.invalid");
    public static final JavaErrorKind.Simple<PsiExpression> STATEMENT_UNREACHABLE_LOOP_BODY = JavaErrorKinds.error("statement.unreachable.loop.body");
    public static final JavaErrorKind.Simple<PsiElement> STATEMENT_UNREACHABLE = JavaErrorKinds.error(PsiElement.class, "statement.unreachable").withAnchor(statement -> {
        PsiElement keyword = null;
        if (statement instanceof PsiIfStatement || statement instanceof PsiSwitchBlock || statement instanceof PsiLoopStatement || statement instanceof PsiThrowStatement || statement instanceof PsiReturnStatement || statement instanceof PsiYieldStatement || statement instanceof PsiTryStatement || statement instanceof PsiSynchronizedStatement || statement instanceof PsiAssertStatement || statement instanceof PsiLabeledStatement) {
            keyword = statement.getFirstChild();
        }
        return keyword != null ? keyword : statement;
    });
    public static final JavaErrorKind.Simple<PsiStatement> STATEMENT_BAD_EXPRESSION = JavaErrorKinds.error("statement.bad.expression");
    public static final JavaErrorKind.Simple<PsiStatement> STATEMENT_DECLARATION_NOT_ALLOWED = JavaErrorKinds.error("statement.declaration.not.allowed");
    public static final JavaErrorKind.Simple<PsiExpression> GUARD_MISPLACED = JavaErrorKinds.error("guard.misplaced");
    public static final JavaErrorKind.Simple<PsiExpression> GUARD_EVALUATED_TO_FALSE = JavaErrorKinds.error("guard.evaluated.to.false");
    public static final JavaErrorKind.Simple<PsiComment> COMMENT_SHEBANG_JAVA_FILE = JavaErrorKinds.error(PsiComment.class, "comment.shebang.java.file").withRange(psi -> TextRange.create((int)0, (int)2));
    public static final JavaErrorKind.Simple<PsiComment> COMMENT_UNCLOSED = JavaErrorKinds.error(PsiComment.class, "comment.unclosed").withRange(psi -> TextRange.from((int)(psi.getTextLength() - 1), (int)1));
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_ILLEGAL_UNDERSCORE = JavaErrorKinds.error("literal.illegal.underscore");
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_HEXADECIMAL_NO_DIGITS = JavaErrorKinds.error("literal.hexadecimal.no.digits");
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_BINARY_NO_DIGITS = JavaErrorKinds.error("literal.binary.no.digits");
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_INTEGER_TOO_LARGE = JavaErrorKinds.error("literal.integer.too.large");
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_LONG_TOO_LARGE = JavaErrorKinds.error("literal.long.too.large");
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_FLOATING_MALFORMED = JavaErrorKinds.error("literal.floating.malformed");
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_FLOATING_TOO_LARGE = JavaErrorKinds.error("literal.floating.too.large");
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_FLOATING_TOO_SMALL = JavaErrorKinds.error("literal.floating.too.small");
    public static final JavaErrorKind.Parameterized<PsiLiteralExpression, @NotNull TextRange> LITERAL_CHARACTER_ILLEGAL_ESCAPE = JavaErrorKinds.parameterized(PsiLiteralExpression.class, TextRange.class, "literal.character.illegal.escape").withRange((psi, range) -> range);
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_CHARACTER_TOO_LONG = JavaErrorKinds.error("literal.character.too.long");
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_CHARACTER_EMPTY = JavaErrorKinds.error("literal.character.empty");
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_CHARACTER_UNCLOSED = JavaErrorKinds.error("literal.character.unclosed");
    public static final JavaErrorKind.Parameterized<PsiLiteralValue, @NotNull TextRange> LITERAL_STRING_ILLEGAL_ESCAPE = JavaErrorKinds.parameterized(PsiLiteralValue.class, TextRange.class, "literal.string.illegal.escape").withRange((psi, range) -> range);
    public static final JavaErrorKind.Simple<PsiLiteralValue> LITERAL_STRING_ILLEGAL_LINE_END = JavaErrorKinds.error("literal.string.illegal.line.end");
    public static final JavaErrorKind.Simple<PsiLiteralExpression> LITERAL_TEXT_BLOCK_UNCLOSED = JavaErrorKinds.error(PsiLiteralExpression.class, "literal.text.block.unclosed").withRange(e -> TextRange.from((int)e.getTextLength(), (int)0));
    public static final JavaErrorKind.Simple<PsiLiteralValue> LITERAL_TEXT_BLOCK_NO_NEW_LINE = JavaErrorKinds.error(PsiLiteralValue.class, "literal.text.block.no.new.line").withRange(e -> TextRange.create((int)0, (int)3));
    public static final JavaErrorKind.Parameterized<PsiKeyword, String> MODIFIER_NOT_ALLOWED = JavaErrorKinds.parameterized(PsiKeyword.class, String.class, "modifier.not.allowed").withDescription((keyword, text) -> JavaCompilationErrorBundle.message("modifier.not.allowed", text));
    public static final JavaErrorKind.Parameterized<PsiKeyword, String> MODIFIER_REPEATED = JavaErrorKinds.parameterized(PsiKeyword.class, String.class, "modifier.repeated").withDescription((keyword, text) -> JavaCompilationErrorBundle.message("modifier.repeated", text));
    public static final JavaErrorKind.Parameterized<PsiKeyword, String> MODIFIER_INCOMPATIBLE = JavaErrorKinds.parameterized(PsiKeyword.class, String.class, "modifier.incompatible").withDescription((keyword, text) -> JavaCompilationErrorBundle.message("modifier.incompatible", keyword.getText(), text));
    public static final JavaErrorKind.Parameterized<PsiKeyword, String> MODIFIER_NOT_ALLOWED_LOCAL_CLASS = JavaErrorKinds.parameterized(PsiKeyword.class, String.class, "modifier.not.allowed.local.class").withDescription((keyword, text) -> JavaCompilationErrorBundle.message("modifier.not.allowed.local.class", text));
    public static final JavaErrorKind.Parameterized<PsiKeyword, String> MODIFIER_NOT_ALLOWED_NON_SEALED = JavaErrorKinds.parameterized(PsiKeyword.class, String.class, "modifier.not.allowed.non.sealed");
    public static final JavaErrorKind.Simple<PsiMethodCallExpression> CALL_SUPER_ENUM_CONSTRUCTOR = JavaErrorKinds.error("call.super.enum.constructor");
    public static final JavaErrorKind.Parameterized<PsiExpression, PsiClass> CALL_SUPER_QUALIFIER_NOT_INNER_CLASS = JavaErrorKinds.parameterized(PsiExpression.class, PsiClass.class, "call.super.qualifier.not.inner.class").withDescription((psi, cls) -> JavaCompilationErrorBundle.message("call.super.qualifier.not.inner.class", JavaErrorFormatUtil.formatClass(cls)));
    public static final JavaErrorKind.Simple<PsiMethodCallExpression> CALL_EXPECTED = JavaErrorKinds.error("call.expected");
    public static final JavaErrorKind.Simple<PsiDeconstructionPattern> CALL_PARSED_AS_DECONSTRUCTION_PATTERN = JavaErrorKinds.error("call.parsed.as.deconstruction.pattern");
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> CALL_STATIC_INTERFACE_METHOD_QUALIFIER = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "call.static.interface.method.qualifier").withRange(JavaErrorFormatUtil::getRange);
    public static final JavaErrorKind.Parameterized<PsiCall, PsiClass> CALL_FORMAL_VARARGS_ELEMENT_TYPE_INACCESSIBLE_HERE = JavaErrorKinds.parameterized(PsiCall.class, PsiClass.class, "call.formal.varargs.element.type.inaccessible.here").withAnchor(call -> (PsiElement)Objects.requireNonNullElse(call.getArgumentList(), call)).withDescription((call, cls) -> JavaCompilationErrorBundle.message("call.formal.varargs.element.type.inaccessible.here", JavaErrorFormatUtil.formatClass(cls)));
    public static final JavaErrorKind.Parameterized<PsiCall, String> CALL_TYPE_INFERENCE_ERROR = JavaErrorKinds.parameterized(PsiCall.class, String.class, "call.type.inference.error").withRange((psi, context) -> JavaErrorFormatUtil.getRange((PsiElement)psi)).withDescription((psi, context) -> JavaCompilationErrorBundle.message("call.type.inference.error", context));
    public static final JavaErrorKind.Parameterized<PsiElement, JavaMismatchedCallContext> CALL_WRONG_ARGUMENTS = JavaErrorKinds.parameterized(PsiElement.class, JavaMismatchedCallContext.class, "call.wrong.arguments").withTooltip((psi, ctx) -> ctx.createTooltip()).withNavigationShift((psi, ctx) -> psi instanceof PsiExpressionList ? 1 : 0).withDescription((psi, ctx) -> ctx.createDescription());
    public static final JavaErrorKind.Parameterized<PsiMethodCallExpression, JavaResolveResult[]> CALL_UNRESOLVED = JavaErrorKinds.parameterized(PsiMethodCallExpression.class, JavaResolveResult[].class, "call.unresolved").withAnchor(PsiMethodCallExpression::getArgumentList).withNavigationShift(1).withDescription((call, results) -> JavaCompilationErrorBundle.message("call.unresolved", call.getMethodExpression().getReferenceName() + JavaErrorFormatUtil.formatArgumentTypes(call.getArgumentList(), true)));
    public static final JavaErrorKind.Parameterized<PsiMethodCallExpression, JavaResolveResult[]> CALL_UNRESOLVED_NAME = JavaErrorKinds.parameterized(PsiMethodCallExpression.class, JavaResolveResult[].class, "call.unresolved.name").withRange((call, cls) -> JavaErrorFormatUtil.getRange((PsiElement)call)).withHighlightType(JavaErrorHighlightType.WRONG_REF).withDescription((call, results) -> JavaCompilationErrorBundle.message("call.unresolved.name", call.getMethodExpression().getReferenceName() + JavaErrorFormatUtil.formatArgumentTypes(call.getArgumentList(), true)));
    public static final JavaErrorKind.Parameterized<PsiMethodCallExpression, JavaAmbiguousCallContext> CALL_AMBIGUOUS = JavaErrorKinds.parameterized(PsiMethodCallExpression.class, JavaAmbiguousCallContext.class, "call.ambiguous").withAnchor(PsiMethodCallExpression::getArgumentList).withNavigationShift((psi, ctx) -> 1).withDescription((call, ctx) -> ctx.description()).withTooltip((call, ctx) -> ctx.tooltip());
    public static final JavaErrorKind.Parameterized<PsiMethodCallExpression, JavaResolveResult[]> CALL_AMBIGUOUS_NO_MATCH = JavaErrorKinds.parameterized(PsiMethodCallExpression.class, JavaResolveResult[].class, "call.ambiguous.no.match").withRange((call, cls) -> JavaErrorFormatUtil.getRange((PsiElement)call)).withHighlightType(JavaErrorHighlightType.WRONG_REF).withDescription((call, cls) -> JavaCompilationErrorBundle.message("call.ambiguous.no.match", call.getMethodExpression().getReferenceName(), Objects.requireNonNull(RefactoringChangeUtil.getQualifierClass((PsiReferenceExpression)call.getMethodExpression())).getName()));
    public static final JavaErrorKind.Parameterized<PsiMethodCallExpression, PsiPrimitiveType> CALL_QUALIFIER_PRIMITIVE = JavaErrorKinds.parameterized(PsiMethodCallExpression.class, PsiPrimitiveType.class, "call.qualifier.primitive").withRange((call, type) -> JavaErrorFormatUtil.getRange((PsiElement)call)).withHighlightType(JavaErrorHighlightType.WRONG_REF).withDescription((call, type) -> JavaCompilationErrorBundle.message("call.qualifier.primitive", type.getPresentableText()));
    public static final JavaErrorKind.Parameterized<PsiMethodCallExpression, PsiMethod> CALL_DIRECT_ABSTRACT_METHOD_ACCESS = JavaErrorKinds.parameterized(PsiMethodCallExpression.class, PsiMethod.class, "call.direct.abstract.method.access").withDescription((call, method) -> JavaCompilationErrorBundle.message("call.direct.abstract.method.access", JavaErrorFormatUtil.formatMethod(method)));
    public static final JavaErrorKind.Simple<PsiMethodCallExpression> CALL_CONSTRUCTOR_MUST_BE_FIRST_STATEMENT = JavaErrorKinds.error(PsiMethodCallExpression.class, "call.constructor.must.be.first.statement").withDescription(call -> JavaCompilationErrorBundle.message("call.constructor.must.be.first.statement", call.getMethodExpression().getText() + "()"));
    public static final JavaErrorKind.Simple<PsiMethodCallExpression> CALL_CONSTRUCTOR_ONLY_ALLOWED_IN_CONSTRUCTOR = JavaErrorKinds.error(PsiMethodCallExpression.class, "call.constructor.only.allowed.in.constructor").withDescription(call -> JavaCompilationErrorBundle.message("call.constructor.only.allowed.in.constructor", call.getMethodExpression().getText() + "()"));
    public static final JavaErrorKind.Simple<PsiMethodCallExpression> CALL_CONSTRUCTOR_MUST_BE_TOP_LEVEL_STATEMENT = JavaErrorKinds.error(PsiMethodCallExpression.class, "call.constructor.must.be.top.level.statement").withDescription(call -> JavaCompilationErrorBundle.message("call.constructor.must.be.top.level.statement", call.getMethodExpression().getText() + "()"));
    public static final JavaErrorKind.Simple<PsiMethodCallExpression> CALL_CONSTRUCTOR_DUPLICATE = JavaErrorKinds.error(PsiMethodCallExpression.class, "call.constructor.duplicate");
    public static final JavaErrorKind.Simple<PsiMethodCallExpression> CALL_CONSTRUCTOR_RECURSIVE = JavaErrorKinds.error(PsiMethodCallExpression.class, "call.constructor.recursive");
    public static final JavaErrorKind.Simple<PsiMethodCallExpression> CALL_CONSTRUCTOR_RECORD_IN_CANONICAL = JavaErrorKinds.error(PsiMethodCallExpression.class, "call.constructor.record.in.canonical");
    public static final JavaErrorKind.Parameterized<PsiElement, String> CALL_MEMBER_BEFORE_CONSTRUCTOR = JavaErrorKinds.parameterized(PsiElement.class, String.class, "call.member.before.constructor").withRange((psi, refName) -> JavaErrorFormatUtil.getRange(psi)).withDescription((psi, refName) -> JavaCompilationErrorBundle.message("call.member.before.constructor", refName));
    public static final JavaErrorKind.Simple<PsiExpression> STRING_TEMPLATE_VOID_NOT_ALLOWED_IN_EMBEDDED = JavaErrorKinds.error("string.template.void.not.allowed.in.embedded");
    public static final JavaErrorKind.Simple<PsiTemplateExpression> STRING_TEMPLATE_PROCESSOR_MISSING = JavaErrorKinds.error("string.template.processor.missing");
    public static final JavaErrorKind.Parameterized<PsiExpression, PsiType> STRING_TEMPLATE_RAW_PROCESSOR = JavaErrorKinds.parameterized(PsiExpression.class, PsiType.class, "string.template.raw.processor").withDescription((psi, type) -> JavaCompilationErrorBundle.message("string.template.raw.processor", type.getPresentableText()));
    public static final JavaErrorKind.Parameterized<PsiElement, JavaResolveResult> ACCESS_PRIVATE = JavaErrorKinds.parameterized(PsiElement.class, JavaResolveResult.class, "access.private").withRange((psi, cls) -> JavaErrorFormatUtil.getRange(psi)).withDescription((psi, result) -> JavaCompilationErrorBundle.message("access.private", JavaErrorFormatUtil.formatResolvedSymbol(result), JavaErrorFormatUtil.formatResolvedSymbolContainer(result)));
    public static final JavaErrorKind.Parameterized<PsiElement, JavaResolveResult> ACCESS_PROTECTED = JavaErrorKinds.parameterized(PsiElement.class, JavaResolveResult.class, "access.protected").withRange((psi, cls) -> JavaErrorFormatUtil.getRange(psi)).withDescription((psi, result) -> JavaCompilationErrorBundle.message("access.protected", JavaErrorFormatUtil.formatResolvedSymbol(result), JavaErrorFormatUtil.formatResolvedSymbolContainer(result)));
    public static final JavaErrorKind.Parameterized<PsiElement, JavaResolveResult> ACCESS_PACKAGE_LOCAL = JavaErrorKinds.parameterized(PsiElement.class, JavaResolveResult.class, "access.package.local").withRange((psi, cls) -> JavaErrorFormatUtil.getRange(psi)).withDescription((psi, result) -> JavaCompilationErrorBundle.message("access.package.local", JavaErrorFormatUtil.formatResolvedSymbol(result), JavaErrorFormatUtil.formatResolvedSymbolContainer(result)));
    public static final JavaErrorKind.Parameterized<PsiElement, JavaResolveResult> ACCESS_GENERIC_PROBLEM = JavaErrorKinds.parameterized(PsiElement.class, JavaResolveResult.class, "access.generic.problem").withRange((psi, cls) -> JavaErrorFormatUtil.getRange(psi)).withDescription((psi, result) -> JavaCompilationErrorBundle.message("access.generic.problem", JavaErrorFormatUtil.formatResolvedSymbol(result), JavaErrorFormatUtil.formatResolvedSymbolContainer(result)));
    public static final JavaErrorKind.Simple<PsiImportModuleStatement> IMPORT_MODULE_NOT_ALLOWED = JavaErrorKinds.error(PsiImportModuleStatement.class, "module.import.not.allowed");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> IMPORT_SINGLE_CLASS_CONFLICT = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "import.single.class.conflict").withDescription((ref, cls) -> JavaCompilationErrorBundle.message("import.single.class.conflict", cls.getQualifiedName()));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> IMPORT_SINGLE_STATIC_CLASS_ALREADY_DEFINED = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "import.single.static.class.already.defined").withDescription(ref -> JavaCompilationErrorBundle.message("import.single.static.class.already.defined", ref.getReferenceName()));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> IMPORT_SINGLE_STATIC_CLASS_AMBIGUOUS = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "import.single.static.class.ambiguous").withDescription(ref -> JavaCompilationErrorBundle.message("import.single.static.class.ambiguous", ref.getReferenceName()));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> IMPORT_SINGLE_STATIC_FIELD_ALREADY_DEFINED = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "import.single.static.field.already.defined").withDescription(ref -> JavaCompilationErrorBundle.message("import.single.static.field.already.defined", ref.getReferenceName()));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> IMPORT_SINGLE_STATIC_FIELD_AMBIGUOUS = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "import.single.static.field.ambiguous").withDescription(ref -> JavaCompilationErrorBundle.message("import.single.static.field.ambiguous", ref.getReferenceName()));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> IMPORT_STATIC_ON_DEMAND_RESOLVES_TO_CLASS = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "import.static.on.demand.resolves.to.class").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription(ref -> JavaCompilationErrorBundle.message("import.static.on.demand.resolves.to.class", ref.getCanonicalText()));
    public static final JavaErrorKind.Simple<PsiJavaToken> IMPORT_LIST_EXTRA_SEMICOLON = JavaErrorKinds.error(PsiJavaToken.class, "import.list.extra.semicolon");
    public static final JavaErrorKind.Simple<PsiIdentifier> UNDERSCORE_IDENTIFIER = JavaErrorKinds.error("underscore.identifier");
    public static final JavaErrorKind.Simple<PsiIdentifier> UNDERSCORE_IDENTIFIER_UNNAMED = JavaErrorKinds.error("underscore.identifier.unnamed");
    public static final JavaErrorKind.Simple<PsiIdentifier> UNDERSCORE_IDENTIFIER_LAMBDA = JavaErrorKinds.error("underscore.identifier.lambda");
    public static final JavaErrorKind.Simple<PsiVariable> UNNAMED_VARIABLE_BRACKETS = JavaErrorKinds.error(PsiVariable.class, "unnamed.variable.brackets").withRange(var -> {
        TokenSet brackets = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.LBRACKET, JavaTokenType.RBRACKET});
        return Stream.of(var.getChildren()).filter(t -> PsiUtil.isJavaToken((PsiElement)t, (TokenSet)brackets)).map(PsiElement::getTextRangeInParent).reduce(TextRange::union).orElseThrow();
    });
    public static final JavaErrorKind.Simple<PsiLocalVariable> UNNAMED_VARIABLE_WITHOUT_INITIALIZER = JavaErrorKinds.error(PsiLocalVariable.class, "unnamed.variable.without.initializer").withRange(var -> TextRange.create((int)0, (int)Objects.requireNonNull(var.getNameIdentifier()).getTextRangeInParent().getEndOffset()));
    public static final JavaErrorKind.Simple<PsiField> UNNAMED_FIELD_NOT_ALLOWED = JavaErrorKinds.error(PsiField.class, "unnamed.field.not.allowed").withRange(var -> TextRange.create((int)0, (int)Objects.requireNonNull(var.getNameIdentifier()).getTextRangeInParent().getEndOffset()));
    public static final JavaErrorKind.Simple<PsiParameter> UNNAMED_METHOD_PARAMETER_NOT_ALLOWED = JavaErrorKinds.error(PsiParameter.class, "unnamed.method.parameter.not.allowed").withRange(var -> TextRange.create((int)0, (int)Objects.requireNonNull(var.getNameIdentifier()).getTextRangeInParent().getEndOffset()));
    public static final JavaErrorKind.Simple<PsiVariable> UNNAMED_VARIABLE_NOT_ALLOWED_IN_THIS_CONTEXT = JavaErrorKinds.error(PsiVariable.class, "unnamed.variable.not.allowed.in.this.context").withRange(var -> TextRange.create((int)0, (int)Objects.requireNonNull(var.getNameIdentifier()).getTextRangeInParent().getEndOffset()));
    public static final JavaErrorKind.Simple<PsiReturnStatement> RETURN_OUTSIDE_SWITCH_EXPRESSION = JavaErrorKinds.error(PsiReturnStatement.class, "return.outside.switch.expression");
    public static final JavaErrorKind.Simple<PsiReturnStatement> RETURN_COMPACT_CONSTRUCTOR = JavaErrorKinds.error(PsiReturnStatement.class, "return.compact.constructor");
    public static final JavaErrorKind.Simple<PsiReturnStatement> RETURN_OUTSIDE_METHOD = JavaErrorKinds.error(PsiReturnStatement.class, "return.outside.method");
    public static final JavaErrorKind.Parameterized<PsiReturnStatement, PsiMethod> RETURN_VALUE_MISSING = JavaErrorKinds.parameterized(PsiReturnStatement.class, PsiMethod.class, "return.value.missing");
    public static final JavaErrorKind.Parameterized<PsiReturnStatement, PsiMethod> RETURN_FROM_CONSTRUCTOR = JavaErrorKinds.parameterized(PsiReturnStatement.class, PsiMethod.class, "return.from.constructor");
    public static final JavaErrorKind.Parameterized<PsiElement, PsiParameterListOwner> RETURN_MISSING = JavaErrorKinds.parameterized(PsiElement.class, PsiParameterListOwner.class, "return.missing");
    public static final JavaErrorKind.Parameterized<PsiReturnStatement, PsiMethod> RETURN_FROM_VOID_METHOD = JavaErrorKinds.parameterized(PsiReturnStatement.class, PsiMethod.class, "return.from.void.method");
    public static final JavaErrorKind.Parameterized<PsiReturnStatement, PsiMethodCallExpression> RETURN_BEFORE_EXPLICIT_CONSTRUCTOR_CALL = JavaErrorKinds.parameterized(PsiReturnStatement.class, PsiMethodCallExpression.class, "return.before.explicit.constructor.call").withDescription((psi, call) -> JavaCompilationErrorBundle.message("return.before.explicit.constructor.call", call.getMethodExpression().getText() + "()"));
    public static final JavaErrorKind.Simple<PsiField> FIELD_NOT_INITIALIZED = JavaErrorKinds.error(PsiField.class, "field.not.initialized").withRange(JavaErrorFormatUtil::getFieldDeclarationTextRange).withDescription(var -> JavaCompilationErrorBundle.message("field.not.initialized", var.getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, PsiField> FIELD_INITIALIZED_BEFORE_CONSTRUCTOR_CALL = JavaErrorKinds.parameterized(PsiElement.class, PsiField.class, "field.initialized.before.constructor.call").withDescription((psi, field) -> JavaCompilationErrorBundle.message("field.initialized.before.constructor.call", PsiFormatUtil.formatVariable((PsiVariable)field, (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY)));
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> VARIABLE_NOT_INITIALIZED = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiVariable.class, "variable.not.initialized").withDescription((ref, var) -> JavaCompilationErrorBundle.message("variable.not.initialized", var.getName()));
    public static final JavaErrorKind.Parameterized<PsiVariable, PsiVariable> VARIABLE_ALREADY_DEFINED = JavaErrorKinds.parameterized(PsiVariable.class, PsiVariable.class, "variable.already.defined").withAnchor(var -> (PsiElement)Objects.requireNonNullElse(var.getNameIdentifier(), var)).withDescription((var, oldVar) -> JavaCompilationErrorBundle.message("variable.already.defined", var.getName())).withTooltip((variable, oldVariable) -> {
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)variable);
        if (vFile == null) {
            return HtmlChunk.empty();
        }
        String path = FileUtil.toSystemIndependentName((String)vFile.getPath());
        HtmlChunk.Element link = HtmlChunk.link((String)("#navigation/" + path + ":" + oldVariable.getTextOffset()), (String)Objects.requireNonNull(variable.getName()));
        return HtmlChunk.raw((String)JavaCompilationErrorBundle.message("variable.already.defined", link)).wrapWith(HtmlChunk.html());
    });
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> VARIABLE_ALREADY_ASSIGNED = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiVariable.class, "variable.already.assigned").withDescription((ref, var) -> JavaCompilationErrorBundle.message("variable.already.assigned", var.getName()));
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> VARIABLE_ALREADY_ASSIGNED_CONSTRUCTOR = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiVariable.class, "variable.already.assigned.constructor").withDescription((ref, var) -> {
        PsiMethod constructor = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiMethod.class);
        assert (constructor != null);
        PsiMethodCallExpression thisCall = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor);
        assert (thisCall != null);
        return JavaCompilationErrorBundle.message("variable.already.assigned.constructor", var.getName(), thisCall.getTextOffset() + thisCall.getTextLength() > ref.getTextOffset() ? 1 : 2);
    });
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> VARIABLE_ALREADY_ASSIGNED_FIELD = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiVariable.class, "variable.already.assigned.field").withDescription((ref, var) -> JavaCompilationErrorBundle.message("variable.already.assigned.field", var.getName()));
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> VARIABLE_ALREADY_ASSIGNED_INITIALIZER = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiVariable.class, "variable.already.assigned.initializer").withDescription((ref, var) -> JavaCompilationErrorBundle.message("variable.already.assigned.initializer", var.getName()));
    public static final JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> VARIABLE_ASSIGNED_IN_LOOP = JavaErrorKinds.parameterized(PsiReferenceExpression.class, PsiVariable.class, "variable.assigned.in.loop").withDescription((ref, var) -> JavaCompilationErrorBundle.message("variable.assigned.in.loop", var.getName()));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiVariable> VARIABLE_MUST_BE_FINAL = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiVariable.class, "variable.must.be.final").withDescription((ref, var) -> JavaCompilationErrorBundle.message("variable.must.be.final", var.getName()));
    public static final JavaErrorKind.Simple<PsiReferenceExpression> VARIABLE_MUST_BE_FINAL_RESOURCE = JavaErrorKinds.error(PsiReferenceExpression.class, "variable.must.be.final.resource");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiVariable> VARIABLE_MUST_BE_EFFECTIVELY_FINAL = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiVariable.class, "variable.must.be.effectively.final").withDescription((ref, var) -> JavaCompilationErrorBundle.message("variable.must.be.effectively.final", var.getName()));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiVariable> VARIABLE_MUST_BE_EFFECTIVELY_FINAL_LAMBDA = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiVariable.class, "variable.must.be.effectively.final.lambda");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiVariable> VARIABLE_MUST_BE_EFFECTIVELY_FINAL_GUARD = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiVariable.class, "variable.must.be.effectively.final.guard");
    public static final JavaErrorKind.Simple<PsiPackageStatement> MODULE_NO_PACKAGE = JavaErrorKinds.error("module.no.package");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiJavaModule> MODULE_CONFLICTING_PACKAGES = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiJavaModule.class, "module.conflicting.packages").withDescription((ref, module) -> JavaCompilationErrorBundle.message("module.conflicting.packages", ref.getText(), module.getName()));
    public static final JavaErrorKind.Simple<PsiJavaModule> MODULE_FILE_WRONG_NAME = JavaErrorKinds.error(PsiJavaModule.class, "module.file.wrong.name").withRange(JavaErrorFormatUtil::getRange);
    public static final JavaErrorKind.Parameterized<PsiJavaModule, PsiFile> MODULE_FILE_DUPLICATE = JavaErrorKinds.parameterized(PsiJavaModule.class, PsiFile.class, "module.file.duplicate").withRange((module, file) -> JavaErrorFormatUtil.getRange((PsiElement)module));
    public static final JavaErrorKind.Parameterized<PsiRequiresStatement, String> MODULE_DUPLICATE_REQUIRES = JavaErrorKinds.parameterized(PsiRequiresStatement.class, String.class, "module.duplicate.requires").withDescription((requires, refName) -> JavaCompilationErrorBundle.message("module.duplicate.requires", refName));
    public static final JavaErrorKind.Parameterized<PsiPackageAccessibilityStatement, String> MODULE_DUPLICATE_EXPORTS = JavaErrorKinds.parameterized(PsiPackageAccessibilityStatement.class, String.class, "module.duplicate.exports").withDescription((requires, refName) -> JavaCompilationErrorBundle.message("module.duplicate.exports", refName));
    public static final JavaErrorKind.Parameterized<PsiPackageAccessibilityStatement, String> MODULE_DUPLICATE_OPENS = JavaErrorKinds.parameterized(PsiPackageAccessibilityStatement.class, String.class, "module.duplicate.opens").withDescription((requires, refName) -> JavaCompilationErrorBundle.message("module.duplicate.opens", refName));
    public static final JavaErrorKind.Parameterized<PsiUsesStatement, String> MODULE_DUPLICATE_USES = JavaErrorKinds.parameterized(PsiUsesStatement.class, String.class, "module.duplicate.uses").withDescription((requires, refName) -> JavaCompilationErrorBundle.message("module.duplicate.uses", refName));
    public static final JavaErrorKind.Parameterized<PsiProvidesStatement, String> MODULE_DUPLICATE_PROVIDES = JavaErrorKinds.parameterized(PsiProvidesStatement.class, String.class, "module.duplicate.provides").withDescription((requires, refName) -> JavaCompilationErrorBundle.message("module.duplicate.provides", refName));
    public static final JavaErrorKind.Parameterized<PsiJavaModule, JavaPsiModuleUtil.ModulePackageConflict> MODULE_CONFLICTING_READS = JavaErrorKinds.parameterized(PsiJavaModule.class, JavaPsiModuleUtil.ModulePackageConflict.class, "module.conflicting.reads").withRange((module, conflict) -> JavaErrorFormatUtil.getRange((PsiElement)module)).withDescription((module, conflict) -> JavaCompilationErrorBundle.message("module.conflicting.reads", module.getName(), conflict.packageName(), conflict.module1().getName(), conflict.module2().getName()));
    public static final JavaErrorKind.Parameterized<PsiJavaModule, VirtualFile> MODULE_FILE_WRONG_LOCATION = JavaErrorKinds.parameterized(PsiJavaModule.class, VirtualFile.class, "module.file.wrong.location").withRange((module, file) -> JavaErrorFormatUtil.getRange((PsiElement)module));
    public static final JavaErrorKind.Parameterized<PsiPackageAccessibilityStatement, PsiJavaModule> MODULE_OPENS_IN_WEAK_MODULE = JavaErrorKinds.parameterized(PsiPackageAccessibilityStatement.class, PsiJavaModule.class, "module.opens.in.weak.module");
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> MODULE_SERVICE_ENUM = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "module.service.enum").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription((ref, cls) -> JavaCompilationErrorBundle.message("module.service.enum", cls.getName()));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> MODULE_SERVICE_ALIEN = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "module.service.alien").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref));
    public static final JavaErrorKind.Simple<PsiJavaModuleReferenceElement> MODULE_NOT_FOUND = JavaErrorKinds.error(PsiJavaModuleReferenceElement.class, "module.not.found").withHighlightType(JavaErrorHighlightType.WRONG_REF).withDescription(ref -> JavaCompilationErrorBundle.message("module.not.found", ref.getReferenceText()));
    public static final JavaErrorKind.Simple<PsiJavaModuleReferenceElement> MODULE_NOT_ON_PATH = JavaErrorKinds.error(PsiJavaModuleReferenceElement.class, "module.not.on.path").withDescription(ref -> JavaCompilationErrorBundle.message("module.not.on.path", ref.getReferenceText()));
    public static final JavaErrorKind.Parameterized<PsiJavaModuleReferenceElement, Collection<PsiJavaModule>> MODULE_CYCLIC_DEPENDENCE = JavaErrorKinds.error(PsiJavaModuleReferenceElement.class, "module.cyclic.dependence").parameterized().withDescription((ref, modules) -> JavaCompilationErrorBundle.message("module.cyclic.dependence", modules.stream().map(PsiJavaModule::getName).sorted().collect(Collectors.joining(", "))));
    public static final JavaErrorKind.Simple<PsiJavaCodeReferenceElement> MODULE_DUPLICATE_IMPLEMENTATION = JavaErrorKinds.error(PsiJavaCodeReferenceElement.class, "module.duplicate.implementation").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription(ref -> JavaCompilationErrorBundle.message("module.duplicate.implementation", ref.getQualifiedName()));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> MODULE_SERVICE_PROVIDER_TYPE = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "module.service.provider.type").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription((ref, impl) -> JavaCompilationErrorBundle.message("module.service.provider.type", impl.getName()));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> MODULE_SERVICE_NO_CONSTRUCTOR = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "module.service.no.constructor").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription((ref, impl) -> JavaCompilationErrorBundle.message("module.service.no.constructor", impl.getName()));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> MODULE_SERVICE_ABSTRACT = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "module.service.abstract").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription((ref, impl) -> JavaCompilationErrorBundle.message("module.service.abstract", impl.getName()));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> MODULE_SERVICE_INNER = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, PsiClass.class, "module.service.inner").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref)).withDescription((ref, impl) -> JavaCompilationErrorBundle.message("module.service.inner", impl.getName()));
    public static final JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, SuperclassSubclassContext> MODULE_SERVICE_IMPLEMENTATION_TYPE = JavaErrorKinds.parameterized(PsiJavaCodeReferenceElement.class, SuperclassSubclassContext.class, "module.service.implementation.type").withAnchor(ref -> (PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref));
    public static final JavaErrorKind.Simple<PsiJavaModuleReferenceElement> MODULE_DUPLICATE_EXPORTS_TARGET = JavaErrorKinds.error(PsiJavaModuleReferenceElement.class, "module.duplicate.exports.target").withDescription(ref -> JavaCompilationErrorBundle.message("module.duplicate.exports.target", ref.getReferenceText()));
    public static final JavaErrorKind.Simple<PsiJavaModuleReferenceElement> MODULE_DUPLICATE_OPENS_TARGET = JavaErrorKinds.error(PsiJavaModuleReferenceElement.class, "module.duplicate.opens.target").withDescription(ref -> JavaCompilationErrorBundle.message("module.duplicate.opens.target", ref.getReferenceText()));
    public static final JavaErrorKind.Simple<PsiPackageAccessibilityStatement> MODULE_REFERENCE_PACKAGE_NOT_FOUND = JavaErrorKinds.error(PsiPackageAccessibilityStatement.class, "module.reference.package.not.found").withAnchor(st -> st.getPackageReference()).withDescription(st -> JavaCompilationErrorBundle.message("module.reference.package.not.found", st.getPackageName()));
    public static final JavaErrorKind.Simple<PsiPackageAccessibilityStatement> MODULE_REFERENCE_PACKAGE_EMPTY = JavaErrorKinds.error(PsiPackageAccessibilityStatement.class, "module.reference.package.empty").withAnchor(st -> st.getPackageReference()).withDescription(st -> JavaCompilationErrorBundle.message("module.reference.package.empty", st.getPackageName()));
    public static final JavaErrorKind.Parameterized<PsiElement, JpmsModuleAccessInfo> MODULE_ACCESS_FROM_NAMED = JavaErrorKinds.parameterized(PsiElement.class, JpmsModuleAccessInfo.class, "module.access.from.named").withDescription((psi, info) -> JavaCompilationErrorBundle.message("module.access.from.named", info.getTarget().getPackageName(), Objects.requireNonNull(info.getTarget().getModule()).getName(), info.getCurrent().getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, JpmsModuleAccessInfo> MODULE_ACCESS_FROM_UNNAMED = JavaErrorKinds.parameterized(PsiElement.class, JpmsModuleAccessInfo.class, "module.access.from.unnamed").withDescription((psi, info) -> JavaCompilationErrorBundle.message("module.access.from.unnamed", info.getTarget().getPackageName(), Objects.requireNonNull(info.getTarget().getModule()).getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, JpmsModuleAccessInfo> MODULE_ACCESS_TO_UNNAMED = JavaErrorKinds.parameterized(PsiElement.class, JpmsModuleAccessInfo.class, "module.access.to.unnamed").withDescription((psi, info) -> JavaCompilationErrorBundle.message("module.access.to.unnamed", info.getTarget().getPackageName(), info.getCurrent().getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, JpmsModuleAccessInfo> MODULE_ACCESS_PACKAGE_BAD_NAME = JavaErrorKinds.parameterized(PsiElement.class, JpmsModuleAccessInfo.class, "module.access.package.bad.name").withDescription((psi, info) -> JavaCompilationErrorBundle.message("module.access.package.bad.name", info.getTarget().getPackageName(), Objects.requireNonNull(info.getTarget().getModule()).getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, JpmsModuleAccessInfo> MODULE_ACCESS_BAD_NAME = JavaErrorKinds.parameterized(PsiElement.class, JpmsModuleAccessInfo.class, "module.access.bad.name").withDescription((psi, info) -> JavaCompilationErrorBundle.message("module.access.bad.name", Objects.requireNonNull(info.getTarget().getModule()).getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, JpmsModuleAccessInfo> MODULE_ACCESS_PACKAGE_NOT_IN_GRAPH = JavaErrorKinds.parameterized(PsiElement.class, JpmsModuleAccessInfo.class, "module.access.package.not.in.graph").withDescription((psi, info) -> JavaCompilationErrorBundle.message("module.access.package.not.in.graph", info.getTarget().getPackageName(), Objects.requireNonNull(info.getTarget().getModule()).getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, JpmsModuleAccessInfo> MODULE_ACCESS_NOT_IN_GRAPH = JavaErrorKinds.parameterized(PsiElement.class, JpmsModuleAccessInfo.class, "module.access.not.in.graph").withDescription((psi, info) -> JavaCompilationErrorBundle.message("module.access.not.in.graph", Objects.requireNonNull(info.getTarget().getModule()).getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, JpmsModuleAccessInfo> MODULE_ACCESS_PACKAGE_DOES_NOT_READ = JavaErrorKinds.parameterized(PsiElement.class, JpmsModuleAccessInfo.class, "module.access.package.does.not.read").withDescription((psi, info) -> JavaCompilationErrorBundle.message("module.access.package.does.not.read", info.getTarget().getPackageName(), Objects.requireNonNull(info.getTarget().getModule()).getName(), info.getCurrent().getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, JpmsModuleAccessInfo> MODULE_ACCESS_DOES_NOT_READ = JavaErrorKinds.parameterized(PsiElement.class, JpmsModuleAccessInfo.class, "module.access.does.not.read").withDescription((psi, info) -> JavaCompilationErrorBundle.message("module.access.does.not.read", Objects.requireNonNull(info.getTarget().getModule()).getName(), info.getCurrent().getName()));
    public static final JavaErrorKind.Parameterized<PsiElement, JpmsModuleAccessInfo> MODULE_ACCESS_JPS_DEPENDENCY_PROBLEM = JavaErrorKinds.parameterized(PsiElement.class, JpmsModuleAccessInfo.class, "module.access.jps.dependency.problem").withDescription((psi, info) -> JavaCompilationErrorBundle.message("module.access.jps.dependency.problem", Objects.requireNonNull(info.getTarget().getModule()).getName()));

    private JavaErrorKinds() {
    }

    @NotNull
    private static <Psi extends PsiElement> JavaErrorKind.Simple<Psi> error(@NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String key) {
        if (key == null) {
            JavaErrorKinds.$$$reportNull$$$0(0);
        }
        return new JavaErrorKind.Simple(key);
    }

    @NotNull
    private static <Psi extends PsiElement> JavaErrorKind.Simple<Psi> error(@NotNull Class<Psi> psiClass, @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String key) {
        if (psiClass == null) {
            JavaErrorKinds.$$$reportNull$$$0(1);
        }
        if (key == null) {
            JavaErrorKinds.$$$reportNull$$$0(2);
        }
        return JavaErrorKinds.error(key);
    }

    @NotNull
    private static <Psi extends PsiElement, Context> JavaErrorKind.Parameterized<Psi, Context> parameterized(@NotNull Class<Psi> psiClass, @NotNull Class<Context> contextClass, @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String key) {
        if (psiClass == null) {
            JavaErrorKinds.$$$reportNull$$$0(3);
        }
        if (contextClass == null) {
            JavaErrorKinds.$$$reportNull$$$0(4);
        }
        if (key == null) {
            JavaErrorKinds.$$$reportNull$$$0(5);
        }
        return new JavaErrorKind.Parameterized(key);
    }

    @NotNull
    private static <Psi extends PsiElement, Context> JavaErrorKind.Parameterized<Psi, Context> parameterized(@NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaCompilationErrorBundle") String key) {
        if (key == null) {
            JavaErrorKinds.$$$reportNull$$$0(6);
        }
        return new JavaErrorKind.Parameterized(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parameterized";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record UnresolvedConstructorContext(@NotNull PsiClass psiClass, @NotNull @NotNull JavaResolveResult @NotNull [] results) {
        @NotNull
        private final PsiClass psiClass;
        @NotNull
        private final @NotNull JavaResolveResult @NotNull [] results;

        public UnresolvedConstructorContext(@NotNull PsiClass psiClass, @NotNull @NotNull JavaResolveResult @NotNull [] results) {
            if (psiClass == null) {
                UnresolvedConstructorContext.$$$reportNull$$$0(0);
            }
            if (results == null) {
                UnresolvedConstructorContext.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public PsiClass psiClass() {
            PsiClass psiClass = this.psiClass;
            if (psiClass == null) {
                UnresolvedConstructorContext.$$$reportNull$$$0(2);
            }
            return psiClass;
        }

        @NotNull
        public @NotNull JavaResolveResult @NotNull [] results() {
            if (this.results == null) {
                UnresolvedConstructorContext.$$$reportNull$$$0(3);
            }
            return this.results;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$UnresolvedConstructorContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$UnresolvedConstructorContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "psiClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "results";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public record SuperclassSubclassContext(@NotNull PsiClass superClass, @NotNull PsiClass subClass) {
        @NotNull
        private final PsiClass superClass;
        @NotNull
        private final PsiClass subClass;

        public SuperclassSubclassContext(@NotNull PsiClass superClass, @NotNull PsiClass subClass) {
            if (superClass == null) {
                SuperclassSubclassContext.$$$reportNull$$$0(0);
            }
            if (subClass == null) {
                SuperclassSubclassContext.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public PsiClass superClass() {
            PsiClass psiClass = this.superClass;
            if (psiClass == null) {
                SuperclassSubclassContext.$$$reportNull$$$0(2);
            }
            return psiClass;
        }

        @NotNull
        public PsiClass subClass() {
            PsiClass psiClass = this.subClass;
            if (psiClass == null) {
                SuperclassSubclassContext.$$$reportNull$$$0(3);
            }
            return psiClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subClass";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$SuperclassSubclassContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$SuperclassSubclassContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "superClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public record InheritTypeClashContext(@NotNull PsiClass superClass, @Nullable PsiType type1, @Nullable PsiType type2) {
        @NotNull
        private final PsiClass superClass;

        public InheritTypeClashContext(@NotNull PsiClass superClass, @Nullable PsiType type1, @Nullable PsiType type2) {
            if (superClass == null) {
                InheritTypeClashContext.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public PsiClass superClass() {
            PsiClass psiClass = this.superClass;
            if (psiClass == null) {
                InheritTypeClashContext.$$$reportNull$$$0(1);
            }
            return psiClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$InheritTypeClashContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$InheritTypeClashContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "superClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public record DeconstructionCountMismatchContext(@NotNull @NotNull PsiPattern @NotNull [] patternComponents, @NotNull @NotNull PsiRecordComponent @NotNull [] recordComponents, boolean hasMismatch) {
        @NotNull
        private final @NotNull PsiPattern @NotNull [] patternComponents;
        @NotNull
        private final @NotNull PsiRecordComponent @NotNull [] recordComponents;

        public DeconstructionCountMismatchContext(@NotNull @NotNull PsiPattern @NotNull [] patternComponents, @NotNull @NotNull PsiRecordComponent @NotNull [] recordComponents, boolean hasMismatch) {
            if (patternComponents == null) {
                DeconstructionCountMismatchContext.$$$reportNull$$$0(0);
            }
            if (recordComponents == null) {
                DeconstructionCountMismatchContext.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public @NotNull PsiPattern @NotNull [] patternComponents() {
            if (this.patternComponents == null) {
                DeconstructionCountMismatchContext.$$$reportNull$$$0(2);
            }
            return this.patternComponents;
        }

        @NotNull
        public @NotNull PsiRecordComponent @NotNull [] recordComponents() {
            if (this.recordComponents == null) {
                DeconstructionCountMismatchContext.$$$reportNull$$$0(3);
            }
            return this.recordComponents;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patternComponents";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recordComponents";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$DeconstructionCountMismatchContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$DeconstructionCountMismatchContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "patternComponents";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "recordComponents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public record PatternTypeContext(@NotNull PsiType contextType, @NotNull PsiType patternType) {
        @NotNull
        private final PsiType contextType;
        @NotNull
        private final PsiType patternType;

        public PatternTypeContext(@NotNull PsiType contextType, @NotNull PsiType patternType) {
            if (contextType == null) {
                PatternTypeContext.$$$reportNull$$$0(0);
            }
            if (patternType == null) {
                PatternTypeContext.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public PsiType contextType() {
            PsiType psiType = this.contextType;
            if (psiType == null) {
                PatternTypeContext.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        @NotNull
        public PsiType patternType() {
            PsiType psiType = this.patternType;
            if (psiType == null) {
                PatternTypeContext.$$$reportNull$$$0(3);
            }
            return psiType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patternType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$PatternTypeContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$PatternTypeContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "patternType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public record AmbiguousImplicitConstructorCallContext(@NotNull PsiClass psiClass, @NotNull PsiMethod candidate1, @NotNull PsiMethod candidate2) {
        @NotNull
        private final PsiClass psiClass;
        @NotNull
        private final PsiMethod candidate1;
        @NotNull
        private final PsiMethod candidate2;

        public AmbiguousImplicitConstructorCallContext(@NotNull PsiClass psiClass, @NotNull PsiMethod candidate1, @NotNull PsiMethod candidate2) {
            if (psiClass == null) {
                AmbiguousImplicitConstructorCallContext.$$$reportNull$$$0(0);
            }
            if (candidate1 == null) {
                AmbiguousImplicitConstructorCallContext.$$$reportNull$$$0(1);
            }
            if (candidate2 == null) {
                AmbiguousImplicitConstructorCallContext.$$$reportNull$$$0(2);
            }
        }

        @Nls
        String description() {
            String m1 = PsiFormatUtil.formatMethod((PsiMethod)this.candidate1, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            String m2 = PsiFormatUtil.formatMethod((PsiMethod)this.candidate2, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            return JavaCompilationErrorBundle.message("constructor.ambiguous.implicit.call", m1, m2);
        }

        @NotNull
        public PsiClass psiClass() {
            PsiClass psiClass = this.psiClass;
            if (psiClass == null) {
                AmbiguousImplicitConstructorCallContext.$$$reportNull$$$0(3);
            }
            return psiClass;
        }

        @NotNull
        public PsiMethod candidate1() {
            PsiMethod psiMethod = this.candidate1;
            if (psiMethod == null) {
                AmbiguousImplicitConstructorCallContext.$$$reportNull$$$0(4);
            }
            return psiMethod;
        }

        @NotNull
        public PsiMethod candidate2() {
            PsiMethod psiMethod = this.candidate2;
            if (psiMethod == null) {
                AmbiguousImplicitConstructorCallContext.$$$reportNull$$$0(5);
            }
            return psiMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidate1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidate2";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$AmbiguousImplicitConstructorCallContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$AmbiguousImplicitConstructorCallContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "psiClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "candidate1";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "candidate2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public record IncompatibleOverrideExceptionContext(@NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull PsiClassType exceptionType, @Nullable PsiJavaCodeReferenceElement exceptionReference) {
        @NotNull
        private final PsiMethod method;
        @NotNull
        private final PsiMethod superMethod;
        @NotNull
        private final PsiClassType exceptionType;

        public IncompatibleOverrideExceptionContext(@NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull PsiClassType exceptionType, @Nullable PsiJavaCodeReferenceElement exceptionReference) {
            if (method == null) {
                IncompatibleOverrideExceptionContext.$$$reportNull$$$0(0);
            }
            if (superMethod == null) {
                IncompatibleOverrideExceptionContext.$$$reportNull$$$0(1);
            }
            if (exceptionType == null) {
                IncompatibleOverrideExceptionContext.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        public PsiMethod method() {
            PsiMethod psiMethod = this.method;
            if (psiMethod == null) {
                IncompatibleOverrideExceptionContext.$$$reportNull$$$0(3);
            }
            return psiMethod;
        }

        @NotNull
        public PsiMethod superMethod() {
            PsiMethod psiMethod = this.superMethod;
            if (psiMethod == null) {
                IncompatibleOverrideExceptionContext.$$$reportNull$$$0(4);
            }
            return psiMethod;
        }

        @NotNull
        public PsiClassType exceptionType() {
            PsiClassType psiClassType = this.exceptionType;
            if (psiClassType == null) {
                IncompatibleOverrideExceptionContext.$$$reportNull$$$0(5);
            }
            return psiClassType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superMethod";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$IncompatibleOverrideExceptionContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$IncompatibleOverrideExceptionContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "method";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "superMethod";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "exceptionType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public record IncompatibleOverrideReturnTypeContext(@NotNull PsiMethod method, @NotNull PsiType methodReturnType, @NotNull PsiMethod superMethod, @NotNull PsiType superMethodReturnType) {
        @NotNull
        private final PsiMethod method;
        @NotNull
        private final PsiType methodReturnType;
        @NotNull
        private final PsiMethod superMethod;
        @NotNull
        private final PsiType superMethodReturnType;

        public IncompatibleOverrideReturnTypeContext(@NotNull PsiMethod method, @NotNull PsiType methodReturnType, @NotNull PsiMethod superMethod, @NotNull PsiType superMethodReturnType) {
            if (method == null) {
                IncompatibleOverrideReturnTypeContext.$$$reportNull$$$0(0);
            }
            if (methodReturnType == null) {
                IncompatibleOverrideReturnTypeContext.$$$reportNull$$$0(1);
            }
            if (superMethod == null) {
                IncompatibleOverrideReturnTypeContext.$$$reportNull$$$0(2);
            }
            if (superMethodReturnType == null) {
                IncompatibleOverrideReturnTypeContext.$$$reportNull$$$0(3);
            }
        }

        @NotNull
        public PsiMethod method() {
            PsiMethod psiMethod = this.method;
            if (psiMethod == null) {
                IncompatibleOverrideReturnTypeContext.$$$reportNull$$$0(4);
            }
            return psiMethod;
        }

        @NotNull
        public PsiType methodReturnType() {
            PsiType psiType = this.methodReturnType;
            if (psiType == null) {
                IncompatibleOverrideReturnTypeContext.$$$reportNull$$$0(5);
            }
            return psiType;
        }

        @NotNull
        public PsiMethod superMethod() {
            PsiMethod psiMethod = this.superMethod;
            if (psiMethod == null) {
                IncompatibleOverrideReturnTypeContext.$$$reportNull$$$0(6);
            }
            return psiMethod;
        }

        @NotNull
        public PsiType superMethodReturnType() {
            PsiType psiType = this.superMethodReturnType;
            if (psiType == null) {
                IncompatibleOverrideReturnTypeContext.$$$reportNull$$$0(7);
            }
            return psiType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodReturnType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superMethod";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superMethodReturnType";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$IncompatibleOverrideReturnTypeContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$IncompatibleOverrideReturnTypeContext";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "method";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "methodReturnType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "superMethod";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "superMethodReturnType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    public record OverrideClashContext(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        @NotNull
        private final PsiMethod method;
        @NotNull
        private final PsiMethod superMethod;

        public OverrideClashContext(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
            if (method == null) {
                OverrideClashContext.$$$reportNull$$$0(0);
            }
            if (superMethod == null) {
                OverrideClashContext.$$$reportNull$$$0(1);
            }
        }

        boolean sameClass() {
            PsiClass cls1 = this.method.getContainingClass();
            PsiClass cls2 = this.superMethod.getContainingClass();
            return cls1 != null && cls2 != null && cls1.isEquivalentTo((PsiElement)cls2);
        }

        @NotNull
        @Nls
        String clashMessage() {
            String string = JavaErrorFormatUtil.formatClashMethodMessage(this.method, this.superMethod);
            if (string == null) {
                OverrideClashContext.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public PsiMethod method() {
            PsiMethod psiMethod = this.method;
            if (psiMethod == null) {
                OverrideClashContext.$$$reportNull$$$0(3);
            }
            return psiMethod;
        }

        @NotNull
        public PsiMethod superMethod() {
            PsiMethod psiMethod = this.superMethod;
            if (psiMethod == null) {
                OverrideClashContext.$$$reportNull$$$0(4);
            }
            return psiMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superMethod";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$OverrideClashContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$OverrideClashContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clashMessage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "method";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "superMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public record TypeParameterBoundMismatchContext(@NotNull PsiTypeParameter parameter, @NotNull PsiType bound, @NotNull PsiType actualType) {
        @NotNull
        private final PsiTypeParameter parameter;
        @NotNull
        private final PsiType bound;
        @NotNull
        private final PsiType actualType;

        public TypeParameterBoundMismatchContext(@NotNull PsiTypeParameter parameter, @NotNull PsiType bound, @NotNull PsiType actualType) {
            if (parameter == null) {
                TypeParameterBoundMismatchContext.$$$reportNull$$$0(0);
            }
            if (bound == null) {
                TypeParameterBoundMismatchContext.$$$reportNull$$$0(1);
            }
            if (actualType == null) {
                TypeParameterBoundMismatchContext.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        public PsiTypeParameter parameter() {
            PsiTypeParameter psiTypeParameter = this.parameter;
            if (psiTypeParameter == null) {
                TypeParameterBoundMismatchContext.$$$reportNull$$$0(3);
            }
            return psiTypeParameter;
        }

        @NotNull
        public PsiType bound() {
            PsiType psiType = this.bound;
            if (psiType == null) {
                TypeParameterBoundMismatchContext.$$$reportNull$$$0(4);
            }
            return psiType;
        }

        @NotNull
        public PsiType actualType() {
            PsiType psiType = this.actualType;
            if (psiType == null) {
                TypeParameterBoundMismatchContext.$$$reportNull$$$0(5);
            }
            return psiType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bound";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actualType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$TypeParameterBoundMismatchContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$TypeParameterBoundMismatchContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "bound";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "actualType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public record IncompatibleIntersectionContext(@NotNull PsiTypeParameter parameter, @NotNull @Nls String message) {
        @NotNull
        private final PsiTypeParameter parameter;
        @NotNull
        @Nls
        private final String message;

        public IncompatibleIntersectionContext(@NotNull PsiTypeParameter parameter, @NotNull @Nls String message) {
            if (parameter == null) {
                IncompatibleIntersectionContext.$$$reportNull$$$0(0);
            }
            if (message == null) {
                IncompatibleIntersectionContext.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public PsiTypeParameter parameter() {
            PsiTypeParameter psiTypeParameter = this.parameter;
            if (psiTypeParameter == null) {
                IncompatibleIntersectionContext.$$$reportNull$$$0(2);
            }
            return psiTypeParameter;
        }

        @NotNull
        @Nls
        public String message() {
            String string = this.message;
            if (string == null) {
                IncompatibleIntersectionContext.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$IncompatibleIntersectionContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$IncompatibleIntersectionContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parameter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public record ClassStaticReferenceErrorContext(@NotNull PsiClass outerClass, @Nullable PsiClass innerClass, @NotNull PsiElement place) {
        @NotNull
        private final PsiClass outerClass;
        @NotNull
        private final PsiElement place;

        public ClassStaticReferenceErrorContext(@NotNull PsiClass outerClass, @Nullable PsiClass innerClass, @NotNull PsiElement place) {
            if (outerClass == null) {
                ClassStaticReferenceErrorContext.$$$reportNull$$$0(0);
            }
            if (place == null) {
                ClassStaticReferenceErrorContext.$$$reportNull$$$0(1);
            }
        }

        @Nullable
        public PsiModifierListOwner enclosingStaticElement() {
            return PsiUtil.getEnclosingStaticElement((PsiElement)this.place, (PsiClass)this.outerClass);
        }

        @NotNull
        public PsiClass outerClass() {
            PsiClass psiClass = this.outerClass;
            if (psiClass == null) {
                ClassStaticReferenceErrorContext.$$$reportNull$$$0(2);
            }
            return psiClass;
        }

        @NotNull
        public PsiElement place() {
            PsiElement psiElement = this.place;
            if (psiElement == null) {
                ClassStaticReferenceErrorContext.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outerClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$ClassStaticReferenceErrorContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$ClassStaticReferenceErrorContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "outerClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public record AnnotationValueErrorContext(@NotNull PsiAnnotationMethod method, @NotNull PsiType expectedType, boolean fromDefaultValue) {
        @NotNull
        private final PsiAnnotationMethod method;
        @NotNull
        private final PsiType expectedType;

        public AnnotationValueErrorContext(@NotNull PsiAnnotationMethod method, @NotNull PsiType expectedType, boolean fromDefaultValue) {
            if (method == null) {
                AnnotationValueErrorContext.$$$reportNull$$$0(0);
            }
            if (expectedType == null) {
                AnnotationValueErrorContext.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String typeText() {
            String string = PsiTypesUtil.removeExternalAnnotations((PsiType)this.expectedType()).getInternalCanonicalText();
            if (string == null) {
                AnnotationValueErrorContext.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public static AnnotationValueErrorContext from(@NotNull PsiAnnotationMemberValue value, @NotNull PsiAnnotationMethod method, @NotNull PsiType expectedType) {
            AnnotationValueErrorContext context;
            if (value == null) {
                AnnotationValueErrorContext.$$$reportNull$$$0(3);
            }
            if (method == null) {
                AnnotationValueErrorContext.$$$reportNull$$$0(4);
            }
            if (expectedType == null) {
                AnnotationValueErrorContext.$$$reportNull$$$0(5);
            }
            boolean fromDefaultValue = PsiTreeUtil.isAncestor((PsiElement)method.getDefaultValue(), (PsiElement)value, (boolean)false);
            AnnotationValueErrorContext annotationValueErrorContext = context = new AnnotationValueErrorContext(method, expectedType, fromDefaultValue);
            if (annotationValueErrorContext == null) {
                AnnotationValueErrorContext.$$$reportNull$$$0(6);
            }
            return annotationValueErrorContext;
        }

        @NotNull
        public PsiAnnotationMethod method() {
            PsiAnnotationMethod psiAnnotationMethod = this.method;
            if (psiAnnotationMethod == null) {
                AnnotationValueErrorContext.$$$reportNull$$$0(7);
            }
            return psiAnnotationMethod;
        }

        @NotNull
        public PsiType expectedType() {
            PsiType psiType = this.expectedType;
            if (psiType == null) {
                AnnotationValueErrorContext.$$$reportNull$$$0(8);
            }
            return psiType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedType";
                    break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$AnnotationValueErrorContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$AnnotationValueErrorContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "typeText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "method";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expectedType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    public record DuplicateMethodsContext(@NotNull @NotNull List<@NotNull PsiMethod> methods) {
        @NotNull
        private final @NotNull List<@NotNull PsiMethod> methods;

        public DuplicateMethodsContext(@NotNull @NotNull List<@NotNull PsiMethod> methods) {
            if (methods == null) {
                DuplicateMethodsContext.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public @NotNull List<@NotNull PsiMethod> methods() {
            List<PsiMethod> list = this.methods;
            if (list == null) {
                DuplicateMethodsContext.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methods";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$DuplicateMethodsContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaErrorKinds$DuplicateMethodsContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "methods";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

