/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.temporal.CreateTimeZoneMethodsRecordNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.ParseISODateTimeResult;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToTemporalZonedDateTimeNode
extends JavaScriptBaseNode {
    protected ToTemporalZonedDateTimeNode() {
    }

    public abstract JSTemporalZonedDateTimeObject execute(Object var1, JSDynamicObject var2);

    @Specialization
    public JSTemporalZonedDateTimeObject toTemporalZonedDateTime(Object item, JSDynamicObject options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isZonedDateTimeProfile, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached ToTemporalTimeZoneNode toTemporalTimeZone, @Cached GetTemporalCalendarWithISODefaultNode getTemporalCalendarNode, @Cached ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
        JSTemporalDateTimeRecord result;
        JSDynamicObject timeZone;
        JSDynamicObject calendar;
        assert (options != null);
        TruffleString offsetString = null;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        TemporalUtil.OffsetBehaviour offsetBehaviour = TemporalUtil.OffsetBehaviour.OPTION;
        TemporalUtil.MatchBehaviour matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_EXACTLY;
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = (JSDynamicObject)item;
            if (isZonedDateTimeProfile.profile(this, TemporalUtil.isTemporalZonedDateTime(itemObj))) {
                return (JSTemporalZonedDateTimeObject)itemObj;
            }
            calendar = getTemporalCalendarNode.execute(itemObj);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listDHMMMMMNSY);
            Boundaries.listAdd(fieldNames, TemporalConstants.TIME_ZONE);
            Boundaries.listAdd(fieldNames, TemporalConstants.OFFSET);
            JSObject fields = TemporalUtil.prepareTemporalFields(ctx, itemObj, fieldNames, TemporalUtil.listTimeZone);
            Object timeZoneObj = JSObject.get((JSDynamicObject)fields, TemporalConstants.TIME_ZONE);
            timeZone = toTemporalTimeZone.execute(timeZoneObj);
            Object offsetStringObj = JSObject.get((JSDynamicObject)fields, TemporalConstants.OFFSET);
            if (offsetStringObj == Undefined.instance) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.WALL;
            } else {
                offsetString = toStringNode.executeString(offsetStringObj);
            }
            result = TemporalUtil.interpretTemporalDateTimeFields(calendar, fields, options, getOptionNode, dateFromFieldsNode);
        } else {
            TemporalUtil.toTemporalOverflow(options, getOptionNode);
            TruffleString string = toStringNode.executeString(item);
            ParseISODateTimeResult resultZDT = TemporalUtil.parseTemporalZonedDateTimeString(string);
            result = resultZDT;
            TruffleString timeZoneName = resultZDT.getTimeZoneResult().getName();
            assert (timeZoneName != null);
            if (!TemporalUtil.canParseAsTimeZoneNumericUTCOffset(timeZoneName)) {
                if (!TemporalUtil.isValidTimeZoneName(timeZoneName)) {
                    errorBranch.enter(this);
                    throw TemporalErrors.createRangeErrorInvalidTimeZoneString();
                }
                timeZoneName = TemporalUtil.canonicalizeTimeZoneName(timeZoneName);
            }
            offsetString = resultZDT.getTimeZoneResult().getOffsetString();
            offsetBehaviour = resultZDT.getTimeZoneResult().isZ() ? TemporalUtil.OffsetBehaviour.EXACT : TemporalUtil.OffsetBehaviour.WALL;
            timeZone = TemporalUtil.createTemporalTimeZone(ctx, realm, timeZoneName);
            calendar = toTemporalCalendarWithISODefaultNode.execute(result.getCalendar());
            matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_MINUTES;
        }
        long offsetNanoseconds = 0L;
        if (offsetBehaviour == TemporalUtil.OffsetBehaviour.OPTION) {
            offsetNanoseconds = TemporalUtil.parseTimeZoneOffsetString(offsetString);
        }
        TemporalUtil.Disambiguation disambiguation = TemporalUtil.toTemporalDisambiguation(options, getOptionNode, equalNode);
        TemporalUtil.OffsetOption offset = TemporalUtil.toTemporalOffset(options, TemporalConstants.REJECT, getOptionNode, equalNode);
        TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
        BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), offsetBehaviour, offsetNanoseconds, timeZoneRec, disambiguation, offset, matchBehaviour);
        return JSTemporalZonedDateTime.create(ctx, realm, epochNanoseconds, timeZone, calendar);
    }
}

