/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.properties.datasource;

import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.microservices.jvm.config.properties.MicroservicePropertiesDocument;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.database.ConfigDataSourceCandidate;
import com.intellij.persistence.database.ConfigDataSourcePropertyInfo;
import com.intellij.persistence.database.ConfigDataSourceProvider;
import com.intellij.persistence.database.DataSourceConfigType;
import com.intellij.persistence.database.config.properties.processor.PropertiesConfigDataSourceProcessorKt;
import com.intellij.persistence.database.config.properties.processor.PropertiesConfigFileProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.model.SpringBootPropertiesFileUtil;
import com.intellij.spring.boot.properties.datasource.SpringBootPropertiesConfigDatasourceLineMarkerProviderKt;
import com.intellij.spring.boot.properties.datasource.SpringDataSourceConfigType;
import com.intellij.spring.boot.properties.datasource.SpringDataSourceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J$\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0018H\u0016JH\u0010\u0019\u001a \u0012\u0004\u0012\u00020\u001b\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00180\u000b0\u001a2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000b0\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/intellij/spring/boot/properties/datasource/SpringBootPropertiesConfigFileProcessor;", "Lcom/intellij/persistence/database/config/properties/processor/PropertiesConfigFileProcessor;", "Lcom/intellij/spring/boot/properties/datasource/SpringDataSourceConfigType;", "Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "<init>", "()V", "dataSourceProvider", "Lcom/intellij/persistence/database/ConfigDataSourceProvider;", "getDataSourceProvider", "()Lcom/intellij/persistence/database/ConfigDataSourceProvider;", "supportedDataSourceTypes", "", "getSupportedDataSourceTypes", "()Ljava/util/List;", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "belongsToConfig", "property", "Lcom/intellij/lang/properties/psi/Property;", "candidate", "Lcom/intellij/persistence/database/ConfigDataSourceCandidate;", "collectDatasourceCandidatesInfo", "", "Lcom/intellij/microservices/jvm/config/properties/MicroservicePropertiesDocument;", "propertiesByDocument", "getDocuments", "file", "Lcom/intellij/lang/properties/psi/impl/PropertiesFileImpl;", "intellij.spring.boot.properties.datasource"})
@SourceDebugExtension(value={"SMAP\nSpringBootPropertiesConfigDatasourceLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootPropertiesConfigDatasourceLineMarkerProvider.kt\ncom/intellij/spring/boot/properties/datasource/SpringBootPropertiesConfigFileProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1205#2,2:94\n1282#2,2:96\n1642#2,10:98\n1915#2:108\n296#2,2:109\n1916#2:112\n1652#2:113\n1696#2,8:114\n1285#2:122\n1#3:111\n*S KotlinDebug\n*F\n+ 1 SpringBootPropertiesConfigDatasourceLineMarkerProvider.kt\ncom/intellij/spring/boot/properties/datasource/SpringBootPropertiesConfigFileProcessor\n*L\n54#1:94,2\n54#1:96,2\n56#1:98,10\n56#1:108\n57#1:109,2\n56#1:112\n56#1:113\n62#1:114,8\n54#1:122\n56#1:111\n*E\n"})
public final class SpringBootPropertiesConfigFileProcessor
extends PropertiesConfigFileProcessor<SpringDataSourceConfigType, ConfigDataSourcePropertyInfo> {
    @NotNull
    private final ConfigDataSourceProvider<SpringDataSourceConfigType, ConfigDataSourcePropertyInfo> dataSourceProvider = new SpringDataSourceProvider();
    @NotNull
    private final List<SpringDataSourceConfigType> supportedDataSourceTypes = (List)SpringDataSourceConfigType.getEntries();

    @NotNull
    public ConfigDataSourceProvider<SpringDataSourceConfigType, ConfigDataSourcePropertyInfo> getDataSourceProvider() {
        return this.dataSourceProvider;
    }

    @NotNull
    public List<SpringDataSourceConfigType> getSupportedDataSourceTypes() {
        return this.supportedDataSourceTypes;
    }

    public boolean isApplicable(@Nullable Module module, @Nullable Project project) {
        return SpringBootPropertiesConfigDatasourceLineMarkerProviderKt.hasSpringBoot(module, project);
    }

    public boolean belongsToConfig(@NotNull Property property, @NotNull ConfigDataSourceCandidate<SpringDataSourceConfigType, ConfigDataSourcePropertyInfo> candidate) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(candidate, (String)"candidate");
        return PropertiesConfigDataSourceProcessorKt.belongsToDbConfig((Property)property, (DataSourceConfigType)candidate.getConfigType());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<MicroservicePropertiesDocument, List<ConfigDataSourceCandidate<SpringDataSourceConfigType, ConfigDataSourcePropertyInfo>>> collectDatasourceCandidatesInfo(@NotNull Map<MicroservicePropertiesDocument, ? extends List<? extends Property>> propertiesByDocument, @NotNull Module module) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(propertiesByDocument, (String)"propertiesByDocument");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable $this$associate$iv = propertiesByDocument.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$distinctBy$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            MicroservicePropertiesDocument document = (MicroservicePropertiesDocument)entry.getKey();
            List properties = (List)entry.getValue();
            Iterable iterable2 = properties;
            boolean $i$f$mapNotNull = false;
            void var18_18 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ConfigDataSourceCandidate configDataSourceCandidate;
                Object v0;
                Property propertyImpl;
                block6: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    propertyImpl = (Property)element$iv$iv2;
                    boolean bl3 = false;
                    Iterable $this$firstOrNull$iv = this.getSupportedDataSourceTypes();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SpringDataSourceConfigType configType = (SpringDataSourceConfigType)((Object)element$iv);
                        boolean bl4 = false;
                        if (!PropertiesConfigDataSourceProcessorKt.belongsToDbConfig((Property)propertyImpl, (DataSourceConfigType)configType)) continue;
                        v0 = element$iv;
                        break block6;
                    }
                    v0 = null;
                }
                SpringDataSourceConfigType applicableConfig = v0;
                if (applicableConfig != null) {
                    boolean bl5 = false;
                    ConfigDataSourcePropertyInfo info = new ConfigDataSourcePropertyInfo((PsiElement)propertyImpl, document.getDocumentId());
                    configDataSourceCandidate = new ConfigDataSourceCandidate(info, (DataSourceConfigType)applicableConfig);
                } else {
                    configDataSourceCandidate = null;
                }
                if (configDataSourceCandidate == null) continue;
                ConfigDataSourceCandidate it$iv$iv = configDataSourceCandidate;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$distinctBy = false;
            HashSet<SpringDataSourceConfigType> set$iv = new HashSet<SpringDataSourceConfigType>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                ConfigDataSourceCandidate it = (ConfigDataSourceCandidate)e$iv;
                boolean bl7 = false;
                SpringDataSourceConfigType key$iv = (SpringDataSourceConfigType)it.getConfigType();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            List candidates = list$iv;
            entry = TuplesKt.to((Object)document, (Object)candidates);
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public List<MicroservicePropertiesDocument> getDocuments(@NotNull Module module, @NotNull PropertiesFileImpl file) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SpringBootPropertiesFileUtil.Companion.getInstance().getDocuments((PsiFile)file, module);
    }
}

