/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.properties.datasource.config.processor;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.spring.boot.properties.datasource.config.processor.DataSourceSettingsFormatter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/boot/properties/datasource/config/processor/CassandraDataSourceSettingsFormatter;", "Lcom/intellij/spring/boot/properties/datasource/config/processor/DataSourceSettingsFormatter;", "<init>", "()V", "format", "", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "canProcess", "", "intellij.spring.boot.properties.datasource"})
public final class CassandraDataSourceSettingsFormatter
implements DataSourceSettingsFormatter {
    @Override
    @NotNull
    public Map<String, String> format(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        String string = dataSource.getUrl();
        String url = string != null ? StringsKt.substringAfter$default((String)string, (String)"jdbc:cassandra://", null, (int)2, null) : null;
        Pair[] pairArray = new Pair[5];
        String string2 = url;
        if (string2 == null || (string2 = StringsKt.substringBefore$default((String)string2, (char)':', null, (int)2, null)) == null) {
            string2 = "127.0.0.1";
        }
        pairArray[0] = TuplesKt.to((Object)"spring.cassandra.contact-points", (Object)string2);
        Object object = url;
        pairArray[1] = TuplesKt.to((Object)"spring.cassandra.port", (Object)String.valueOf(object != null && (object = StringsKt.substringAfter((String)object, (char)':', (String)"")) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 9042));
        String string3 = url;
        if (string3 == null || (string3 = StringsKt.substringAfterLast$default((String)string3, (char)'/', null, (int)2, null)) == null) {
            string3 = "";
        }
        pairArray[2] = TuplesKt.to((Object)"spring.cassandra.keyspace-name", (Object)string3);
        pairArray[3] = TuplesKt.to((Object)"spring.cassandra.username", (Object)dataSource.getUsername());
        pairArray[4] = TuplesKt.to((Object)"spring.cassandra.password", (Object)"");
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public boolean canProcess(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return dataSource.getDbms().isCassandra();
    }
}

