/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.highlighting.quickFix;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.spring.modulith.SpringModulithBundle;
import com.intellij.spring.modulith.highlighting.quickFix.SpringModulithHighlightingFixService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\r\u0010\u000e\u001a\u00070\u0004\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/spring/modulith/highlighting/quickFix/SpringModulithMarkClassNamedInterfaceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "className", "", "classFqn", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "applyFix", "", "descriptor", "intellij.spring.modulith"})
public final class SpringModulithMarkClassNamedInterfaceFix
implements LocalQuickFix,
PriorityAction {
    @NotNull
    private final String className;
    @NotNull
    private final String classFqn;

    public SpringModulithMarkClassNamedInterfaceFix(@NotNull String className, @NotNull String classFqn) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        this.className = className;
        this.classFqn = classFqn;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.className};
        return SpringModulithBundle.message("quickfix.mark.class.named.interface", objectArray);
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.NORMAL;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)descriptor.getPsiElement());
        if (module == null) {
            return;
        }
        Module module2 = module;
        SpringModulithHighlightingFixService.Companion.getInstance(project).markClassAsNamedInterface$intellij_spring_modulith(this.classFqn, module2);
    }
}

