/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.verification;

import com.intellij.psi.PsiClass;
import com.intellij.spring.modulith.SpringModulithUtilsKt;
import com.intellij.spring.modulith.model.ApplicationModule;
import com.intellij.spring.modulith.model.ModulithDependency;
import com.intellij.spring.modulith.model.NamedInterface;
import com.intellij.spring.modulith.verification.AccessErrorType;
import com.intellij.spring.modulith.verification.AccessVerificationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u001a\"\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a.\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"verifyApiAccess", "Lcom/intellij/spring/modulith/verification/AccessVerificationResult;", "source", "Lcom/intellij/psi/PsiClass;", "target", "appModules", "", "Lcom/intellij/spring/modulith/model/ApplicationModule;", "checkAllowedDependencies", "currentModule", "targetModule", "targetFqn", "", "checkPublicApiUsed", "sourceModule", "ACCESS_ALLOWED", "intellij.spring.modulith"})
@SourceDebugExtension(value={"SMAP\nspringModulithVerification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 springModulithVerification.kt\ncom/intellij/spring/modulith/verification/SpringModulithVerificationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1#2:134\n1807#3,3:135\n1807#3,3:138\n1391#3:141\n1480#3,5:142\n*S KotlinDebug\n*F\n+ 1 springModulithVerification.kt\ncom/intellij/spring/modulith/verification/SpringModulithVerificationKt\n*L\n61#1:135,3\n76#1:138,3\n96#1:141\n96#1:142,5\n*E\n"})
public final class SpringModulithVerificationKt {
    @NotNull
    private static final AccessVerificationResult ACCESS_ALLOWED = new AccessVerificationResult(true, null, null, null, null);

    @NotNull
    public static final AccessVerificationResult verifyApiAccess(@NotNull PsiClass source, @NotNull PsiClass target, @NotNull List<ApplicationModule> appModules) {
        AccessVerificationResult dependenciesVerificationResult;
        Object v3;
        ApplicationModule currentModule;
        String targetFqn;
        block7: {
            Object object;
            Object object22;
            block6: {
                String string;
                String sourceFqn;
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter(appModules, (String)"appModules");
                String string2 = source.getQualifiedName();
                if (string2 == null) {
                    string2 = sourceFqn = "";
                }
                if ((string = target.getQualifiedName()) == null) {
                    string = "";
                }
                targetFqn = string;
                Iterable iterable = appModules;
                for (Object object22 : iterable) {
                    ApplicationModule it = (ApplicationModule)object22;
                    boolean bl = false;
                    if (!it.hasClass(sourceFqn)) continue;
                    object = object22;
                    break block6;
                }
                object = null;
            }
            currentModule = (ApplicationModule)object;
            Iterable iterable = appModules;
            object22 = iterable.iterator();
            while (object22.hasNext()) {
                Object e = object22.next();
                ApplicationModule it = (ApplicationModule)e;
                boolean bl = false;
                if (!it.hasClass(targetFqn)) continue;
                v3 = e;
                break block7;
            }
            v3 = null;
        }
        ApplicationModule targetModule = v3;
        if (currentModule == null || targetModule == null || Intrinsics.areEqual((Object)currentModule, (Object)targetModule)) {
            return ACCESS_ALLOWED;
        }
        AccessVerificationResult accessVerificationResult = dependenciesVerificationResult = SpringModulithVerificationKt.checkAllowedDependencies(currentModule, targetModule, targetFqn);
        if (accessVerificationResult != null) {
            return accessVerificationResult;
        }
        return SpringModulithVerificationKt.checkPublicApiUsed(currentModule, targetModule, targetFqn, appModules);
    }

    private static final AccessVerificationResult checkAllowedDependencies(ApplicationModule currentModule, ApplicationModule targetModule, String targetFqn) {
        boolean bl;
        block12: {
            Iterable $this$any$iv;
            Object v0;
            List<ModulithDependency> allowedDependencies;
            block10: {
                allowedDependencies = currentModule.getAllowedDependencies();
                if (allowedDependencies == null) {
                    return null;
                }
                Iterable iterable = targetModule.getNamedInterfaces();
                for (Object object : iterable) {
                    NamedInterface it = (NamedInterface)object;
                    boolean bl2 = false;
                    if (!it.getTypes().contains(targetFqn)) continue;
                    v0 = object;
                    break block10;
                }
                v0 = null;
            }
            NamedInterface targetNamedInterface = v0;
            if (allowedDependencies.isEmpty()) {
                String dependency = targetNamedInterface != null && !Intrinsics.areEqual((Object)targetNamedInterface.getName(), (Object)"<<UNNAMED>>") ? targetModule.getId() + " :: " + targetNamedInterface.getName() : targetModule.getId();
                return new AccessVerificationResult(false, AccessErrorType.NO_ALLOWED_DEPENDENCIES, dependency, currentModule, targetModule);
            }
            if (targetNamedInterface != null && !Intrinsics.areEqual((Object)targetNamedInterface.getName(), (Object)"<<UNNAMED>>")) {
                boolean bl3;
                block11: {
                    $this$any$iv = allowedDependencies;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ModulithDependency dependency = (ModulithDependency)element$iv;
                            boolean bl4 = false;
                            if (!(dependency instanceof ModulithDependency.NamedInterfaceModulithDependency && Intrinsics.areEqual((Object)((ModulithDependency.NamedInterfaceModulithDependency)dependency).getModuleId(), (Object)targetModule.getId()) && (Intrinsics.areEqual((Object)((ModulithDependency.NamedInterfaceModulithDependency)dependency).getNamedInterfaceId(), (Object)targetNamedInterface.getName()) || Intrinsics.areEqual((Object)((ModulithDependency.NamedInterfaceModulithDependency)dependency).getNamedInterfaceId(), (Object)"*")))) continue;
                            bl3 = true;
                            break block11;
                        }
                        bl3 = false;
                    }
                }
                boolean isTargetNamedInterfaceAllowed = bl3;
                return isTargetNamedInterfaceAllowed ? null : new AccessVerificationResult(false, AccessErrorType.DEPENDENCY_NOT_ALLOWED, targetModule.getId() + " :: " + targetNamedInterface.getName(), currentModule, targetModule);
            }
            $this$any$iv = allowedDependencies;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ModulithDependency dependency = (ModulithDependency)element$iv;
                    boolean bl5 = false;
                    if (!(dependency instanceof ModulithDependency.ModuleModulithDependency && Intrinsics.areEqual((Object)((ModulithDependency.ModuleModulithDependency)dependency).getModuleId(), (Object)targetModule.getId()))) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        boolean isTargetModuleAllowed = bl;
        return isTargetModuleAllowed ? null : new AccessVerificationResult(false, AccessErrorType.DEPENDENCY_NOT_ALLOWED, targetModule.getId(), currentModule, targetModule);
    }

    /*
     * WARNING - void declaration
     */
    private static final AccessVerificationResult checkPublicApiUsed(ApplicationModule sourceModule, ApplicationModule targetModule, String targetFqn, List<ApplicationModule> appModules) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = targetModule.getNamedInterfaces();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NamedInterface it = (NamedInterface)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getTypes();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List publicTypes = (List)destination$iv$iv;
        boolean isPublicApiAccessed = publicTypes.contains(targetFqn);
        if (isPublicApiAccessed) {
            ApplicationModule targetParentModule = SpringModulithUtilsKt.getParentModule(targetModule, appModules);
            if (targetParentModule == null) {
                return ACCESS_ALLOWED;
            }
            ApplicationModule sourceParentModule = SpringModulithUtilsKt.getParentModule(sourceModule, appModules);
            return Intrinsics.areEqual((Object)sourceParentModule, (Object)targetParentModule) ? ACCESS_ALLOWED : new AccessVerificationResult(false, AccessErrorType.INTERNAL_API_USED, targetModule.getId(), sourceModule, targetModule);
        }
        return new AccessVerificationResult(false, AccessErrorType.INTERNAL_API_USED, null, sourceModule, targetModule);
    }
}

