/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.ExecuteRunConfigurationTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.build.GradleExecutionEnvironmentProvider;
import org.jetbrains.plugins.gradle.execution.build.GradleInitScriptParameters;
import org.jetbrains.plugins.gradle.execution.target.GradleServerEnvironmentSetup;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleData;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 %2\u00020\u0001:\u0003%&'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\rH\u0014J$\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider;", "Lorg/jetbrains/plugins/gradle/execution/build/GradleExecutionEnvironmentProvider;", "<init>", "()V", "generateInitScript", "", "params", "Lorg/jetbrains/plugins/gradle/execution/build/GradleInitScriptParameters;", "argsString", "Lcom/intellij/execution/configurations/JavaParameters;", "definitionsString", "getMainClass", "profile", "Lcom/intellij/execution/JavaRunConfigurationBase;", "getConfigurationRunName", "configureParameters", "runProfile", "createExecutionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "executeRunConfigurationTask", "Lcom/intellij/task/ExecuteRunConfigurationTask;", "executor", "Lcom/intellij/execution/Executor;", "isTestModule", "", "module", "Lcom/intellij/openapi/module/Module;", "withJavaConfiguration", "Lorg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider$GradleInitScriptParametersBuilder;", "resolveRunConfigurationJdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "customiseTaskExecutionsSettings", "", "taskSettings", "Lcom/intellij/openapi/externalSystem/model/execution/ExternalSystemTaskExecutionSettings;", "Companion", "GradleInitScriptParametersBuilder", "GradleInitScriptParametersImpl", "intellij.gradle.java"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nGradleBaseApplicationEnvironmentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBaseApplicationEnvironmentProvider.kt\norg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n777#2:281\n873#2,2:282\n*S KotlinDebug\n*F\n+ 1 GradleBaseApplicationEnvironmentProvider.kt\norg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider\n*L\n146#1:281\n146#1:282,2\n*E\n"})
public abstract class GradleBaseApplicationEnvironmentProvider
implements GradleExecutionEnvironmentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected String generateInitScript(@NotNull GradleInitScriptParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String scriptText = GradleInitScriptUtil.loadApplicationInitScript((String)params.getGradleTaskPath(), (String)params.getRunAppTaskName(), (String)params.getMainClass(), (String)params.getJavaExePath(), (String)params.getSourceSetName(), (String)params.getParams(), (String)params.getDefinitions(), null, (String)params.getWorkingDirectory(), (params.getConfiguration().getShortenCommandLine() == ShortenCommandLine.MANIFEST ? 1 : 0) != 0, (params.getConfiguration().getShortenCommandLine() == ShortenCommandLine.ARGS_FILE ? 1 : 0) != 0, (boolean)false, (String)params.getJavaModuleName());
        return scriptText;
    }

    @NotNull
    protected String argsString(@NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List list = params.getProgramParametersList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
        String string = Companion.createEscapedParameters(list, "args");
        List list2 = params.getVMParametersList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
        return string + Companion.createEscapedParameters(list2, "jvmArgs");
    }

    @NotNull
    protected String definitionsString(@NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return "";
    }

    @Nullable
    protected String getMainClass(@NotNull JavaRunConfigurationBase profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile.getRunClass();
    }

    @Nullable
    protected String getConfigurationRunName(@NotNull JavaRunConfigurationBase profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.getMainClass(profile);
    }

    @Nullable
    protected JavaParameters configureParameters(@NotNull JavaRunConfigurationBase runProfile) {
        JavaParameters javaParameters;
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        JavaParameters $this$configureParameters_u24lambda_u240 = javaParameters = new JavaParameters();
        boolean bl = false;
        JavaParametersUtil.configureConfiguration((SimpleJavaParameters)((SimpleJavaParameters)$this$configureParameters_u24lambda_u240), (CommonJavaRunConfigurationParameters)((CommonJavaRunConfigurationParameters)runProfile));
        $this$configureParameters_u24lambda_u240.getVMParametersList().addParametersString(runProfile.getVMParameters());
        return javaParameters;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ExecuteRunConfigurationTask executeRunConfigurationTask, @Nullable Executor executor) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String string;
        Object it;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executeRunConfigurationTask, (String)"executeRunConfigurationTask");
        if (!this.isApplicable(executeRunConfigurationTask)) {
            return null;
        }
        RunProfile runProfile = executeRunConfigurationTask.getRunProfile();
        Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
        RunProfile runProfile2 = runProfile;
        if (!(runProfile2 instanceof JavaRunConfigurationBase)) {
            return null;
        }
        String string2 = (String)ActionsKt.runReadAction(() -> GradleBaseApplicationEnvironmentProvider.createExecutionEnvironment$lambda$0(this, runProfile2));
        if (string2 == null) {
            return null;
        }
        String mainClass = string2;
        String string3 = (String)ActionsKt.runReadAction(() -> GradleBaseApplicationEnvironmentProvider.createExecutionEnvironment$lambda$1(this, runProfile2));
        if (string3 == null) {
            return null;
        }
        String configurationRunName = string3;
        Module module = ((JavaRunConfigurationModule)((JavaRunConfigurationBase)runProfile2).getConfigurationModule()).getModule();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        String javaModuleName = ((JavaRunConfigurationBase)runProfile2).findJavaModuleName(this.isTestModule(module2));
        GradleModuleData gradleModuleData = CachedModuleDataFinder.Companion.getGradleModuleData(module2);
        if (gradleModuleData == null) {
            return null;
        }
        GradleModuleData gradleModuleData2 = gradleModuleData;
        String externalProjectPath = gradleModuleData2.getDirectoryToRunTask();
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)gradleSettings, (String)"getInstance(...)");
        GradleSettings settings = gradleSettings;
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)settings.getLinkedProjectSettings(externalProjectPath);
        if (gradleProjectSettings == null) {
            return null;
        }
        GradleProjectSettings projectSettings = gradleProjectSettings;
        if (!projectSettings.isResolveModulePerSourceSet()) {
            return null;
        }
        JavaParameters javaParameters = this.configureParameters((JavaRunConfigurationBase)runProfile2);
        if (javaParameters == null) {
            return null;
        }
        JavaParameters params = javaParameters;
        ExternalSystemTaskExecutionSettings taskSettings = new ExternalSystemTaskExecutionSettings();
        taskSettings.setPassParentEnvs(params.isPassParentEnvs());
        taskSettings.setEnv(params.getEnv().isEmpty() ? MapsKt.emptyMap() : (Map)new HashMap(params.getEnv()));
        taskSettings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        taskSettings.setExternalProjectPath(externalProjectPath);
        String runAppTaskName = configurationRunName + ".main()";
        taskSettings.setTaskNames(CollectionsKt.listOf((Object)gradleModuleData2.getTaskPathOfSimpleTaskName(runAppTaskName)));
        this.customiseTaskExecutionsSettings(taskSettings, module2);
        Object object = executor;
        if (object == null || (object = object.getId()) == null) {
            object = "Run";
        }
        Object executorId = object;
        ExecutionEnvironment executionEnvironment = ExternalSystemUtil.createExecutionEnvironment((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemTaskExecutionSettings)taskSettings, (String)executorId);
        if (executionEnvironment == null) {
            return null;
        }
        ExecutionEnvironment environment = executionEnvironment;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        Intrinsics.checkNotNull((Object)runnerAndConfigurationSettings);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
        RunConfiguration runConfiguration = runnerAndConfigurationSettings2.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration");
        ExternalSystemRunConfiguration gradleRunConfiguration = (ExternalSystemRunConfiguration)runConfiguration;
        String string4 = GradleProjectResolverUtil.getGradleIdentityPathOrNull((Module)module2);
        if (string4 == null) {
            return null;
        }
        String gradlePath = string4;
        String string5 = GradleProjectResolverUtil.getSourceSetName((Module)module2);
        if (string5 == null) {
            return null;
        }
        String sourceSetName = string5;
        String string6 = ProgramParametersUtil.getWorkingDir((CommonProgramRunConfigurationParameters)((CommonProgramRunConfigurationParameters)runProfile2), (Project)module2.getProject(), (Module)module2);
        if (string6 != null) {
            it = string6;
            boolean bl = false;
            string = FileUtil.toSystemIndependentName((String)it);
        } else {
            string = null;
        }
        String workingDir = string;
        GradleInitScriptParametersBuilder builder2 = this.withJavaConfiguration(new GradleInitScriptParametersBuilder((JavaRunConfigurationBase)runProfile2, module2).withWorkingDirectory(workingDir).withParams(this.argsString(params)).withDefinitions(this.definitionsString(params)).withGradleTaskPath(gradlePath).withRunAppTaskName(runAppTaskName).withMainClass(mainClass).withJavaModuleName(javaModuleName).withSourceSetName(sourceSetName), project, (JavaRunConfigurationBase)runProfile2);
        String initScript = this.generateInitScript(builder2.build());
        gradleRunConfiguration.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)initScript);
        gradleRunConfiguration.putUserData(GradleTaskManager.INIT_SCRIPT_PREFIX_KEY, (Object)runAppTaskName);
        ((GradleRunConfiguration)gradleRunConfiguration).setDebugServerProcess(false);
        it = RunManagerImpl.Companion.getInstanceImpl(project).getBeforeRunTasks((RunConfiguration)runProfile2);
        GradleRunConfiguration gradleRunConfiguration2 = (GradleRunConfiguration)gradleRunConfiguration;
        boolean $i$f$filter = false;
        void var27_28 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BeforeRunTask it2 = (BeforeRunTask)element$iv$iv;
            boolean bl = false;
            if (!(it2.getProviderId() != CompileStepBeforeRun.ID)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        gradleRunConfiguration2.setBeforeRunTasks((List)destination$iv$iv);
        return environment;
    }

    private final boolean isTestModule(Module module) {
        return ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE).isEmpty();
    }

    private final GradleInitScriptParametersBuilder withJavaConfiguration(GradleInitScriptParametersBuilder $this$withJavaConfiguration, Project project, JavaRunConfigurationBase runProfile) {
        GradleInitScriptParametersBuilder gradleInitScriptParametersBuilder;
        GradleInitScriptParametersBuilder $this$withJavaConfiguration_u24lambda_u240 = gradleInitScriptParametersBuilder = $this$withJavaConfiguration;
        boolean bl = false;
        if (TargetEnvironmentConfigurations.getEffectiveConfiguration((RunProfile)((RunProfile)runProfile), (Project)project) != null) {
            v0 = $this$withJavaConfiguration_u24lambda_u240.withJavaExePath(GradleServerEnvironmentSetup.Companion.getTargetJavaExecutablePathMappingKey());
        } else {
            Sdk jdk = this.resolveRunConfigurationJdk(project, runProfile);
            SdkTypeId sdkTypeId = jdk.getSdkType();
            Intrinsics.checkNotNull((Object)sdkTypeId, (String)"null cannot be cast to non-null type com.intellij.openapi.projectRoots.JavaSdkType");
            JavaSdkType type = (JavaSdkType)sdkTypeId;
            String string = type.getVMExecutablePath(jdk);
            if (string == null) {
                throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.cannot.find.vm.executable", (Object[])new Object[0]));
            }
            String javaExePath = string;
            String string2 = FileUtil.toSystemIndependentName((String)javaExePath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            v0 = $this$withJavaConfiguration_u24lambda_u240.withJavaExePath(string2);
        }
        return gradleInitScriptParametersBuilder;
    }

    private final Sdk resolveRunConfigurationJdk(Project project, JavaRunConfigurationBase runProfile) {
        try {
            Sdk sdk = JavaParametersUtil.createProjectJdk((Project)project, (String)runProfile.getAlternativeJrePath());
            if (sdk == null) {
                throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
            }
            return sdk;
        }
        catch (CantRunException e) {
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)project)).submit(() -> GradleBaseApplicationEnvironmentProvider.resolveRunConfigurationJdk$lambda$0(e, project));
            throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.cannot.find.vm.executable", (Object[])new Object[0]));
        }
    }

    protected void customiseTaskExecutionsSettings(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)taskSettings, (String)"taskSettings");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
    }

    private static final String createExecutionEnvironment$lambda$0(GradleBaseApplicationEnvironmentProvider this$0, RunProfile $runProfile) {
        return this$0.getMainClass((JavaRunConfigurationBase)$runProfile);
    }

    private static final String createExecutionEnvironment$lambda$1(GradleBaseApplicationEnvironmentProvider this$0, RunProfile $runProfile) {
        return this$0.getConfigurationRunName((JavaRunConfigurationBase)$runProfile);
    }

    private static final void resolveRunConfigurationJdk$lambda$0(CantRunException $e, Project $project) {
        ExecutionErrorDialog.show((ExecutionException)((ExecutionException)$e), (String)GradleInspectionBundle.message("dialog.title.cannot.use.specified.jre", new Object[0]), (Project)$project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider$Companion;", "", "<init>", "()V", "createEscapedParameters", "", "parameters", "", "prefix", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String createEscapedParameters(@NotNull List<String> parameters, @NotNull String prefix) {
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            StringBuilder result = new StringBuilder();
            for (String parameter : parameters) {
                String escaped;
                if (StringUtil.isEmpty((String)parameter)) continue;
                char[] cArray = new char[]{'\\', '\"', '\''};
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.escapeChars((String)parameter, (char[])cArray), (String)"escapeChars(...)");
                result.append(prefix).append(" '").append(escaped).append("'\n");
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\rJ\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider$GradleInitScriptParametersBuilder;", "", "configuration", "Lcom/intellij/execution/JavaRunConfigurationBase;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/execution/JavaRunConfigurationBase;Lcom/intellij/openapi/module/Module;)V", "getConfiguration", "()Lcom/intellij/execution/JavaRunConfigurationBase;", "getModule", "()Lcom/intellij/openapi/module/Module;", "workingDirectory", "", "params", "definitions", "gradleTaskPath", "runAppTaskName", "mainClass", "javaExePath", "sourceSetName", "javaModuleName", "build", "Lorg/jetbrains/plugins/gradle/execution/build/GradleInitScriptParameters;", "withWorkingDirectory", "withParams", "withDefinitions", "withGradleTaskPath", "withRunAppTaskName", "withMainClass", "withJavaModuleName", "withJavaExePath", "withSourceSetName", "intellij.gradle.java"})
    private static final class GradleInitScriptParametersBuilder {
        @NotNull
        private final JavaRunConfigurationBase configuration;
        @NotNull
        private final Module module;
        @Nullable
        private String workingDirectory;
        private String params;
        private String definitions;
        private String gradleTaskPath;
        private String runAppTaskName;
        private String mainClass;
        private String javaExePath;
        private String sourceSetName;
        @Nullable
        private String javaModuleName;

        public GradleInitScriptParametersBuilder(@NotNull JavaRunConfigurationBase configuration, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.configuration = configuration;
            this.module = module;
        }

        @NotNull
        public final JavaRunConfigurationBase getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final GradleInitScriptParameters build() {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7 = this.params;
            if (string7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                string7 = null;
            }
            if ((string6 = this.definitions) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"definitions");
                string6 = null;
            }
            if ((string5 = this.gradleTaskPath) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gradleTaskPath");
                string5 = null;
            }
            if ((string4 = this.runAppTaskName) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"runAppTaskName");
                string4 = null;
            }
            if ((string3 = this.mainClass) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainClass");
                string3 = null;
            }
            if ((string2 = this.javaExePath) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"javaExePath");
                string2 = null;
            }
            if ((string = this.sourceSetName) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sourceSetName");
                string = null;
            }
            return new GradleInitScriptParametersImpl(this.configuration, this.module, this.workingDirectory, string7, string6, string5, string4, string3, string2, string, this.javaModuleName);
        }

        @NotNull
        public final GradleInitScriptParametersBuilder withWorkingDirectory(@Nullable String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        @NotNull
        public final GradleInitScriptParametersBuilder withParams(@NotNull String params) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.params = params;
            return this;
        }

        @NotNull
        public final GradleInitScriptParametersBuilder withDefinitions(@NotNull String definitions) {
            Intrinsics.checkNotNullParameter((Object)definitions, (String)"definitions");
            this.definitions = definitions;
            return this;
        }

        @NotNull
        public final GradleInitScriptParametersBuilder withGradleTaskPath(@NotNull String gradleTaskPath) {
            Intrinsics.checkNotNullParameter((Object)gradleTaskPath, (String)"gradleTaskPath");
            this.gradleTaskPath = gradleTaskPath;
            return this;
        }

        @NotNull
        public final GradleInitScriptParametersBuilder withRunAppTaskName(@NotNull String runAppTaskName) {
            Intrinsics.checkNotNullParameter((Object)runAppTaskName, (String)"runAppTaskName");
            this.runAppTaskName = runAppTaskName;
            return this;
        }

        @NotNull
        public final GradleInitScriptParametersBuilder withMainClass(@NotNull String mainClass) {
            Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
            this.mainClass = mainClass;
            return this;
        }

        @NotNull
        public final GradleInitScriptParametersBuilder withJavaModuleName(@Nullable String javaModuleName) {
            this.javaModuleName = javaModuleName;
            return this;
        }

        @NotNull
        public final GradleInitScriptParametersBuilder withJavaExePath(@NotNull String javaExePath) {
            Intrinsics.checkNotNullParameter((Object)javaExePath, (String)"javaExePath");
            this.javaExePath = javaExePath;
            return this;
        }

        @NotNull
        public final GradleInitScriptParametersBuilder withSourceSetName(@NotNull String sourceSetName) {
            Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
            this.sourceSetName = sourceSetName;
            return this;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0019\b\u0002\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u0014\u0010\r\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0014\u0010\u000e\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0017R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider$GradleInitScriptParametersImpl;", "Lorg/jetbrains/plugins/gradle/execution/build/GradleInitScriptParameters;", "configuration", "Lcom/intellij/execution/JavaRunConfigurationBase;", "module", "Lcom/intellij/openapi/module/Module;", "workingDirectory", "", "params", "definitions", "gradleTaskPath", "runAppTaskName", "mainClass", "javaExePath", "sourceSetName", "javaModuleName", "<init>", "(Lcom/intellij/execution/JavaRunConfigurationBase;Lcom/intellij/openapi/module/Module;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getConfiguration", "()Lcom/intellij/execution/JavaRunConfigurationBase;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getWorkingDirectory", "()Ljava/lang/String;", "getParams", "getDefinitions", "getGradleTaskPath", "getRunAppTaskName", "getMainClass", "getJavaExePath", "getSourceSetName", "getJavaModuleName", "intellij.gradle.java"})
    private static final class GradleInitScriptParametersImpl
    implements GradleInitScriptParameters {
        @NotNull
        private final JavaRunConfigurationBase configuration;
        @NotNull
        private final Module module;
        @Nullable
        private final String workingDirectory;
        @NotNull
        private final String params;
        @NotNull
        private final String definitions;
        @NotNull
        private final String gradleTaskPath;
        @NotNull
        private final String runAppTaskName;
        @NotNull
        private final String mainClass;
        @NotNull
        private final String javaExePath;
        @NotNull
        private final String sourceSetName;
        @Nullable
        private final String javaModuleName;

        public GradleInitScriptParametersImpl(@NotNull JavaRunConfigurationBase configuration, @NotNull Module module, @Nullable String workingDirectory, @NotNull String params, @NotNull String definitions, @NotNull String gradleTaskPath, @NotNull String runAppTaskName, @NotNull String mainClass, @NotNull String javaExePath, @NotNull String sourceSetName, @Nullable String javaModuleName) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)definitions, (String)"definitions");
            Intrinsics.checkNotNullParameter((Object)gradleTaskPath, (String)"gradleTaskPath");
            Intrinsics.checkNotNullParameter((Object)runAppTaskName, (String)"runAppTaskName");
            Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
            Intrinsics.checkNotNullParameter((Object)javaExePath, (String)"javaExePath");
            Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
            this.configuration = configuration;
            this.module = module;
            this.workingDirectory = workingDirectory;
            this.params = params;
            this.definitions = definitions;
            this.gradleTaskPath = gradleTaskPath;
            this.runAppTaskName = runAppTaskName;
            this.mainClass = mainClass;
            this.javaExePath = javaExePath;
            this.sourceSetName = sourceSetName;
            this.javaModuleName = javaModuleName;
        }

        @Override
        @NotNull
        public JavaRunConfigurationBase getConfiguration() {
            return this.configuration;
        }

        @Override
        @NotNull
        public Module getModule() {
            return this.module;
        }

        @Override
        @Nullable
        public String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @NotNull
        public String getParams() {
            return this.params;
        }

        @Override
        @NotNull
        public String getDefinitions() {
            return this.definitions;
        }

        @Override
        @NotNull
        public String getGradleTaskPath() {
            return this.gradleTaskPath;
        }

        @Override
        @NotNull
        public String getRunAppTaskName() {
            return this.runAppTaskName;
        }

        @Override
        @NotNull
        public String getMainClass() {
            return this.mainClass;
        }

        @Override
        @NotNull
        public String getJavaExePath() {
            return this.javaExePath;
        }

        @Override
        @NotNull
        public String getSourceSetName() {
            return this.sourceSetName;
        }

        @Override
        @Nullable
        public String getJavaModuleName() {
            return this.javaModuleName;
        }
    }
}

