/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.html.embedding.HtmlCustomEmbeddedContentTokenType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.html.HTMLParser;
import com.intellij.lang.xml.XMLParserDefinitionKt;
import com.intellij.lexer.HtmlLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlEmbeddedContentImpl;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.xml.stub.XmlStubBasedElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.UnsupportedNodeElementTypeException;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/html/HTMLParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getWhitespaceTokens", "Lcom/intellij/psi/tree/TokenSet;", "getCommentTokens", "getStringLiteralElements", "createParser", "Lcom/intellij/lang/PsiParser;", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "spaceExistenceTypeBetweenTokens", "Lcom/intellij/lang/ParserDefinition$SpaceRequirements;", "left", "right", "intellij.xml.psi.impl"})
public class HTMLParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        return (Lexer)new HtmlLexer();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return XmlElementType.HTML_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return XmlTokenType.WHITESPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return XmlTokenType.COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(@Nullable Project project) {
        return (PsiParser)new HTMLParser();
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        if (elementType instanceof XmlStubBasedElementType) {
            Object PsiT = ((XmlStubBasedElementType)elementType).createPsi(node);
            object = PsiT;
            Intrinsics.checkNotNullExpressionValue(PsiT, (String)"createPsi(...)");
        } else if (elementType instanceof HtmlCustomEmbeddedContentTokenType) {
            object = ((HtmlCustomEmbeddedContentTokenType)elementType).createPsi(node);
        } else if (elementType == XmlElementType.HTML_EMBEDDED_CONTENT) {
            object = (PsiElement)new HtmlEmbeddedContentImpl(node);
        } else if (PlatformUtils.isJetBrainsClient()) {
            object = (PsiElement)new ASTWrapperPsiElement(node);
        } else {
            throw new UnsupportedNodeElementTypeException(node);
        }
        return object;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        return (PsiFile)new HtmlFileImpl(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return XMLParserDefinitionKt.canStickTokensTogether(left, right);
    }
}

