/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.module.CloudApplicationConfigurable;
import com.intellij.remoteServer.impl.module.CloudModuleBuilder;
import org.jetbrains.annotations.Nullable;

public abstract class CloudModuleBuilderContribution {
    private final CloudModuleBuilder myModuleBuilder;
    private final ServerType<?> myCloudType;
    private CloudApplicationConfigurable myApplicationConfigurable;

    public CloudModuleBuilderContribution(CloudModuleBuilder moduleBuilder, ServerType<?> cloudType) {
        this.myModuleBuilder = moduleBuilder;
        this.myCloudType = cloudType;
    }

    protected CloudModuleBuilder getModuleBuilder() {
        return this.myModuleBuilder;
    }

    protected ServerType<?> getCloudType() {
        return this.myCloudType;
    }

    public CloudApplicationConfigurable getApplicationConfigurable(@Nullable Project project, Disposable parentDisposable) {
        if (this.myApplicationConfigurable == null) {
            this.myApplicationConfigurable = this.createApplicationConfigurable(project, parentDisposable);
        }
        return this.myApplicationConfigurable;
    }

    public void preConfigureModule(Module module, ModifiableRootModel model) {
    }

    public abstract void configureModule(Module var1);

    protected abstract CloudApplicationConfigurable createApplicationConfigurable(@Nullable Project var1, Disposable var2);

    protected DeploymentConfiguration createDeploymentConfiguration(DeploymentSource deploymentSource) {
        return this.myCloudType.createDeploymentConfigurator(null).createDefaultConfiguration(deploymentSource);
    }
}

