/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.jpa.jpb.model.util.SUastUtils;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.SpringDataSourceInfoProvider;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/data/commons/util/SpringDataQueryDialectsUtil;", "", "<init>", "()V", "getTargetSqlDialect", "Lcom/intellij/lang/Language;", "psiElement", "Lcom/intellij/psi/PsiElement;", "getExplicitSqlDialect", "getPsiClassSqlDialect", "psiClass", "Lcom/intellij/psi/PsiClass;", "intellij.spring.data"})
@SourceDebugExtension(value={"SMAP\nSpringDataQueryDialectsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataQueryDialectsUtil.kt\ncom/intellij/spring/data/commons/util/SpringDataQueryDialectsUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1#2:68\n1#2:90\n1#2:104\n1#2:118\n1586#3:69\n1661#3,3:70\n1391#3:73\n1480#3,5:74\n1642#3,10:79\n1915#3:89\n1916#3:91\n1652#3:92\n1642#3,10:93\n1915#3:103\n1916#3:105\n1652#3:106\n1642#3,10:107\n1915#3:117\n1916#3:119\n1652#3:120\n*S KotlinDebug\n*F\n+ 1 SpringDataQueryDialectsUtil.kt\ncom/intellij/spring/data/commons/util/SpringDataQueryDialectsUtil\n*L\n50#1:90\n51#1:104\n58#1:118\n41#1:69\n41#1:70,3\n49#1:73\n49#1:74,5\n50#1:79,10\n50#1:89\n50#1:91\n50#1:92\n51#1:93,10\n51#1:103\n51#1:105\n51#1:106\n58#1:107,10\n58#1:117\n58#1:119\n58#1:120\n*E\n"})
public final class SpringDataQueryDialectsUtil {
    @NotNull
    public static final SpringDataQueryDialectsUtil INSTANCE = new SpringDataQueryDialectsUtil();

    private SpringDataQueryDialectsUtil() {
    }

    @Nullable
    public final Language getTargetSqlDialect(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Language language = this.getExplicitSqlDialect(psiElement);
        if (language != null) {
            Language it = language;
            boolean bl = false;
            return it;
        }
        PsiClass psiClass = SUastUtils.getContainingClass((PsiElement)psiElement);
        if (psiClass == null) {
            return null;
        }
        PsiClass repositoryClass = psiClass;
        return this.getPsiClassSqlDialect(repositoryClass);
    }

    private final Language getExplicitSqlDialect(PsiElement psiElement) {
        Dbms dbms;
        DatabaseConnectionPoint databaseConnectionPoint;
        DatabaseSession databaseSession;
        JdbcConsole jdbcConsole = JdbcConsoleProvider.getValidConsole((Project)psiElement.getProject(), (VirtualFile)psiElement.getContainingFile().getVirtualFile());
        if (jdbcConsole != null && (databaseSession = jdbcConsole.getSession()) != null && (databaseConnectionPoint = databaseSession.getConnectionPoint()) != null && (dbms = databaseConnectionPoint.getDbms()) != null) {
            Dbms it = dbms;
            boolean bl = false;
            SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)SqlLanguageDialect.EP.forDbms(it);
            if (sqlLanguageDialect != null) {
                it = sqlLanguageDialect;
                boolean bl2 = false;
                return (Language)it;
            }
        }
        return null;
    }

    private final Language getPsiClassSqlDialect(PsiClass psiClass) {
        return (Language)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psiClass), () -> SpringDataQueryDialectsUtil.getPsiClassSqlDialect$lambda$0(psiClass));
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result getPsiClassSqlDialect$lambda$0(PsiClass $psiClass) {
        Object object;
        Iterable $this$mapNotNull$iv;
        Module module = PsiUtilsKt.module((PsiElement)((PsiElement)$psiClass));
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)$psiClass.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"getInstance(...)");
        DbPsiFacade dbPsiFacade2 = dbPsiFacade;
        Object result = null;
        if (module != null) {
            for (Iterable provider : SpringDataSourceInfoProvider.Companion.getEP_NAME().getExtensionList()) {
                boolean bl;
                String it$iv$iv;
                String it;
                boolean bl2;
                Object element$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                Iterator list$iv$iv;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                Iterable<Object> iterable;
                SpringDataSourceInfoProvider it2;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable2 = provider.getModuleDataSourceIds(module);
                boolean $i$f$map = false;
                void var9_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    DbDataSource dbDataSource = dbPsiFacade2.findDataSource((String)it2);
                    collection.add(dbDataSource != null ? dbDataSource.getLanguage() : null);
                }
                $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                Iterable it3 = $this$map$iv;
                boolean bl4 = false;
                List list = iterable = it3.size() == 1 ? $this$map$iv : null;
                if (iterable != null && ($this$map$iv = (Language)CollectionsKt.first((List)iterable)) != null) {
                    List it4 = $this$map$iv;
                    boolean bl5 = false;
                    result = it4;
                    break;
                }
                $this$map$iv = SpringDataSourceInfoProvider.Companion.getEP_NAME().getExtensionList();
                boolean $i$f$flatMap = false;
                void it4 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                    it2 = (SpringDataSourceInfoProvider)element$iv$iv2;
                    boolean bl6 = false;
                    list$iv$iv = it2.getModuleDataSourceUrls(module);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)((Object)list$iv$iv));
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                list$iv$iv = $this$forEach$iv$iv$iv.iterator();
                while (list$iv$iv.hasNext()) {
                    Object element$iv$iv$iv;
                    element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
                    bl2 = false;
                    it = (String)element$iv$iv;
                    boolean bl7 = false;
                    DbType dbType = DbType.Companion.fromUrl(it);
                    if ((dbType != null ? dbType.getLanguageId() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    element$iv$iv = element$iv$iv$iv;
                    bl2 = false;
                    it = (String)element$iv$iv;
                    boolean bl8 = false;
                    if (Language.findLanguageByID((String)it) == null) continue;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                it3 = $this$mapNotNull$iv;
                boolean bl9 = false;
                iterable = it3.size() == 1 ? $this$mapNotNull$iv : null;
                result = iterable != null ? (Language)CollectionsKt.first((List)iterable) : null;
            }
        }
        if (result == null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv2;
            Iterable provider;
            List list = dbPsiFacade2.getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            provider = list;
            boolean $i$f$mapNotNull = false;
            $this$mapNotNull$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SqlLanguageDialect it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                DbDataSource it = (DbDataSource)element$iv$iv;
                boolean bl10 = false;
                Language language = it.getLanguage();
                if ((language instanceof SqlLanguageDialect ? (SqlLanguageDialect)language : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl11 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Object it = object = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            boolean bl = false;
            Object object2 = it.size() == 1 ? object : null;
            result = object2 != null ? (SqlLanguageDialect)CollectionsKt.first((List)object2) : null;
        }
        ModificationTracker tracker = SpringModificationTrackersManager.getInstance((Project)$psiClass.getProject()).getOuterModelsModificationTracker();
        object = new Object[]{tracker};
        return CachedValueProvider.Result.create(result, (Object[])object);
    }
}

