/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/log/ui/actions/CompareRevisionsFromLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.platform.vcs.log.impl"})
public final class CompareRevisionsFromLogAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        VcsLogDiffHandler handler = (VcsLogDiffHandler)e.getData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        if (selection == null || handler == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List commits = selection.getCommits();
        e.getPresentation().setVisible(commits.size() == 2);
        e.getPresentation().setEnabled(commits.size() == 2 && Intrinsics.areEqual((Object)((CommitId)CollectionsKt.first((List)commits)).getRoot(), (Object)((CommitId)CollectionsKt.last((List)commits)).getRoot()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        VcsLogCommitSelection vcsLogCommitSelection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (vcsLogCommitSelection == null) {
            return;
        }
        VcsLogCommitSelection selection = vcsLogCommitSelection;
        VcsLogDiffHandler vcsLogDiffHandler = (VcsLogDiffHandler)e.getData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        if (vcsLogDiffHandler == null) {
            return;
        }
        VcsLogDiffHandler handler = vcsLogDiffHandler;
        List commits = selection.getCommits();
        if (commits.size() == 2) {
            VirtualFile virtualFile = ((CommitId)CollectionsKt.first((List)commits)).getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            VirtualFile root = virtualFile;
            handler.showDiffForPaths(root, VcsLogUtil.getAffectedPaths(root, e), ((CommitId)commits.get(1)).getHash(), ((CommitId)commits.get(0)).getHash());
        }
    }
}

