/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.frontend.tabs.files;

import com.intellij.ide.actions.SETextShortener;
import com.intellij.ide.rpc.util.TextRangeDto;
import com.intellij.ide.rpc.util.TextRangeDtoKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.searchEverywhere.frontend.ui.SeDefaultListItemRendererKt;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListItemRow;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListRow;
import com.intellij.platform.searchEverywhere.presentations.SeItemPresentation;
import com.intellij.platform.searchEverywhere.presentations.SeTargetItemPresentationImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.dsl.listCellRenderer.LcrTextInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrTextSpeedSearchParams;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/searchEverywhere/frontend/tabs/files/SeTargetItemPresentationRenderer;", "", "resultList", "Ljavax/swing/JList;", "Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultListRow;", "<init>", "(Ljavax/swing/JList;)V", "get", "Ljavax/swing/ListCellRenderer;", "intellij.platform.searchEverywhere.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSeTargetItemPresentationRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeTargetItemPresentationRenderer.kt\ncom/intellij/platform/searchEverywhere/frontend/tabs/files/SeTargetItemPresentationRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1586#2:151\n1661#2,3:152\n1586#2:155\n1661#2,3:156\n777#2:159\n873#2,2:160\n1586#2:162\n1661#2,3:163\n1#3:166\n*S KotlinDebug\n*F\n+ 1 SeTargetItemPresentationRenderer.kt\ncom/intellij/platform/searchEverywhere/frontend/tabs/files/SeTargetItemPresentationRenderer\n*L\n79#1:151\n79#1:152,3\n114#1:155\n114#1:156,3\n114#1:159\n114#1:160,2\n116#1:162\n116#1:163,3\n*E\n"})
public final class SeTargetItemPresentationRenderer {
    @NotNull
    private final JList<SeResultListRow> resultList;

    public SeTargetItemPresentationRenderer(@NotNull JList<SeResultListRow> resultList) {
        Intrinsics.checkNotNullParameter(resultList, (String)"resultList");
        this.resultList = resultList;
    }

    @NotNull
    public final ListCellRenderer<SeResultListRow> get() {
        return BuilderKt.listCellRenderer(arg_0 -> SeTargetItemPresentationRenderer.get$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit get$lambda$0$3$2(SeTargetItemPresentationImpl $presentation, LcrTextSpeedSearchParams $this$speedSearch) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$speedSearch, (String)"$this$speedSearch");
        LcrTextSpeedSearchParams lcrTextSpeedSearchParams = $this$speedSearch;
        List list2 = $presentation.getPresentableTextMatchedRanges();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            LcrTextSpeedSearchParams lcrTextSpeedSearchParams2 = lcrTextSpeedSearchParams;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TextRangeDto textRangeDto = (TextRangeDto)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TextRangeDtoKt.textRange((TextRangeDto)it));
            }
            list = (List)destination$iv$iv;
            lcrTextSpeedSearchParams = lcrTextSpeedSearchParams2;
        } else {
            list = null;
        }
        lcrTextSpeedSearchParams.setRanges((Iterable)list);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit get$lambda$0$6$1$0(SeTargetItemPresentationImpl $presentation, int $prefixBoundary, int $suffixBoundary, int $postSuffixShiftAmount, LcrTextSpeedSearchParams $this$speedSearch) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$speedSearch, (String)"$this$speedSearch");
        LcrTextSpeedSearchParams lcrTextSpeedSearchParams = $this$speedSearch;
        List list2 = $presentation.getContainerTextMatchedRanges();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Iterable iterable = list2;
            LcrTextSpeedSearchParams lcrTextSpeedSearchParams2 = lcrTextSpeedSearchParams;
            boolean $i$f$map22 = false;
            void var7_9 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                TextRangeDto textRangeDto = (TextRangeDto)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TextRangeDtoKt.textRange((TextRangeDto)it));
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TextRange range = (TextRange)element$iv$iv;
                boolean bl = false;
                if (!(range.getEndOffset() <= $prefixBoundary || range.getStartOffset() >= $suffixBoundary)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TextRange range = (TextRange)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(range.getStartOffset() >= $suffixBoundary ? range.shiftLeft($postSuffixShiftAmount) : range);
            }
            list = (List)destination$iv$iv2;
            lcrTextSpeedSearchParams = lcrTextSpeedSearchParams2;
        } else {
            list = null;
        }
        lcrTextSpeedSearchParams.setRanges((Iterable)list);
        return Unit.INSTANCE;
    }

    private static final int get$lambda$0$6$0(FontMetrics $fontMetrics, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $fontMetrics.stringWidth(it);
    }

    private static final Unit get$lambda$0$6$1(boolean $selected, String $shortenContainerText, String $containerText, SeTargetItemPresentationImpl $presentation, LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setAccessibleName(null);
        $this$text.setAttributes(SimpleTextAttributes.GRAYED_ATTRIBUTES);
        if ($selected) {
            int prefixBoundary = StringsKt.commonPrefixWith$default((CharSequence)$shortenContainerText, (CharSequence)$containerText, (boolean)false, (int)2, null).length() - 1;
            int suffixBoundary = $containerText.length() - StringsKt.commonSuffixWith$default((CharSequence)$shortenContainerText, (CharSequence)$containerText, (boolean)false, (int)2, null).length() + 1;
            int postSuffixShiftAmount = $containerText.length() - $shortenContainerText.length();
            $this$text.speedSearch(arg_0 -> SeTargetItemPresentationRenderer.get$lambda$0$6$1$0($presentation, prefixBoundary, suffixBoundary, postSuffixShiftAmount, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit get$lambda$0$7$0(boolean $selected, LcrTextInitParams $this$text) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setAccessibleName(null);
        $this$text.setAlign(LcrInitParams.Align.RIGHT);
        if ($selected) {
            Color color2 = NamedColorUtil.getListSelectionForeground((boolean)true);
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getListSelectionForeground(...)");
        } else {
            Color color3 = NamedColorUtil.getInactiveTextColor();
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getInactiveTextColor(...)");
        }
        $this$text.setForeground(color);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit get$lambda$0$3(SeTargetItemPresentationImpl $presentation, boolean $selected, LcrTextInitParams $this$text) {
        Object object;
        String string;
        LcrTextInitParams lcrTextInitParams;
        block11: {
            block10: {
                void it;
                Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
                lcrTextInitParams = $this$text;
                string = $presentation.getPresentableText();
                object = $presentation.getContainerText();
                if (object == null) break block10;
                String string2 = object;
                String string3 = string;
                LcrTextInitParams lcrTextInitParams2 = lcrTextInitParams;
                boolean bl = false;
                String string4 = " " + (String)it;
                lcrTextInitParams = lcrTextInitParams2;
                string = string3;
                String string5 = string4;
                object = string5;
                if (string5 != null) break block11;
            }
            object = "";
        }
        lcrTextInitParams.setAccessibleName(string + (String)object);
        if ($presentation.getPresentableTextStrikethrough()) {
            $this$text.setAttributes(new SimpleTextAttributes(4, $presentation.getPresentableTextFgColor()));
        } else if ($presentation.getPresentableTextErrorHighlight()) {
            $this$text.setAttributes(new SimpleTextAttributes(8, $presentation.getPresentableTextFgColor(), (Color)JBColor.RED));
        } else {
            Color color = $presentation.getPresentableTextFgColor();
            if (color != null) {
                Color it = color;
                boolean bl = false;
                $this$text.setForeground(it);
            }
        }
        if ($selected) {
            $this$text.speedSearch(arg_0 -> SeTargetItemPresentationRenderer.get$lambda$0$3$2($presentation, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit get$lambda$0(SeTargetItemPresentationRenderer this$0, LcrRow $this$listCellRenderer) {
        block13: {
            int n;
            Integer iconWidth;
            Object it;
            Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
            Object object = $this$listCellRenderer.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.platform.searchEverywhere.frontend.ui.SeResultListItemRow");
            SeItemPresentation seItemPresentation = ((SeResultListItemRow)object).getItem().getPresentation();
            Intrinsics.checkNotNull((Object)seItemPresentation, (String)"null cannot be cast to non-null type com.intellij.platform.searchEverywhere.presentations.SeTargetItemPresentationImpl");
            SeTargetItemPresentationImpl presentation = (SeTargetItemPresentationImpl)seItemPresentation;
            boolean selected = $this$listCellRenderer.getSelected();
            $this$listCellRenderer.setSelectionColor(UIUtil.getListBackground((boolean)selected, (boolean)selected));
            Color color = presentation.getBackgroundColor();
            if (color != null) {
                it = color;
                boolean bl = false;
                $this$listCellRenderer.setBackground((Color)it);
            }
            if (Registry.Companion.is("search.everywhere.ml.semantic.highlight.items", false)) {
                Object object2 = $this$listCellRenderer.getValue();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.platform.searchEverywhere.frontend.ui.SeResultListItemRow");
                boolean isSemantic = Boolean.parseBoolean((String)((SeResultListItemRow)object2).getItem().getAdditionalInfo().get("SeItemDataKeys.IsSemantic"));
                if (isSemantic) {
                    $this$listCellRenderer.setBackground(JBColor.GREEN.darker().darker());
                }
            }
            Icon icon = presentation.getIcon();
            if (icon != null) {
                it = icon;
                boolean bl = false;
                LcrRow.icon$default((LcrRow)$this$listCellRenderer, (Icon)it, null, (int)2, null);
            }
            int defaultGapWidth = JBUI.scale((int)6);
            int bordersWidth = 2 * JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get() + JBUI.CurrentTheme.Popup.Selection.innerInsets().left + JBUI.CurrentTheme.Popup.Selection.innerInsets().right;
            int accumulatedContentWidth = 0;
            accumulatedContentWidth = bordersWidth;
            Integer n2 = presentation.getIconOriginalWidth();
            if (n2 == null) {
                Icon icon2 = presentation.getIcon();
                n2 = icon2 != null ? Integer.valueOf(icon2.getIconWidth()) : null;
            }
            Integer n3 = iconWidth = n2;
            if (n3 != null) {
                int it2 = ((Number)n3).intValue();
                boolean bl = false;
                accumulatedContentWidth += JBUI.scale((int)iconWidth) + defaultGapWidth;
            }
            FontMetrics fontMetrics = this$0.resultList.getFontMetrics(this$0.resultList.getFont());
            int presentableTextWidth = fontMetrics.stringWidth(presentation.getPresentableText());
            accumulatedContentWidth += presentableTextWidth + defaultGapWidth;
            $this$listCellRenderer.text(presentation.getPresentableText(), arg_0 -> SeTargetItemPresentationRenderer.get$lambda$0$3(presentation, selected, arg_0));
            SeDefaultListItemRendererKt.weightTextIfEnabled((LcrRow<SeResultListRow>)$this$listCellRenderer, (SeResultListRow)$this$listCellRenderer.getValue());
            String string = presentation.getLocationText();
            if (string != null) {
                String it3 = string;
                boolean bl = false;
                n = fontMetrics.stringWidth(it3);
            } else {
                n = 0;
            }
            int locationTextWidth = n;
            int locationTextWidthWithGap = locationTextWidth > 0 ? locationTextWidth + defaultGapWidth : 0;
            int resultListWidth = this$0.resultList.getWidth();
            int maxContainerTextWidth = resultListWidth - accumulatedContentWidth - locationTextWidthWithGap;
            String string2 = presentation.getContainerText();
            if (string2 != null) {
                String string3;
                String string4;
                String it4 = string4 = string2;
                boolean bl = false;
                String string5 = string3 = maxContainerTextWidth > 0 ? string4 : null;
                if (string3 != null) {
                    String containerText = string3;
                    boolean bl2 = false;
                    String shortenContainerText = SETextShortener.INSTANCE.getShortenContainerText(containerText, maxContainerTextWidth, arg_0 -> SeTargetItemPresentationRenderer.get$lambda$0$6$0(fontMetrics, arg_0));
                    int shortenContainerTextWidth = fontMetrics.stringWidth(shortenContainerText);
                    if (shortenContainerTextWidth <= maxContainerTextWidth) {
                        accumulatedContentWidth += shortenContainerTextWidth + defaultGapWidth;
                        $this$listCellRenderer.text(shortenContainerText, arg_0 -> SeTargetItemPresentationRenderer.get$lambda$0$6$1(selected, shortenContainerText, containerText, presentation, arg_0));
                    }
                }
            }
            String string6 = presentation.getLocationText();
            if (string6 == null) break block13;
            String locationText = string6;
            boolean bl = false;
            $this$listCellRenderer.text(locationText, arg_0 -> SeTargetItemPresentationRenderer.get$lambda$0$7$0(selected, arg_0));
            accumulatedContentWidth += locationTextWidthWithGap;
            Icon icon3 = presentation.getLocationIcon();
            if (icon3 != null) {
                int iconWidth2;
                Icon locationIcon = icon3;
                boolean bl3 = false;
                Integer n4 = presentation.getLocationIconOriginalWidth();
                int n5 = iconWidth2 = n4 != null ? n4.intValue() : locationIcon.getIconWidth();
                if (accumulatedContentWidth + JBUI.scale((int)iconWidth2) < resultListWidth) {
                    LcrRow.icon$default((LcrRow)$this$listCellRenderer, (Icon)locationIcon, null, (int)2, null);
                }
            }
        }
        return Unit.INSTANCE;
    }
}

