/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import com.intellij.rt.debugger.agent.OverheadDetector;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CaptureStorage {
    public static final String GENERATED_INSERT_METHOD_POSTFIX = "$$$capture";
    private static final ConcurrentIdentityWeakHashMap<Object, CapturedStack> STORAGE_GENERAL = new ConcurrentIdentityWeakHashMap();
    private static final ConcurrentIdentityWeakHashMap<Throwable, CapturedStack> STORAGE_THROWABLES = new ConcurrentIdentityWeakHashMap();
    private static final ConcurrentIdentityWeakHashMap<Thread, Deque<CapturedStack>> THREAD_TO_STACKS_MAP = new ConcurrentIdentityWeakHashMap();
    private static final ThreadLocal<Deque<CapturedStack>> CURRENT_STACKS = new ThreadLocal<Deque<CapturedStack>>(){

        @Override
        protected Deque<CapturedStack> initialValue() {
            return new LinkedList<CapturedStack>();
        }
    };
    private static final boolean storeAsyncStackTracesForAllThreads = Boolean.parseBoolean(System.getProperty("debugger.async.stack.trace.for.all.threads", "false"));
    static final double DEFAULT_OVERHEAD_PERCENT = 50.0;
    private static OverheadDetector ourOverheadDetector = new OverheadDetector(50.0, true);
    static final ThreadLocal<ThreadLocalContext> CURRENT_CONTEXT = new ThreadLocal<ThreadLocalContext>(){

        @Override
        protected ThreadLocalContext initialValue() {
            return new ThreadLocalContext();
        }
    };
    public static boolean DEBUG;
    private static boolean ENABLED;
    static final StackTraceElement ASYNC_STACK_ELEMENT;
    static final StackTraceElement THROTTLED_STACK_ELEMENT;
    private static final ConcurrentIdentityWeakHashMap<ClassLoader, Method> COROUTINE_GET_CALLER_FRAME_METHODS;

    static void init(Properties properties) {
        String overheadPercent = properties.getProperty("overheadPercent");
        String throttlingValue = properties.getProperty("throttling");
        double overhead = overheadPercent != null ? Double.parseDouble(overheadPercent) : 50.0;
        boolean throttlingEnabled = throttlingValue == null || Boolean.parseBoolean(throttlingValue);
        ourOverheadDetector = new OverheadDetector(overhead, throttlingEnabled);
    }

    private static Deque<CapturedStack> getStacksForCurrentThread() {
        if (storeAsyncStackTracesForAllThreads) {
            Thread currentThread = Thread.currentThread();
            Deque<CapturedStack> capturedStacks = THREAD_TO_STACKS_MAP.get(currentThread);
            if (capturedStacks == null) {
                capturedStacks = new LinkedList<CapturedStack>();
                THREAD_TO_STACKS_MAP.put(currentThread, capturedStacks);
            }
            return capturedStacks;
        }
        return CURRENT_STACKS.get();
    }

    public static void capture(final Object key) {
        if (!ENABLED) {
            return;
        }
        ThreadLocalContext context = CURRENT_CONTEXT.get();
        boolean executed = CaptureStorage.runWithOverheadTrackingAndWithoutThrowableCapture(context, new Runnable(){

            @Override
            public void run() {
                try {
                    if (DEBUG) {
                        System.out.println("captureGeneral " + CaptureStorage.getCallerDescriptorForLogging() + " - " + CaptureStorage.getKeyText(key));
                    }
                    CapturedStack stack = (CapturedStack)CaptureStorage.getStacksForCurrentThread().peekLast();
                    STORAGE_GENERAL.put(key, CaptureStorage.createCapturedStack(new Throwable(), stack));
                }
                catch (AssertionError | Exception e) {
                    CaptureStorage.handleException((Throwable)e);
                }
            }
        });
        if (executed) {
            return;
        }
        CaptureStorage.runWithoutThrowableCapture(context, new Runnable(){

            @Override
            public void run() {
                try {
                    if (DEBUG) {
                        System.out.println("captureGeneral (throttled) " + CaptureStorage.getCallerDescriptorForLogging() + " - " + CaptureStorage.getKeyText(key));
                    }
                    STORAGE_GENERAL.put(key, ThrottledCapturedStack.INSTANCE);
                }
                catch (AssertionError | Exception e) {
                    CaptureStorage.handleException((Throwable)e);
                }
            }
        });
    }

    public static void captureThrowable(final Throwable throwable) {
        ThreadLocalContext context = CURRENT_CONTEXT.get();
        if (!ENABLED || context.throwableCaptureDisabled) {
            return;
        }
        CaptureStorage.runWithoutThrowableCapture(context, new Runnable(){

            @Override
            public void run() {
                try {
                    CapturedStack stack;
                    if (DEBUG) {
                        System.out.println("captureThrowable " + CaptureStorage.getCallerDescriptorForLogging() + " - " + CaptureStorage.getKeyText(throwable));
                    }
                    if ((stack = (CapturedStack)CaptureStorage.getStacksForCurrentThread().peekLast()) != null) {
                        assert (!(stack instanceof ExceptionCapturedStack) || ((ExceptionCapturedStack)stack).myException != throwable);
                        STORAGE_THROWABLES.put(throwable, stack);
                    }
                }
                catch (AssertionError | Exception e) {
                    CaptureStorage.handleException((Throwable)e);
                }
            }
        });
    }

    public static void insertEnter(final Object key) {
        if (!ENABLED) {
            return;
        }
        CaptureStorage.runWithoutThrowableCapture(CURRENT_CONTEXT.get(), new Runnable(){

            @Override
            public void run() {
                try {
                    CapturedStack stack = (CapturedStack)STORAGE_GENERAL.get(key);
                    Deque currentStacks = CaptureStorage.getStacksForCurrentThread();
                    currentStacks.add(stack);
                    if (DEBUG) {
                        System.out.println("insert " + CaptureStorage.getCallerDescriptorForLogging() + " -> " + CaptureStorage.getKeyText(key) + ", stack saved (" + currentStacks.size() + ")");
                    }
                }
                catch (Exception e) {
                    CaptureStorage.handleException(e);
                }
            }
        });
    }

    public static void insertExit(final Object key) {
        if (!ENABLED) {
            return;
        }
        CaptureStorage.runWithoutThrowableCapture(CURRENT_CONTEXT.get(), new Runnable(){

            @Override
            public void run() {
                try {
                    Deque currentStacks = CaptureStorage.getStacksForCurrentThread();
                    currentStacks.pollLast();
                    if (DEBUG) {
                        System.out.println("insert " + CaptureStorage.getCallerDescriptorForLogging() + " <- " + CaptureStorage.getKeyText(key) + ", stack removed (" + currentStacks.size() + ")");
                    }
                }
                catch (Exception e) {
                    CaptureStorage.handleException(e);
                }
            }
        });
    }

    public static Object coroutineOwner(final Object key) {
        if (!ENABLED) {
            return key;
        }
        return CaptureStorage.withoutThrowableCapture(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    Method getCallerFrameMethod = CaptureStorage.getGetCallerFrameMethod(key);
                    Object res = key;
                    while (true) {
                        Object caller;
                        if ((caller = getCallerFrameMethod.invoke(res, new Object[0])) == null) {
                            return res;
                        }
                        if ("kotlinx.coroutines.debug.internal.DebugProbesImpl$CoroutineOwner".equals(caller.getClass().getName())) {
                            return caller;
                        }
                        res = caller;
                    }
                }
                catch (Exception e) {
                    CaptureStorage.handleException(e);
                    return key;
                }
            }
        });
    }

    public static StackTraceElement[] getAsyncStackTrace(final Throwable throwable) {
        if (!ENABLED) {
            return throwable.getStackTrace();
        }
        return CaptureStorage.withoutThrowableCapture(new Callable<StackTraceElement[]>(){

            @Override
            public StackTraceElement[] call() {
                try {
                    CapturedStack stack = (CapturedStack)STORAGE_THROWABLES.get(throwable);
                    if (stack != null) {
                        CapturedStack capturedStack = CaptureStorage.createCapturedStack(throwable, stack);
                        ArrayList stackTrace = CaptureStorage.getStackTrace(capturedStack, CaptureAgent.throwableAsyncStackDepthLimit());
                        return stackTrace.toArray(new StackTraceElement[0]);
                    }
                }
                catch (Exception e) {
                    CaptureStorage.handleException(e);
                }
                return throwable.getStackTrace();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runWithOverheadTrackingAndWithoutThrowableCapture(ThreadLocalContext context, Runnable runnable) {
        boolean oldValue = context.throwableCaptureDisabled;
        context.throwableCaptureDisabled = true;
        try {
            boolean bl = context.overheadTracker.runIfNoOverhead(runnable);
            return bl;
        }
        finally {
            context.throwableCaptureDisabled = oldValue;
        }
    }

    private static void runWithoutThrowableCapture(ThreadLocalContext context, Runnable runnable) {
        boolean oldValue = context.throwableCaptureDisabled;
        context.throwableCaptureDisabled = true;
        try {
            runnable.run();
        }
        finally {
            context.throwableCaptureDisabled = oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withoutThrowableCapture(Callable<T> action) {
        ThreadLocalContext context = CURRENT_CONTEXT.get();
        boolean oldValue = context.throwableCaptureDisabled;
        context.throwableCaptureDisabled = true;
        try {
            T t = action.call();
            return t;
        }
        finally {
            context.throwableCaptureDisabled = oldValue;
        }
    }

    private static Method getGetCallerFrameMethod(Object key) throws NoSuchMethodException, ClassNotFoundException {
        ClassLoader classLoader = key.getClass().getClassLoader();
        Method getCallerFrameMethod = COROUTINE_GET_CALLER_FRAME_METHODS.get(classLoader);
        if (getCallerFrameMethod == null) {
            getCallerFrameMethod = Class.forName("kotlin.coroutines.jvm.internal.CoroutineStackFrame", false, classLoader).getDeclaredMethod("getCallerFrame", new Class[0]);
            COROUTINE_GET_CALLER_FRAME_METHODS.put(classLoader, getCallerFrameMethod);
        }
        return getCallerFrameMethod;
    }

    private static CapturedStack createCapturedStack(Throwable exception, CapturedStack insertMatch) {
        ExceptionCapturedStack exceptionStack = new ExceptionCapturedStack(exception);
        if (insertMatch != null) {
            CapturedStack stack = new DeepCapturedStack(exceptionStack, insertMatch);
            if (((CapturedStack)stack).getRecursionDepth() > 100) {
                ArrayList<StackTraceElement> trace = CaptureStorage.getStackTrace(stack, 500);
                trace.trimToSize();
                stack = new UnwindCapturedStack(trace);
            }
            return stack;
        }
        return exceptionStack;
    }

    static List<StackTraceElement> getCurrentCapturedStack(int limit) {
        CapturedStack stack = CaptureStorage.getStacksForCurrentThread().peekLast();
        if (stack == null) {
            return null;
        }
        return CaptureStorage.getStackTrace(stack, limit);
    }

    public static String getCapturedStackForThread(int limit, Thread thread) {
        Deque<CapturedStack> capturedStacks;
        Deque<CapturedStack> deque = storeAsyncStackTracesForAllThreads ? THREAD_TO_STACKS_MAP.get(thread) : (capturedStacks = thread == Thread.currentThread() ? CURRENT_STACKS.get() : null);
        if (capturedStacks == null) {
            return null;
        }
        return CaptureStorage.wrapInString(capturedStacks.peekLast(), limit);
    }

    public static Map<Thread, String> getAllCapturedStacks(int limit) {
        HashMap<Thread, String> threadToStacks = new HashMap<Thread, String>();
        if (storeAsyncStackTracesForAllThreads) {
            for (Map.Entry entry : ((ConcurrentIdentityWeakHashMap)THREAD_TO_STACKS_MAP).map.entrySet()) {
                Thread thread = (Thread)((ConcurrentIdentityWeakHashMap.Key)entry.getKey()).get();
                if (entry.getValue() == null || ((Deque)entry.getValue()).isEmpty() || !thread.isAlive()) continue;
                String capturedStack = CaptureStorage.wrapInString((CapturedStack)((Deque)entry.getValue()).peekLast(), limit);
                threadToStacks.put(thread, capturedStack);
            }
        } else {
            Deque<CapturedStack> capturedStacks = CURRENT_STACKS.get();
            if (capturedStacks != null) {
                threadToStacks.put(Thread.currentThread(), CaptureStorage.wrapInString(capturedStacks.peekLast(), limit));
            }
        }
        return threadToStacks;
    }

    public static Object[][] getRelatedStack(Object key, int limit) {
        return CaptureStorage.wrapInArray(STORAGE_GENERAL.get(key), limit);
    }

    private static String wrapInString(CapturedStack stack, int limit) {
        if (stack == null) {
            return null;
        }
        return CaptureStorage.wrapAsyncStackTraceInString(CaptureStorage.getStackTrace(stack, limit));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String wrapAsyncStackTraceInString(List<StackTraceElement> stackTrace) {
        if (stackTrace == null || stackTrace.isEmpty()) {
            return null;
        }
        try (ByteArrayOutputStream bas = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dos = new DataOutputStream(bas);){
                CaptureStorage.writeAsyncStackTraceToStream(stackTrace, dos);
                string = bas.toString(StandardCharsets.ISO_8859_1.name());
            }
            return string;
        }
        catch (IOException e) {
            CaptureStorage.handleException(e);
            return null;
        }
    }

    static void writeAsyncStackTraceToStream(List<StackTraceElement> stackTrace, DataOutputStream dos) throws IOException {
        for (StackTraceElement elem : stackTrace) {
            CaptureStorage.writeAsyncStackTraceElementToStream(elem, dos);
        }
    }

    static void writeAsyncStackTraceElementToStream(StackTraceElement elem, DataOutputStream dos) throws IOException {
        if (elem == ASYNC_STACK_ELEMENT) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            dos.writeUTF(elem.getClassName());
            dos.writeUTF(elem.getMethodName());
            dos.writeInt(elem.getLineNumber());
        }
    }

    private static Object[][] wrapInArray(CapturedStack stack, int limit) {
        if (stack == null) {
            return null;
        }
        ArrayList<StackTraceElement> stackTrace = CaptureStorage.getStackTrace(stack, limit);
        Object[][] res = new Object[stackTrace.size()][];
        for (int i = 0; i < stackTrace.size(); ++i) {
            StackTraceElement elem = (StackTraceElement)stackTrace.get(i);
            res[i] = elem == ASYNC_STACK_ELEMENT ? null : new Object[]{elem.getClassName(), elem.getFileName(), elem.getMethodName(), String.valueOf(elem.getLineNumber())};
        }
        return res;
    }

    private static List<StackTraceElement> trimInitAgentFrames(List<StackTraceElement> elements) {
        int firstNotAgent = 0;
        for (int i = 0; i < elements.size(); ++i) {
            if (!CaptureStorage.isNotAgentFrame(elements.get(i))) continue;
            firstNotAgent = i;
            break;
        }
        return elements.subList(firstNotAgent, elements.size());
    }

    private static ArrayList<StackTraceElement> getStackTrace(CapturedStack stack, int limit) {
        ArrayList<StackTraceElement> res = new ArrayList<StackTraceElement>();
        while (stack != null && res.size() <= limit) {
            List<StackTraceElement> filteredStacks = CaptureStorage.trimInitAgentFrames(stack.getStackTrace());
            StackData stackData = stack.collectStacks(filteredStacks);
            res.addAll(stackData.stackTrace);
            stack = stackData.previous;
            if (stack == null) continue;
            res.add(ASYNC_STACK_ELEMENT);
        }
        return res;
    }

    public static void setEnabled(boolean enabled) {
        ENABLED = enabled;
    }

    private static void handleException(Throwable e) {
        ENABLED = false;
        System.err.println("Critical error in IDEA Async Stacktraces instrumenting agent. Agent is now disabled. Please report to IDEA support:");
        e.printStackTrace();
    }

    private static boolean isNotAgentFrame(StackTraceElement elem) {
        return !elem.getClassName().startsWith(CaptureStorage.class.getPackage().getName());
    }

    private static String getCallerDescriptorForLogging() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stackTrace.length; ++i) {
            StackTraceElement elem = stackTrace[i];
            if (!CaptureStorage.isNotAgentFrame(elem)) continue;
            return elem.getClassName() + "." + elem.getMethodName();
        }
        return "unknown";
    }

    private static String getKeyText(Object key) {
        String res = key.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(key));
        try {
            return res + "(" + key + ")";
        }
        catch (RuntimeException runtimeException) {
            return res;
        }
    }

    static /* synthetic */ OverheadDetector access$100() {
        return ourOverheadDetector;
    }

    static {
        ENABLED = true;
        ASYNC_STACK_ELEMENT = new StackTraceElement("--- Async", "Stack.Trace --- ", "captured by IntelliJ IDEA debugger", -1);
        THROTTLED_STACK_ELEMENT = new StackTraceElement("< Unknown", "Stack > ", "was not captured due to throttling", -1);
        COROUTINE_GET_CALLER_FRAME_METHODS = new ConcurrentIdentityWeakHashMap();
    }

    private static class ThrottledCapturedStack
    extends CapturedStack {
        public static final ThrottledCapturedStack INSTANCE = new ThrottledCapturedStack();
        private static final List<StackTraceElement> STACK_TRACE_ELEMENTS = Collections.singletonList(THROTTLED_STACK_ELEMENT);

        private ThrottledCapturedStack() {
        }

        @Override
        public List<StackTraceElement> getStackTrace() {
            return STACK_TRACE_ELEMENTS;
        }
    }

    private static class DeepCapturedStack
    extends CapturedStack {
        private final CapturedStack myCurrent;
        private final CapturedStack myPrevious;
        private final int myRecursionDepth;

        DeepCapturedStack(CapturedStack stack, CapturedStack previous) {
            this.myCurrent = stack;
            this.myPrevious = previous;
            this.myRecursionDepth = previous.getRecursionDepth() + 1;
        }

        @Override
        public List<StackTraceElement> getStackTrace() {
            return this.myCurrent.getStackTrace();
        }

        @Override
        public int getRecursionDepth() {
            return this.myRecursionDepth;
        }

        @Override
        StackData collectStacks(List<StackTraceElement> stackTrace) {
            int size = stackTrace.size();
            int newEnd = Integer.MAX_VALUE;
            for (int i = 0; i < size; ++i) {
                StackTraceElement elem = stackTrace.get(i);
                if (elem.getMethodName().endsWith(CaptureStorage.GENERATED_INSERT_METHOD_POSTFIX)) {
                    newEnd = i + 2;
                    break;
                }
                if (elem != ASYNC_STACK_ELEMENT) continue;
                newEnd = i;
                break;
            }
            if (newEnd > size) {
                return new StackData(stackTrace, null);
            }
            return new StackData(stackTrace.subList(0, newEnd), this.myPrevious);
        }
    }

    private static class ExceptionCapturedStack
    extends CapturedStack {
        final Throwable myException;

        private ExceptionCapturedStack(Throwable exception) {
            this.myException = exception;
        }

        @Override
        public List<StackTraceElement> getStackTrace() {
            return Arrays.asList(this.myException.getStackTrace());
        }
    }

    private static class UnwindCapturedStack
    extends CapturedStack {
        final List<StackTraceElement> myStackTraceElements;

        UnwindCapturedStack(List<StackTraceElement> elements) {
            this.myStackTraceElements = elements;
        }

        @Override
        public List<StackTraceElement> getStackTrace() {
            return this.myStackTraceElements;
        }
    }

    private static abstract class CapturedStack {
        private CapturedStack() {
        }

        abstract List<StackTraceElement> getStackTrace();

        int getRecursionDepth() {
            return 0;
        }

        StackData collectStacks(List<StackTraceElement> stackTrace) {
            return new StackData(stackTrace, null);
        }
    }

    private static class StackData {
        public final List<StackTraceElement> stackTrace;
        public final CapturedStack previous;

        private StackData(List<StackTraceElement> stackTrace, CapturedStack previous) {
            this.stackTrace = stackTrace;
            this.previous = previous;
        }
    }

    private static class ConcurrentIdentityWeakHashMap<K, V> {
        private final ReferenceQueue<K> referenceQueue = new ReferenceQueue();
        private final ConcurrentMap<Key<K>, V> map = new ConcurrentHashMap<Key<K>, V>();

        private ConcurrentIdentityWeakHashMap() {
        }

        public V put(K key, V value) {
            this.processQueue();
            return this.map.put(new WeakKey<K>(key, this.referenceQueue), value);
        }

        public V get(K key) {
            return this.map.get(new HardKey<K>(key));
        }

        private void processQueue() {
            WeakKey key;
            while ((key = (WeakKey)this.referenceQueue.poll()) != null) {
                this.map.remove(key);
            }
        }

        private static boolean equalKeys(Key<?> x, Key<?> y) {
            if (x == y) {
                return true;
            }
            Object kx = x.get();
            Object ky = y.get();
            return kx != null && kx == ky;
        }

        private static class WeakKey<K>
        extends WeakReference<K>
        implements Key<K> {
            private final int myHash;

            WeakKey(K key, ReferenceQueue<K> q) {
                super(key, q);
                this.myHash = System.identityHashCode(key);
            }

            public boolean equals(Object o) {
                return o instanceof Key && ConcurrentIdentityWeakHashMap.equalKeys(this, (Key)o);
            }

            public int hashCode() {
                return this.myHash;
            }
        }

        private static class HardKey<K>
        implements Key<K> {
            private final K myKey;
            private final int myHash;

            HardKey(K key) {
                this.myKey = key;
                this.myHash = System.identityHashCode(key);
            }

            @Override
            public K get() {
                return this.myKey;
            }

            public boolean equals(Object o) {
                return o instanceof Key && ConcurrentIdentityWeakHashMap.equalKeys(this, (Key)o);
            }

            public int hashCode() {
                return this.myHash;
            }
        }

        private static interface Key<K> {
            public K get();
        }
    }

    private static interface Callable<T> {
        public T call();
    }

    static class ThreadLocalContext {
        final OverheadDetector.OverheadTracker overheadTracker = CaptureStorage.access$100().createOverheadTracker();
        boolean throwableCaptureDisabled = false;

        ThreadLocalContext() {
        }
    }
}

