/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.apiversioning.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.apiversioning.SpringApiVersioningModel;
import com.intellij.spring.mvc.apiversioning.SpringProgrammaticVersioningConfigSearcher;
import com.intellij.spring.mvc.apiversioning.highlighting.SpringApiVersioningInspectionBase;
import com.intellij.spring.mvc.apiversioning.highlighting.fix.SpringConfigureApiVersioningFix;
import com.intellij.spring.mvc.apiversioning.highlighting.fix.SpringNavigateToWebConfigurerFix;
import com.intellij.spring.mvc.apiversioning.model.SpringApiVersioningConfiguration;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningConfigurationInspection;", "Lcom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningInspectionBase;", "<init>", "()V", "checkInternal", "", "uDeclaration", "Lorg/jetbrains/uast/UDeclaration;", "module", "Lcom/intellij/openapi/module/Module;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "canAddApiVersioningConfiguration", "", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringApiVersioningConfigurationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringApiVersioningConfigurationInspection.kt\ncom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningConfigurationInspection\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n24#2:46\n1786#3,3:47\n*S KotlinDebug\n*F\n+ 1 SpringApiVersioningConfigurationInspection.kt\ncom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningConfigurationInspection\n*L\n25#1:46\n43#1:47,3\n*E\n"})
public final class SpringApiVersioningConfigurationInspection
extends SpringApiVersioningInspectionBase {
    /*
     * WARNING - void declaration
     */
    @Override
    public void checkInternal(@NotNull UDeclaration uDeclaration, @NotNull Module module, @NotNull ProblemsHolder problemsHolder) {
        LocalQuickFix[] localQuickFixArray;
        Object[] objectArray;
        UElement uElement;
        block8: {
            block7: {
                void $this$getParentOfType_u24default$iv;
                RequestMapping<?> requestMapping;
                Intrinsics.checkNotNullParameter((Object)uDeclaration, (String)"uDeclaration");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
                RequestMapping<?> requestMapping2 = requestMapping = this.getRequestMapping(uDeclaration, module);
                if ((requestMapping2 != null ? requestMapping2.getVersion() : null) == null) {
                    return;
                }
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                SpringApiVersioningConfiguration apiVersioningConfiguration = SpringApiVersioningModel.Companion.getInstance(project).getApiVersioningConfiguration(module);
                if (apiVersioningConfiguration != null) {
                    return;
                }
                UExpression uExpression = this.getVersionAttributeExpression(requestMapping);
                if (uExpression == null) break block7;
                uElement = (UElement)uExpression;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                objectArray = (SpringConfigureApiVersioningFix[])UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UNamedExpression.class, (boolean)strict$iv);
                if (objectArray != null && (uElement = objectArray.getSourcePsi()) != null) break block8;
            }
            return;
        }
        UElement versionAttributePsiElement = uElement;
        if (this.canAddApiVersioningConfiguration(module)) {
            objectArray = new SpringConfigureApiVersioningFix[]{new SpringConfigureApiVersioningFix()};
            localQuickFixArray = (LocalQuickFix[])objectArray;
        } else {
            objectArray = new SpringNavigateToWebConfigurerFix[]{new SpringNavigateToWebConfigurerFix()};
            localQuickFixArray = (LocalQuickFix[])objectArray;
        }
        LocalQuickFix[] fixes = localQuickFixArray;
        problemsHolder.registerProblem((PsiElement)versionAttributePsiElement, SpringMvcBundle.message("mvc.inspection.api.versioning.not.configured", new Object[0]), Arrays.copyOf(fixes, fixes.length));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canAddApiVersioningConfiguration(Module module) {
        boolean bl;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<Pair<UClass, UMethod>> configurers = SpringProgrammaticVersioningConfigSearcher.Companion.getInstance(project).getConfigureApiVersioningMethods$intellij_spring_mvc_impl(module);
        if (configurers.isEmpty()) return true;
        Iterable $this$all$iv = configurers;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            Pair pair = (Pair)element$iv;
            boolean bl2 = false;
            UMethod method = (UMethod)pair.component2();
            if (method != null) return false;
            bl = true;
        } while (bl);
        return false;
    }
}

