/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.apiversioning.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.apiversioning.SpringApiVersioningModel;
import com.intellij.spring.mvc.apiversioning.highlighting.SpringApiVersioningInspectionBase;
import com.intellij.spring.mvc.apiversioning.highlighting.SpringEndpointVersionInspectionKt;
import com.intellij.spring.mvc.apiversioning.model.SpringApiVersioningConfiguration;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spring/mvc/apiversioning/highlighting/SpringEndpointVersionInspection;", "Lcom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningInspectionBase;", "<init>", "()V", "checkInternal", "", "uDeclaration", "Lorg/jetbrains/uast/UDeclaration;", "module", "Lcom/intellij/openapi/module/Module;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "skipNonDigits", "", "version", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringEndpointVersionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringEndpointVersionInspection.kt\ncom/intellij/spring/mvc/apiversioning/highlighting/SpringEndpointVersionInspection\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,35:1\n416#2,4:36\n*S KotlinDebug\n*F\n+ 1 SpringEndpointVersionInspection.kt\ncom/intellij/spring/mvc/apiversioning/highlighting/SpringEndpointVersionInspection\n*L\n34#1:36,4\n*E\n"})
public final class SpringEndpointVersionInspection
extends SpringApiVersioningInspectionBase {
    @Override
    public void checkInternal(@NotNull UDeclaration uDeclaration, @NotNull Module module, @NotNull ProblemsHolder problemsHolder) {
        Intrinsics.checkNotNullParameter((Object)uDeclaration, (String)"uDeclaration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        RequestMapping<?> requestMapping = this.getRequestMapping(uDeclaration, module);
        RequestMapping<?> requestMapping2 = requestMapping;
        if (requestMapping2 == null || (requestMapping2 = requestMapping2.getVersion()) == null) {
            return;
        }
        RequestMapping<?> version = requestMapping2;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SpringApiVersioningConfiguration apiVersioningConfiguration = SpringApiVersioningModel.Companion.getInstance(project).getApiVersioningConfiguration(module);
        if (apiVersioningConfiguration == null) {
            return;
        }
        UExpression uExpression = this.getVersionAttributeExpression(requestMapping);
        if (uExpression == null || (uExpression = uExpression.getSourcePsi()) == null) {
            return;
        }
        UExpression versionPsiElement = uExpression;
        if (StringsKt.isBlank((CharSequence)((CharSequence)((Object)version)))) {
            problemsHolder.registerProblem((PsiElement)versionPsiElement, SpringMvcBundle.message("mvc.api.empty.version", new Object[0]), new LocalQuickFix[0]);
        } else if (Intrinsics.areEqual((Object)apiVersioningConfiguration.getHasCustomVersionParser(), (Object)false)) {
            CharSequence charSequence = this.skipNonDigits((String)((Object)version));
            if (!SpringEndpointVersionInspectionKt.access$getSEM_VER_PATTERN$p().matches(charSequence)) {
                problemsHolder.registerProblem((PsiElement)versionPsiElement, SpringMvcBundle.message("mvc.api.sem.ver.malformed", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private final String skipNonDigits(String version) {
        String string;
        block1: {
            String $this$dropWhile$iv = version;
            boolean $i$f$dropWhile = false;
            int n = ((CharSequence)$this$dropWhile$iv).length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$dropWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (!Character.isDigit(it)) continue;
                String string2 = $this$dropWhile$iv.substring(index$iv);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                break block1;
            }
            string = "";
        }
        return string;
    }
}

