/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.utils;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.model.beanRegistrar.KotlinDslRegistrarModelKt;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.spring.mvc.functional.utils.FunctionalMvcProcessingContext;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public final class SpringMvcFunctionalSearchers {
    public static final String NEST_METHOD_NAME = "nest";
    public static final String AND_NEST_METHOD_NAME = "andNest";
    public static final String ROUTE_METHOD_NAME = "route";
    public static final String COROUTE_METHOD_NAME = "coRoute";
    public static final String AND_ROUTE_METHOD_NAME = "andRoute";
    public static final String METHOD_METHOD_NAME = "method";
    public static final String PATH_METHOD_NAME = "path";
    public static final String ADD_METHOD_NAME = "add";
    public static final String AND_METHOD_NAME = "and";

    @Nullable
    public static UExpression findPathExpression(@NotNull UExpression expression, @NotNull Module module, boolean isReactive) {
        UCallExpression pathCallExpression;
        PsiMethod pathMethod;
        if (expression == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(1);
        }
        PsiMethod psiMethod = pathMethod = isReactive ? SpringMvcFunctionalSearchers.findReactiveRequestPredicatesPathMethod(module) : SpringMvcFunctionalSearchers.findRequestPredicatesPathMethod(module);
        if (pathMethod == null) {
            return null;
        }
        PsiElement sourcePsi = expression.getSourcePsi();
        if (sourcePsi == null) {
            return null;
        }
        PsiReference psiReference = (PsiReference)MethodReferencesSearch.search((PsiMethod)pathMethod, (SearchScope)new LocalSearchScope(sourcePsi), (boolean)true).findFirst();
        if (psiReference != null && (pathCallExpression = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)psiReference.getElement(), UCallExpression.class)) != null) {
            return pathCallExpression.getArgumentForParameter(0);
        }
        return null;
    }

    public static PsiClass findRequestPredicatesClass(@Nullable Module module, boolean isReactive) {
        if (module == null) {
            return null;
        }
        return isReactive ? SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.RequestPredicates") : SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.function.RequestPredicates");
    }

    public static PsiClass findRequestPredicatesClass(@Nullable Module module, @NotNull String requestPredicatesClass) {
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(2);
        }
        return module == null ? null : SpringCommonUtils.findLibraryClass((Module)module, (String)requestPredicatesClass);
    }

    public static PsiClass findRouterFunctionsBuilderClass(@Nullable Module module, boolean isReactive) {
        if (module == null) {
            return null;
        }
        return isReactive ? SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.RouterFunctions.Builder") : SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.function.RouterFunctions.Builder");
    }

    public static PsiMethod[] findReactiveRouterFunctionDslNestMethods(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(3);
        }
        return (PsiMethod[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringFunctionalSearchersUtils.findMethods((String)NEST_METHOD_NAME, (PsiClass)SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.RouterFunctionDsl")), (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject())));
    }

    public static PsiMethod[] findServletRouterFunctionDslNestMethods(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(4);
        }
        return (PsiMethod[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringFunctionalSearchersUtils.findMethods((String)NEST_METHOD_NAME, (PsiClass)SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.function.RouterFunctionDsl")), (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject())));
    }

    public static PsiMethod[] findReactiveCoRouterFunctionDslNestMethods(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(5);
        }
        return (PsiMethod[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringFunctionalSearchersUtils.findMethods((String)NEST_METHOD_NAME, (PsiClass)SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.CoRouterFunctionDsl")), (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject())));
    }

    public static PsiMethod[] findServletCoRouterFunctionDslNestMethods(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(6);
        }
        return (PsiMethod[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringFunctionalSearchersUtils.findMethods((String)NEST_METHOD_NAME, (PsiClass)SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.function.CoRouterFunctionDsl")), (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject())));
    }

    @Nullable
    private static PsiMethod findRequestPredicatesPathMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(7);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringFunctionalSearchersUtils.findMethod((String)PATH_METHOD_NAME, (PsiClass)SpringMvcFunctionalSearchers.findRequestPredicatesClass(module, false)), (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject())));
    }

    @Nullable
    private static PsiMethod findReactiveRequestPredicatesPathMethod(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(8);
        }
        return (PsiMethod)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)SpringFunctionalSearchersUtils.findMethod((String)PATH_METHOD_NAME, (PsiClass)SpringMvcFunctionalSearchers.findRequestPredicatesClass(module, true)), (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject())));
    }

    @NotNull
    public static Collection<PsiElement> getExtendedDefinitionScope(@NotNull PsiElement definitionScope) {
        UMethod uMethod;
        if (definitionScope == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(9);
        }
        if ((uMethod = (UMethod)UastContextKt.toUElementOfExpectedTypes((PsiElement)definitionScope, (Class[])new Class[]{UMethod.class})) != null) {
            HashSet<PsiElement> scopes = new HashSet<PsiElement>();
            UExpression uBody = uMethod.getUastBody();
            if (!(uBody instanceof UBlockExpression)) {
                Set<PsiElement> set = Collections.emptySet();
                if (set == null) {
                    SpringMvcFunctionalSearchers.$$$reportNull$$$0(10);
                }
                return set;
            }
            List expressions = ContainerUtil.filterIsInstance((Collection)((UBlockExpression)uBody).getExpressions(), UReturnExpression.class);
            for (UReturnExpression uReturnExpression : expressions) {
                UExpression returnValue = uReturnExpression.getReturnExpression();
                if (returnValue == null) continue;
                if (returnValue instanceof UReferenceExpression) {
                    UExpression uastInitializer;
                    UReferenceExpression referenceExpression = (UReferenceExpression)returnValue;
                    UElement uElement = UResolvableKt.resolveToUElement((UResolvable)referenceExpression);
                    if (uElement instanceof UMethod) {
                        ContainerUtil.addIfNotNull(scopes, (Object)uElement.getSourcePsi());
                        continue;
                    }
                    UField uField = (UField)ObjectUtils.tryCast((Object)uElement, UField.class);
                    if (uField == null || !uField.isFinal() || (uastInitializer = uField.getUastInitializer()) == null) continue;
                    ContainerUtil.addIfNotNull(scopes, (Object)uastInitializer.getSourcePsi());
                    continue;
                }
                if (!(returnValue instanceof UCallExpression)) continue;
                ContainerUtil.addIfNotNull(scopes, (Object)((UCallExpression)returnValue).resolve());
            }
            HashSet<PsiElement> hashSet = scopes;
            if (hashSet == null) {
                SpringMvcFunctionalSearchers.$$$reportNull$$$0(11);
            }
            return hashSet;
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)definitionScope, UCallExpression.class);
        if (uElement instanceof UCallExpression) {
            UCallExpression callExpression = (UCallExpression)uElement;
            return SpringMvcFunctionalSearchers.getFactoryMethodCalls(callExpression);
        }
        Set<PsiElement> set = Collections.emptySet();
        if (set == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    private static Collection<PsiElement> getFactoryMethodCalls(UCallExpression callExpression) {
        final SmartList result = new SmartList();
        callExpression.accept((UastVisitor)new AbstractUastVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiType type = node.getReturnType();
                return this.processType((UResolvable)node, type);
            }

            public boolean visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                PsiType expressionType;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((expressionType = node.getExpressionType()) != null) {
                    PsiType type = KotlinDslRegistrarModelKt.getCorrectedReturnType((PsiType)expressionType);
                    return this.processType((UResolvable)node, type);
                }
                return false;
            }

            private boolean processType(@NotNull UResolvable node, PsiType type) {
                PsiElement psiElement;
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (type == null) {
                    return false;
                }
                String text = type.getCanonicalText();
                if ((text.startsWith("org.springframework.web.servlet.function.RouterFunction") || text.startsWith("org.springframework.web.reactive.function.server.RouterFunction")) && (psiElement = node.resolve()) != null) {
                    result.add((Object)psiElement);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/spring/mvc/functional/utils/SpringMvcFunctionalSearchers$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallableReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        SmartList smartList = result;
        if (smartList == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(13);
        }
        return smartList;
    }

    @NotNull
    static Set<UCallExpression> findRouterFunctionsNestExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(14);
        }
        HashSet<UCallExpression> nestCalls = new HashSet<UCallExpression>();
        if (context.reactive) {
            nestCalls.addAll(SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.reactive.function.server.RouterFunctions", NEST_METHOD_NAME, context));
            nestCalls.addAll(SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.reactive.function.server.RouterFunction", AND_NEST_METHOD_NAME, context));
            nestCalls.addAll(SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.reactive.function.server.RouterFunctions.Builder", NEST_METHOD_NAME, context));
        } else {
            nestCalls.addAll(SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.servlet.function.RouterFunctions", NEST_METHOD_NAME, context));
            nestCalls.addAll(SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.servlet.function.RouterFunction", AND_NEST_METHOD_NAME, context));
            nestCalls.addAll(SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.servlet.function.RouterFunctions.Builder", NEST_METHOD_NAME, context));
        }
        nestCalls.addAll(SpringMvcFunctionalUtil.getMethodCalls("org.springdoc.webflux.core.fn.SpringdocRouteBuilder", NEST_METHOD_NAME, context));
        HashSet<UCallExpression> hashSet = nestCalls;
        if (hashSet == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    @NotNull
    static Set<UCallExpression> findRouterFunctionsBuilderNestExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(16);
        }
        Set<UCallExpression> set = context.reactive ? SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.reactive.function.server.RouterFunctions.Builder", NEST_METHOD_NAME, context) : SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.servlet.function.RouterFunctions.Builder", NEST_METHOD_NAME, context);
        if (set == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(17);
        }
        return set;
    }

    @NotNull
    static Set<UCallExpression> findRouterFunctionsBuilderPathExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(18);
        }
        Set<UCallExpression> set = context.reactive ? SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.reactive.function.server.RouterFunctions.Builder", PATH_METHOD_NAME, context) : SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.servlet.function.RouterFunctions.Builder", PATH_METHOD_NAME, context);
        if (set == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(19);
        }
        return set;
    }

    public static PsiClass findSpringdocRouterBuilderClass(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springdoc.webflux.core.fn.SpringdocRouteBuilder");
    }

    @NotNull
    static Set<UCallExpression> findSpringdocRouterBuilderNestExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(20);
        }
        Set<UCallExpression> set = SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.reactive.function.server.RouterFunctions.Builder", NEST_METHOD_NAME, context);
        if (set == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(21);
        }
        return set;
    }

    @NotNull
    static Set<UCallExpression> findSpringdocRouterBuilderPathExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(22);
        }
        Set<UCallExpression> set = SpringMvcFunctionalUtil.getMethodCalls("org.springdoc.webflux.core.fn.SpringdocRouteBuilder", PATH_METHOD_NAME, context);
        if (set == null) {
            SpringMvcFunctionalSearchers.$$$reportNull$$$0(23);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13, 15, 17, 19, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPredicatesClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionScope";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/functional/utils/SpringMvcFunctionalSearchers";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/functional/utils/SpringMvcFunctionalSearchers";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedDefinitionScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryMethodCalls";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findRouterFunctionsNestExpressions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findRouterFunctionsBuilderNestExpressions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findRouterFunctionsBuilderPathExpressions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findSpringdocRouterBuilderNestExpressions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findSpringdocRouterBuilderPathExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPathExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findRequestPredicatesClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findReactiveRouterFunctionDslNestMethods";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findServletRouterFunctionDslNestMethods";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findReactiveCoRouterFunctionDslNestMethods";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findServletCoRouterFunctionDslNestMethods";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRequestPredicatesPathMethod";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findReactiveRequestPredicatesPathMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExtendedDefinitionScope";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRouterFunctionsNestExpressions";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findRouterFunctionsBuilderNestExpressions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findRouterFunctionsBuilderPathExpressions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findSpringdocRouterBuilderNestExpressions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findSpringdocRouterBuilderPathExpressions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13, 15, 17, 19, 21, 23 -> new IllegalStateException(string);
        };
    }
}

