/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.scheme.xmlUpdateHelper;

import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public final class CssPagePropertiesScraper {
    public static void main(String[] args) throws IOException {
        String url = "https://www.w3.org/TR/css-page-3";
        File file = new File(url);
        try (InputStream inputStream = file.exists() ? new FileInputStream(file) : URLUtil.openStream((URL)new URL(url));){
            Document document = Jsoup.parse((InputStream)inputStream, (String)"UTF-8", (String)"");
            CssPagePropertiesScraper.generateProperties(document, "page-property-list");
            System.out.println();
            CssPagePropertiesScraper.generateProperties(document, "margin-property-list");
        }
    }

    private static void generateProperties(Document document, String headerId) {
        Element header = document.getElementById(headerId);
        Element table = header.nextElementSibling().nextElementSibling();
        ArrayList<String> properties = new ArrayList<String>();
        for (Node tbody : table.childNodes()) {
            tbody.childNodes().forEach(tr -> {
                if (tr.lastChild() != null) {
                    properties.add(((Element)tr.lastChild()).text());
                }
            });
        }
        properties.forEach(property -> System.out.println(property + ": unset;"));
    }
}

