/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions.cwm;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.RuntimeFlagsKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHintKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.editor.TextControlModelExKt;
import com.jetbrains.rd.ide.model.ActionCallStrategyKind;
import com.jetbrains.rd.ide.model.ActionTimestampSetModel;
import com.jetbrains.rd.ide.model.RdCmdItem;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.actions.base.ActionContinuation;
import com.jetbrains.rdclient.actions.base.ActionContinuationHolder;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.actions.base.FrontendActionExecutionListener;
import com.jetbrains.rdclient.actions.base.FrontendActionExecutionListenerKt;
import com.jetbrains.rdclient.actions.base.FrontendActionUpdateTrait;
import com.jetbrains.rdclient.actions.cwm.ActionTimestampModelProvider;
import com.jetbrains.rdclient.actions.cwm.FrontendAsyncActionHost;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.diagnostics.ActionRequestFusData;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editorActions.cwm.EditorActionCommandInfo;
import com.jetbrains.rdclient.editorActions.cwm.FrontendAsyncEditorActionHandler;
import com.jetbrains.rdclient.editorActions.cwm.FrontendAsyncEditorActionHandlerKt;
import com.jetbrains.rdclient.editorActions.cwm.FrontendCallEditorActionRequest;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionHandlerStrategyCustomizer;
import com.jetbrains.rdclient.editorActions.cwm.PhantomCallEditorActionRequest;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.requests.FrontendApplyPatchRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResultKt;
import com.jetbrains.rdclient.requests.FrontendSpeculativeRequestRecordingListener;
import com.jetbrains.rdclient.services.RdActionsSupport;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0016\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0003\u001d\u001e\u001fB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J*\u0010\u0019\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J2\u0010\u001b\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0004H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "Lcom/jetbrains/rdclient/actions/base/FrontendActionUpdateTrait;", "frontendId", "", "baseHandler", "backendDeclaredStrategy", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;)V", "getBackendDeclaredStrategy", "()Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "getCallStrategy", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "backendIsEnabled", "", "isEnabledForCaret", "doExecute", "", "strategy", "doExecuteByStrategy", "tryFrontend", "executeFrontend", "frontendActionId", "CallEditorActionRequestFactory", "LocalCallEditorActionRequestFactory", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendAsyncEditorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n+ 3 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,341:1\n107#2:342\n98#2,4:343\n103#2:347\n98#2,4:348\n106#2:376\n98#2,4:377\n62#3,7:352\n69#3,2:364\n71#3,6:367\n77#3,2:374\n57#4:359\n35#4,2:360\n82#4,2:362\n84#4:366\n23#4:373\n30#5,2:381\n1786#6,3:383\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler\n*L\n121#1:342\n121#1:343,4\n125#1:347\n125#1:348,4\n177#1:376\n177#1:377,4\n150#1:352,7\n150#1:364,2\n150#1:367,6\n150#1:374,2\n150#1:359\n150#1:360,2\n150#1:362,2\n150#1:366\n150#1:373\n217#1:381,2\n226#1:383,3\n*E\n"})
public class FrontendAsyncEditorActionHandler
extends EditorActionHandler
implements FrontendActionUpdateTrait {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String frontendId;
    @NotNull
    private final EditorActionHandler baseHandler;
    @NotNull
    private final ActionCallStrategyKind backendDeclaredStrategy;
    @NotNull
    private static final Set<String> TRAVERSAL_ACTIONS_IDS;
    private static boolean isExecuting;

    public FrontendAsyncEditorActionHandler(@NotNull String frontendId, @NotNull EditorActionHandler baseHandler, @NotNull ActionCallStrategyKind backendDeclaredStrategy) {
        Intrinsics.checkNotNullParameter((Object)frontendId, (String)"frontendId");
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        Intrinsics.checkNotNullParameter((Object)backendDeclaredStrategy, (String)"backendDeclaredStrategy");
        this.frontendId = frontendId;
        this.baseHandler = baseHandler;
        this.backendDeclaredStrategy = backendDeclaredStrategy;
    }

    @NotNull
    public final ActionCallStrategyKind getBackendDeclaredStrategy() {
        return this.backendDeclaredStrategy;
    }

    @NotNull
    public final ActionCallStrategyKind getCallStrategy(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        ActionCallStrategyKind actionCallStrategyKind = Companion.getCallStrategy(this.frontendId, editor, caret, dataContext);
        if (actionCallStrategyKind == null) {
            actionCallStrategyKind = this.backendDeclaredStrategy;
        }
        return actionCallStrategyKind;
    }

    private final boolean backendIsEnabled(Editor editor, DataContext dataContext) {
        return DocumentExKt.getTextControlId(editor) != null && FrontendActionUpdateTrait.super.frontendUpdate(this.frontendId, dataContext, null, "unknown", null);
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return this.baseHandler.isEnabled(editor, caret, dataContext);
        }
        if (DocumentExKt.getTextControlId(editor) == null) {
            return this.baseHandler.isEnabled(editor, caret, dataContext);
        }
        ActionCallStrategyKind strategy2 = this.getCallStrategy(editor, caret, dataContext);
        switch (WhenMappings.$EnumSwitchMapping$0[strategy2.ordinal()]) {
            case 1: 
            case 2: {
                return this.baseHandler.isEnabled(editor, caret, dataContext);
            }
            case 3: {
                return this.baseHandler.isEnabled(editor, caret, dataContext) && this.backendIsEnabled(editor, dataContext);
            }
            case 4: {
                return this.backendIsEnabled(editor, dataContext) || this.baseHandler.isEnabled(editor, caret, dataContext);
            }
            case 5: {
                Boolean actionAvailableByHint = EditorActionAvailabilityHintKt.isActionAvailableByHint$default((Editor)editor, (int)editor.getCaretModel().getOffset(), (String)this.frontendId, null, (int)4, null);
                return Intrinsics.areEqual((Object)actionAvailableByHint, (Object)true);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
            this.executeFrontend(editor, caret, dataContext, this.baseHandler, this.frontendId);
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        ActionCallStrategyKind strategy2 = this.getCallStrategy(editor, caret, dataContext);
        if (isExecuting) {
            void $this$log$iv$iv;
            if (strategy2 == ActionCallStrategyKind.FrontendOnly || strategy2 == ActionCallStrategyKind.FrontendFirst) {
                if (this.baseHandler.isEnabled(editor, caret, dataContext)) {
                    this.executeFrontend(editor, caret, dataContext, this.baseHandler, this.frontendId);
                }
                return;
            }
            Logger $this$error$iv = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
            boolean $i$f$error = false;
            Logger logger = $this$error$iv;
            LogLevel level$iv$iv = LogLevel.Error;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var11_18 = $this$log$iv$iv;
                boolean bl = false;
                String string = "Nested action '" + this.frontendId + "' call: FrontendAsyncEditorActionHandler.doExecute";
                var11_18.log(logLevel, (Object)string, null);
            }
            return;
        }
        Logger $this$trace$iv = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        Logger $this$log$iv$iv = $this$trace$iv;
        LogLevel level$iv$iv = LogLevel.Trace;
        boolean $i$f$log = false;
        if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
            LogLevel logLevel = level$iv$iv;
            Logger logger = $this$log$iv$iv;
            boolean bl = false;
            String string = "For action " + this.frontendId + " selected strategy is " + strategy2;
            logger.log(logLevel, (Object)string, null);
        }
        try {
            isExecuting = true;
            this.doExecute(editor, caret, dataContext, strategy2);
        }
        finally {
            isExecuting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doExecute(Editor editor, Caret caret, DataContext dataContext, ActionCallStrategyKind strategy2) {
        switch (WhenMappings.$EnumSwitchMapping$0[strategy2.ordinal()]) {
            case 1: {
                RdPatch rdPatch;
                void $this$recordChanges$iv;
                ClientAppSession session = FrontendSessionsUtilKt.getFrontendAppSession(dataContext);
                if (session == null || FrontendPatchEngineKt.getEngine(session).getHasActivePatch()) {
                    if (this.baseHandler.isEnabled(editor, caret, dataContext)) {
                        this.executeFrontend(editor, caret, dataContext, this.baseHandler, this.frontendId);
                    }
                    return;
                }
                ResetUndoHistoryToken resetUndoHistoryToken = FrontendAsyncRequestWithImmediateResultKt.createResetUndoHistoryToken(editor);
                PatchEngine patchEngine = FrontendPatchEngineKt.getEngine(session);
                String description$iv = "Action handler " + this.frontendId;
                boolean $i$f$recordChanges = false;
                $this$recordChanges$iv.softAssertThereIsNoActivePatch("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
                boolean alreadyOpened$iv = $this$recordChanges$iv.getHasActivePatch();
                try {
                    RdPatch rdPatch2;
                    AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, null, null, (int)28, null);
                    Throwable throwable = null;
                    try {
                        Object object;
                        void $this$runAndLogException$iv$iv;
                        RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                        boolean bl5 = false;
                        boolean $i$f$fileLogger22 = false;
                        boolean $i$f$currentClassLogger = false;
                        Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(clazz$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        com.intellij.openapi.diagnostic.Logger $i$f$fileLogger22 = logger;
                        boolean $i$f$runAndLogException = false;
                        void var18_29 = $this$runAndLogException$iv$iv;
                        try {
                            void $this$runAndLogException_u24lambda_u240$iv$iv = var18_29;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ChangeScope $this$doExecute_u24lambda_u242 = it$iv.getSession().getChangeScope();
                            boolean bl4 = false;
                            if (this.baseHandler.isEnabled(editor, caret, dataContext)) {
                                this.executeFrontend(editor, caret, dataContext, this.baseHandler, this.frontendId);
                            }
                            object = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable throwable2) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                        }
                        LoggerKt.getOrLogException((Object)object, (com.intellij.openapi.diagnostic.Logger)$this$runAndLogException$iv$iv);
                        rdPatch2 = it$iv.getSession().buildPatchAndClear();
                    }
                    catch (Throwable bl5) {
                        try {
                            throwable = bl5;
                            throw bl5;
                        }
                        catch (Throwable bl5) {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                            throw bl5;
                        }
                    }
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    rdPatch = rdPatch2;
                }
                finally {
                    if (!alreadyOpened$iv && $this$recordChanges$iv.getHasActivePatch()) {
                        void $this$thisLogger$iv$iv = $this$recordChanges$iv;
                        boolean $i$f$thisLogger = false;
                        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(PatchEngine.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                        while ($this$recordChanges$iv.getHasActivePatch()) {
                            $this$recordChanges$iv.closeCurrentSession("Wrong dispose ordering: " + description$iv);
                        }
                    }
                }
                RdPatch patch = rdPatch;
                if (patch != null) {
                    FrontendAsyncRequestExecutor.Companion.getInstance(session).submitRequest(new FrontendApplyPatchRequest(patch, session, resetUndoHistoryToken));
                }
                return;
            }
            case 3: {
                this.doExecuteByStrategy(editor, caret, dataContext, true);
                return;
            }
            case 2: 
            case 4: {
                this.doExecuteByStrategy(editor, caret, dataContext, false);
                break;
            }
            case 5: {
                void $this$log$iv$iv;
                Boolean availableByHint = EditorActionAvailabilityHintKt.isActionAvailableByHint$default((Editor)editor, (int)editor.getCaretModel().getOffset(), (String)this.frontendId, null, (int)4, null);
                if (Intrinsics.areEqual((Object)availableByHint, (Object)true)) {
                    this.doExecuteByStrategy(editor, caret, dataContext, false);
                    break;
                }
                Logger $this$warn$iv = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
                boolean $i$f$warn = false;
                Logger $this$recordChanges$iv = $this$warn$iv;
                LogLevel level$iv$iv = LogLevel.Warn;
                boolean $i$f$log = false;
                if (!$this$log$iv$iv.isEnabled(level$iv$iv)) break;
                LogLevel logLevel = level$iv$iv;
                void var28_43 = $this$log$iv$iv;
                boolean bl = false;
                String string = "Action '" + this.frontendId + "' is not available by availability hint but still was called for execution. Skipping.";
                var28_43.log(logLevel, (Object)string, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void doExecuteByStrategy(Editor editor, Caret caret, DataContext dataContext, boolean tryFrontend) {
        block18: {
            block17: {
                v0 = FrontendSessionsUtilKt.getFrontendAppSession(dataContext);
                if (v0 == null) {
                    this.executeFrontend(editor, caret, dataContext, this.baseHandler, this.frontendId);
                    return;
                }
                session = v0;
                v1 = DocumentExKt.getTextControlId(editor);
                if (v1 == null) {
                    this.executeFrontend(editor, caret, dataContext, this.baseHandler, this.frontendId);
                    return;
                }
                editorId = v1;
                if (!((Boolean)FrontendSessionsUtilKt.isConnected(session).getValue()).booleanValue() || FrontendPatchEngineKt.getEngine(session).getHasActivePatch()) {
                    this.executeFrontend(editor, caret, dataContext, this.baseHandler, this.frontendId);
                    return;
                }
                v2 = ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendActionExecutionListener.Companion.getTOPIC());
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"syncPublisher(...)");
                FrontendActionExecutionListenerKt.beforeActionExecutedOnBackend((FrontendActionExecutionListener)v2, this.frontendId);
                if (!tryFrontend) break block18;
                if (FrontendAsyncEditorActionHandler.TRAVERSAL_ACTIONS_IDS.contains(this.frontendId)) {
                    v3 = DocumentExKt.getTextControlModel(editor);
                    v4 = v3 != null && (v3 = TextControlModelExKt.getHasTemplateTraversalPolicyExtension((TextControlModel)v3)) != null ? v3.getHasTemplateTraversalPolicy() : false;
                    if (v4) {
                        v5 = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"createFromDataContext(...)");
                        event = v5;
                        FrontendAsyncActionHost.Companion.getInstance(session).execute(this.frontendId, event);
                        return;
                    }
                }
                deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                v6 = (ActionContinuationHolder)BackendActionDelegationKt.getBACKEND_ACTION_CONTINUATION_KEY().getData(dataContext);
                if (v6 != null) {
                    v6.setContinuation(new ActionContinuation((CompletableDeferred<Unit>)deferred){
                        final /* synthetic */ CompletableDeferred<Unit> $deferred;
                        {
                            this.$deferred = $deferred;
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object await(Continuation<? super Unit> $completion) {
                            if (!($completion instanceof doExecuteByStrategy.await.1)) ** GOTO lbl-1000
                            var3_2 = $completion;
                            if ((var3_2.label & -2147483648) != 0) {
                                var3_2.label -= -2147483648;
                            } else lbl-1000:
                            // 2 sources

                            {
                                $continuation = new ContinuationImpl(this, $completion){
                                    /* synthetic */ Object result;
                                    final /* synthetic */ doExecuteByStrategy.1 this$0;
                                    int label;
                                    {
                                        this.this$0 = this$0;
                                        super($completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        this.result = $result;
                                        this.label |= Integer.MIN_VALUE;
                                        return this.this$0.await((Continuation<? super Unit>)((Continuation)this));
                                    }
                                };
                            }
                            $result = $continuation.result;
                            var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch ($continuation.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    $continuation.label = 1;
                                    v0 = this.$deferred.await((Continuation)$continuation);
                                    if (v0 == var4_4) {
                                        return var4_4;
                                    }
                                    ** GOTO lbl20
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl20:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    });
                }
                v7 = activeLookupBeforeAction = LookupManager.getActiveLookup((Editor)editor);
                lookupItemBeforeAction = v7 != null ? v7.getCurrentItem() : null;
                v8 = activeLookupBeforeAction;
                wasFocused = v8 != null ? v8.isFocused() : false;
                $this$service$iv = (ComponentManager)session;
                $i$f$service = false;
                serviceClass$iv = CallEditorActionRequestFactory.class;
                v9 = $this$service$iv.getService(serviceClass$iv);
                if (v9 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                editorActionRequestFactory = (CallEditorActionRequestFactory)v9;
                executeFrontend = (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doExecuteByStrategy$lambda$0(com.jetbrains.rdclient.editorActions.cwm.FrontendAsyncEditorActionHandler com.intellij.openapi.editor.Editor com.intellij.openapi.editor.Caret com.intellij.openapi.actionSystem.DataContext ), ()Lkotlin/Unit;)((FrontendAsyncEditorActionHandler)this, (Editor)editor, (Caret)caret, (DataContext)dataContext);
                request = new Ref.ObjectRef();
                v10 = editorActionRequestFactory.createRequest(editor, editorId, this.frontendId, caret, (Function0<Unit>)executeFrontend, dataContext);
                if (v10 == null) {
                    var16_19 = this;
                    $i$a$-run-FrontendAsyncEditorActionHandler$doExecuteByStrategy$request$1 = false;
                    deferred.complete((Object)Unit.INSTANCE);
                    return;
                }
                request.element = v10;
                v11 = isPatchEmpty = request.element instanceof FrontendAsyncRequestWithImmediateResult != false && ((FrontendAsyncRequestWithImmediateResult)request.element).getPatch().getChanges().isEmpty() != false;
                if (!(request.element instanceof FrontendAsyncRequestWithImmediateResult)) ** GOTO lbl-1000
                $this$all$iv = ((FrontendAsyncRequestWithImmediateResult)request.element).getPatch().getChanges();
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v12 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (RdPatchItem)element$iv;
                        $i$a$-all-FrontendAsyncEditorActionHandler$doExecuteByStrategy$isPatchCommandOnly$1 = false;
                        if (it instanceof RdCmdItem) continue;
                        v12 = false;
                        break block17;
                    }
                    v12 = true;
                }
            }
            if (v12) {
                v13 = true;
            } else lbl-1000:
            // 2 sources

            {
                v13 = isPatchCommandOnly = false;
            }
            if (!(!isPatchEmpty && !isPatchCommandOnly || (currentLookup = LookupManager.getActiveLookup((Editor)editor)) == null || Intrinsics.areEqual((Object)currentLookup.getCurrentItem(), (Object)lookupItemBeforeAction) && wasFocused == currentLookup.isFocused())) {
                if (isPatchEmpty) {
                    deferred.complete((Object)Unit.INSTANCE);
                    return;
                }
                request.element = new FrontendApplyPatchRequest(((FrontendAsyncRequestWithImmediateResult)request.element).getPatch(), session, ((FrontendAsyncRequestWithImmediateResult)request.element).getResetUndoHistoryToken());
            }
            try {
                if (RuntimeFlagsKt.isRhizomeAdEnabled()) ** GOTO lbl97
                FrontendAsyncRequestExecutor.Companion.getInstance(session).submitRequest((FrontendAsyncRequest)request.element);
                Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                v14 = ((EditorImpl)editor).getDisposable();
                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getDisposable(...)");
                lifetime = LifetimeDisposableExKt.createLifetime((Disposable)v14);
                LifetimeCoroutineUtilKt.launch$default((Lifetime)lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<FrontendAsyncRequest>)request, (CompletableDeferred<Unit>)deferred, null){
                    int label;
                    final /* synthetic */ Ref.ObjectRef<FrontendAsyncRequest> $request;
                    final /* synthetic */ CompletableDeferred<Unit> $deferred;
                    {
                        this.$request = $request;
                        this.$deferred = $deferred;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = ((FrontendAsyncRequest)this.$request.element).await((Continuation<? super Unit>)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.$deferred.complete((Object)Unit.INSTANCE);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                lifetime.onTermination((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doExecuteByStrategy$lambda$3(kotlinx.coroutines.CompletableDeferred ), ()Lkotlin/Unit;)((CompletableDeferred)deferred));
            }
            catch (CancellationException ce) {
                deferred.cancel(ce);
                return;
            }
        }
        v15 = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"createFromDataContext(...)");
        event = v15;
        FrontendAsyncActionHost.Companion.getInstance(session).execute(this.frontendId, event);
lbl97:
        // 3 sources

    }

    protected void executeFrontend(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext, @NotNull EditorActionHandler baseHandler, @NotNull String frontendActionId) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        baseHandler.execute(editor, caret, dataContext);
    }

    private static final Unit doExecuteByStrategy$lambda$0(FrontendAsyncEditorActionHandler this$0, Editor $editor, Caret $caret, DataContext $dataContext) {
        this$0.executeFrontend($editor, $caret, $dataContext, this$0.baseHandler, this$0.frontendId);
        return Unit.INSTANCE;
    }

    private static final Unit doExecuteByStrategy$lambda$3(CompletableDeferred $deferred) {
        if (!$deferred.isCompleted()) {
            JobKt.cancel$default((Job)((Job)$deferred), (String)"Editor is disposed", null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"EditorTab", "BraceOrQuoteOut", "EditorUnindentSelection", "EditorIndentSelection"};
        TRAVERSAL_ACTIONS_IDS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001JB\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$CallEditorActionRequestFactory;", "", "createRequest", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "executeFrontend", "Lkotlin/Function0;", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rd.client"})
    public static interface CallEditorActionRequestFactory {
        @Nullable
        public FrontendAsyncRequest createRequest(@NotNull Editor var1, @NotNull TextControlId var2, @NotNull String var3, @Nullable Caret var4, @NotNull Function0<Unit> var5, @NotNull DataContext var6);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$Companion;", "", "<init>", "()V", "TRAVERSAL_ACTIONS_IDS", "", "", "value", "", "isExecuting", "()Z", "getCallStrategy", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "actionId", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isExecuting() {
            return isExecuting;
        }

        @Nullable
        public final ActionCallStrategyKind getCallStrategy(@NotNull String actionId, @Nullable Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (editor == null) {
                return null;
            }
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            FileType fileType = DocumentUtilKt.getFileTypeByName(document);
            return (ActionCallStrategyKind)FrontendEditorActionHandlerStrategyCustomizer.Companion.getEP().computeSafeIfAny(arg_0 -> Companion.getCallStrategy$lambda$0(actionId, editor, caret, dataContext, fileType, arg_0));
        }

        private static final ActionCallStrategyKind getCallStrategy$lambda$0(String $actionId, Editor $editor, Caret $caret, DataContext $dataContext, FileType $fileType, FrontendEditorActionHandlerStrategyCustomizer customizer) {
            Intrinsics.checkNotNullParameter((Object)customizer, (String)"customizer");
            return customizer.getCustomStrategy($actionId, $editor, $caret, $dataContext, $fileType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$CallEditorActionRequestFactory;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "createRequest", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "executeFrontend", "Lkotlin/Function0;", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendAsyncEditorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory\n+ 2 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,341:1\n62#2,7:342\n69#2,2:354\n71#2,6:357\n77#2,2:364\n57#3:349\n35#3,2:350\n82#3,2:352\n84#3:356\n23#3:363\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory\n*L\n297#1:342,7\n297#1:354,2\n297#1:357,6\n297#1:364,2\n297#1:349\n297#1:350,2\n297#1:352,2\n297#1:356\n297#1:363\n*E\n"})
    public static final class LocalCallEditorActionRequestFactory
    implements CallEditorActionRequestFactory {
        @NotNull
        private final ClientAppSession session;

        public LocalCallEditorActionRequestFactory(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        @NotNull
        public final ClientAppSession getSession() {
            return this.session;
        }

        @Override
        @Nullable
        public FrontendAsyncRequest createRequest(@NotNull Editor editor, @NotNull TextControlId editorId, @NotNull String frontendActionId, @Nullable Caret caret, @NotNull Function0<Unit> executeFrontend, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
            Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
            Intrinsics.checkNotNullParameter(executeFrontend, (String)"executeFrontend");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            ResetUndoHistoryToken resetUndoHistoryToken = FrontendAsyncRequestWithImmediateResultKt.createResetUndoHistoryToken(editor);
            ActionTimestampSetModel timestampSetModel = ActionTimestampModelProvider.Companion.createTimestampModelSet(frontendActionId, dataContext, false);
            Pair pair = EditorActionCommandInfo.Companion.capture(() -> LocalCallEditorActionRequestFactory.createRequest$lambda$0(this, frontendActionId, executeFrontend));
            RdPatch patch = (RdPatch)pair.component1();
            EditorActionCommandInfo info = (EditorActionCommandInfo)pair.component2();
            ActionRequestFusData actionFusData = ActionRequestFusData.Companion.from(frontendActionId, dataContext);
            if (patch == null) {
                if ((Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorTab") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorIndentSelection") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorUnindentSelection") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorEnter") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorBackSpace")) && RdActionsSupport.Companion.getInstance().hasBackendAction(frontendActionId)) {
                    return new PhantomCallEditorActionRequest(frontendActionId, editorId, info, timestampSetModel, actionFusData);
                }
                return null;
            }
            return new FrontendCallEditorActionRequest(patch, editorId, frontendActionId, this.session, resetUndoHistoryToken, info, timestampSetModel, actionFusData);
        }

        private static final Unit createRequest$lambda$0$0$0(Function0 $executeFrontend) {
            $executeFrontend.invoke();
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private static final RdPatch createRequest$lambda$0(LocalCallEditorActionRequestFactory this$0, String $frontendActionId, Function0 $executeFrontend) {
            RdPatch rdPatch;
            void $this$recordChanges$iv;
            PatchEngine patchEngine = FrontendPatchEngineKt.getEngine(this$0.session);
            String description$iv = "Call editor action " + $frontendActionId;
            boolean $i$f$recordChanges = false;
            $this$recordChanges$iv.softAssertThereIsNoActivePatch("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
            boolean alreadyOpened$iv = $this$recordChanges$iv.getHasActivePatch();
            try {
                RdPatch rdPatch2;
                AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, null, null, (int)28, null);
                Throwable throwable = null;
                try {
                    Object object;
                    void $this$runAndLogException$iv$iv;
                    RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                    boolean bl5 = false;
                    boolean $i$f$fileLogger22 = false;
                    boolean $i$f$currentClassLogger = false;
                    Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                    com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(clazz$iv$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    com.intellij.openapi.diagnostic.Logger $i$f$fileLogger22 = logger;
                    boolean $i$f$runAndLogException = false;
                    void var13_19 = $this$runAndLogException$iv$iv;
                    try {
                        void $this$runAndLogException_u24lambda_u240$iv$iv = var13_19;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        ChangeScope $this$createRequest_u24lambda_u240_u240 = it$iv.getSession().getChangeScope();
                        boolean bl4 = false;
                        FrontendSpeculativeRequestRecordingListener.Companion.withListener(this$0.session, () -> LocalCallEditorActionRequestFactory.createRequest$lambda$0$0$0($executeFrontend));
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable2) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    LoggerKt.getOrLogException((Object)object, (com.intellij.openapi.diagnostic.Logger)$this$runAndLogException$iv$iv);
                    rdPatch2 = it$iv.getSession().buildPatchAndClear();
                }
                catch (Throwable bl5) {
                    try {
                        throwable = bl5;
                        throw bl5;
                    }
                    catch (Throwable bl5) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                        throw bl5;
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                rdPatch = rdPatch2;
            }
            finally {
                if (!alreadyOpened$iv && $this$recordChanges$iv.getHasActivePatch()) {
                    void $this$thisLogger$iv$iv = $this$recordChanges$iv;
                    boolean $i$f$thisLogger = false;
                    com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(PatchEngine.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                    while ($this$recordChanges$iv.getHasActivePatch()) {
                        $this$recordChanges$iv.closeCurrentSession("Wrong dispose ordering: " + description$iv);
                    }
                }
            }
            return rdPatch;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionCallStrategyKind.values().length];
            try {
                nArray[ActionCallStrategyKind.FrontendOnly.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.BackendWithFrontendUpdate.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.FrontendFirst.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.Backend.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.BackendWhenAvailableByHint.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

