/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.util.ArrayUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TestTrackingIOUtil {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveTestResults(File tracesDirectory, String name, Map<Object, boolean[]> trace) throws IOException {
        File traceFile = new File(tracesDirectory, name + ".tr");
        if (!traceFile.exists()) {
            traceFile.createNewFile();
        }
        DataOutputStream os = null;
        try {
            Iterator iterator;
            os = new DataOutputStream(new FileOutputStream(traceFile));
            int size = trace.size();
            os.writeInt(size);
            int entries = 0;
            for (Map.Entry entry : iterator.entrySet()) {
                if (entries < size) {
                    int idx;
                    ++entries;
                    os.writeUTF(entry.getKey().toString());
                    boolean[] lines = ArrayUtil.copy((boolean[])entry.getValue());
                    int numberOfTraces = 0;
                    for (idx = 1; idx < lines.length; ++idx) {
                        if (!lines[idx]) continue;
                        ++numberOfTraces;
                    }
                    os.writeInt(numberOfTraces);
                    for (idx = 1; idx < lines.length; ++idx) {
                        boolean bl = lines[idx];
                        if (!bl) continue;
                        os.writeInt(idx);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (os != null) {
                void var1_3;
                var1_3.close();
            }
            throw throwable;
        }
        os.close();
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Map<String, int[]>> loadTestTrackingData(File tracesDirectory) throws IOException {
        void var1_2;
        File[] fileArray;
        File[] traces = tracesDirectory.listFiles();
        HashMap<String, Map<String, int[]>> result = new HashMap<String, Map<String, int[]>>();
        if (traces == null) {
            return result;
        }
        for (File traceFile : fileArray) {
            String fileName = traceFile.getName();
            String name = fileName.substring(0, fileName.length() - 3);
            HashMap<String, int[]> classes = new HashMap<String, int[]>();
            FilterInputStream is = null;
            try {
                is = new DataInputStream(new FileInputStream(traceFile));
                int size = ((DataInputStream)is).readInt();
                for (int i = 0; i < size; ++i) {
                    String className = ((DataInputStream)is).readUTF();
                    int lines = ((DataInputStream)is).readInt();
                    int[] coveredLines = new int[lines];
                    for (int j = 0; j < lines; ++j) {
                        coveredLines[j] = ((DataInputStream)is).readInt();
                    }
                    classes.put(className, coveredLines);
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    is.close();
                }
                throw throwable;
            }
            is.close();
            result.put(name, classes);
        }
        return var1_2;
    }
}

