/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSConfigInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            FlowJSConfigInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            FlowJSConfigInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DialectDetector.languageOfElement((PsiElement)comment) != JavaScriptSupportLoader.FLOW_JS) {
                    return;
                }
                int flowIndex = comment.getText().indexOf("@flow");
                if (flowIndex == -1) {
                    return;
                }
                FlowJSConfigService service = FlowJSConfigService.getService((Project)holder.getProject());
                PsiFile file = comment.getContainingFile();
                PsiComment flagComment = FlowJSAnnotation.findFlowFlagComment((PsiFile)file);
                if (flagComment != comment) {
                    return;
                }
                VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
                if (!service.getConfigOfFile(virtualFile).isEmpty()) {
                    return;
                }
                VirtualFile currentDir = virtualFile.getParent();
                if (currentDir == null) {
                    return;
                }
                SmartList fixes = new SmartList();
                fixes.add(new FlowJSConfigQuickFix(currentDir, JavaScriptBundle.message((String)"js.flowjs.config.inspection.to.current.path.name", (Object[])new Object[0])));
                VirtualFile contentRoot = ProjectFileIndex.getInstance((Project)holder.getProject()).getContentRootForFile(virtualFile);
                if (contentRoot != null && !Objects.equals(contentRoot, currentDir)) {
                    String basePath = holder.getProject().getBasePath();
                    String message = basePath != null && VfsUtilCore.pathEqualsTo((VirtualFile)contentRoot, (String)basePath) ? JavaScriptBundle.message((String)"js.flowjs.config.inspection.to.project.path.name", (Object[])new Object[0]) : JavaScriptBundle.message((String)"js.flowjs.config.inspection.to.module.path.name", (Object[])new Object[0]);
                    fixes.add(new FlowJSConfigQuickFix(contentRoot, message));
                }
                TextRange range = new TextRange(flowIndex, flowIndex + "@flow".length());
                holder.registerProblem((PsiElement)comment, range, JavaScriptBundle.message((String)"js.flowjs.config.inspection.message", (Object[])new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/flow/FlowJSConfigInspection$1", "visitComment"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/flow/FlowJSConfigInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FlowJSConfigQuickFix
    extends IntentionAndQuickFixAction {
        @NotNull
        private final VirtualFile dir;
        @IntentionName
        @NotNull
        private final String name;

        FlowJSConfigQuickFix(@NotNull VirtualFile dir, @IntentionName @NotNull String name) {
            if (dir == null) {
                FlowJSConfigQuickFix.$$$reportNull$$$0(0);
            }
            if (name == null) {
                FlowJSConfigQuickFix.$$$reportNull$$$0(1);
            }
            this.dir = dir;
            this.name = name;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                FlowJSConfigQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                FlowJSConfigQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private void createConfigFile() {
            Path file = this.dir.toNioPath().resolve(".flowconfig");
            NioPathUtil.findOrCreateFile((Path)file);
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{this.dir});
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
            List flowExecutableFiles;
            if (project == null) {
                FlowJSConfigQuickFix.$$$reportNull$$$0(4);
            }
            if (!(flowExecutableFiles = FlowJSServerService.calcPossibleFlowExecutableFiles((Project)project)).isEmpty()) {
                for (FlowJSSettings.FlowJSExecutable path : flowExecutableFiles) {
                    if (FlowJSServerService.isFlowServerAvailable((FlowJSSettings.FlowJSExecutable)path, (Project)project) != null) continue;
                    GeneralCommandLine line = path.createCommandLine(project);
                    line.addParameter("init");
                    line.setWorkDirectory(this.dir.getCanonicalPath());
                    try {
                        OSProcessHandler handler = new OSProcessHandler(line);
                        handler.startNotify();
                        if (handler.waitFor()) {
                            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{this.dir});
                        }
                        return;
                    }
                    catch (ExecutionException executionException) {
                    }
                }
            }
            this.createConfigFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

