/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstInspectionBase;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstQuickFix;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class ES6ConvertVarToLetConstInspection
extends ES6ConvertVarToLetConstInspectionBase {
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6ConvertVarToLetConstInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6ConvertVarToLetConstInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSVarStatement(@NotNull JSVarStatement node) {
                boolean isBatch;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!DialectDetector.hasFeature((PsiElement)node, (JSLanguageFeature)JSLanguageFeature.LET_DEFINITIONS)) {
                    return;
                }
                ASTNode varNode = node.getNode().findChildByType(JSTokenTypes.VAR_KEYWORD);
                if (varNode == null || !ES6ConvertVarToLetConstInspection.isAvailableForStatement(node)) {
                    return;
                }
                boolean bl = isBatch = !holder.isOnTheFly() || ES6ConvertVarToLetConstInspection.this.myEmulateBatch && ApplicationManager.getApplication().isUnitTestMode();
                if (isBatch) {
                    ES6ConvertVarToLetConstQuickFix fix2 = new ES6ConvertVarToLetConstQuickFix(node).setInBatch(true).setConservative(ES6ConvertVarToLetConstInspection.this.myConservativeOption);
                    holder.registerProblem(varNode.getPsi(), JavaScriptBundle.message((String)"js.convert.var.to.let.or.const.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{fix2});
                } else {
                    boolean asIntention = ES6ConvertVarToLetConstInspection.this.checkHighlightLevel(node);
                    LocalQuickFix[] fixes = !ES6ConvertVarToLetConstQuickFix.canBeConst(node, true, false) ? new LocalQuickFix[]{new ES6ConvertVarToLetConstQuickFix(node).forceVariant(false).setForceFix(asIntention)} : new LocalQuickFix[]{new ES6ConvertVarToLetConstQuickFix(node).forceVariant(true).setForceFix(asIntention), new ES6ConvertVarToLetConstQuickFix(node).forceVariant(false).setForceFix(asIntention)};
                    holder.registerProblem(varNode.getPsi(), JavaScriptBundle.message((String)"js.convert.var.to.let.or.const.inspection.text", (Object[])new Object[0]), fixes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/ES6ConvertVarToLetConstInspection$1", "visitJSVarStatement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/ES6ConvertVarToLetConstInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

