/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSConsecutiveCommasInArrayLiteralInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSConsecutiveCommasInArrayLiteralInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSConsecutiveCommasInArrayLiteralInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitJSArrayLiteralExpression(@NotNull JSArrayLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (JSDestructuringUtil.parentIsDestructuringAssignmentLHS((JSExpression)node)) {
                    return;
                }
                PsiElement child = node.getFirstChild();
                while (child != null) {
                    ASTNode astNode;
                    PsiElement nextSibling = child.getNextSibling();
                    while (nextSibling instanceof PsiWhiteSpace || nextSibling instanceof PsiComment) {
                        nextSibling = nextSibling.getNextSibling();
                    }
                    if (nextSibling != null && (astNode = child.getNode()).getElementType() == JSElementTypes.EMPTY_EXPRESSION) {
                        ASTNode next;
                        for (next = astNode.getTreeNext(); next != null && next.getElementType() != JSTokenTypes.COMMA; next = next.getTreeNext()) {
                        }
                        if (next == null) continue;
                        holder.registerProblem((PsiElement)node, new TextRange(child.getStartOffsetInParent(), nextSibling.getStartOffsetInParent() + 1), JavaScriptBundle.message((String)"js.consecutive.commas.in.array.literal.inspection.message", (Object[])new Object[0]), new LocalQuickFix[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.remove.unneeded.comma.fix", false, astNode.getPsi(), next.getPsi()), new InsertUndefinedFix(child)});
                    }
                    child = nextSibling;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection$1", "visitJSArrayLiteralExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class InsertUndefinedFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected InsertUndefinedFix(@Nullable PsiElement element) {
            super(element);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                InsertUndefinedFix.$$$reportNull$$$0(0);
            }
            if (psiFile == null) {
                InsertUndefinedFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                InsertUndefinedFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                InsertUndefinedFix.$$$reportNull$$$0(3);
            }
            InsertUndefinedFix.replaceWithUndefined(startElement);
        }

        public static PsiElement replaceWithUndefined(@NotNull PsiElement startElement) {
            if (startElement == null) {
                InsertUndefinedFix.$$$reportNull$$$0(4);
            }
            return startElement.replace((PsiElement)JSPsiElementFactory.createJSExpression((String)"undefined", (PsiElement)startElement));
        }

        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message((String)"js.consecutive.commas.in.array.literal.inspection.insert.undefined", (Object[])new Object[0]);
            if (string == null) {
                InsertUndefinedFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                InsertUndefinedFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection$InsertUndefinedFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection$InsertUndefinedFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceWithUndefined";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

