/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSMissingSwitchBranchesInspection;
import com.intellij.lang.javascript.intentions.JSSwitchBranchesProcessor;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSMissingSwitchDefaultInspection
extends JSInspection {
    public boolean ignoreDynamicTypes = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreDynamicTypes", (String)JavaScriptBundle.message((String)"js.unreachable.switch.branches.ignore.with.dynamic", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSMissingSwitchDefaultInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    private boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSMissingSwitchDefaultInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSMissingSwitchDefaultInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            public void visitJSSwitchStatement(@NotNull JSSwitchStatement switchStatement) {
                if (switchStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (JSMissingSwitchBranchesInspection.hasDefault(switchStatement)) {
                    return;
                }
                JSType typeForCases = JSSwitchBranchesProcessor.findTypeForCases((JSSwitchStatement)switchStatement);
                if (typeForCases != null && !(typeForCases instanceof JSAnyType)) {
                    List allVariants = ContainerUtil.map((Collection)JSSwitchBranchesProcessor.getAllCaseVariants((JSType)typeForCases, (boolean)false), it -> it.value());
                    Set existingVariants = JSSwitchBranchesProcessor.getExistingValues((List)JSSwitchBranchesProcessor.getExistingVariants((JSSwitchStatement)switchStatement));
                    if (ContainerUtil.and((Iterable)allVariants, existingVariants::contains)) {
                        return;
                    }
                } else if (JSMissingSwitchDefaultInspection.this.ignoreDynamicTypes) {
                    return;
                }
                String message = JavaScriptBundle.message((String)"js.switch.no.default", (Object[])new Object[0]);
                JSCreateDefaultBranchFix fix2 = new JSCreateDefaultBranchFix();
                JSMissingSwitchBranchesInspection.registerOnSwitchStatement(switchStatement, message, fix2, holder, JSMissingSwitchDefaultInspection.this.isOnTheFly());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "com/intellij/lang/javascript/inspections/JSMissingSwitchDefaultInspection$1", "visitJSSwitchStatement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMissingSwitchDefaultInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMissingSwitchDefaultInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class JSCreateDefaultBranchFix
    implements LocalQuickFix {
        private JSCreateDefaultBranchFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.switch.no.default.add", (Object[])new Object[0]);
            if (string == null) {
                JSCreateDefaultBranchFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                JSCreateDefaultBranchFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                JSCreateDefaultBranchFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            JSSwitchStatement statement = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSSwitchStatement.class, (boolean)false);
            assert (statement != null);
            JSCaseClause clause = JSMissingSwitchBranchesInspection.createCaseClause(null, (PsiElement)statement);
            JSCaseClause[] clauses = statement.getCaseClauses();
            if (clauses.length > 0) {
                JSCaseClause lastClause = clauses[clauses.length - 1];
                JSSourceElement[] statements = lastClause.getStatementListItems();
                if (statements.length == 0) {
                    lastClause.addBefore(JSCreateDefaultBranchFix.createBreak(statement), null);
                } else {
                    JSSourceElement lastStatement = statements[statements.length - 1];
                    if (!(lastStatement instanceof JSBreakStatement) && !(lastStatement instanceof JSReturnStatement)) {
                        lastClause.addAfter(JSCreateDefaultBranchFix.createBreak(statement), (PsiElement)lastStatement);
                    }
                }
            }
            statement.addAfter((PsiElement)clause, (PsiElement)(clauses.length > 0 ? clauses[clauses.length - 1] : ImportUtils.findLBrace((JSElement)statement)));
        }

        private static PsiElement createBreak(JSSwitchStatement statement) {
            return JSPsiElementFactory.createJSStatement((String)"break;", (PsiElement)statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMissingSwitchDefaultInspection$JSCreateDefaultBranchFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMissingSwitchDefaultInspection$JSCreateDefaultBranchFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

