/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.typeEngine.JSTypeEngineUtils;
import com.intellij.javascript.types.TSType;
import com.intellij.javascript.types.TSVoidType;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;

public final class JSVoidFunctionReturnValueUsedInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSVoidFunctionReturnValueUsedInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSVoidFunctionReturnValueUsedInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public void visitJSCallExpression(@NotNull JSCallExpression node) {
                PsiElement resolve;
                IElementType sign;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node instanceof JSNewExpression) {
                    return;
                }
                JSCallExpression nodeOrParentheses = node;
                while (nodeOrParentheses.getParent() instanceof JSParenthesizedExpression) {
                    nodeOrParentheses = (JSParenthesizedExpression)nodeOrParentheses.getParent();
                }
                PsiElement parent = nodeOrParentheses.getParent();
                if (parent instanceof JSExpressionStatement || parent instanceof JSPrefixExpression && parent.getParent() instanceof JSExpressionStatement || JSPsiImplUtils.isReturnedFromFunction((JSExpression)nodeOrParentheses)) {
                    return;
                }
                if (parent instanceof JSPrefixExpression && ((JSPrefixExpression)parent).getOperationSign() == JSTokenTypes.VOID_KEYWORD && JSPsiImplUtils.isReturnedFromFunction((JSExpression)((JSPrefixExpression)parent))) {
                    return;
                }
                if (parent instanceof JSConditionalExpression && ((JSConditionalExpression)parent).getCondition() != nodeOrParentheses) {
                    return;
                }
                if (parent instanceof JSPrefixExpression && ((JSPrefixExpression)parent).getOperationSign() == JSTokenTypes.EXCL) {
                    parent = parent.getParent();
                }
                if (parent instanceof JSBinaryExpression && ((sign = ((JSBinaryExpression)parent).getOperationSign()) == JSTokenTypes.OROR || sign == JSTokenTypes.COMMA || sign == JSTokenTypes.ANDAND)) {
                    return;
                }
                TSType type = JSTypeEngineUtils.INSTANCE.getTSType((PsiElement)node);
                if (!(type instanceof TSVoidType)) {
                    return;
                }
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)methodExpression).resolve()) != null) {
                    JSFunctionItem functionItem = JSPsiImplUtils.calculatePossibleFunction((PsiElement)resolve, (PsiElement)methodExpression, (boolean)true);
                    if (functionItem == null || functionItem instanceof JSRecordType.CallSignature) {
                        return;
                    }
                    @NotNull JBIterable overrides = JSInheritanceUtil.findOverrides((JSFunctionItem)functionItem);
                    if (overrides.find(f -> !(f.getReturnType() instanceof JSVoidType)) != null) {
                        return;
                    }
                }
                holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"js.void.function.result.used.description", (Object[])new Object[0]), new LocalQuickFix[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSVoidFunctionReturnValueUsedInspection$1", "visitJSCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSVoidFunctionReturnValueUsedInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

