/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.javascript.highlighting.JSInheritanceUtilKt;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JSModCommandAction;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInferType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.ModShowConflicts;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConvertParametersToObjectIntention
extends JSModCommandAction<JSParameterList> {
    private static final String PARAMETERS_VARIABLE = "parameters";

    public JSConvertParametersToObjectIntention() {
        super(JSParameterList.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.convert.parameters.to.object.intention.name", (Object[])new Object[0]);
        if (string == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected boolean isAvailable(@NotNull JSParameterList parameterList) {
        if (parameterList == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(1);
        }
        if (DialectDetector.isActionScript((PsiElement)parameterList)) {
            return false;
        }
        JSParameterList actualParamList = JSConvertParametersToObjectIntention.getActualParameterList(parameterList);
        if (actualParamList != parameterList) {
            return false;
        }
        Object[] parameters = parameterList.getParameters();
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class);
        return function != null && !(JSUtils.getParentSkipParentheses((PsiElement)function) instanceof JSArgumentList) && !ArrayUtil.isEmpty((Object[])parameters) && ContainerUtil.and((Object[])parameters, this::isSimpleParameter);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull JSParameterList element) {
        if (context == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(3);
        }
        return Presentation.of((String)this.getFamilyName());
    }

    protected void invoke(@NotNull JSParameterList parameterList, @NotNull ModPsiUpdater updater) {
        String newParameterType;
        JSFunction function;
        if (parameterList == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(5);
        }
        if ((function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class)) == null) {
            return;
        }
        function = (JSFunction)CompletionUtil.getOriginalOrSelf((PsiElement)function);
        JSParameter[] parameters = parameterList.getParameterVariables();
        if (parameters.length == 0) {
            return;
        }
        HashSet<JSCallExpression> callExpressions = new HashSet<JSCallExpression>();
        HashMap<PsiElement, ModShowConflicts.Conflict> conflicts = new HashMap<PsiElement, ModShowConflicts.Conflict>();
        JSConvertParametersToObjectIntention.fillFunctionUsages(function, callExpressions, conflicts);
        if (!conflicts.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode() && !BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException((Collection)ContainerUtil.flatMap(conflicts.values(), ModShowConflicts.Conflict::messages));
            }
            updater.showConflicts(conflicts);
        }
        ArrayList<JSCallExpression> writableCallExpressions = new ArrayList<JSCallExpression>();
        for (JSCallExpression call : callExpressions) {
            writableCallExpressions.add((JSCallExpression)updater.getWritable((PsiElement)call));
        }
        boolean hasTypes = DialectDetector.hasFeature((PsiElement)parameterList, (JSLanguageFeature)JSLanguageFeature.TYPES);
        boolean hasDestructuring = DialectDetector.hasFeature((PsiElement)function, (JSLanguageFeature)JSLanguageFeature.DESTRUCTURING_PARAMETERS);
        StringBuilder parameterTypeBuilder = hasTypes ? new StringBuilder() : null;
        StringBuilder destructuringObjectBuilder = hasDestructuring ? new StringBuilder() : null;
        JSConvertParametersToObjectIntention.buildTypeAndDestructuringTexts(parameters, parameterTypeBuilder, destructuringObjectBuilder);
        String destructuringObjectText = hasDestructuring ? destructuringObjectBuilder.toString() : null;
        String string = newParameterType = hasTypes ? parameterTypeBuilder.toString() : "";
        if (destructuringObjectText != null) {
            JSConvertParametersToObjectIntention.replaceParametersInFunctionSignature(parameterList, parameters, destructuringObjectText + newParameterType);
        } else {
            JSConvertParametersToObjectIntention.replaceParametersInFunctionSignature(parameterList, parameters, PARAMETERS_VARIABLE + newParameterType);
            JSFunction writableFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class);
            if (writableFunction != null) {
                JSConvertParametersToObjectIntention.addVariablesInitializationToFunctionBody(parameters, writableFunction);
            }
        }
        JSConvertParametersToObjectIntention.replaceArgumentsInCalls(parameters, writableCallExpressions);
    }

    @Nullable
    private static JSParameterList getActualParameterList(@NotNull JSParameterList parameterList) {
        if (parameterList == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(6);
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class);
        while (TypeScriptPsiUtil.isTypeSignature((JSFunction)function)) {
            parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)function, JSParameterList.class);
            if (parameterList == null) {
                return null;
            }
            function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class);
        }
        return parameterList;
    }

    private static void replaceArgumentsInCalls(JSParameter @NotNull [] parameters, @NotNull Collection<JSCallExpression> writableCallExpressions) {
        if (writableCallExpressions == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(8);
        }
        boolean hasRest = parameters.length > 0 && parameters[parameters.length - 1].isRest();
        for (JSCallExpression writableCall : writableCallExpressions) {
            JSArgumentList argumentList = writableCall.getArgumentList();
            if (argumentList == null) continue;
            JSExpression[] arguments = argumentList.getArguments();
            int argToReplaceCount = Math.min(arguments.length, parameters.length);
            String newArgument = JSConvertParametersToObjectIntention.wrapArgumentsWithObjectLiteral(parameters, arguments, argToReplaceCount, hasRest);
            JSExpression newArgumentPsi = JSPsiElementFactory.createJSExpression((String)newArgument, (PsiElement)writableCall);
            if (argToReplaceCount > 0) {
                if (argToReplaceCount > 1) {
                    argumentList.getNode().removeRange(arguments[0].getNode(), arguments[argToReplaceCount - 1].getNode());
                }
                arguments[argToReplaceCount - 1].replace((PsiElement)newArgumentPsi);
            } else {
                ASTNode leftPar = argumentList.getNode().findChildByType(JSTokenTypes.LPAR);
                if (leftPar != null) {
                    argumentList.addAfter((PsiElement)newArgumentPsi, leftPar.getPsi());
                }
            }
            if (!hasRest || arguments.length <= argToReplaceCount) continue;
            for (int i = argToReplaceCount; i < arguments.length; ++i) {
                JSExpression argument = arguments[i];
                JSChangeUtil.removeRangeWithRemovalOfCommas((PsiElement)argument, (PsiElement[])arguments);
            }
        }
    }

    private static void replaceParametersInFunctionSignature(@NotNull JSParameterList parameterList, JSParameter @NotNull [] parameters, @NotNull String replacement) {
        if (parameterList == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(9);
        }
        if (replacement == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(10);
        }
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(11);
        }
        JSParameter firstParam = parameters[0];
        JSParameter lastParam = parameters[parameters.length - 1];
        if (parameters.length > 1) {
            parameterList.getNode().removeRange(firstParam.getNode(), lastParam.getNode());
        }
        JSParameterList list = (JSParameterList)JSChangeUtil.createParameter((String)replacement, (PsiElement)parameterList).getParent();
        lastParam.replace((PsiElement)list.getParameters()[0]);
    }

    private static void buildTypeAndDestructuringTexts(JSParameter @NotNull [] parameters, @Nullable StringBuilder parameterTypeBuilder, @Nullable StringBuilder destructuringObjectBuilder) {
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(12);
        }
        if (parameterTypeBuilder == null && destructuringObjectBuilder == null) {
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            JSParameter parameter = parameters[i];
            if (parameterTypeBuilder != null) {
                if (i != 0) {
                    parameterTypeBuilder.append(", ");
                }
                JSConvertParametersToObjectIntention.appendParameterType(parameterTypeBuilder, parameter);
            }
            if (destructuringObjectBuilder == null) continue;
            if (i != 0) {
                destructuringObjectBuilder.append(", ");
            }
            JSConvertParametersToObjectIntention.appendParameterNameWithInitializer(destructuringObjectBuilder, parameter);
        }
        if (parameterTypeBuilder != null && !parameterTypeBuilder.isEmpty()) {
            parameterTypeBuilder.insert(0, ": { ").append(" }");
        }
        if (destructuringObjectBuilder != null) {
            destructuringObjectBuilder.insert(0, "{").append("}");
        }
    }

    private static void appendParameterType(@NotNull StringBuilder parameterTypeBuilder, @NotNull JSParameter parameter) {
        boolean isRest;
        if (parameterTypeBuilder == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(13);
        }
        if (parameter == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(14);
        }
        JSType type = (isRest = parameter.isRest()) ? TypeScriptPsiUtil.getTypeFromDeclaration((StubBasedPsiElementBase)((StubBasedPsiElementBase)parameter)) : parameter.getJSType();
        String name = parameter.getName();
        if (isRest && type == null) {
            type = new JSArrayTypeImpl((JSType)JSAnyType.get((PsiElement)parameter), JSTypeSourceFactory.createTypeSource((PsiElement)parameter, (boolean)true));
        }
        parameterTypeBuilder.append(name).append(parameter.isOptional() || parameter.isRest() && !(type instanceof JSTupleType) ? "?" : "").append(": ").append(type != null ? type.getTypeText(JSType.TypeTextFormat.CODE) : JSClassUtils.getAnyTypeString((PsiElement)parameter, (boolean)true));
    }

    private static void appendParameterNameWithInitializer(@NotNull StringBuilder destructuringObjectBuilder, @NotNull JSParameter parameter) {
        if (destructuringObjectBuilder == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(15);
        }
        if (parameter == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(16);
        }
        destructuringObjectBuilder.append(parameter.getName());
        JSExpression initializer = parameter.getInitializer();
        if (initializer != null) {
            destructuringObjectBuilder.append("=").append(initializer.getText());
        }
    }

    @Nullable
    private static JSCallExpression getParentCall(@NotNull JSFunction function) {
        PsiElement parent;
        if (function == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(17);
        }
        if (function instanceof JSFunctionExpression && (parent = JSUtils.getParentSkipParentheses((PsiElement)function)) instanceof JSCallExpression) {
            return (JSCallExpression)parent;
        }
        return null;
    }

    private static void fillFunctionUsages(@NotNull JSFunction function, @NotNull Collection<JSCallExpression> callExpressions, @NotNull Map<PsiElement, ModShowConflicts.Conflict> conflicts) {
        if (function == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(18);
        }
        if (callExpressions == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(19);
        }
        if (conflicts == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(20);
        }
        if (JSInheritanceUtilKt.findSuperMembersFromContextType((JSPsiElementBase)function) != null || JSInheritanceUtil.findTopOverriddenMember((JSPsiElementBase)function) != null || !JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)function).isEmpty()) {
            JSConvertParametersToObjectIntention.addConflict(conflicts, (PsiElement)function, JavaScriptBundle.message((String)"js.convert.parameters.to.object.usage.will.not.be.updated.for.contextual.type", (Object[])new Object[0]));
        }
        JSQualifiedNamedElement funcRef = function instanceof JSFunctionExpression ? ((JSFunctionExpression)function).getElementAssignedTo() : null;
        JSParameterListElement[] parameters = function.getParameters();
        boolean hasRestParam = parameters.length > 0 && parameters[parameters.length - 1].isRest();
        JSCallExpression parentCall = JSConvertParametersToObjectIntention.getParentCall(function);
        if (parentCall != null) {
            callExpressions.add(parentCall);
        }
        Processor referenceProcessor = reference -> {
            PsiElement referenceElement = reference.getElement();
            PsiElement parent = JSUtils.getParentSkipParentheses((PsiElement)referenceElement);
            if (parent instanceof JSCallExpression) {
                JSExpression[] arguments = ((JSCallExpression)parent).getArguments();
                boolean hasNonTerminalSpread = false;
                for (int i = 0; i < arguments.length; ++i) {
                    JSExpression argument = arguments[i];
                    if (!(argument instanceof JSSpreadExpression) || i == arguments.length - 1 && hasRestParam) continue;
                    JSConvertParametersToObjectIntention.addConflict(conflicts, (PsiElement)argument, JavaScriptBundle.message((String)"js.convert.parameters.to.object.usage.will.not.be.updated.for.spread", (Object[])new Object[0]));
                    hasNonTerminalSpread = true;
                    break;
                }
                if (!hasNonTerminalSpread) {
                    callExpressions.add((JSCallExpression)parent);
                }
            } else if (parent == function.getParent()) {
                JSConvertParametersToObjectIntention.addConflict(conflicts, referenceElement, JavaScriptBundle.message((String)"js.convert.parameters.to.object.usage.will.not.be.updated.for.contextual.type", (Object[])new Object[0]));
            } else if (referenceElement instanceof JSReferenceExpression) {
                JSConvertParametersToObjectIntention.addConflict(conflicts, referenceElement, JavaScriptBundle.message((String)"js.convert.parameters.to.object.non.call.usage.will.not.be.updated", (Object[])new Object[0]));
            }
            return true;
        };
        ReferencesSearch.search((PsiElement)function, (SearchScope)function.getUseScope()).forEach(referenceProcessor);
        if (funcRef != null) {
            ReferencesSearch.search((PsiElement)funcRef, (SearchScope)funcRef.getUseScope()).forEach(referenceProcessor);
        }
    }

    private static void addConflict(@NotNull Map<PsiElement, ModShowConflicts.Conflict> conflicts, @NotNull PsiElement element, @Nls @NotNull String message) {
        if (conflicts == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(21);
        }
        if (element == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(22);
        }
        if (message == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(23);
        }
        conflicts.merge(element, new ModShowConflicts.Conflict(List.of(message)), ModShowConflicts.Conflict::merge);
    }

    protected boolean isSimpleParameter(JSParameterListElement p) {
        if (!this.isValidSimpleParameter(p)) {
            return false;
        }
        PsiElement typeElement = p.getTypeElement();
        return typeElement == null || ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)typeElement).filter(Conditions.instanceOf((Class[])new Class[]{TypeScriptThisType.class, TypeScriptInferType.class}))).traverse().isEmpty();
    }

    protected boolean isValidSimpleParameter(JSParameterListElement p) {
        JSParameter simpleParameter = (JSParameter)ObjectUtils.tryCast((Object)p, JSParameter.class);
        return simpleParameter != null && !TypeScriptPsiUtil.isFieldParameter((JSParameter)simpleParameter);
    }

    @NotNull
    private static String wrapArgumentsWithObjectLiteral(JSParameter @NotNull [] parameters, JSExpression @NotNull [] arguments, int argToReplaceCount, boolean hasRest) {
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(24);
        }
        if (arguments == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(25);
        }
        StringBuilder builder = new StringBuilder(argToReplaceCount * 4);
        builder.append("{");
        int maxIndex = hasRest ? arguments.length : argToReplaceCount;
        boolean closeBracket = false;
        for (int i = 0; i < maxIndex; ++i) {
            JSExpression argument = arguments[i];
            boolean spread = false;
            if (argument instanceof JSSpreadExpression && ((JSSpreadExpression)argument).getExpression() instanceof JSArrayLiteralExpression) {
                spread = true;
                argument = ((JSSpreadExpression)argument).getExpression();
            }
            if (!hasRest || i < argToReplaceCount) {
                builder.append(parameters[i].getName());
                builder.append(" : ");
                if (hasRest && i == argToReplaceCount - 1 && !spread) {
                    builder.append("[");
                    closeBracket = true;
                }
            }
            builder.append(argument == null ? "" : argument.getText());
            if (i < maxIndex - 1) {
                builder.append(", ");
                continue;
            }
            if (!hasRest || !closeBracket) continue;
            builder.append("]");
        }
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static void addVariablesInitializationToFunctionBody(JSParameter @NotNull [] parameters, @NotNull JSFunction function) {
        JSBlockStatement body;
        if (function == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(27);
        }
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(28);
        }
        if ((body = function.getBlock()) == null) {
            return;
        }
        PsiElement anchor = body.getFirstChild();
        String variablePrefix = JSChangeUtil.getVariablePrefix((PsiElement)function);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)function);
        for (JSParameter parameter : parameters) {
            String parameterName = parameter.getName();
            String variableText = variablePrefix + " " + parameterName + " = parameters." + parameterName + semicolon;
            anchor = body.addAfter((PsiElement)JSPsiElementFactory.createJSStatement((String)variableText, (PsiElement)function), anchor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 28 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writableCallExpressions";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = PARAMETERS_VARIABLE;
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypeBuilder";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringObjectBuilder";
                break;
            }
            case 17: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressions";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapArgumentsWithObjectLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameterList";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceArgumentsInCalls";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceParametersInFunctionSignature";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeAndDestructuringTexts";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterNameWithInitializer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParentCall";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fillFunctionUsages";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addConflict";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "wrapArgumentsWithObjectLiteral";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addVariablesInitializationToFunctionBody";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 28 -> new IllegalArgumentException(string);
        };
    }
}

